/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlAppProperties;
import ca.jamdat.flight.FlDisplayManager;
import ca.jamdat.flight.FlKeyManager;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.FlVideoMode;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.J2MEApp;
import ca.jamdat.flight.Scene;
import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Viewport;
import ca.jamdat.fuser.Constants;

public class FlApplication
extends Viewport {
    public static final byte ExitTypeNow = 0;
    public static final byte ExitTypeSoon = 1;
    public static final byte TimeFormat12H = 0;
    public static final byte TimeFormat24H = 1;
    public static final byte gameOrientationCurrent = 0;
    public static final byte gameOrientation0 = 1;
    public static final byte gameOrientation90 = 2;
    public static final byte gameOrientation180 = 4;
    public static final byte gameOrientation270 = 8;
    public static final byte gameOrientationSystem = 16;
    public static final byte softKeyPositionError = 0;
    public static final byte softKeyPositionLeft = 1;
    public static final byte softKeyPositionRight = 2;
    public static final byte softKeyPositionBottom = 16;
    public static final byte softKeyPositionTop = 32;
    public static final byte softKeyPositionBottomLeft = 17;
    public static final byte softKeyPositionBottomRight = 18;
    public static final byte softKeyPositionTopLeft = 33;
    public static final byte softKeyPositionTopRight = 34;
    public static final byte defaultGamingKeyPrimary = 0;
    public static final byte defaultGamingKeySecondary = 1;
    public static final byte playViewDefault = 0;
    public static final byte playViewDeck = 1;
    public static final byte playViewGames = 2;
    public static final byte playViewProfile = 3;
    public static final byte playViewFriends = 4;
    public static final byte playViewShowRoom = 5;
    public static final byte playViewArena = 6;
    public static final byte initialTime = 0;
    public static final byte lastSuspendTime = 1;
    public static final byte lastLong64 = 2;
    public long[] mLong64Array = null;
    public int mSupportedOrientations;
    public boolean mIsSuspended;
    public boolean mHasFocus = true;
    public boolean mDirty = true;
    public boolean mExitProcessed;
    public int mLastKeyDown = 0;
    public short[] mKeyMap = new short[33];
    public int mKeyRepeatTime;
    public TimeSystem mApplicationTimeSystem = new TimeSystem();
    public boolean mIgnoreSecondKeyDown = true;
    public Component mComponentWithFocus;
    public Scene mCurrentScene;
    public byte mCurrentTransitionType = 0;

    public void destruct() {
        FrameworkGlobals.GetInstance().mFlDataStore = null;
        FrameworkGlobals.GetInstance().mFlKeyManager = null;
        FrameworkGlobals.GetInstance().mFlPowerManager = null;
        FrameworkGlobals.GetInstance().mBlGlobal = null;
        FrameworkGlobals.GetInstance().mFlBrowser = null;
        this.mComponentWithFocus = null;
        this.mLong64Array = null;
    }

    public void FocusLost() {
    }

    public void FocusGained() {
    }

    public boolean QuitRequest() {
        return true;
    }

    public void SaveGame() {
    }

    public void Suspend() {
    }

    public void Resume() {
    }

    public void OnScreenSizeChange() {
    }

    public void OnSliderChange(boolean bl) {
    }

    public void OnMasterVolumeChange(short s2) {
    }

    public void OnFrameLimit(int n2) {
    }

    public short GetGameLanguage() {
        return 12;
    }

    public static FlApplication GetInstance() {
        return FrameworkGlobals.GetInstance().application;
    }

    public static FlString GetJamdatBuildString() {
        FlString flString = new FlString(FlApplication.GetPropertyValue(StringUtils.CreateString("MIDlet-Version")));
        return flString;
    }

    public static void Kill() {
    }

    public static boolean MemoryCardWasRemoved() {
        return false;
    }

    public static void Exit() {
        FlApplication.InternalExit();
    }

    public static void InternalExit() {
        FlApplication.ProcessExit();
        FlApplication.OSExit();
    }

    public static void ProcessExit() {
        FlApplication flApplication = FlApplication.GetInstance();
        if (!flApplication.mExitProcessed) {
            Scene scene = flApplication.mCurrentScene;
            if (scene != null) {
                scene.SendMsg(scene, -115);
            }
            flApplication.mExitProcessed = true;
        }
    }

    public static boolean HasExited() {
        return FlApplication.GetInstance().mExitProcessed;
    }

    public static FlString GetTitle() {
        return new FlString();
    }

    public static FlString GetDir() {
        return new FlString();
    }

    public static FlString GetDataDir() {
        return new FlString();
    }

    public static FlString GetExternalStorageDir() {
        return new FlString();
    }

    public static boolean IsExternalStorageReadable() {
        return false;
    }

    public static void DisplayMessage(FlString flString) {
    }

    public static byte GetMajorVersion() {
        return (byte)Constants.ApplicationMajorVersion();
    }

    public static byte GetMinorVersion() {
        return (byte)Constants.ApplicationMinorVersion();
    }

    public static short GetBuildVersion() {
        return (byte)Constants.ApplicationBuildVersion();
    }

    public static FlString GetVersionString() {
        FlString flString = new FlString(StringUtils.CreateString("."));
        FlString flString2 = new FlString(FlApplication.GetMajorVersion());
        flString2.AddAssign(flString);
        flString2.AddAssign(new FlString(FlApplication.GetMinorVersion()));
        flString2.AddAssign(flString);
        flString2.AddAssign(new FlString(FlApplication.GetBuildVersion()));
        return flString2;
    }

    public static FlString GetDeviceID() {
        return FlApplication.GetPropertyValue(StringUtils.CreateString("DeviceID"));
    }

    public static FlString GetCarrierID() {
        return FlApplication.GetPropertyValue(StringUtils.CreateString("CarrierID"));
    }

    public static FlString GetPlatformID() {
        return StringUtils.CreateString("3");
    }

    public static FlString GetHardwareKeyString() {
        FlString flString = new FlString(StringUtils.CreateString(","));
        FlString flString2 = new FlString(FlApplication.GetCarrierID());
        if (flString2.Equals(StringUtils.CreateString("9999"))) {
            return StringUtils.CreateString("1,2,390");
        }
        return flString2.Add(flString).Add(FlApplication.GetPlatformID()).Add(flString).Add(FlApplication.GetDeviceID());
    }

    public static short GetTCPPort() {
        return (short)FlApplication.GetPropertyValue(StringUtils.CreateString("TCPPort")).ToLong();
    }

    public static FlString GetServerAddr() {
        return FlApplication.GetPropertyValue(StringUtils.CreateString("ServerAddr"));
    }

    public static FlString GetPropertyValue(FlString flString) {
        FlAppProperties flAppProperties = new FlAppProperties();
        flAppProperties.Load();
        return flAppProperties.GetValue(flString);
    }

    public boolean IsPropertySet(FlString flString) {
        return flString.GetLength() > 0 && !flString.Equals(StringUtils.CreateString("NULL"));
    }

    public void SetOSWaitCursorVisible(boolean bl) {
    }

    public void SetDpadDisable(boolean bl) {
    }

    public void SetDirty(boolean bl) {
        this.mDirty = bl;
    }

    public boolean IsDirty() {
        return this.mDirty;
    }

    public void SendQuitRequestMsg() {
        this.SendMsg(this, -56, 0);
    }

    public void SetIsSuspended(boolean bl) {
        this.mIsSuspended = bl;
    }

    public boolean GetIsSuspended() {
        return this.mIsSuspended;
    }

    public void SetHasFocus(boolean bl) {
        this.mHasFocus = bl;
    }

    public boolean HasFocus() {
        return this.mHasFocus;
    }

    public void SetFrameRate(short s2) {
    }

    public void ReturnToOSGameMenu() {
    }

    public void OnKeyFromOS(int n2, boolean bl) {
        switch (n2) {
            case 0: {
                return;
            }
            case 12: {
                if (!bl) {
                    SoundManager.DecMasterVolume();
                }
                return;
            }
            case 11: {
                if (!bl) {
                    SoundManager.IncMasterVolume();
                }
                return;
            }
        }
        int n3 = this.GetTranslatedKey(n2);
        int n4 = this.mLastKeyDown;
        Component component = this.mComponentWithFocus;
        if (bl) {
            if (n4 == n2) {
                this.mLastKeyDown = 0;
                this.SendKeyUpMsg(n3);
            } else if (this.mIgnoreSecondKeyDown) {
                this.OnKeyFromOS(n4, true);
            }
        } else if (n4 != 0) {
            this.OnKeyFromOS(n4, true);
            if (!this.mIgnoreSecondKeyDown) {
                this.OnKeyFromOS(n2, false);
            }
        } else {
            this.mLastKeyDown = n2;
            this.mKeyRepeatTime = Integer.MAX_VALUE;
            this.SendKeyDownMsg(n3);
            if (this.mComponentWithFocus == component) {
                this.SendKeyRepeatMsg(n3);
            }
        }
    }

    public void SendKeyUpToLastKeyDown() {
        this.OnKeyFromOS(this.mLastKeyDown, true);
    }

    public boolean KeyIsDown(int n2) {
        return (this.mKeyMap[this.mLastKeyDown] == 0 && n2 == this.mLastKeyDown || n2 == this.mKeyMap[this.mLastKeyDown]) && n2 != 0;
    }

    public void MapKey(int n2, int n3) {
        this.ResetDownKeys();
        this.mKeyMap[n2] = (short)n3;
    }

    public void ResetDownKeys() {
        this.mLastKeyDown = 0;
    }

    public int GetTranslatedKey(int n2) {
        if (this.mKeyMap[n2] != 0) {
            n2 = this.mKeyMap[n2];
        }
        return n2;
    }

    public void UpdateSoftKey(int n2, FlString flString) {
        J2MEApp.instance.GetCurrentScene().updateSoftKey(n2, StringUtils.CreateJavaString(flString));
    }

    public int GetDefaultGamingKey(byte by, byte by2) {
        return 0;
    }

    public byte GetSoftKeyPosition(int n2, byte by) {
        return 0;
    }

    public boolean IsNativeResolution(int n2, int n3) {
        FlDisplayManager.GetInstance();
        FlVideoMode flVideoMode = new FlVideoMode(FlDisplayManager.GetVideoMode());
        return flVideoMode.GetWidth() == n2 && flVideoMode.GetHeight() == n3;
    }

    public int GetAllowedOrientations() {
        return 0;
    }

    public int GetAllowedNativeOrientations() {
        return 0;
    }

    public byte GetCurrentGameOrientation() {
        return 0;
    }

    public boolean SetGameOrientation(byte by, boolean bl) {
        return true;
    }

    public void SetSupportedGameOrientations(int n2) {
        this.mSupportedOrientations = n2;
    }

    public int GetSupportedGameOrientations() {
        return this.mSupportedOrientations;
    }

    public boolean GetIsSystemSelectedOrientation() {
        return true;
    }

    public void SetCurrentFocus(Component component) {
        component = component.ForwardFocus();
        Component component2 = this.mComponentWithFocus;
        this.mComponentWithFocus = component;
        FlApplication.MoveFocusForNotifications(component2, component, component.GetDepth() - component2.GetDepth());
    }

    public Component GetCurrentFocus() {
        return this.mComponentWithFocus;
    }

    public void OnFocusLostFromOS() {
        if (this.HasFocus()) {
            this.SetHasFocus(false);
            this.Invalidate();
            this.ReleaseAllInput();
            this.FocusLost();
        }
    }

    public void OnFocusGainedFromOS() {
        if (!this.HasFocus()) {
            this.SetHasFocus(true);
            this.Invalidate();
            this.FocusGained();
        }
    }

    public void OnSuspendFromOS() {
        if (!this.GetIsSuspended()) {
            this.SetIsSuspended(true);
            this.mLong64Array[1] = FlApplication.GetRealTime();
            this.Suspend();
        }
    }

    public void OnResumeFromOS() {
        if (this.GetIsSuspended()) {
            this.SetIsSuspended(false);
            this.mLong64Array[0] = this.mLong64Array[0] + (FlApplication.GetRealTime() - this.mLong64Array[1]);
            this.mLong64Array[1] = 0L;
            this.Resume();
        }
    }

    public void ReleaseAllInput() {
        this.SendKeyUpToLastKeyDown();
    }

    public void Iteration(int n2, int n3) {
        int n4 = this.mLastKeyDown;
        int n5 = this.mKeyRepeatTime;
        if (n4 != 0) {
            if (n5 == Integer.MAX_VALUE) {
                n5 = -350;
            } else if ((n5 += n3) > 150) {
                this.SendKeyRepeatMsg(this.GetTranslatedKey(n4));
                n5 = 0;
            }
        }
        this.mKeyRepeatTime = n5;
        this.mApplicationTimeSystem.OnTime(n2, n3);
    }

    public byte GetTimeFormat() {
        return 1;
    }

    public FlString[] GetCommandLineArgs() {
        return null;
    }

    public int GetCommandLineArgsCount() {
        return 0;
    }

    public boolean GetGameKeyAltMode() {
        return FlKeyManager.GetInstance().GetGameKeyAltMode();
    }

    public void SetGameKeyAltMode(boolean bl) {
        FlKeyManager.GetInstance().SetGameKeyAltMode(bl);
    }

    public static long GetRunTime() {
        if (FlApplication.GetInstance().GetIsSuspended()) {
            return FlApplication.GetInstance().mLong64Array[1] - FlApplication.GetInstance().mLong64Array[0];
        }
        return FlApplication.GetRealTime() - FlApplication.GetInstance().mLong64Array[0];
    }

    public static long GetRealTime() {
        return System.currentTimeMillis();
    }

    public static TimeSystem GetGlobalTimeSystem() {
        return FlApplication.GetInstance().mApplicationTimeSystem;
    }

    public static String GetPropertyValue(String string) {
        FlAppProperties flAppProperties = new FlAppProperties();
        flAppProperties.Load();
        return flAppProperties.GetValue(string);
    }

    public void SetIgnoreSecondKeyDown(boolean bl) {
        this.mIgnoreSecondKeyDown = bl;
    }

    public FlApplication() {
        FrameworkGlobals.GetInstance().application = this;
        this.mComponentWithFocus = this;
        FlRect flRect = FlDisplayManager.GetVideoModeRect();
        this.SetRect(flRect.GetLeft(), flRect.GetTop(), flRect.GetWidth(), flRect.GetHeight());
        FlKeyManager.GetInstance();
        this.mLong64Array = new long[2];
        this.mLong64Array[0] = FlApplication.GetRealTime();
        this.mLong64Array[1] = 0L;
        this.SetSupportedGameOrientations(15);
    }

    public Scene GetCurrentScene() {
        return this.mCurrentScene;
    }

    public boolean IsInSceneTransition() {
        return this.mCurrentTransitionType != 0;
    }

    public static void OSExit() {
        J2MEApp.instance.OSExit();
    }

    public void SendKeyDownMsg(int n2) {
        this.mComponentWithFocus.SendMsg(this.mComponentWithFocus, -120, n2);
    }

    public void SendKeyUpMsg(int n2) {
        this.mComponentWithFocus.SendMsg(this.mComponentWithFocus, -121, n2);
    }

    public void SendKeyRepeatMsg(int n2) {
        this.mComponentWithFocus.SendMsg(this.mComponentWithFocus, -119, n2);
    }

    public static void MoveFocusForNotifications(Component component, Component component2, int n2) {
        if (component == component2) {
            return;
        }
        int n3 = n2;
        Component component3 = null;
        if (n2 <= 0) {
            component.OnFocusChange(false);
            component = component.GetViewport();
            ++n3;
            if (component == component2) {
                component2.OnFocusChange(true);
            }
        }
        if (n2 >= 0) {
            component3 = component2;
            component2 = component2.GetViewport();
            --n3;
        }
        FlApplication.MoveFocusForNotifications(component, component2, n3);
        if (component3 != null) {
            component3.OnFocusChange(true);
        }
    }

    public int GetDefaultGamingKey(byte by) {
        return this.GetDefaultGamingKey(by, (byte)0);
    }

    public byte GetSoftKeyPosition(int n2) {
        return this.GetSoftKeyPosition(n2, (byte)0);
    }

    public boolean SetGameOrientation(byte by) {
        return this.SetGameOrientation(by, true);
    }

    public static FlApplication[] InstArrayFlApplication(int n2) {
        FlApplication[] flApplicationArray = new FlApplication[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            flApplicationArray[i2] = new FlApplication();
        }
        return flApplicationArray;
    }

    public static FlApplication[][] InstArrayFlApplication(int n2, int n3) {
        FlApplication[][] flApplicationArray = new FlApplication[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flApplicationArray[i2] = new FlApplication[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                flApplicationArray[i2][i3] = new FlApplication();
            }
        }
        return flApplicationArray;
    }

    public static FlApplication[][][] InstArrayFlApplication(int n2, int n3, int n4) {
        FlApplication[][][] flApplicationArray = new FlApplication[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flApplicationArray[i2] = new FlApplication[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                flApplicationArray[i2][i3] = new FlApplication[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    flApplicationArray[i2][i3][i4] = new FlApplication();
                }
            }
        }
        return flApplicationArray;
    }
}

