/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlColor;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.GameApp;

public class Utilities {
    public static boolean IsAttachedToApplication(Component component) {
        Component component2 = component;
        while (component2 != GameApp.Get()) {
            if ((component2 = component2.GetViewport()) != null) continue;
            return false;
        }
        return true;
    }

    public static int GetKeyValue(int n2) {
        if (n2 >= 17 && n2 <= 26) {
            return n2 - 17;
        }
        return -1;
    }

    public static int GetSelectionIndexFromCommmand(Selector selector, int n2) {
        int n3 = selector.GetNumSelections();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (selector.GetSelectionAt(i2).GetCommand() != n2) continue;
            return i2;
        }
        return -1;
    }

    public static void AddSelection(Selector selector, Selection selection, int n2) {
        selection.SetVisible(true);
        int n3 = selector.GetNumSelections();
        selector.SetNumElements(n3 + 1);
        short s2 = selection.GetRectHeight();
        for (int i2 = n3; i2 > n2; --i2) {
            selector.SetElementAt(i2, selector.GetElementAt(i2 - 1));
            selector.GetElementAt(i2).SetTopLeft((short)0, (short)(i2 * s2));
        }
        selector.SetElementAt(n2, selection);
        selection.SetTopLeft((short)0, (short)(n2 * s2));
        selector.UpdateScroller();
    }

    public static void RemoveSelectionByCommand(Selector selector, int n2) {
        int n3 = Utilities.GetSelectionIndexFromCommmand(selector, n2);
        if (n3 >= 0) {
            Utilities.RemoveSelection(selector, n3);
        }
    }

    public static void RemoveSelection(Selector selector, int n2) {
        selector.GetElementAt(n2).SetVisible(false);
        int n3 = selector.GetNumSelections();
        short s2 = selector.GetElementAt(n2).GetRectHeight();
        for (int i2 = n2; i2 < n3 - 1; ++i2) {
            selector.SetElementAt(i2, selector.GetElementAt(i2 + 1));
            selector.GetElementAt(i2).SetTopLeft((short)0, (short)(i2 * s2));
        }
        selector.SetNumElements(n3 - 1);
        selector.UpdateScroller();
    }

    public static void CenterComponent(Component component) {
        Viewport viewport = component.GetViewport();
        short s2 = component.GetRectWidth();
        short s3 = component.GetRectHeight();
        short s4 = viewport.GetRectWidth();
        short s5 = viewport.GetRectHeight();
        int n2 = s4 / 2 - s2 / 2;
        int n3 = s5 / 2 - s3 / 2;
        component.SetTopLeft((short)n2, (short)n3);
    }

    public static FlString TrimString(FlString flString) {
        FlString flString2 = new FlString(flString);
        while (flString2.GetLength() > 0 && flString2.GetCharAt(0) == 32) {
            flString2.RemoveCharAt(0);
        }
        int n2 = flString2.GetLength() - 1;
        while (n2 >= 0 && flString2.GetCharAt(n2) == 32) {
            flString2.RemoveCharAt(n2);
            n2 = flString2.GetLength() - 1;
        }
        return flString2;
    }

    public static void ToUpper(FlString flString) {
        int n2 = flString.GetLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = flString.GetCharAt(i2);
            if (by < 97 || by > 122) continue;
            flString.ReplaceCharAt(i2, (byte)(by - 32));
        }
    }

    public static void BubbleSort(int[] nArray, int n2) {
        for (int i2 = 1; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2 - i2; ++i3) {
                if (nArray[i3] > nArray[i3 + 1]) continue;
                int n3 = nArray[i3];
                nArray[i3] = nArray[i3 + 1];
                nArray[i3 + 1] = n3;
            }
        }
    }

    public static boolean StringReplacer(FlString flString, FlString flString2, FlString flString3) {
        int n2 = flString.FindSubstring(flString2);
        if (n2 != -1) {
            flString.ReplaceStringAt(n2, flString3, flString2.GetLength());
        }
        return n2 != -1;
    }

    public static int ValidateLongValue(int n2) {
        return n2 >= 2140000000 ? 2140000000 : (n2 <= -2140000000 ? -2140000000 : n2);
    }

    public static Shape CreateShape(FlColor flColor, Viewport viewport) {
        Shape shape = new Shape(viewport);
        shape.SetSolid(true);
        shape.SetColor(flColor);
        return shape;
    }

    public static Utilities[] InstArrayUtilities(int n2) {
        Utilities[] utilitiesArray = new Utilities[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            utilitiesArray[i2] = new Utilities();
        }
        return utilitiesArray;
    }

    public static Utilities[][] InstArrayUtilities(int n2, int n3) {
        Utilities[][] utilitiesArray = new Utilities[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            utilitiesArray[i2] = new Utilities[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                utilitiesArray[i2][i3] = new Utilities();
            }
        }
        return utilitiesArray;
    }

    public static Utilities[][][] InstArrayUtilities(int n2, int n3, int n4) {
        Utilities[][][] utilitiesArray = new Utilities[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            utilitiesArray[i2] = new Utilities[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                utilitiesArray[i2][i3] = new Utilities[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    utilitiesArray[i2][i3][i4] = new Utilities();
                }
            }
        }
        return utilitiesArray;
    }
}

