/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerState;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class StateEliminatingPlayer
extends PokerState {
    public static final byte kUndefined = -1;
    public static final byte kDeterminePlayerToEliminate = 0;
    public static final byte kEliminatingHumanPlayer = 1;
    public static final byte kEliminatingAIPlayer = 2;
    public static final byte kEliminatePlayer = 3;
    public static final byte kLeavingEliminationState = 4;
    public byte mStateStage = (byte)-1;

    public StateEliminatingPlayer(PokerGame pokerGame) {
        super(pokerGame);
    }

    public void destruct() {
    }

    public byte GetID() {
        return 8;
    }

    public int GetAcceptSoftkeyCaption() {
        int n2 = 2;
        if (!GameApp.Get().GetGameSettings().IsCurrentModeTournament()) {
            n2 = 0;
        }
        return n2;
    }

    public void OnEntry() {
        this.mGameScene.UpdateSoftKey();
        if (this.mStateStage == -1) {
            this.mTexasManager.FlagEliminatedPlayers();
            this.SetStage((byte)0);
        }
    }

    public void OnExit() {
        this.SetStage((byte)-1);
    }

    public void OnTime(int n2, int n3) {
        this.ManageState();
        super.OnTime(n2, n3);
    }

    public void OnSkip() {
        this.mGameScene.GetPlayerViewportManager().ToggleInfoScreensOutIfNeeded();
        this.HidePopup();
        while (this.mStateStage != 0 && this.mStateStage != 4) {
            this.ManageState();
        }
        super.OnSkip();
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        this.mStateStage = fileSegmentStream.ReadByte();
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte(this.mStateStage);
    }

    public void ManageState() {
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        switch (this.mStateStage) {
            case 0: {
                PokerPlayer pokerPlayer = null;
                pokerPlayer = this.mTexasManager.GetEliminatedPlayer();
                if (pokerPlayer == null) {
                    this.SetStage((byte)4);
                    break;
                }
                if (pokerPlayer.IsPlayerHuman()) {
                    this.SetStage((byte)1);
                    break;
                }
                playerViewportManager.ToggleInfoScreen(texasPokerTable.GetSeatOfPlayer(pokerPlayer), true, 0);
                this.SetStage((byte)2);
                break;
            }
            case 1: {
                this.mGameScene.UpdateSoftKey();
                this.HandlePopup((byte)18);
                this.SetStage((byte)3);
                break;
            }
            case 2: {
                this.HandlePopup((byte)9);
                this.SetStage((byte)3);
                break;
            }
            case 3: {
                PokerPlayer pokerPlayer = this.mTexasManager.GetEliminatedPlayer();
                if (!pokerPlayer.IsPlayerHuman()) {
                    byte by = texasPokerTable.GetSeatOfPlayer(pokerPlayer);
                    playerViewportManager.SetPlayerCardVisible(false, by, false);
                    playerViewportManager.ToggleInfoScreen(by, false);
                }
                pokerPlayer.SetState((byte)0);
                this.mTexasManager.PopEliminatedPlayer();
                this.SetStage((byte)0);
                break;
            }
            case 4: {
                if (!playerViewportManager.IsInfoScreenAnimationCompleted()) break;
                this.SetNextState((byte)9);
            }
        }
    }

    public void SetStage(byte by, int n2) {
        this.mStateStage = by;
        this.SetWaitingTime(n2);
    }

    public void SetStage(byte by) {
        this.SetStage(by, -1);
    }
}

