/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Selector;
import ca.jamdat.texasholdem09.Menu;
import ca.jamdat.texasholdem09.SelectionBar;

public class SelectorMenu
extends Menu {
    public Selector mSelector;
    public int mFocusedSelectionIndex;
    public int mNbVisibleElements;

    public SelectorMenu(int n2, int n3) {
        super(n2, n3);
    }

    public void destruct() {
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mSelector = Selector.Cast(this.mPackage.GetEntryPoint(-1), null);
    }

    public void ReceiveFocus() {
        super.ReceiveFocus();
        if (this.mSelector.GetNumSelections() > 0) {
            while (!this.mSelector.GetSelectionAt(this.mFocusedSelectionIndex).GetEnabledState()) {
                ++this.mFocusedSelectionIndex;
                if (this.mFocusedSelectionIndex <= this.mSelector.GetNumSelections()) continue;
                this.mFocusedSelectionIndex = 0;
            }
            Selection selection = this.mSelector.GetSelectionAt(this.mFocusedSelectionIndex);
            selection.TakeFocus();
            this.mSelector.SetSingleSelection(this.mFocusedSelectionIndex, true);
            SelectionBar selectionBar = this.GetSelectionBar();
            if (selectionBar != null) {
                selectionBar.SetVisible(true);
            }
            if (this.mCursor != null) {
                this.mCursor.SetVisible(true);
                this.mCursor.StartAnim();
            }
        }
    }

    public void Unload() {
        if (this.mSelector != null) {
            this.mFocusedSelectionIndex = this.mSelector.GetSingleSelection();
            if (this.mFocusedSelectionIndex == -1) {
                this.mFocusedSelectionIndex = 0;
            }
            this.mSelector = null;
        }
        super.Unload();
    }

    public boolean OnMsg(Component component, int n2, int n3) {
        if (n2 == -128 && component == this.mView && n3 == 0) {
            this.mFocusedSelectionIndex = this.mSelector.GetSingleSelection();
            Selection selection = this.mSelector.GetSelectionAt(this.mFocusedSelectionIndex);
            selection.SetSelectedState(false, false);
            SelectionBar selectionBar = this.GetSelectionBar();
            if (selectionBar != null) {
                selectionBar.SetVisible(false);
            }
            if (this.mCursor != null) {
                this.mCursor.SetVisible(false);
                this.mCursor.StopAnim();
            }
        }
        return super.OnMsg(component, n2, n3);
    }

    public Scroller GetPenMoveHScrollingComponent() {
        return this.mSelector.IsVertical() ? super.GetPenMoveHScrollingComponent() : this.mSelector;
    }

    public Scroller GetPenMoveVScrollingComponent() {
        return this.mSelector.IsVertical() ? this.mSelector : super.GetPenMoveVScrollingComponent();
    }
}

