/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Text;
import ca.jamdat.texasholdem09.Cursor;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.HorizontalSelector;
import ca.jamdat.texasholdem09.SelectionBar;
import ca.jamdat.texasholdem09.SelectorMenu;
import ca.jamdat.texasholdem09.VerticalSelector;

public class PracticeMenu
extends SelectorMenu {
    public Selector mLevelSelector;
    public Selector mGameTypeSelector;
    public Selector mBlindsSelector;

    public PracticeMenu(int n2, int n3) {
        super(n2, n3);
        this.SetCursor(new Cursor());
        this.SetSelectionBar(new SelectionBar());
    }

    public void destruct() {
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mLevelSelector = Selector.Cast(this.mPackage.GetEntryPoint(6), null);
        this.mGameTypeSelector = Selector.Cast(this.mPackage.GetEntryPoint(7), null);
        this.mBlindsSelector = Selector.Cast(this.mPackage.GetEntryPoint(8), null);
    }

    public void Unload() {
        this.mLevelSelector = null;
        this.mGameTypeSelector = null;
        this.mBlindsSelector = null;
        super.Unload();
    }

    public void Initialize() {
        super.Initialize();
        this.mBankRoll.SetBankRollVisibility(false);
        HorizontalSelector.Initialize(this.mLevelSelector, 0);
        HorizontalSelector.Initialize(this.mGameTypeSelector, 1);
        HorizontalSelector.Initialize(this.mBlindsSelector, 0);
        this.mNbVisibleElements = VerticalSelector.Initialize(this.mSelector, 0);
        this.UpdateBlindSelection();
        GameApp.Get().GetTutorialManager().HandleTutorial((byte)4, this);
    }

    public boolean OnCommand(int n2) {
        boolean bl = false;
        if (n2 == -77) {
            this.SetGameSettings();
            this.OnCommand(-74);
            bl = true;
        }
        return bl || super.OnCommand(n2);
    }

    public boolean OnMsg(Component component, int n2, int n3) {
        boolean bl = false;
        if (n2 == -111 && component == this.mGameTypeSelector) {
            this.UpdateBlindSelection();
            bl = true;
        }
        return bl || super.OnMsg(component, n2, n3);
    }

    public Scroller GetPenMoveHScrollingComponent() {
        Selection selection = this.mSelector.GetSelectionAt(this.mSelector.GetSingleSelection());
        Selector selector = null;
        if (selection.ForwardFocus() != selection) {
            selector = (Selector)selection.ForwardFocus();
        }
        return selector;
    }

    public int GetBestUnlockedLocation() {
        int n2 = 6;
        for (int i2 = 0; i2 < 5; ++i2) {
            if (!GameApp.Get().GetCareerState().IsCasinoUnlocked(i2) || i2 == 1 || i2 == 3) continue;
            n2 = i2;
        }
        return n2;
    }

    public int GetDifficulty() {
        int n2 = 6;
        switch (this.mLevelSelector.GetSingleSelection()) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
        }
        return n2;
    }

    public void SetGameSettings() {
        GameSettings gameSettings = GameApp.Get().GetGameSettings();
        gameSettings.SetCurrentGameMode(this.mGameTypeSelector.GetSingleSelection());
        gameSettings.SetTournamentRound(gameSettings.IsCurrentModeTournament() ? 1 : 0);
        gameSettings.SetLocation(this.GetBestUnlockedLocation());
        gameSettings.SetDifficulty(this.GetDifficulty());
        gameSettings.SetBlind(this.mBlindsSelector.GetSingleSelection());
    }

    public void UpdateBlindSelection() {
        int n2 = this.mGameTypeSelector.GetSingleSelection();
        Selection selection = null;
        selection = Selection.Cast(this.mPackage.GetEntryPoint(4), null);
        selection.SetEnabledState(n2 != 2);
        if (n2 == 2) {
            this.mBlindsSelector.SetSingleSelection(0);
            this.mBlindsSelector.UpdateScroller();
        }
        int n3 = this.mBlindsSelector.GetNumSelections();
        int n4 = this.mLevelSelector.GetSingleSelection();
        FlString flString = new FlString(StringUtils.CreateString("/"));
        for (int i2 = 0; i2 < n3; ++i2) {
            Text text = (Text)this.mBlindsSelector.GetSelectionAt(i2).GetChild(0);
            FlString flString2 = new FlString(GameSettings.GetSmallBlindCostStatic(n4, i2, n2, true));
            FlString flString3 = new FlString(GameSettings.GetBigBlindCostStatic(n4, i2, n2, true));
            flString2.AddAssign(flString);
            flString2.AddAssign(flString3);
            text.SetCaption(flString2);
            flString3 = null;
        }
    }
}

