/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.Popup;

public class PopupManager {
    public int mNumPopups;
    public Popup[] mPopupArray = new Popup[7];

    public PopupManager() {
        for (int i2 = 0; i2 < 7; ++i2) {
            this.mPopupArray[i2] = null;
        }
    }

    public void destruct() {
        this.ReleasePopups();
        this.mPopupArray = null;
    }

    public void Unload() {
        for (int i2 = 0; i2 < this.mNumPopups; ++i2) {
            if (this.mPopupArray[i2] == null) continue;
            this.mPopupArray[i2].Unload();
        }
    }

    public void ReleasePopups() {
        this.Unload();
        for (int i2 = 0; i2 < 7; ++i2) {
            this.mPopupArray[i2] = null;
        }
        this.mNumPopups = 0;
    }

    public void AddPopup(Popup popup, boolean bl) {
        if (this.mNumPopups + 1 <= 7) {
            if (bl) {
                for (int i2 = this.mNumPopups; i2 > 0; --i2) {
                    this.mPopupArray[i2] = this.mPopupArray[i2 - 1];
                }
                this.mPopupArray[0] = popup;
            } else {
                this.mPopupArray[this.mNumPopups] = popup;
            }
            ++this.mNumPopups;
        }
    }

    public Popup GetNextPopup() {
        Popup popup = this.mPopupArray[0];
        for (int i2 = 0; i2 < this.mNumPopups - 1; ++i2) {
            this.mPopupArray[i2] = this.mPopupArray[i2 + 1];
        }
        --this.mNumPopups;
        this.mPopupArray[this.mNumPopups] = null;
        return popup;
    }

    public boolean IsPopupPending() {
        return this.mNumPopups > 0;
    }

    public boolean CanAddPopup() {
        return this.mNumPopups < 7;
    }

    public boolean IsPopupAdded(Popup popup) {
        for (int i2 = 0; i2 < this.mNumPopups; ++i2) {
            if (this.mPopupArray[i2] != popup) continue;
            return true;
        }
        return false;
    }

    public static PopupManager[] InstArrayPopupManager(int n2) {
        PopupManager[] popupManagerArray = new PopupManager[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            popupManagerArray[i2] = new PopupManager();
        }
        return popupManagerArray;
    }

    public static PopupManager[][] InstArrayPopupManager(int n2, int n3) {
        PopupManager[][] popupManagerArray = new PopupManager[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            popupManagerArray[i2] = new PopupManager[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                popupManagerArray[i2][i3] = new PopupManager();
            }
        }
        return popupManagerArray;
    }

    public static PopupManager[][][] InstArrayPopupManager(int n2, int n3, int n4) {
        PopupManager[][][] popupManagerArray = new PopupManager[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            popupManagerArray[i2] = new PopupManager[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                popupManagerArray[i2][i3] = new PopupManager[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    popupManagerArray[i2][i3][i4] = new PopupManager();
                }
            }
        }
        return popupManagerArray;
    }
}

