/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlMath;
import ca.jamdat.texasholdem09.Character;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.HV;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.PokerPlayerHuman;
import ca.jamdat.texasholdem09.PtrArray_PokerPlayer;
import ca.jamdat.texasholdem09.PtrArray_PokerPlayerAI;
import ca.jamdat.texasholdem09.Utilities;

public abstract class PokerTable {
    public static final byte undefinedSeat = -1;
    public static final byte firstSeat = 0;
    public static final byte bottomLeft = 0;
    public static final byte topLeft = 1;
    public static final byte topRight = 2;
    public static final byte bottomRight = 3;
    public static final byte bottom = 4;
    public static final byte seatCount = 5;
    public static final byte userSeat = 4;
    public PokerPlayer[] mPlayers = null;
    public int[][] mPotsDistribution = null;
    public int[] mPlayersPotContribution = null;
    public int mPotNbr = -1;
    public int mCurrentPotIdx;
    public int mNbOfStartingPlayers = GameApp.Get().GetGameSettings().IsCurrentModeHeadsUp() ? 2 : 5;
    public int mHeroCharacterAtTable = -1;

    public PokerTable() {
        this.mPlayers = new PokerPlayer[this.mNbOfStartingPlayers];
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            this.mPlayers[i2] = null;
        }
        this.mPotsDistribution = new int[this.mNbOfStartingPlayers][this.mNbOfStartingPlayers];
        this.mPlayersPotContribution = new int[this.mNbOfStartingPlayers];
    }

    public void destruct() {
    }

    public void UnloadResources() {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (this.mPlayers[i2] != null) {
                this.mPlayers[i2].UnloadResources();
                this.mPlayers[i2] = null;
                this.mPlayers[i2] = null;
            }
            if (this.mPotsDistribution[i2] == null) continue;
            this.mPotsDistribution[i2] = null;
        }
        this.mPlayers = null;
        this.mPotsDistribution = null;
        this.mPlayersPotContribution = null;
    }

    public abstract boolean ApplyHeadsupModifIfNeeded();

    public abstract void ResetNextData();

    public abstract void AddCard();

    public abstract byte[] GetCommunityCards();

    public PokerPlayer GetRightPlayer(PokerPlayer pokerPlayer) {
        int n2 = this.GetSeatOfPlayer(pokerPlayer);
        if (--n2 < 0) {
            n2 = this.mNbOfStartingPlayers - 1;
        }
        return this.mPlayers[n2];
    }

    public PokerPlayer GetLeftPlayer(PokerPlayer pokerPlayer) {
        int n2 = this.GetSeatOfPlayer(pokerPlayer);
        if (++n2 >= this.mNbOfStartingPlayers) {
            n2 = 0;
        }
        return this.mPlayers[n2];
    }

    public void AddHumanPlayer(byte by, int n2) {
        byte by2 = by;
        if (this.mPlayers[by2] != null) {
            this.mPlayers[by2].UnloadResources();
            this.mPlayers[by2] = null;
        }
        this.mPlayers[by2] = new PokerPlayerHuman();
        this.mPlayers[by2].SetChip(n2);
    }

    public void AddAIPlayer(byte by, int n2, Character character, boolean bl) {
        int n3 = this.MapSeatToSeatIdx(by);
        if (this.mPlayers[n3] != null) {
            this.mPlayers[n3].UnloadResources();
            this.mPlayers[n3] = null;
        }
        this.mPlayers[n3] = new PokerPlayerAI(character, bl);
        this.mPlayers[n3].SetChip(n2);
        if (this.mPlayers[n3].IsPlayerHero()) {
            this.SetHeroCharacterAtTable((PokerPlayerAI)this.mPlayers[n3]);
        }
    }

    public int GetPot(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            n3 += this.mPotsDistribution[n2][i2];
        }
        return n3;
    }

    public int GetPot() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            n2 += this.mPlayersPotContribution[i2];
        }
        return n2;
    }

    public int GetEffectivePotOfPlayer(PokerPlayer pokerPlayer) {
        int n2 = 0;
        byte by = this.GetSeatOfPlayer(pokerPlayer);
        int n3 = this.mPlayersPotContribution[by] + pokerPlayer.GetChip();
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (this.mPlayersPotContribution[i2] > n3) {
                n2 += n3;
                continue;
            }
            n2 += this.mPlayersPotContribution[i2];
        }
        return n2;
    }

    public void Save(FileSegmentStream fileSegmentStream) {
        int n2;
        for (n2 = 0; n2 < this.mNbOfStartingPlayers; ++n2) {
            this.mPlayers[n2].Save(fileSegmentStream);
        }
        for (n2 = 0; n2 < this.mNbOfStartingPlayers; ++n2) {
            for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
                fileSegmentStream.WriteLong(this.mPotsDistribution[i2][n2]);
            }
            fileSegmentStream.WriteLong(this.mPlayersPotContribution[n2]);
        }
        fileSegmentStream.WriteLong(this.mPotNbr);
        fileSegmentStream.WriteLong(this.mCurrentPotIdx);
        fileSegmentStream.WriteByte((byte)this.mHeroCharacterAtTable);
    }

    public void Load(FileSegmentStream fileSegmentStream) {
        int n2;
        for (n2 = 0; n2 < this.mNbOfStartingPlayers; ++n2) {
            this.mPlayers[n2].Load(fileSegmentStream);
        }
        for (n2 = 0; n2 < this.mNbOfStartingPlayers; ++n2) {
            for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
                this.mPotsDistribution[i2][n2] = fileSegmentStream.ReadLong();
            }
            this.mPlayersPotContribution[n2] = fileSegmentStream.ReadLong();
        }
        this.mPotNbr = fileSegmentStream.ReadLong();
        this.mCurrentPotIdx = fileSegmentStream.ReadLong();
        this.mHeroCharacterAtTable = fileSegmentStream.ReadByte();
    }

    public void CheckForExcedentMoneyInPot() {
        if (this.GetNumberPlayersInState((byte)1) <= 1) {
            int n2;
            int n3;
            boolean bl = false;
            if (this.GetNumberPlayersInState((byte)1) == 1) {
                if (this.GetNumberPlayersInState((byte)4) == 0) {
                    bl = true;
                }
            } else if (this.GetNumberPlayersInState((byte)4) == 1) {
                bl = true;
            }
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            for (n3 = 0; n3 < this.mNbOfStartingPlayers; ++n3) {
                n2 = n3;
                if (this.mPlayersPotContribution[n2] >= n8) {
                    n8 = this.mPlayersPotContribution[n2];
                    if (this.mPlayersPotContribution[n2] >= n7) {
                        n8 = n7;
                        n7 = this.mPlayersPotContribution[n2];
                    }
                }
                if (this.mPlayers[n2].GetState() == 4 && this.mPlayersPotContribution[n2] >= n6) {
                    n6 = this.mPlayersPotContribution[n2];
                    if (this.mPlayersPotContribution[n2] >= n5) {
                        n6 = n5;
                        n5 = this.mPlayersPotContribution[n2];
                    }
                }
                if (this.mPlayers[n2].GetState() != 1) continue;
                n4 = this.mPlayersPotContribution[n2];
            }
            if (n7 > n8) {
                n3 = 0;
                if (bl) {
                    n3 = n8;
                } else if (n5 == n7) {
                    n3 = n6;
                } else if (n4 == n7) {
                    n3 = n5;
                }
                n2 = this.mNbOfStartingPlayers;
                int n9 = 0;
                for (int n10 = 0; n10 < this.mNbOfStartingPlayers; n10 = (int)((byte)(n10 + 1))) {
                    if (this.mPlayersPotContribution[n10] == n7) {
                        int n11 = n2 = n10;
                        this.mPlayersPotContribution[n11] = this.mPlayersPotContribution[n11] - (n7 - n3);
                        n9 += n7 - n3;
                        continue;
                    }
                    if (this.mPlayersPotContribution[n10] <= n3) continue;
                    n9 += this.mPlayersPotContribution[n10] - n3;
                    int n12 = n10;
                    this.mPlayersPotContribution[n12] = this.mPlayersPotContribution[n12] - (this.mPlayersPotContribution[n10] - n3);
                }
                this.mPlayers[n2].AddChip(n9);
            }
        }
    }

    public int GetNumberPlayersInState(byte by) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (this.mPlayers[i2].GetState() != by) continue;
            ++n2;
        }
        return n2;
    }

    public int GetNbOfPlayersInTheHand() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (!this.mPlayers[i2].IsPlayerInTheHand()) continue;
            ++n2;
        }
        return n2;
    }

    public void ResetPots() {
        this.mCurrentPotIdx = 0;
        this.ResetPotsDistribution();
        this.ResetPlayersPotContribution();
    }

    public void ResetForNextHand() {
        this.ResetPots();
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            this.mPlayers[i2].ResetForNextHand();
        }
    }

    public void ResetForNextBettingRound() {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            this.mPlayers[i2].ResetForNextBettingRound();
        }
    }

    public void ResolvePotsDistribution() {
        int n2;
        int n3;
        int n4 = this.GetNumberPlayersInState((byte)4);
        this.ResetPotsDistribution();
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            this.mPotsDistribution[0][i2] = this.mPlayersPotContribution[i2];
        }
        if (n4 == 0) {
            this.mPotNbr = 1;
            return;
        }
        int[] nArray = null;
        nArray = new int[this.mNbOfStartingPlayers];
        int n5 = 0;
        for (n3 = 0; n3 < this.mNbOfStartingPlayers; n3 = (byte)(n3 + 1)) {
            if (this.GetPlayerSeatedAt((byte)n3).GetState() != 4) continue;
            nArray[n5] = this.mPlayersPotContribution[n3];
            ++n5;
        }
        Utilities.BubbleSort(nArray, n4);
        n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (n3 != 0 && nArray[n5 - 1] == nArray[n3]) continue;
            nArray[n5] = nArray[n3];
            ++n5;
        }
        n3 = n5;
        Utilities.BubbleSort(nArray, n3);
        int[] nArray2 = null;
        nArray2 = new int[this.mNbOfStartingPlayers];
        for (n2 = 0; n2 < this.mNbOfStartingPlayers; ++n2) {
            nArray2[n2] = this.mPlayersPotContribution[n2];
        }
        Utilities.BubbleSort(nArray2, this.mNbOfStartingPlayers);
        this.mPotNbr = n3;
        if (nArray2[0] > nArray[0]) {
            ++this.mPotNbr;
        }
        for (n2 = 0; n2 < this.mPotNbr - 1; ++n2) {
            int n6 = nArray[n3 - n2 - 1];
            if (n2 != 0) {
                n6 -= nArray[n3 - n2];
            }
            this.TrimPot(n2, n6);
        }
        nArray = null;
        nArray2 = null;
    }

    public int ComputeUserPosition() {
        int n2 = 4;
        int n3 = this.GetNbOfStartingAIPlayers();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!this.mPlayers[i2].IsPlayerOutOfTheGame()) continue;
            --n2;
        }
        return n2;
    }

    public boolean AreInPlayCardsAllShown() {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (!this.mPlayers[i2].IsPlayerInTheHand()) continue;
            ++n2;
            if (!this.mPlayers[i2].AreCardsShown()) continue;
            ++n3;
        }
        return n2 == n3;
    }

    public byte GetSeatOfPlayer(PokerPlayer pokerPlayer) {
        if (pokerPlayer != null) {
            for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
                if (pokerPlayer != this.mPlayers[i2]) continue;
                return (byte)i2;
            }
        }
        return -1;
    }

    public PokerPlayer GetPlayerSeatedAt(byte by) {
        int n2 = this.MapSeatToSeatIdx(by);
        if (n2 == -1) {
            return null;
        }
        return this.mPlayers[n2];
    }

    public PokerPlayer GetHumanPlayer() {
        return this.GetPlayerSeatedAt(PokerTable.GetSeatOfHumanPlayer());
    }

    public int GetPotsNbr() {
        return this.mPotNbr;
    }

    public int GetNbOfPlayersInCurrentPot() {
        return this.GetNbOfPlayersInPot(this.mPotNbr - 1);
    }

    public boolean IsPlayerInvolvedInCurrentPot(byte by) {
        return this.IsPlayerInvolvedInPot(this.mPotNbr - 1, by);
    }

    public void IncrementCurrentPotIdx() {
        ++this.mCurrentPotIdx;
    }

    public int GetCurrentPotIdx() {
        return this.mCurrentPotIdx;
    }

    public void GetPlayersInPot(PtrArray_PokerPlayer ptrArray_PokerPlayer, int n2) {
        ptrArray_PokerPlayer.Clear();
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            byte by = (byte)i2;
            if (!this.IsPlayerInvolvedInPot(n2, by) || this.mPlayers[by].GetState() == 2) continue;
            ptrArray_PokerPlayer.Insert(this.mPlayers[by]);
        }
    }

    public void GetPotWinners(PtrArray_PokerPlayer ptrArray_PokerPlayer, int n2) {
        ptrArray_PokerPlayer.Clear();
        PtrArray_PokerPlayer ptrArray_PokerPlayer2 = new PtrArray_PokerPlayer();
        this.GetPlayersInPot(ptrArray_PokerPlayer2, n2);
        int n3 = ptrArray_PokerPlayer2.GetAt(0).GetHandValue();
        ptrArray_PokerPlayer.InsertAt(ptrArray_PokerPlayer2.GetAt(0), 0);
        int n4 = 1;
        for (int i2 = 1; i2 < ptrArray_PokerPlayer2.End(); ++i2) {
            short s2 = HV.Compare(n3, ptrArray_PokerPlayer2.GetAt(i2).GetHandValue());
            if (s2 == 0) {
                ptrArray_PokerPlayer.InsertAt(ptrArray_PokerPlayer2.GetAt(i2), n4);
                ++n4;
                continue;
            }
            if (s2 >= 0) continue;
            ptrArray_PokerPlayer.Clear();
            ptrArray_PokerPlayer.InsertAt(ptrArray_PokerPlayer2.GetAt(i2), 0);
            n4 = 1;
            n3 = ptrArray_PokerPlayer2.GetAt(i2).GetHandValue();
        }
        ptrArray_PokerPlayer2.Clear();
    }

    public void PayPotWinners(PtrArray_PokerPlayer ptrArray_PokerPlayer, int n2) {
        int n3 = this.GetPot(n2);
        int n4 = n3 / ptrArray_PokerPlayer.End();
        int n5 = n3 - n4 * ptrArray_PokerPlayer.End();
        for (int i2 = 0; i2 < ptrArray_PokerPlayer.End(); ++i2) {
            int n6 = 0;
            if (n5 > 0) {
                n6 = 1;
                --n5;
            }
            ptrArray_PokerPlayer.GetAt(i2).AddChip(n4 + n6);
            ptrArray_PokerPlayer.GetAt(i2).AddChipWon(n4 + n6);
        }
        --this.mPotNbr;
        --this.mCurrentPotIdx;
    }

    public void AddToPot(int n2, int n3) {
        int n4 = n2;
        this.mPlayersPotContribution[n4] = this.mPlayersPotContribution[n4] + n3;
    }

    public void TrimPot(int n2, int n3) {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (this.mPotsDistribution[n2][i2] - n3 <= 0) continue;
            this.mPotsDistribution[n2 + 1][i2] = this.mPotsDistribution[n2][i2] - n3;
            this.mPotsDistribution[n2][i2] = n3;
        }
    }

    public int GetMaxValueInPot(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (n3 >= this.mPotsDistribution[n2][i2]) continue;
            n3 = this.mPotsDistribution[n2][i2];
        }
        return n3;
    }

    public int GetPotContributionFrom(byte by) {
        return this.mPlayersPotContribution[by];
    }

    public int GetMaxPotContribution() {
        int n2 = this.mPlayersPotContribution[0];
        for (int n3 = 0; n3 < this.mNbOfStartingPlayers; n3 = (int)((byte)(n3 + 1))) {
            if (this.mPlayersPotContribution[n3] <= n2) continue;
            n2 = this.mPlayersPotContribution[n3];
        }
        return n2;
    }

    public void ResetPotsDistribution() {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            for (int i3 = 0; i3 < this.mNbOfStartingPlayers; ++i3) {
                this.mPotsDistribution[i3][i2] = 0;
            }
        }
    }

    public void ResetPlayersPotContribution() {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            this.mPlayersPotContribution[i2] = 0;
        }
    }

    public void GetNotOutAiPlayers(PtrArray_PokerPlayerAI ptrArray_PokerPlayerAI) {
        ptrArray_PokerPlayerAI.Clear();
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (this.mPlayers[(byte)i2].GetState() == 0) continue;
            ptrArray_PokerPlayerAI.Insert((PokerPlayerAI)this.mPlayers[(byte)i2]);
        }
    }

    public void CloseTable() {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (this.mPlayers[i2] != null) continue;
            this.AddAIPlayer((byte)i2, 0, new Character(-1, -1), true);
            this.mPlayers[i2].SetState((byte)0);
        }
    }

    public int GetNbOfStartingAIPlayers() {
        return this.mNbOfStartingPlayers - 1;
    }

    public int GetNbOfStartingPlayers() {
        return this.mNbOfStartingPlayers;
    }

    public static byte GetSeatOfHumanPlayer() {
        byte by = 4;
        if (GameApp.Get().GetGameSettings().IsCurrentModeHeadsUp()) {
            by = 1;
        }
        return by;
    }

    public int GetHeroCharacterAtTable() {
        return this.mHeroCharacterAtTable;
    }

    public int GetNbOfPlayersInPot(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            byte by = (byte)i2;
            if (!this.IsPlayerInvolvedInPot(n2, by) || this.mPlayers[by].GetState() == 2) continue;
            ++n3;
        }
        return n3;
    }

    public boolean IsPlayerInvolvedInPot(int n2, byte by) {
        return this.mPotsDistribution[n2][by] > 0;
    }

    public void SetHeroCharacterAtTable(PokerPlayerAI pokerPlayerAI) {
        boolean bl = true;
        int n2 = pokerPlayerAI.GetPortrait();
        if (this.mHeroCharacterAtTable != -1) {
            boolean bl2 = bl = FlMath.Random((short)0, (short)1) == 1;
        }
        if (bl) {
            this.mHeroCharacterAtTable = n2;
        }
    }

    public int MapSeatToSeatIdx(byte by) {
        byte by2 = by;
        if (by != -1 && GameApp.Get().GetGameSettings().IsCurrentModeHeadsUp() && by != PokerTable.GetSeatOfHumanPlayer()) {
            by2 = 0;
        }
        return by2;
    }

    public void AddAIPlayer(byte by, int n2, Character character) {
        this.AddAIPlayer(by, n2, character, false);
    }
}

