/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameScene;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.TexasGameManager;
import ca.jamdat.texasholdem09.TexasPokerTable;

public abstract class PokerState {
    public static final byte kStateInvalid = -1;
    public static final byte kStateIntroduction = 0;
    public static final byte kStateWaitingForInitialize = 1;
    public static final byte kStateWaitingForDeal = 2;
    public static final byte kStateDealingCards = 3;
    public static final byte kStateBetting = 4;
    public static final byte kStateDealingSharedCards = 5;
    public static final byte kStateNoShowdown = 6;
    public static final byte kStateShowdown = 7;
    public static final byte kStateEliminatingPlayer = 8;
    public static final byte kStateEndingTurn = 9;
    public static final byte kStateGameOver = 10;
    public PokerGame mPokerGame;
    public GameScene mGameScene;
    public byte mNextState;
    public TexasGameManager mTexasManager;

    public PokerState(PokerGame pokerGame) {
        this.mPokerGame = pokerGame;
        this.mNextState = (byte)-1;
        this.mTexasManager = TexasGameManager.Get();
    }

    public void destruct() {
    }

    public abstract byte GetID();

    public int GetAcceptSoftkeyCaption() {
        return 2;
    }

    public int GetDeclineSoftkeyCaption() {
        return 3;
    }

    public void Load() {
    }

    public void Unload() {
    }

    public void OnEntry() {
        if (this.mPokerGame.IsSkippingToEnd() && !GameApp.Get().GetCheatContainer().GetCheat(13).IsActivated()) {
            this.mPokerGame.SetIsInSkipMode(true);
        }
    }

    public void OnExit() {
    }

    public boolean OnCommand(int n2) {
        return false;
    }

    public boolean OnKeyUp(int n2) {
        boolean bl = false;
        if (!this.mPokerGame.IsInSkipMode()) {
            this.mPokerGame.SetIsInSkipMode(true);
            bl = true;
        }
        return bl;
    }

    public boolean OnKeyDownOrRepeat(int n2) {
        return false;
    }

    public void OnPause() {
    }

    public void OnSkip() {
        this.SetWaitingTime(0);
        this.mPokerGame.SetIsInSkipMode(false);
    }

    public void OnTime(int n2, int n3) {
        if (this.ReadyForNextState()) {
            this.mPokerGame.ChangeState(this.mNextState);
            this.mNextState = (byte)-1;
        }
    }

    public boolean IsWaitingForUserInput() {
        return false;
    }

    public boolean ReadyForNextState() {
        return this.mNextState != -1;
    }

    public byte GetNextState() {
        return this.mNextState;
    }

    public void SetNextState(byte by) {
        if (this.mNextState != 10) {
            this.mNextState = by;
        }
    }

    public void GoToNextGameState() {
    }

    public void Read(FileSegmentStream fileSegmentStream) {
    }

    public void Write(FileSegmentStream fileSegmentStream) {
    }

    public void SetGameScene(GameScene gameScene) {
        this.mGameScene = gameScene;
    }

    public void SetWaitingTime(int n2) {
        this.mPokerGame.SetWaitingTime(n2);
    }

    public void HidePopup() {
        if (this.mGameScene.GetCurrentPopup() != null) {
            this.mGameScene.HidePopup();
        }
    }

    public void HandlePopup(byte by) {
        if (!this.mPokerGame.IsInSkipMode()) {
            this.mGameScene.HandlePopup(by);
        }
    }

    public void UpdateHumanPlayerStackUI() {
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        playerViewportManager.GetHumanPlayerViewport().SetStackText(texasPokerTable.GetHumanPlayer().GetChip());
    }
}

