/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.TexasGameManager;

public class PokerPlayerHuman
extends PokerPlayerAI {
    public PlayerDecision mHumanDecision = new PlayerDecision();

    public PokerPlayerHuman() {
        super(TexasGameManager.Get().GetHumanAdvisorCharacter());
    }

    public void destruct() {
    }

    public boolean IsPlayerHuman() {
        return true;
    }

    public void UnloadResources() {
        this.mHumanDecision = null;
        super.UnloadResources();
    }

    public void ResetForNextBettingRound() {
        super.ResetForNextBettingRound();
        this.mHumanDecision.SetPlayerAction((byte)-1);
    }

    public void Save(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte(this.mHumanDecision.GetPlayerAction());
        fileSegmentStream.WriteLong(this.mHumanDecision.GetChip());
        super.Save(fileSegmentStream);
    }

    public void Load(FileSegmentStream fileSegmentStream) {
        this.mHumanDecision.SetPlayerAction(fileSegmentStream.ReadByte());
        this.mHumanDecision.SetChip(fileSegmentStream.ReadLong());
        super.Load(fileSegmentStream);
    }

    public void SetDecision(PlayerDecision playerDecision) {
        this.mHumanDecision.SetChip(playerDecision.GetChip());
        this.mHumanDecision.SetPlayerAction(playerDecision.GetPlayerAction());
        this.CheckBluff(this.mHumanDecision);
        this.mActionReady = true;
    }

    public PlayerDecision GetDecision() {
        return this.mHumanDecision;
    }

    public void SetChip(int n2) {
        super.SetChip(n2);
        GameApp gameApp = GameApp.Get();
        if (!gameApp.GetGameSettings().IsPractice()) {
            gameApp.GetCareerState().SetInGameStack(n2);
        }
    }

    public PlayerDecision GetAdvisorDecision() {
        return this.mPlayerDecision;
    }

    public static PokerPlayerHuman[] InstArrayPokerPlayerHuman(int n2) {
        PokerPlayerHuman[] pokerPlayerHumanArray = new PokerPlayerHuman[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            pokerPlayerHumanArray[i2] = new PokerPlayerHuman();
        }
        return pokerPlayerHumanArray;
    }

    public static PokerPlayerHuman[][] InstArrayPokerPlayerHuman(int n2, int n3) {
        PokerPlayerHuman[][] pokerPlayerHumanArray = new PokerPlayerHuman[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            pokerPlayerHumanArray[i2] = new PokerPlayerHuman[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                pokerPlayerHumanArray[i2][i3] = new PokerPlayerHuman();
            }
        }
        return pokerPlayerHumanArray;
    }

    public static PokerPlayerHuman[][][] InstArrayPokerPlayerHuman(int n2, int n3, int n4) {
        PokerPlayerHuman[][][] pokerPlayerHumanArray = new PokerPlayerHuman[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            pokerPlayerHumanArray[i2] = new PokerPlayerHuman[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                pokerPlayerHumanArray[i2][i3] = new PokerPlayerHuman[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    pokerPlayerHumanArray[i2][i3][i4] = new PokerPlayerHuman();
                }
            }
        }
        return pokerPlayerHumanArray;
    }
}

