/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.Text;
import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.Cursor;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerPlayerHuman;
import ca.jamdat.texasholdem09.Popup;
import ca.jamdat.texasholdem09.Softkey;
import ca.jamdat.texasholdem09.SubtypeHandler;
import ca.jamdat.texasholdem09.TexasGameManager;

public class PlayerActionPopup
extends Popup {
    public static final byte callCheckSelection = 0;
    public static final byte raiseBetSelection = 1;
    public static final byte allInSelection = 2;
    public static final byte foldSelection = 3;
    public static final byte menuSelectionCount = 4;
    public static final byte callCheckCaptionText = 0;
    public static final byte callCheckValueText = 1;
    public static final byte raiseBetCaptionText = 2;
    public static final byte raiseBetValueText = 3;
    public static final byte allInValueText = 4;
    public static final byte actionTextCount = 5;
    public int mRaiseTo;
    public int mSmallBlindValue;
    public boolean mRaiseDisabled;
    public boolean mAllInDisabled;
    public boolean mCallDisabled;
    public PlayerDecision mMinRaiseOrBet;
    public PlayerDecision mMaxRaiseOrBet;
    public PlayerDecision mCallDecision;
    public PlayerDecision mFoldDecision;
    public PlayerDecision mAllInDecision;
    public Selector mPlayerActionSelector;
    public Text[] mPlayerActionTexts = null;
    public int mKeyRepeatedCount;
    public int mKeyHeldTimer = -1;
    public int mKeyHeld = 0;
    public Selection mRaiseBetLeftArrowSelection;
    public Selection mRaiseBetRightArrowSelection;
    public Cursor mCursor;
    public boolean mIsBackFromAdvisor;

    public PlayerActionPopup(BaseScene baseScene, Softkey softkey, Softkey softkey2, Cursor cursor) {
        super(baseScene, softkey, softkey2, (byte)10, Popup.IsKeepGameScenePopupInMemory());
        this.mCursor = cursor;
        this.mMinRaiseOrBet = new PlayerDecision();
        this.mMaxRaiseOrBet = new PlayerDecision();
        this.mCallDecision = new PlayerDecision();
        this.mFoldDecision = new PlayerDecision();
        this.mAllInDecision = new PlayerDecision();
    }

    public void destruct() {
    }

    public void Load() {
        super.Load();
        if (this.mContentMetaPackage == null) {
            this.mContentMetaPackage = GameLibrary.GetPackage(1376298);
        }
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        Package package_ = this.mContentMetaPackage.GetPackage();
        this.mRaiseBetLeftArrowSelection = Selection.Cast(package_.GetEntryPoint(6), null);
        this.mRaiseBetRightArrowSelection = Selection.Cast(package_.GetEntryPoint(7), null);
        this.mPlayerActionTexts = new Text[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            Text cfr_ignored_0 = this.mPlayerActionTexts[i2];
            this.mPlayerActionTexts[i2] = Text.Cast(package_.GetEntryPoint(21 + i2), null);
        }
        this.mPlayerActionSelector = Selector.Cast(package_.GetEntryPoint(5), null);
        Selector selector = (Selector)this.mPlayerActionSelector.GetSelectionAt(1).GetChild(1);
        selector.SetSingleSelection(0);
    }

    public void InitializeSpecificPopup() {
        Package package_ = this.mContentMetaPackage.GetPackage();
        TexasGameManager texasGameManager = TexasGameManager.Get();
        PokerPlayer pokerPlayer = texasGameManager.GetActivePlayer();
        PlayerDecision[] playerDecisionArray = texasGameManager.GetActivePlayer().GetPossibleDecision();
        int n2 = texasGameManager.GetBigBlindValue();
        this.mSmallBlindValue = n2 / 2;
        this.mRaiseDisabled = false;
        this.mCallDisabled = false;
        this.mAllInDisabled = false;
        this.mFoldDecision.Assign(playerDecisionArray[0]);
        this.mCallDecision.Assign(playerDecisionArray[1]);
        byte by = this.mCallDecision.GetPlayerAction();
        FlString flString = null;
        if (by == 2) {
            if (pokerPlayer.GetChip() - this.mCallDecision.GetChip() == 0) {
                this.mCallDisabled = true;
                this.mRaiseDisabled = true;
                this.mAllInDecision.Assign(this.mCallDecision);
            } else {
                FlString flString2 = new FlString(this.mCallDecision.GetChip());
                this.mPlayerActionTexts[1].SetCaption(flString2);
                this.mPlayerActionTexts[1].SetVisible(true);
            }
            flString = FlString.Cast(package_.GetEntryPoint(15), null);
        } else {
            flString = FlString.Cast(package_.GetEntryPoint(14), null);
            this.mPlayerActionTexts[1].SetVisible(false);
        }
        this.mPlayerActionTexts[0].SetCaption(flString);
        int n3 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (playerDecisionArray[i2].GetPlayerAction() == -1) continue;
            ++n3;
        }
        if (n3 == 4) {
            PlayerDecision playerDecision = playerDecisionArray[2];
            if (playerDecision.GetChip() == playerDecisionArray[3].GetChip()) {
                this.mAllInDecision.Assign(playerDecision);
                this.mMinRaiseOrBet.Assign(this.mMaxRaiseOrBet.Assign(playerDecision));
                this.mRaiseTo = this.mMinRaiseOrBet.GetChip();
                this.mRaiseDisabled = true;
            } else {
                by = playerDecision.GetPlayerAction();
                flString = by == 3 ? FlString.Cast(package_.GetEntryPoint(16), null) : FlString.Cast(package_.GetEntryPoint(17), null);
                this.mMinRaiseOrBet.Assign(playerDecision);
                this.mMaxRaiseOrBet.Assign(playerDecisionArray[3]);
                this.mAllInDecision.Assign(this.mMaxRaiseOrBet);
                this.mRaiseTo = this.mMinRaiseOrBet.GetChip();
                this.mPlayerActionTexts[2].SetCaption(flString);
                this.mPlayerActionTexts[3].SetCaption(new FlString(this.mRaiseTo));
            }
        } else if (n3 == 2 && pokerPlayer.GetChip() - this.mCallDecision.GetChip() != 0) {
            this.mAllInDisabled = true;
            this.mRaiseDisabled = true;
        } else {
            this.mRaiseDisabled = true;
            this.mAllInDecision.Assign(this.mCallDecision);
        }
        this.mPlayerActionTexts[4].SetCaption(new FlString(this.mAllInDecision.GetChip()));
        if (!this.mRaiseDisabled) {
            int n4 = this.mMaxRaiseOrBet.GetChip();
            FlString flString3 = new FlString(n4);
            MetaPackage metaPackage = GameLibrary.GetPackage(1769526);
            Package package_2 = metaPackage.GetPackage();
            FlFont flFont = null;
            flFont = FlFont.Cast(package_2.GetEntryPoint(1), null);
            GameLibrary.ReleasePackage(metaPackage);
            int n5 = flFont.GetCharWidth((byte)52, false, false);
            int n6 = n5 * flString3.GetLength();
            int n7 = 64 - n6;
            this.mRaiseBetLeftArrowSelection.SetTopLeft((short)n7, this.mRaiseBetLeftArrowSelection.GetRectTop());
            flString3 = null;
        }
    }

    public boolean OnCommand(int n2) {
        boolean bl = true;
        if (n2 == -93) {
            PlayerDecision playerDecision = new PlayerDecision();
            int n3 = this.mPlayerActionSelector.GetSingleSelection();
            switch (n3) {
                case 0: {
                    playerDecision.Assign(this.mCallDecision);
                    break;
                }
                case 1: {
                    this.mMaxRaiseOrBet.SetChip(this.mRaiseTo);
                    playerDecision.Assign(this.mMaxRaiseOrBet);
                    break;
                }
                case 2: {
                    playerDecision.Assign(this.mAllInDecision);
                    break;
                }
                case 3: {
                    playerDecision.Assign(this.mFoldDecision);
                    break;
                }
            }
            TexasGameManager.Get().GetActivePlayer().SetDecision(playerDecision);
            this.mParentScene.OnCommand(-68);
        } else {
            bl = false;
        }
        return bl;
    }

    public void Unload() {
        if (this.mPlayerActionTexts != null) {
            this.mPlayerActionTexts = null;
        }
        super.Unload();
    }

    public void Hide() {
        this.mCursor.SetVisible(false);
        this.mCursor.StopAnim();
        this.UnRegisterInGlobalTime();
        super.Hide();
    }

    public void Shown() {
        super.Shown();
        int n2 = 0;
        if (this.mIsBackFromAdvisor) {
            n2 = this.SelectAdvisorDecision();
            this.mIsBackFromAdvisor = false;
        } else {
            if (this.mCallDisabled) {
                n2 = 2;
            }
            this.mPlayerActionSelector.SetSingleSelection(n2, true);
        }
        SubtypeHandler.OnSubtype(this.mParentScene, this.mPlayerActionSelector.GetSelectionAt(n2), -127, 1);
        this.mKeyHeldTimer = 0;
        this.RegisterInGlobalTime();
        this.mCursor.SetVisible(true);
        this.mCursor.StartAnim();
    }

    public void OnMsg(Component component, int n2, int n3) {
        if (n3 == 1) {
            if (component == this.mRaiseBetLeftArrowSelection) {
                this.mKeyHeld = 3;
            } else if (component == this.mRaiseBetRightArrowSelection) {
                this.mKeyHeld = 4;
            } else {
                return;
            }
            this.OnKeyHolding();
        } else if (n3 == 0) {
            this.mKeyRepeatedCount = 0;
            this.mKeyHeld = 0;
        }
    }

    public void OnHideAdvisor() {
        this.mIsBackFromAdvisor = true;
    }

    public void TakeFocus() {
        this.mPlayerActionSelector.TakeFocus();
    }

    public Scroller GetPenMoveVScrollingComponent() {
        return this.mPlayerActionSelector;
    }

    public int GetAttributes() {
        int n2 = 15;
        return n2;
    }

    public void ShowComponents() {
        Selection selection = null;
        selection = this.mPlayerActionSelector.GetSelectionAt(0);
        selection.SetEnabledState(!this.mCallDisabled);
        if (this.mCallDisabled) {
            this.mPlayerActionTexts[1].SetVisible(false);
        }
        selection = this.mPlayerActionSelector.GetSelectionAt(1);
        selection.SetEnabledState(!this.mRaiseDisabled);
        this.mPlayerActionTexts[3].SetVisible(!this.mRaiseDisabled);
        selection = this.mPlayerActionSelector.GetSelectionAt(2);
        selection.SetEnabledState(!this.mAllInDisabled);
        this.mPlayerActionTexts[4].SetVisible(!this.mAllInDisabled);
        super.ShowComponents();
    }

    public void OnTime(int n2, int n3) {
        if (this.mKeyHeldTimer < 0) {
            super.OnTime(n2, n3);
        } else if (this.mKeyHeldTimer > 0) {
            this.mKeyHeldTimer = FlMath.Maximum(this.mKeyHeldTimer - n3, 0);
        } else if (this.mKeyHeld != 0) {
            this.OnKeyHolding();
        }
    }

    public void ChangeRaiseOrBetAmount(int n2) {
        if (n2 > 0) {
            if (this.mRaiseTo < this.mMaxRaiseOrBet.GetChip()) {
                this.mRaiseTo += n2;
                if (this.mRaiseTo > this.mMaxRaiseOrBet.GetChip()) {
                    this.mRaiseTo = this.mMaxRaiseOrBet.GetChip();
                }
            } else {
                this.mRaiseTo = this.mMinRaiseOrBet.GetChip();
            }
        } else if (this.mRaiseTo > this.mMinRaiseOrBet.GetChip()) {
            this.mRaiseTo += n2;
            if (this.mRaiseTo < this.mMinRaiseOrBet.GetChip()) {
                this.mRaiseTo = this.mMinRaiseOrBet.GetChip();
            }
        } else {
            this.mRaiseTo = this.mMaxRaiseOrBet.GetChip();
        }
        this.mPlayerActionTexts[3].SetCaption(new FlString(this.mRaiseTo));
    }

    public void OnKeyHolding() {
        if (this.mPlayerActionSelector.GetSingleSelection() == 1) {
            this.mKeyRepeatedCount = FlMath.Minimum(++this.mKeyRepeatedCount, 20);
            int n2 = this.mSmallBlindValue + this.mSmallBlindValue * FlMath.Maximum(0, this.mKeyRepeatedCount - 3);
            if (this.mKeyHeld == 3) {
                n2 *= -1;
            }
            this.ChangeRaiseOrBetAmount(n2);
            this.mKeyHeldTimer = 250;
        }
    }

    public int SelectAdvisorDecision() {
        TexasGameManager texasGameManager = TexasGameManager.Get();
        PokerPlayerHuman pokerPlayerHuman = (PokerPlayerHuman)texasGameManager.GetActivePlayer();
        PlayerDecision playerDecision = pokerPlayerHuman.GetAdvisorDecision();
        int n2 = 3;
        byte by = playerDecision.GetPlayerAction();
        if (by == 2 || by == 1) {
            n2 = 0;
        } else if (by == 3 || by == 4) {
            n2 = 1;
            this.mRaiseTo = playerDecision.GetChip();
            this.mPlayerActionTexts[3].SetCaption(new FlString(this.mRaiseTo));
        } else if (by == 5) {
            n2 = 2;
        }
        this.mPlayerActionSelector.SetSingleSelection(n2, true);
        return n2;
    }
}

