/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.CardValue;

public class HV {
    public static final byte highCard = 0;
    public static final byte pair = 1;
    public static final byte twoPairs = 2;
    public static final byte triple = 3;
    public static final byte straight = 4;
    public static final byte flush = 5;
    public static final byte fullHouse = 6;
    public static final byte four = 7;
    public static final byte straightFlush = 8;
    public static final byte royalStraightFlush = 9;
    public static final byte handTypeCount = 10;

    public static byte GetType(int n2) {
        return (byte)(n2 & 0xF);
    }

    public static int InsertCardWithoutSuit(byte by, int n2, int n3) {
        int n4 = ~(15 << (n2 + 1) * 4);
        n3 &= n4;
        n4 = CardValue.GetValue(by) << (n2 + 1) * 4;
        return n3 | n4;
    }

    public static byte GetCardWithoutSuit(short s2, int n2) {
        int n3 = 15 << (s2 + 1) * 4;
        return (byte)((n2 & n3) >> (s2 + 1) * 4);
    }

    public static short Compare(int n2, int n3) {
        byte by;
        byte by2 = HV.GetType(n2);
        if (by2 > (by = HV.GetType(n3))) {
            return 1;
        }
        if (by2 < by) {
            return -1;
        }
        for (short s2 = 0; s2 < HV.GetNbSignificantCardsForHandTypeComparison(by2); s2 = (short)(s2 + 1)) {
            byte by3;
            byte by4 = CardValue.GetValue(HV.GetCardWithoutSuit(s2, n2));
            if (by4 > (by3 = CardValue.GetValue(HV.GetCardWithoutSuit(s2, n3)))) {
                return 1;
            }
            if (by4 >= by3) continue;
            return -1;
        }
        return 0;
    }

    public static short GetNbSignificantCardsForHandTypeComparison(int n2) {
        switch (HV.GetType(n2)) {
            case 0: {
                return 5;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 1;
            }
        }
        return 0;
    }

    public static HV[] InstArrayHV(int n2) {
        HV[] hVArray = new HV[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            hVArray[i2] = new HV();
        }
        return hVArray;
    }

    public static HV[][] InstArrayHV(int n2, int n3) {
        HV[][] hVArray = new HV[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            hVArray[i2] = new HV[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                hVArray[i2][i3] = new HV();
            }
        }
        return hVArray;
    }

    public static HV[][][] InstArrayHV(int n2, int n3, int n4) {
        HV[][][] hVArray = new HV[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            hVArray[i2] = new HV[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                hVArray[i2][i3] = new HV[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    hVArray[i2][i3][i4] = new HV();
                }
            }
        }
        return hVArray;
    }
}

