/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Text;
import ca.jamdat.texasholdem09.AdvisorPopup;
import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.CareerState;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.HorizontalSelector;
import ca.jamdat.texasholdem09.LocationInfoPopup;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.NewLocationPopup;
import ca.jamdat.texasholdem09.SelectorMenu;
import ca.jamdat.texasholdem09.TutorialManager;
import ca.jamdat.texasholdem09.TutorialPopup;
import ca.jamdat.texasholdem09.Utilities;

public class GameMenu
extends SelectorMenu {
    public static final byte popUpStateNone = -1;
    public static final byte handleIntroTutorials = 0;
    public static final byte handleLastGameResult = 1;
    public static final byte handleBankruptcy = 2;
    public static final byte handleChipGain = 3;
    public static final byte handleMilestones = 4;
    public static final byte handleUnlockedCasinos = 5;
    public static final byte handleTournamentTutorials = 6;
    public static final byte handleGameChallenges = 7;
    public static final byte loadPopUpEnding = 8;
    public static final byte popupNone = -1;
    public static final byte tutorialCareerGamePopup = 0;
    public static final byte tutorialAdvisorPopup = 1;
    public static final byte tournamentEliminationPopup = 2;
    public static final byte abandonPopup = 3;
    public static final byte tournamentFinalRoundEliminationPopup = 4;
    public static final byte tournamentVictoryPopup = 5;
    public static final byte bankruptcyPopup = 6;
    public static final byte firstCasinoUnlockedPopup = 7;
    public static final byte jimmysDiveUnlockedPopup = 7;
    public static final byte elGranTacoUnlockedPopup = 8;
    public static final byte klondikeUnlockedPopup = 9;
    public static final byte sphinxUnlockedPopup = 10;
    public static final byte neptuneUnlockedPopup = 11;
    public static final byte tutorialTournamentPopup = 12;
    public static final byte headsUpChallengePopup = 13;
    public static final byte proGameChallengePopup = 14;
    public Text mLocationInfoText;
    public boolean mIsIntro = true;
    public CareerState mCareerState = GameApp.Get().GetCareerState();
    public GameSettings mGameSettings = GameApp.Get().GetGameSettings();
    public byte mPopUpState = (byte)-1;
    public byte mCurrentGameMenuPopupId = (byte)-1;

    public GameMenu(int n2, int n3) {
        super(n2, n3);
    }

    public void destruct() {
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mLocationInfoText = Text.Cast(this.mPackage.GetEntryPoint(7), null);
    }

    public void Initialize() {
        super.Initialize();
        this.mIsIntro = true;
        this.mPopUpState = GameApp.Get().GetGameMenuSettings().GetPopUpState();
        this.mCurrentGameMenuPopupId = GameApp.Get().GetGameMenuSettings().GetCurrentPopUpId();
        int n2 = this.mFocusedSelectionIndex == 0 ? this.FindDefaultCasino() : this.mFocusedSelectionIndex;
        HorizontalSelector.Initialize(this.mSelector, n2);
        this.ResumePopUp();
        this.Update();
        this.SetLockGrid();
    }

    public void ReceiveFocus() {
        this.mView.RegisterInGlobalTime();
        super.ReceiveFocus();
    }

    public void Unload() {
        super.Unload();
    }

    public boolean OnCommand(int n2) {
        boolean bl = false;
        if (!bl) {
            bl = true;
            switch (n2) {
                case 5: 
                case 6: 
                case 7: {
                    this.HidePopupIfNeededAndExecute(n2);
                    break;
                }
                case 15: {
                    this.CreateHeadsUpGame();
                    break;
                }
                case 17: {
                    this.mCareerState.SetHeadsUpHeroCharacterPortrait(-1);
                    break;
                }
                case 19: {
                    this.CreateProGame();
                    break;
                }
                case 21: {
                    this.mCareerState.ProGameChallengeDeclined();
                    break;
                }
                case 22: {
                    this.HidePopup(23);
                    break;
                }
                case 23: {
                    this.HandlePopUps();
                    break;
                }
                case 24: {
                    this.HidePopup();
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl || super.OnCommand(n2);
    }

    public void OnTime(int n2, int n3) {
        super.OnTime(n2, n3);
        if (this.mCurrentPopup != null && this.mCurrentPopup.IsLoaded() && this.mCurrentPopup.GetState() == 4 && !this.mCurrentPopup.HasFocus()) {
            this.mCurrentPopup.TakeFocus();
        }
    }

    public boolean OnMsg(Component component, int n2, int n3) {
        boolean bl = false;
        if (component == this.mSelector && n2 == -111 && n3 == 1 && this.mFocusedSelectionIndex != this.mSelector.GetSingleSelection()) {
            this.Update();
            bl = true;
        }
        return bl || super.OnMsg(component, n2, n3);
    }

    public boolean OnKeyUp(int n2) {
        boolean bl = false;
        if (!bl && n2 == 16 && this.mPopUpState == 8) {
            this.ShowLocationInfoPopup();
            bl = true;
        }
        return bl || super.OnKeyUp(n2);
    }

    public boolean OnKeyDownOrRepeat(int n2) {
        boolean bl = false;
        switch (n2) {
            default: 
        }
        return bl || super.OnKeyDownOrRepeat(n2);
    }

    public void OnPopupShown() {
        this.SetLocationInfoVisible(false);
        super.OnPopupShown();
    }

    public void OnPopupHidden() {
        if (this.mCurrentGameMenuPopupId == 14 || this.mCurrentGameMenuPopupId == 13) {
            this.HandlePopUps();
        }
        this.SetCurrentGameMenuPopupId((byte)-1);
        this.SetLocationInfoVisible(true);
        super.OnPopupHidden();
    }

    public void SetTournamentPromptIfAvailable() {
        int n2 = this.mFocusedSelectionIndex;
        if (this.mCareerState.IsLocationAvailable(n2) && this.mPopUpState == 8) {
            if (this.IsTournamentAvailable()) {
                this.AddPromptPopup(6, 7, 12, true, 19);
            } else {
                this.OnCommand(7);
            }
        }
    }

    public boolean IsTournamentAvailable() {
        int n2 = this.mFocusedSelectionIndex;
        return this.mCareerState.IsNextTournament(n2) && this.mCareerState.GetBankRoll() >= GameSettings.GetBuyInCostStatic(n2, 2);
    }

    public FlString CreateAbandonString() {
        int n2 = 14;
        if (this.mGameSettings.IsGameMenuModeTournament()) {
            n2 = 15;
        }
        return this.CreateChipsString(n2);
    }

    public FlString CreateChipsString(int n2) {
        FlString flString = new FlString(StringUtils.CreateString("[CHIPS]"));
        FlString flString2 = null;
        flString2 = FlString.Cast(this.mPackage.GetEntryPoint(n2), null);
        FlString flString3 = new FlString(flString2);
        Utilities.StringReplacer(flString3, flString, new FlString(this.mCareerState.GetLatestChipsIncome()));
        return flString3;
    }

    public FlString CreateHeadsUpString() {
        int n2 = this.mCareerState.GetHeadsUpHeroCharacterPortrait();
        int n3 = n2 - 18;
        FlString flString = null;
        flString = FlString.Cast(this.mPackage.GetEntryPoint(13), null);
        FlString flString2 = null;
        flString2 = FlString.Cast(this.mPackage.GetEntryPoint(8 + n3), null);
        FlString flString3 = new FlString(flString);
        FlString flString4 = new FlString(StringUtils.CreateString("[OPPONENT]"));
        Utilities.StringReplacer(flString3, flString4, flString2);
        FlString flString5 = new FlString(StringUtils.CreateString("[CHIPS]"));
        FlString flString6 = new FlString(GameSettings.GetBuyInCostStatic(this.mGameSettings.GetLocation(), 0));
        Utilities.StringReplacer(flString3, flString5, flString6);
        return flString3;
    }

    public FlString CreateProGameString() {
        FlString flString = null;
        flString = FlString.Cast(this.mPackage.GetEntryPoint(12), null);
        return flString;
    }

    public FlString CreateTournamentVictoryString() {
        return this.CreateChipsString(16);
    }

    public FlString CreateTournamentFinalRoundEliminationString() {
        return this.CreateChipsString(17);
    }

    public FlString CreateTournamentEliminationString() {
        FlString flString = null;
        flString = FlString.Cast(this.mPackage.GetEntryPoint(18), null);
        return new FlString(flString);
    }

    public FlString CreateNewlyUnlockedCasinoString() {
        FlString flString = null;
        flString = FlString.Cast(this.mPackage.GetEntryPoint(22), null);
        return new FlString(flString);
    }

    public FlString CreateBankruptcyString() {
        FlString flString = null;
        flString = FlString.Cast(this.mPackage.GetEntryPoint(23), null);
        return new FlString(flString);
    }

    public void CreateGame() {
        this.SetGameSettings();
        GameApp.Get().GetStatistics().OnGameStart();
        this.mCareerState.DecreaseBankRoll(this.mGameSettings.GetBuyInCost());
        if (this.mGameSettings.IsGameMenuModeTournament()) {
            this.mCareerState.ResetNextTournament();
        }
        this.OnCommand(-74);
    }

    public void CreateHeadsUpGame() {
        this.mGameSettings.SetGameMenuGameMode(0);
        this.CreateGame();
    }

    public void CreateProGame() {
        this.mGameSettings.SetGameMenuGameMode(3);
        this.CreateGame();
    }

    public void CreateStandardGame() {
        this.mGameSettings.SetGameMenuGameMode(1);
        this.CreateGame();
    }

    public void CreateTournamentGame() {
        this.mGameSettings.SetGameMenuGameMode(2);
        this.CreateGame();
    }

    public int FindDefaultCasino() {
        int n2;
        for (n2 = this.mGameSettings.GetLocation(); n2 > 0 && this.mCareerState.GetBankRoll() < GameSettings.GetBuyInCostStatic(n2, 1); --n2) {
        }
        return n2;
    }

    public void HandlePopUps() {
        boolean bl = false;
        if (this.mPopUpState == 0 && (bl = this.HandleIntroTutorials())) {
            this.SetPopupState((byte)1);
        }
        if (this.mPopUpState == 1) {
            bl = this.HandleLastGameResult();
            this.SetPopupState((byte)2);
            if (!bl) {
                return;
            }
        }
        if (this.mPopUpState == 2) {
            this.mCareerState.ResetLatestChipsIncome();
            bl = this.HandleBankruptcy();
            this.SetPopupState((byte)3);
            if (!bl) {
                return;
            }
        }
        if (this.mPopUpState == 3) {
            bl = this.HandleChipGain();
            if (bl) {
                this.SetPopupState((byte)4);
            } else {
                this.mSelectSoftKey.SetCommand(0);
            }
        }
        if (this.mPopUpState == 4) {
            this.mSelectSoftKey.SetCommand(5);
            bl = this.HandleMilestones();
            if (bl) {
                this.SetPopupState((byte)5);
            }
        }
        if (this.mPopUpState == 5 && (bl = this.HandleUnlockedCasinos())) {
            this.SetPopupState((byte)6);
        }
        if (this.mPopUpState == 6 && (bl = this.HandleTournamentTutorial())) {
            this.SetPopupState((byte)7);
        }
        if (this.mPopUpState == 7) {
            bl = this.HandleGameChallenges();
            this.SetPopupState((byte)8);
            if (!bl) {
                return;
            }
        }
        if (this.mPopUpState == 8) {
            this.mCareerState.ResetLastGameResult();
            this.OnHandlePopUpsDone();
        }
    }

    public boolean HandleIntroTutorials() {
        TutorialManager tutorialManager = GameApp.Get().GetTutorialManager();
        if (tutorialManager.HandleTutorial((byte)1, this, 22)) {
            this.SetCurrentGameMenuPopupId((byte)0);
            return false;
        }
        if (tutorialManager.HandleTutorial((byte)2, this, 22)) {
            this.SetCurrentGameMenuPopupId((byte)1);
            return false;
        }
        return true;
    }

    public boolean HandleLastGameResult() {
        boolean bl = false;
        switch (this.mCareerState.GetLastGameResult()) {
            case 3: 
            case 6: {
                this.ShowPopup((byte)2);
                bl = true;
                break;
            }
            case 4: {
                if (this.mCareerState.GetLatestChipsIncome() > 0) {
                    this.ShowPopup((byte)3);
                    bl = true;
                }
                this.UpdateStats();
                break;
            }
            case 7: {
                this.UpdateStats();
                break;
            }
            case 2: {
                this.ShowPopup((byte)4);
                bl = true;
                break;
            }
            case 1: {
                this.ShowPopup((byte)5);
                bl = true;
            }
        }
        return !bl;
    }

    public void UpdateStats() {
        GameApp.Get().GetStatistics().OnGameAbandoned();
        this.mCareerState.ResetGameMenuGameMode();
    }

    public boolean HandleBankruptcy() {
        boolean bl = true;
        switch (this.mCareerState.GetLastGameResult()) {
            case 5: 
            case 6: 
            case 7: {
                this.ShowPopup((byte)6);
                bl = false;
            }
        }
        return bl;
    }

    public boolean HandleChipGain() {
        boolean bl = true;
        if (!this.mBankRoll.IsBankRollUpToDate()) {
            this.mBankRoll.StartAnimation();
            this.mCareerState.ResetPreviousBankRoll();
        }
        return bl;
    }

    public boolean HandleMilestones() {
        return true;
    }

    public boolean HandleUnlockedCasinos() {
        boolean bl = true;
        for (int i2 = 1; i2 < 5; ++i2) {
            if (!this.mCareerState.IsCasinoNewlyUnlocked(i2)) continue;
            this.ShowPopup((byte)(7 + i2));
            bl = false;
            break;
        }
        return bl;
    }

    public boolean HandleTournamentTutorial() {
        if (this.mCareerState.GetNextTournament() != 6 && GameApp.Get().GetTutorialManager().HandleTutorial((byte)0, this, 22)) {
            this.SetCurrentGameMenuPopupId((byte)12);
            return false;
        }
        return true;
    }

    public boolean HandleGameChallenges() {
        boolean bl = true;
        if (this.mCareerState.IsChallengedToHeadsUpGame()) {
            this.ShowPopup((byte)13);
            bl = false;
        } else if (this.mCareerState.IsChallengedToProGame()) {
            this.ShowPopup((byte)14);
            bl = false;
        }
        return bl;
    }

    public void SetBuyInText() {
        int n2 = this.mFocusedSelectionIndex;
        FlString flString = null;
        flString = FlString.Cast(this.mPackage.GetEntryPoint(5), null);
        FlString flString2 = new FlString(flString);
        flString2.AddAssign(StringUtils.CreateString(" : "));
        flString2.AddAssign(new FlString(GameSettings.GetBuyInCostStatic(n2, 1)));
        Text text = null;
        text = Text.Cast(this.mPackage.GetEntryPoint(4), null);
        text.SetCaption(flString2);
        FlFont flFont = null;
        MetaPackage metaPackage = GameLibrary.GetPackage(1769526);
        Package package_ = metaPackage.GetPackage();
        if (this.mCareerState.IsLocationAvailable(n2)) {
            flFont = FlFont.Cast(package_.GetEntryPoint(4), null);
            if (this.IsTournamentAvailable()) {
                text.SetTopLeft(text.GetRectLeft(), (short)0);
            } else {
                text.SetTopLeft(text.GetRectLeft(), (short)(text.GetViewport().GetRectHeight() / 2 - text.GetRectHeight() / 2));
            }
        } else {
            flFont = FlFont.Cast(package_.GetEntryPoint(2), null);
            text.SetTopLeft(text.GetRectLeft(), (short)0);
        }
        text.SetFont(flFont);
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void SetAvailabilityText() {
        Object object;
        FlString flString = null;
        if (this.mCareerState.IsLocationAvailable(this.mFocusedSelectionIndex)) {
            if (this.IsTournamentAvailable()) {
                object = null;
                object = FlString.Cast(this.mPackage.GetEntryPoint(19), null);
                flString = new FlString((FlString)object);
                flString.AddAssign(StringUtils.CreateString(" : "));
                flString.AddAssign(new FlString(GameSettings.GetBuyInCostStatic(this.mFocusedSelectionIndex, 2)));
            } else {
                object = null;
                object = FlString.Cast(this.mPackage.GetEntryPoint(25), null);
                flString = new FlString((FlString)object);
            }
        } else {
            object = null;
            object = this.mCareerState.IsCasinoUnlocked(this.mFocusedSelectionIndex) ? FlString.Cast(this.mPackage.GetEntryPoint(21), null) : FlString.Cast(this.mPackage.GetEntryPoint(20), null);
            flString = new FlString((FlString)object);
        }
        object = null;
        object = Text.Cast(this.mPackage.GetEntryPoint(6), null);
        ((Text)object).SetCaption(flString);
    }

    public void SetGameSettings() {
        GameSettings gameSettings = this.mGameSettings;
        int n2 = this.mFocusedSelectionIndex;
        if (gameSettings.IsGameMenuModeProGame()) {
            n2 = 4;
        }
        gameSettings.SetLocation(n2);
        gameSettings.SetDifficulty(n2);
        gameSettings.SetTournamentRound(gameSettings.IsGameMenuModeTournament() ? 1 : 0);
        gameSettings.SetBlind(0);
    }

    public void Update() {
        this.mFocusedSelectionIndex = this.mSelector.GetSingleSelection();
        this.UpdateIcons(true);
        this.SetBuyInText();
        this.SetAvailabilityText();
        this.UpdateSoftKeys();
    }

    public void UpdateIcons(boolean bl) {
    }

    public void UpdateSoftKeys() {
        int n2;
        FlString flString = null;
        if (this.mCareerState.IsLocationAvailable(this.mFocusedSelectionIndex)) {
            flString = FlString.Cast(this.mPackage.GetEntryPoint(24), null);
            n2 = 5;
        } else {
            flString = FlString.Cast(this.mPackage.GetEntryPoint(25), null);
            n2 = 0;
        }
        this.mSelectSoftKey.SetCaption(new FlString(flString));
        this.mSelectSoftKey.SetCommand(n2);
    }

    public void SetLockGrid() {
    }

    public void StartCasinoScrollingAnimation(boolean bl) {
    }

    public void StopCasinoScrollingAnimation() {
    }

    public void StartSwitchCasinoSprite() {
    }

    public void FinalizeSwitchCasinoSprite() {
    }

    public boolean IsCasinoSpriteSwitchReady() {
        return true;
    }

    public void OnHandlePopUpsDone() {
        GameApp.Get().GetGameMenuSettings().Reset();
    }

    public void HidePopupIfNeededAndExecute(int n2) {
        if (this.mCurrentPopup == null) {
            switch (n2) {
                case 5: {
                    this.SetTournamentPromptIfAvailable();
                    break;
                }
                case 6: {
                    this.CreateTournamentGame();
                    break;
                }
                case 7: {
                    this.CreateStandardGame();
                }
            }
        } else {
            this.HidePopup(n2);
        }
    }

    public void SetLocationInfoVisible(boolean bl) {
        this.mLocationInfoText.SetVisible(bl);
    }

    public void ShowLocationInfoPopup() {
        if (this.mCurrentPopup == null) {
            this.AddPopup(new LocationInfoPopup((BaseScene)this, this.mSelectSoftKey, this.mClearSoftKey, this.mFocusedSelectionIndex, this.mCareerState.IsNextTournament(this.mFocusedSelectionIndex)), true);
        } else if (this.mCurrentPopup.GetId() == 3) {
            this.HidePopup();
        }
    }

    public boolean ShowPopup(byte by) {
        boolean bl = true;
        this.SetCurrentGameMenuPopupId(by);
        switch (this.mCurrentGameMenuPopupId) {
            case 0: {
                if (GameApp.Get().GetSettings().IsTutorialEnabled()) {
                    this.AddPopup(new TutorialPopup((BaseScene)this, this.mSelectSoftKey, this.mClearSoftKey, 1, 22), false);
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (GameApp.Get().GetSettings().IsTutorialEnabled()) {
                    this.AddPopup(new AdvisorPopup(this, this.mSelectSoftKey, this.mClearSoftKey, 1), false);
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                this.AddMessagePopup(this.CreateTournamentEliminationString(), 22);
                break;
            }
            case 3: {
                this.AddMessagePopup(this.CreateAbandonString(), 22);
                break;
            }
            case 4: {
                this.AddMessagePopup(this.CreateTournamentFinalRoundEliminationString(), 22);
                break;
            }
            case 5: {
                this.AddMessagePopup(this.CreateTournamentVictoryString(), 22);
                break;
            }
            case 6: {
                this.AddMessagePopup(this.CreateBankruptcyString(), 22);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.AddPopup(new NewLocationPopup((BaseScene)this, this.mSelectSoftKey, this.mClearSoftKey, this.mCurrentGameMenuPopupId - 7), false);
                break;
            }
            case 12: {
                if (GameApp.Get().GetSettings().IsTutorialEnabled()) {
                    this.AddPopup(new TutorialPopup((BaseScene)this, this.mSelectSoftKey, this.mClearSoftKey, 0, 22), false);
                    break;
                }
                bl = false;
                break;
            }
            case 13: {
                this.AddPromptPopup(14, 16, this.CreateHeadsUpString(), false);
                break;
            }
            case 14: {
                this.AddPromptPopup(18, 20, this.CreateProGameString(), false);
                break;
            }
        }
        return bl;
    }

    public void SetPopupState(byte by) {
        this.mPopUpState = by;
        GameApp.Get().GetGameMenuSettings().SetPopUpState(this.mPopUpState);
    }

    public void SetCurrentGameMenuPopupId(byte by) {
        if (by != -1) {
            // empty if block
        }
        this.mCurrentGameMenuPopupId = by;
        GameApp.Get().GetGameMenuSettings().SetPopUpId(this.mCurrentGameMenuPopupId);
    }

    public void ResumePopUp() {
        boolean bl = true;
        if (this.mCurrentGameMenuPopupId != -1 && this.ShowPopup(this.mCurrentGameMenuPopupId)) {
            bl = false;
        }
        if (bl) {
            this.HandlePopUps();
        }
    }
}

