/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FVec3T_F32;
import ca.jamdat.flight.FileStream;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.StringUtils;

public class FileSegmentStream {
    public static final int modeRead = 0;
    public static final int modeWrite = 1;
    public int mByteArrayCapacity;
    public byte[] mByteArray = null;
    public int mPosition;
    public boolean mValidData;
    public boolean mModified;
    public int mMode;

    public FileSegmentStream(int n2) {
        this.mByteArrayCapacity = n2;
        this.mMode = 0;
        this.mByteArray = new byte[n2];
    }

    public void destruct() {
        this.mByteArray = null;
    }

    public void SetValidDataFlag(boolean bl) {
        this.mModified = this.mValidData != bl || this.mModified;
        this.mValidData = bl;
    }

    public boolean HasValidData() {
        return this.mValidData;
    }

    public boolean IsModified() {
        return this.mModified;
    }

    public void WriteByte(byte by) {
        int n2 = this.mPosition;
        if (this.mByteArray[n2] != by) {
            this.mByteArray[n2] = by;
            this.mModified = true;
        }
        this.mPosition = n2 + 1;
    }

    public void WriteBoolean(boolean bl) {
        if (bl) {
            this.WriteByte((byte)1);
        } else {
            this.WriteByte((byte)0);
        }
    }

    public void WriteShort(short s2) {
        this.WriteByte((byte)(s2 >> 8));
        this.WriteByte((byte)(s2 & 0xFF));
    }

    public void WriteLong(int n2) {
        this.WriteShort((short)(n2 >> 16));
        this.WriteShort((short)(n2 & 0xFFFF));
    }

    public void WritePaddedString(FlString flString, int n2) {
        int n3 = flString.GetLength();
        int n4 = n2 - n3;
        FlString flString2 = new FlString(flString);
        for (int i2 = 0; i2 < n4; ++i2) {
            flString2.AddAssign(StringUtils.CreateString("0"));
        }
        this.WriteLong(n3);
        this.WriteString(flString2);
    }

    public void WriteF32(F32 f32) {
        this.WriteLong(f32.ToFixedPoint(16));
    }

    public void WriteFVec3(FVec3T_F32 fVec3T_F32) {
        this.WriteF32(fVec3T_F32.x);
        this.WriteF32(fVec3T_F32.y);
        this.WriteF32(fVec3T_F32.z);
    }

    public void WriteByteArray(byte[] byArray, int n2) {
        this.WriteLong(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.WriteByte(byArray[i2]);
        }
    }

    public void WriteBooleanArray(boolean[] blArray, int n2) {
        this.WriteLong(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.WriteBoolean(blArray[i2]);
        }
    }

    public void WriteShortArray(short[] sArray, int n2) {
        this.WriteLong(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.WriteShort(sArray[i2]);
        }
    }

    public void WriteLongArray(int[] nArray, int n2) {
        this.WriteLong(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.WriteLong(nArray[i2]);
        }
    }

    public void WriteF32Array(F32[] f32Array, int n2) {
        this.WriteLong(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.WriteF32(f32Array[i2]);
        }
    }

    public void WriteFVec3Array(FVec3T_F32[] fVec3T_F32Array, int n2) {
        this.WriteLong(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.WriteFVec3(fVec3T_F32Array[i2]);
        }
    }

    public byte ReadByte() {
        return this.mByteArray[this.mPosition++];
    }

    public boolean ReadBoolean() {
        return this.ReadByte() == 1;
    }

    public short ReadShort() {
        byte by = this.ReadByte();
        byte by2 = this.ReadByte();
        int n2 = by << 8 | by2 & 0xFF;
        return (short)n2;
    }

    public int ReadLong() {
        short s2 = this.ReadShort();
        short s3 = this.ReadShort();
        int n2 = s2 << 16 | s3 & 0xFFFF;
        return n2;
    }

    public FlString ReadPaddedString() {
        int n2 = this.ReadLong();
        FlString flString = new FlString();
        this.ReadString(flString);
        return flString.Substring(0, n2);
    }

    public F32 ReadF32() {
        return new F32(this.ReadLong(), 16);
    }

    public FVec3T_F32 ReadFVec3() {
        F32 f32 = new F32(this.ReadF32());
        F32 f322 = new F32(this.ReadF32());
        F32 f323 = new F32(this.ReadF32());
        return new FVec3T_F32(f32, f322, f323);
    }

    public void ReadByteArray(byte[] byArray, int n2) {
        int n3 = this.ReadLong();
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = this.ReadByte();
        }
    }

    public void ReadBooleanArray(boolean[] blArray, int n2) {
        int n3 = this.ReadLong();
        for (int i2 = 0; i2 < n2; ++i2) {
            blArray[i2] = this.ReadBoolean();
        }
    }

    public void ReadShortArray(short[] sArray, int n2) {
        int n3 = this.ReadLong();
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = this.ReadShort();
        }
    }

    public void ReadLongArray(int[] nArray, int n2) {
        int n3 = this.ReadLong();
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.ReadLong();
        }
    }

    public void ReadF32Array(F32[] f32Array, int n2) {
        int n3 = this.ReadLong();
        for (int i2 = 0; i2 < n2; ++i2) {
            f32Array[i2] = this.ReadF32();
        }
    }

    public void ReadFVec3Array(FVec3T_F32[] fVec3T_F32Array, int n2) {
        int n3 = this.ReadLong();
        for (int i2 = 0; i2 < n2; ++i2) {
            fVec3T_F32Array[i2].Assign(this.ReadFVec3());
        }
    }

    public static void Test() {
    }

    public void ForceModifiedFlag() {
        this.mModified = true;
    }

    public void SetMode(int n2) {
        this.mMode = n2;
        this.SetPosition(0);
    }

    public void SetPosition(int n2) {
        this.mPosition = n2;
    }

    public int GetPosition() {
        return this.mPosition;
    }

    public int GetSize() {
        return 4 + this.GetCapacity();
    }

    public int GetCapacity() {
        return this.mByteArrayCapacity;
    }

    public void Read(FileStream fileStream) {
        this.SetMode(0);
        this.SetValidDataFlag(fileStream.ReadLong() == 1);
        fileStream.Read(this.mByteArray, this.GetCapacity());
        this.mModified = false;
    }

    public void Write(FileStream fileStream) {
        this.SetMode(1);
        fileStream.WriteLong(this.HasValidData() ? 1 : 0);
        fileStream.Write(this.mByteArray, this.GetCapacity());
        this.mModified = false;
    }

    public void ReadString(FlString flString) {
        int n2 = this.ReadLong();
        for (int i2 = 0; i2 < n2; ++i2) {
            flString.AddAssign(FlString.FromChar((byte)this.ReadShort()));
        }
    }

    public void WriteString(FlString flString) {
        int n2 = flString.GetLength();
        this.WriteLong(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.WriteShort(flString.GetCharAt(i2));
        }
    }
}

