/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.texasholdem09.FileHandler;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;

public class FileManager {
    public static final int idSettings = 0;
    public static final int idStatistics = 1;
    public static final int idGameModel = 2;
    public static final int idPracticeGameModel = 3;
    public static final int idGameSettings = 4;
    public static final int idCareerState = 5;
    public static final int idTutorialManager = 6;
    public static final int idGameMenuSettings = 7;
    public static final int idCount = 8;
    public static final int statusIdle = 0;
    public static final int statusWorking = 1;
    public static final int statusNotEnoughSpace = 2;
    public static final int statusBootCompleted = 3;
    public static final int fileMain = 0;
    public static final int fileBackup = 1;
    public static final int fileCount = 2;
    public FileHandler[] mFiles = new FileHandler[2];

    public FileManager() {
        FlString flString = new FlString(FlApplication.GetDataDir().Add(StringUtils.CreateString("a")));
        this.mFiles[0] = new FileHandler(flString.Add(new FlString(1)), this.AllocateSegments(), 8);
        this.mFiles[1] = new FileHandler(flString.Add(new FlString(2)), this.AllocateSegments(), 8);
    }

    public void destruct() {
        for (int i2 = 0; i2 < 2; ++i2) {
            this.mFiles[i2] = null;
        }
    }

    public int OnLoad() {
        this.mFiles[0].OnSerialize(0);
        this.mFiles[1].OnSerialize(0);
        this.SelectMostRecentFileAndAlternateBackup();
        this.ReadApplicationObjects();
        return 3;
    }

    public boolean OnSave() {
        boolean bl = this.mFiles[0].OnSerialize(1);
        return bl;
    }

    public void WriteObject(int n2) {
        FileHandler fileHandler = this.mFiles[0];
        GameApp gameApp = GameApp.Get();
        switch (n2) {
            case 1: {
                gameApp.GetStatistics().Write(fileHandler.GetSegmentStream(1, 1));
                break;
            }
            case 0: {
                gameApp.GetSettings().Write(fileHandler.GetSegmentStream(0, 1));
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                gameApp.GetGameSettings().Write(fileHandler.GetSegmentStream(4, 1));
                break;
            }
            case 5: {
                gameApp.GetCareerState().Write(fileHandler.GetSegmentStream(5, 1));
                break;
            }
            case 6: {
                gameApp.GetTutorialManager().Write(fileHandler.GetSegmentStream(6, 1));
                break;
            }
            case 7: {
                gameApp.GetGameMenuSettings().Write(fileHandler.GetSegmentStream(7, 1));
                break;
            }
        }
    }

    public void WriteApplicationObjects() {
        this.WriteObject(0);
        this.WriteObject(1);
        this.WriteObject(5);
        this.WriteObject(6);
        this.WriteObject(7);
    }

    public void ReadObject(int n2) {
        FileHandler fileHandler = this.mFiles[0];
        GameApp gameApp = GameApp.Get();
        switch (n2) {
            case 1: {
                gameApp.GetStatistics().Read(fileHandler.GetSegmentStream(1, 0));
                break;
            }
            case 0: {
                gameApp.GetSettings().Read(fileHandler.GetSegmentStream(0, 0));
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                gameApp.GetGameSettings().Read(fileHandler.GetSegmentStream(4, 0));
                break;
            }
            case 5: {
                gameApp.GetCareerState().Read(fileHandler.GetSegmentStream(5, 0));
                break;
            }
            case 6: {
                gameApp.GetTutorialManager().Read(fileHandler.GetSegmentStream(6, 0));
                break;
            }
            case 7: {
                gameApp.GetGameMenuSettings().Read(fileHandler.GetSegmentStream(7, 0));
                break;
            }
        }
    }

    public void ReadApplicationObjects() {
        this.ReadObject(0);
        this.ReadObject(1);
        this.ReadObject(4);
        this.ReadObject(5);
        this.ReadObject(6);
        this.ReadObject(7);
    }

    public FileSegmentStream GetInputSegmentStream(int n2) {
        return this.mFiles[0].GetSegmentStream(n2, 0);
    }

    public FileSegmentStream GetOutputSegmentStream(int n2) {
        return this.mFiles[0].GetSegmentStream(n2, 1);
    }

    public void ResetSegmentStream() {
        this.mFiles[0].ResetSerializableData();
    }

    public FileSegmentStream[] AllocateSegments() {
        FileSegmentStream[] fileSegmentStreamArray = new FileSegmentStream[8];
        fileSegmentStreamArray[2] = new FileSegmentStream(978);
        fileSegmentStreamArray[3] = new FileSegmentStream(978);
        fileSegmentStreamArray[0] = new FileSegmentStream(23);
        fileSegmentStreamArray[4] = new FileSegmentStream(19);
        fileSegmentStreamArray[1] = new FileSegmentStream(136);
        fileSegmentStreamArray[5] = new FileSegmentStream(35);
        fileSegmentStreamArray[6] = new FileSegmentStream(6);
        fileSegmentStreamArray[7] = new FileSegmentStream(2);
        return fileSegmentStreamArray;
    }

    public void LoadOrCreateSynchronousFile(FileHandler fileHandler, boolean bl) {
        if (bl) {
            fileHandler.OnSerialize(0);
        } else {
            fileHandler.OnSerialize(1);
        }
    }

    public void SelectMostRecentFileAndAlternateBackup() {
        FileHandler fileHandler = this.mFiles[0];
        FileHandler fileHandler2 = this.mFiles[1];
        if (fileHandler2.GetWritingCount() > fileHandler.GetWritingCount()) {
            fileHandler2.SetPathname(fileHandler.GetPathname());
            fileHandler = null;
            this.mFiles[0] = fileHandler2;
            this.mFiles[1] = null;
        } else {
            fileHandler.SetPathname(fileHandler2.GetPathname());
            this.mFiles[1] = null;
        }
    }

    public static FileManager[] InstArrayFileManager(int n2) {
        FileManager[] fileManagerArray = new FileManager[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fileManagerArray[i2] = new FileManager();
        }
        return fileManagerArray;
    }

    public static FileManager[][] InstArrayFileManager(int n2, int n3) {
        FileManager[][] fileManagerArray = new FileManager[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            fileManagerArray[i2] = new FileManager[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                fileManagerArray[i2][i3] = new FileManager();
            }
        }
        return fileManagerArray;
    }

    public static FileManager[][][] InstArrayFileManager(int n2, int n3, int n4) {
        FileManager[][][] fileManagerArray = new FileManager[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            fileManagerArray[i2] = new FileManager[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                fileManagerArray[i2][i3] = new FileManager[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    fileManagerArray[i2][i3][i4] = new FileManager();
                }
            }
        }
        return fileManagerArray;
    }
}

