/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.HorizontalSelector;
import ca.jamdat.texasholdem09.SelectorMenu;
import ca.jamdat.texasholdem09.StatisticComponent;
import ca.jamdat.texasholdem09.Statistics;

public class CareerStatisticsMenu
extends SelectorMenu {
    public static final byte PlayStyle = 0;
    public static final byte Hands = 1;
    public static final byte Money = 2;
    public static final byte Tournaments = 3;
    public Scroller mScroller;
    public StatisticComponent[] mComponentList = null;
    public int mLastNumberOfComponentsAllocated;

    public CareerStatisticsMenu(int n2, int n3) {
        super(n2, n3);
    }

    public void destruct() {
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mScroller = Scroller.Cast(this.mPackage.GetEntryPoint(4), null);
    }

    public void Initialize() {
        super.Initialize();
        HorizontalSelector.Initialize(this.mSelector, this.mFocusedSelectionIndex);
        this.mScroller.SetIsViewportCentered(false);
        this.UpdatePage((byte)this.mSelector.GetSingleSelection());
    }

    public void Unload() {
        CareerStatisticsMenu.CleanStatisticComponents(this.mComponentList, this.mLastNumberOfComponentsAllocated);
        this.mComponentList = null;
        super.Unload();
    }

    public boolean OnMsg(Component component, int n2, int n3) {
        boolean bl = false;
        this.mScroller.OnDefaultMsg(component, n2, n3);
        if (n2 == -111 && component == this.mSelector && this.mFocusedSelectionIndex != this.mSelector.GetSingleSelection()) {
            this.mFocusedSelectionIndex = this.mSelector.GetSingleSelection();
            this.UpdatePage((byte)this.mFocusedSelectionIndex);
        }
        return bl || super.OnMsg(component, n2, n3);
    }

    public static void UpdateStatisticsPage(int n2, int n3, int n4, Package package_, Scroller scroller, StatisticComponent[] statisticComponentArray, boolean bl) {
        Statistics statistics = GameApp.Get().GetStatistics();
        scroller.SetMaxNumElements(n2);
        scroller.SetNumElements(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            FlString flString = null;
            flString = FlString.Cast(package_.GetEntryPoint(n3 + i2), null);
            FlString flString2 = new FlString();
            int n5 = n4 + i2;
            boolean bl2 = Statistics.RequiresPct(n5, bl);
            int n6 = bl ? statistics.GetCareerStat((byte)n5) : statistics.GetInGameStat((byte)n5);
            CareerStatisticsMenu.FormatStat(flString2, n6, bl2);
            StatisticComponent statisticComponent = new StatisticComponent();
            statisticComponent.Load();
            if (bl) {
                statisticComponent.Initialize(flString, flString2, (short)159, (short)14, true);
            } else {
                statisticComponent.Initialize(flString, flString2, (short)144, (short)14, false);
            }
            statisticComponent.SetTopLeft((short)0, (short)(statisticComponent.GetRectHeight() * i2));
            statisticComponentArray[i2] = statisticComponent;
            statisticComponent.SetViewport((Viewport)scroller.GetChild(0));
            scroller.SetElementAt(i2, statisticComponent);
            flString2 = null;
        }
    }

    public static void CleanStatisticComponents(StatisticComponent[] statisticComponentArray, int n2) {
        if (statisticComponentArray != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (statisticComponentArray[i2] == null) continue;
                statisticComponentArray[i2].SetViewport(null);
                statisticComponentArray[i2].Unload();
                statisticComponentArray[i2] = null;
            }
        }
    }

    public static void FormatStat(FlString flString, int n2, boolean bl) {
        flString.Assign(new FlString(n2));
        if (bl) {
            flString.AddAssign(StringUtils.CreateString("%"));
        }
    }

    public void InitStatisticsPage(int n2, int n3, int n4, Package package_, Scroller scroller, boolean bl) {
        this.mComponentList = new StatisticComponent[n2];
        for (int i2 = 0; i2 < this.mComponentList.length; ++i2) {
            this.mComponentList[i2] = null;
        }
        CareerStatisticsMenu.UpdateStatisticsPage(n2, n3, n4, package_, scroller, this.mComponentList, bl);
    }

    public void UpdatePage(byte by) {
        CareerStatisticsMenu.CleanStatisticComponents(this.mComponentList, this.mLastNumberOfComponentsAllocated);
        this.mComponentList = null;
        if (by == 0) {
            this.mLastNumberOfComponentsAllocated = 6;
            this.InitStatisticsPage(6, 7, 0, this.mPackage, this.mScroller, true);
        } else if (by == 1) {
            this.mLastNumberOfComponentsAllocated = 7;
            this.InitStatisticsPage(7, 13, 6, this.mPackage, this.mScroller, true);
        } else if (by == 2) {
            this.mLastNumberOfComponentsAllocated = 5;
            this.InitStatisticsPage(5, 20, 13, this.mPackage, this.mScroller, true);
        } else if (by == 3) {
            this.mLastNumberOfComponentsAllocated = 2;
            this.InitStatisticsPage(2, 25, 18, this.mPackage, this.mScroller, true);
        }
        this.mScroller.ResetScroller();
    }
}

