/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Array_byte;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.texasholdem09.CardSuit;
import ca.jamdat.texasholdem09.CardValue;
import ca.jamdat.texasholdem09.Deck;
import ca.jamdat.texasholdem09.HV;
import ca.jamdat.texasholdem09.HandCalculator;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.PtrArray_PokerPlayerAI;
import ca.jamdat.texasholdem09.StaticCard;

public class AIAlgo
extends TimeControlled {
    public static final byte group1a = 0;
    public static final byte group1b = 1;
    public static final byte group2a = 2;
    public static final byte group2b = 3;
    public static final byte group3a = 4;
    public static final byte group3b = 5;
    public static final byte group4a = 6;
    public static final byte group4b = 7;
    public static final byte group5a = 8;
    public static final byte group5b = 9;
    public static final byte group6a = 10;
    public static final byte group6b = 11;
    public static final byte group7a = 12;
    public static final byte group7b = 13;
    public static final byte group8a = 14;
    public static final byte group8b = 15;
    public static final byte group9 = 16;
    public static final byte count = 17;
    public static final byte kHVComputing = 0;
    public static final byte kHSComputing = 1;
    public static final byte kIdle = 2;
    public int mComputingSliceTimeMs = 100;
    public PtrArray_PokerPlayerAI mRegisteredAIs;
    public short mFocusedAIindex;
    public short mFirstFocusedAIindex;
    public int[][] mHVTable = new int[52][52];
    public int mHSAheadForFocusedAI;
    public int mHSTiedForFocusedAI;
    public int mHSBehindForFocusedAI;
    public int mHandValueForFocusedAI;
    public byte[] mAllCommCards = null;
    public byte[] mBRCommCards = null;
    public int mBRCommCardsCount;
    public Array_byte mBRPossibleCards;
    public Array_byte mPossibleCardsForFocusedAI;
    public short mFirstLoopIndexForFocusedAI;
    public short mSecondLoopIndexForFocusedAI;
    public HandCalculator mHC;
    public byte mState;
    public byte mRound;
    public byte mRiverHighestPossibleHandType = 0;

    public AIAlgo() {
        this.mFocusedAIindex = (short)-1;
        this.mFirstFocusedAIindex = (short)-1;
        this.mState = (byte)2;
        this.mRound = (byte)-1;
        this.mRegisteredAIs = new PtrArray_PokerPlayerAI();
        this.mBRPossibleCards = new Array_byte();
        this.mPossibleCardsForFocusedAI = new Array_byte();
        this.mHC = new HandCalculator();
        this.mBRCommCards = new byte[5];
        this.mAllCommCards = new byte[5];
        StaticCard.Clear(this.mBRCommCards, 5);
        StaticCard.Clear(this.mAllCommCards, 5);
    }

    public void destruct() {
        this.mBRCommCards = null;
        this.mAllCommCards = null;
    }

    public void Init(PtrArray_PokerPlayerAI ptrArray_PokerPlayerAI) {
        this.mRegisteredAIs.Assign(ptrArray_PokerPlayerAI);
    }

    public void InitHand(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < this.mRegisteredAIs.End(); ++i2) {
            PokerPlayerAI pokerPlayerAI;
            pokerPlayerAI.SetComputeMetrics((pokerPlayerAI = this.mRegisteredAIs.GetAt(i2)).GetState() != 0);
            pokerPlayerAI.SetMetricsReadyForComputingRound((byte)0, false);
            pokerPlayerAI.SetMetricsReadyForComputingRound((byte)1, false);
            pokerPlayerAI.SetMetricsReadyForComputingRound((byte)2, false);
        }
        StaticCard.Assign(byArray, this.mAllCommCards, 5);
        this.mFocusedAIindex = this.mFirstFocusedAIindex = (short)n2;
        this.mRound = 0;
        this.mRiverHighestPossibleHandType = 0;
        this.InitBettingRound();
    }

    public byte GetRiverHighestPossibleHandType() {
        return this.mRiverHighestPossibleHandType;
    }

    public static F32 GetValueForHoleCategory(byte by) {
        F32 f32 = new F32();
        F32 f322 = new F32();
        f322 = F32.FromInt(by, 8).Div(F32.FromInt(17, 8), 8);
        f32 = F32.FromInt(1, 8).Sub(f322);
        return f32;
    }

    public static byte GetHoleCategory(byte[] byArray) {
        byte by;
        boolean bl;
        byte by2;
        byte by3 = byArray[0];
        byte by4 = byArray[1];
        if (StaticCard.CompareTo(by3, by4) < 0) {
            by2 = by3;
            by3 = by4;
            by4 = by2;
        }
        by2 = CardValue.GetValue(by3);
        byte by5 = CardValue.GetValue(by4);
        byte by6 = CardSuit.GetSuit(by3);
        boolean bl2 = bl = by6 == (by = CardSuit.GetSuit(by4));
        if (by2 == 12 && by5 == 12 || by2 == 11 && by5 == 11) {
            return 0;
        }
        if (by2 == 10 && by5 == 10 || by2 == 9 && by5 == 9 || by2 == 12 && by5 == 11 && bl) {
            return 1;
        }
        if (by2 == 8 && by5 == 8 || by2 == 12 && by5 == 10 && bl) {
            return 2;
        }
        if (by2 == 12 && by5 == 9 && bl || by2 == 11 && by5 == 10 && bl || by2 == 12 && by5 == 11) {
            return 3;
        }
        if (by2 == 7 && by5 == 7 || by2 == 9 && by5 == 8 && bl || by2 == 10 && by5 == 9 && bl) {
            return 4;
        }
        if (by2 == 11 && by5 == 9 && bl || by2 == 12 && by5 == 8 && bl || by2 == 12 && by5 == 10) {
            return 5;
        }
        if (by2 == 8 && by5 == 7 && bl || by2 == 11 && by5 == 10 || by2 == 6 && by5 == 6 || by2 == 10 && by5 == 8 && bl) {
            return 6;
        }
        if (by2 == 7 && by5 == 6 && bl || by2 == 9 && by5 == 7 && bl || by2 == 12 && by5 == 9 || by2 == 11 && by5 == 8 && bl) {
            return 7;
        }
        if (by2 == 5 && by5 == 5 || by2 == 6 && by5 == 5 && bl || by2 == 10 && by5 == 7 && bl || by2 == 8 && by5 == 6 && bl || by2 == 11 && by5 == 9) {
            return 8;
        }
        if (by2 == 10 && by5 == 9 || by2 == 9 && by5 == 8 || by2 == 5 && by5 == 4 && bl || by2 == 7 && by5 == 5 && bl || by2 == 12 && bl || by2 == 4 && by5 == 3 && bl) {
            return 9;
        }
        if (by2 == 4 && by5 == 4 || by2 == 12 && by5 == 8 || by2 == 3 && by5 == 3 || by2 == 6 && by5 == 4 && bl || by2 == 11 && by5 == 8) {
            return 10;
        }
        if (by2 == 10 && by5 == 8 || by2 == 3 && by5 == 2 && bl || by2 == 11 && by5 == 7 && bl || by2 == 9 && by5 == 6 && bl || by2 == 5 && by5 == 3 && bl) {
            return 11;
        }
        if (by2 == 2 && by5 == 2 || by2 == 9 && by5 == 7 || by2 == 4 && by5 == 2 && bl || by2 == 8 && by5 == 7 || by2 == 3 && by5 == 1 && bl || by2 == 1 && by5 == 1) {
            return 12;
        }
        if (by2 == 7 && by5 == 6 || by2 == 2 && by5 == 1 && bl || by2 == 0 && by5 == 0 || by2 == 11 && bl || by2 == 8 && by5 == 5 && bl || by2 == 10 && by5 == 6 && bl) {
            return 13;
        }
        if (by2 == 6 && by5 == 5 || by2 == 12 && by5 == 7 || by2 == 10 && by5 == 7 || by2 == 5 && by5 == 4 || by2 == 2 && by5 == 0 && bl || by2 == 1 && by5 == 0 && bl || by2 == 7 && by5 == 4 && bl) {
            return 14;
        }
        if (by2 == 6 && by5 == 3 && bl || by2 == 9 && by5 == 6 || by2 == 9 && by5 == 5 && bl || by2 == 4 && by5 == 3 || by2 == 3 && by5 == 2 || by2 == 5 && by5 == 2 && bl || by2 == 11 && by5 == 7 || by2 == 8 && by5 == 6) {
            return 15;
        }
        return 16;
    }

    public void UnloadResources() {
        this.mRegisteredAIs.Clear();
        this.UnRegisterInGlobalTime();
    }

    public void OnTime(int n2, int n3) {
        FlApplication.GetInstance();
        int n4 = (int)FlApplication.GetRealTime();
        switch (this.mState) {
            case 0: {
                byte[] byArray = new byte[2];
                for (int i2 = this.mFirstLoopIndexForFocusedAI; i2 < this.mBRPossibleCards.End(); ++i2) {
                    byte by;
                    byArray[0] = by = this.mBRPossibleCards.GetAt(i2);
                    for (int i3 = i2 + 1; i3 < this.mBRPossibleCards.End(); ++i3) {
                        byte by2;
                        byte by3;
                        byArray[1] = by3 = this.mBRPossibleCards.GetAt(i3);
                        int n5 = this.mHC.GetBestHandValueForNewCards(byArray);
                        short s2 = StaticCard.GetAsUniqueNumericValue(by);
                        short s3 = StaticCard.GetAsUniqueNumericValue(by3);
                        this.mHVTable[s2][s3] = n5;
                        this.mHVTable[s3][s2] = n5;
                        if (this.mRound != 2 || (by2 = HV.GetType(n5)) <= this.mRiverHighestPossibleHandType) continue;
                        this.mRiverHighestPossibleHandType = by2;
                    }
                    FlApplication.GetInstance();
                    if ((int)FlApplication.GetRealTime() - n4 <= this.mComputingSliceTimeMs || this.mComputingSliceTimeMs == 0) continue;
                    this.mFirstLoopIndexForFocusedAI = (short)(i2 + 1);
                    byArray = null;
                    return;
                }
                if (this.mRound == 2) {
                    // empty if block
                }
                this.InitFocusedAI();
                this.mState = 1;
                byArray = null;
                break;
            }
            case 1: {
                if (!this.mRegisteredAIs.GetAt(this.mFocusedAIindex).GetComputeMetrics()) {
                    this.ShiftFocusedAI();
                    return;
                }
                for (int i4 = this.mFirstLoopIndexForFocusedAI; i4 < this.mPossibleCardsForFocusedAI.End(); ++i4) {
                    byte by = this.mPossibleCardsForFocusedAI.GetAt(i4);
                    for (int i5 = i4 + 1; i5 < this.mPossibleCardsForFocusedAI.End(); ++i5) {
                        short s4;
                        byte by4 = this.mPossibleCardsForFocusedAI.GetAt(i5);
                        short s5 = StaticCard.GetAsUniqueNumericValue(by);
                        int n6 = this.mHVTable[s5][s4 = StaticCard.GetAsUniqueNumericValue(by4)];
                        short s6 = HV.Compare(this.mHandValueForFocusedAI, n6);
                        if (s6 > 0) {
                            ++this.mHSAheadForFocusedAI;
                            continue;
                        }
                        if (s6 < 0) {
                            ++this.mHSBehindForFocusedAI;
                            continue;
                        }
                        ++this.mHSTiedForFocusedAI;
                    }
                    FlApplication.GetInstance();
                    if ((int)FlApplication.GetRealTime() - n4 <= this.mComputingSliceTimeMs || this.mComputingSliceTimeMs == 0) continue;
                    this.mFirstLoopIndexForFocusedAI = (short)(i4 + 1);
                    return;
                }
                this.ComputeMetricsForFocusedAI();
                this.ShiftFocusedAI();
                break;
            }
            case 2: {
                return;
            }
        }
    }

    public void InitBettingRound() {
        Deck deck = new Deck();
        this.mBRPossibleCards.Assign(deck.GetCardArray());
        StaticCard.Clear(this.mBRCommCards, 5);
        this.mBRCommCardsCount = 0;
        for (int i2 = 0; i2 < this.mRound + 3; ++i2) {
            byte by = this.mAllCommCards[i2];
            this.mBRPossibleCards.Remove(by);
            this.mBRCommCards[this.mBRCommCardsCount] = by;
            ++this.mBRCommCardsCount;
        }
        this.mFirstLoopIndexForFocusedAI = 0;
        this.mHC.Clear();
        this.mHC.InitBestHandValueComputation(this.mBRCommCards, this.mBRCommCardsCount);
        this.mState = 0;
    }

    public void InitFocusedAI() {
        PokerPlayerAI pokerPlayerAI = this.mRegisteredAIs.GetAt(this.mFocusedAIindex);
        byte[] byArray = pokerPlayerAI.GetNextHoleCards();
        this.mPossibleCardsForFocusedAI.Assign(this.mBRPossibleCards);
        this.mPossibleCardsForFocusedAI.Remove(byArray[0]);
        this.mPossibleCardsForFocusedAI.Remove(byArray[1]);
        this.mHC.Clear();
        this.mHC.InitBestHandValueComputation(this.mBRCommCards, this.mBRCommCardsCount);
        this.mHandValueForFocusedAI = this.mHC.GetBestHandValueForNewCards(pokerPlayerAI.GetNextHoleCards());
        this.mHSAheadForFocusedAI = 0;
        this.mHSTiedForFocusedAI = 0;
        this.mHSBehindForFocusedAI = 0;
        this.mFirstLoopIndexForFocusedAI = 0;
    }

    public void ComputeMetricsForFocusedAI() {
        PokerPlayerAI pokerPlayerAI = this.mRegisteredAIs.GetAt(this.mFocusedAIindex);
        F32 f32 = new F32();
        f32 = F32.FromInt(this.mHSAheadForFocusedAI, 8).Add(F32.FromInt(this.mHSTiedForFocusedAI, 8));
        F32 f322 = new F32();
        f322 = F32.FromInt(this.mHSAheadForFocusedAI, 8).Add(F32.FromInt(this.mHSBehindForFocusedAI, 8)).Add(F32.FromInt(this.mHSTiedForFocusedAI, 8));
        f32 = f32.Div(f322, 8);
        pokerPlayerAI.SetHSForComputingRound(f32, this.mRound);
        if (this.mRound < 2) {
            this.ComputeHPForFocusedAI();
        } else {
            pokerPlayerAI.SetHPForComputingRound(F32.FromInt(-1, 8), this.mRound);
        }
        pokerPlayerAI.SetMetricsReadyForComputingRound(this.mRound);
    }

    public void ShiftFocusedAI() {
        this.mFocusedAIindex = (short)((this.mFocusedAIindex + 1) % this.mRegisteredAIs.End());
        if (this.mFocusedAIindex == this.mFirstFocusedAIindex) {
            if (this.mRound < 2) {
                this.mRound = (byte)(this.mRound + 1);
                this.InitBettingRound();
            } else {
                this.mFocusedAIindex = (short)-1;
                this.mState = (byte)2;
            }
        } else {
            this.InitFocusedAI();
            this.mState = 1;
        }
    }

    public void ComputeHPForFocusedAI() {
        PokerPlayerAI pokerPlayerAI = this.mRegisteredAIs.GetAt(this.mFocusedAIindex);
        byte[] byArray = pokerPlayerAI.GetNextHoleCards();
        byte by = byArray[0];
        byte by2 = byArray[1];
        boolean bl = false;
        byte by3 = HandCalculator.GetHPHeurCategory(by, by2, this.mBRCommCards, bl, this.mBRCommCardsCount);
        F32 f32 = new F32();
        f32 = F32.Zero(8);
        switch (by3) {
            case 0: {
                if (this.mRound == 0) {
                    f32 = F32.FromInt(19, 8);
                    break;
                }
                f32 = F32.FromInt(10, 8);
                break;
            }
            case 1: {
                if (this.mRound == 0) {
                    f32 = F32.FromInt(14, 8);
                    break;
                }
                f32 = F32.FromInt(5, 8);
                break;
            }
            case 2: {
                f32 = this.mRound == 0 ? F32.FromInt(48, 8) : F32.FromInt(30, 8);
                if (!HandCalculator.IsBoardPaired(this.mBRCommCards, this.mBRCommCardsCount)) break;
                f32 = f32.Sub(F32.FromInt(5, 8));
                break;
            }
            case 3: {
                f32 = this.mRound == 0 ? F32.FromInt(44, 8) : F32.FromInt(25, 8);
                if (!HandCalculator.IsBoardPaired(this.mBRCommCards, this.mBRCommCardsCount)) break;
                f32 = f32.Sub(F32.FromInt(5, 8));
                break;
            }
            case 4: {
                int n2 = HandCalculator.GetMaxNbOfSameSuitCards(this.mBRCommCards, this.mBRCommCardsCount);
                if (this.mRound == 0) {
                    f32 = F32.FromInt(45, 8);
                    if (n2 != 3) break;
                    f32 = f32.Sub(F32.FromInt(10, 8));
                    break;
                }
                f32 = F32.FromInt(25, 8);
                if (n2 == 4) {
                    f32 = f32.Sub(F32.FromInt(10, 8));
                    break;
                }
                if (n2 != 3) break;
                f32 = f32.Sub(F32.FromInt(5, 8));
                break;
            }
            case 5: {
                int n3 = HandCalculator.GetMaxNbOfSameSuitCards(this.mBRCommCards, this.mBRCommCardsCount);
                if (this.mRound == 0) {
                    f32 = F32.FromInt(38, 8);
                    if (n3 != 3) break;
                    f32 = f32.Sub(F32.FromInt(8, 8));
                    break;
                }
                f32 = F32.FromInt(22, 8);
                if (n3 < 3) break;
                f32 = f32.Sub(F32.FromInt(5, 8));
                break;
            }
            case 6: {
                f32 = this.mRound == 0 ? F32.FromInt(32, 8) : F32.FromInt(20, 8);
                int n4 = HandCalculator.GetMaxNbOfSameSuitCards(this.mBRCommCards, this.mBRCommCardsCount);
                if (n4 < 3) break;
                f32 = f32.Sub(F32.FromInt(5, 8));
                break;
            }
            case 7: {
                f32 = this.mRound == 0 ? F32.FromInt(26, 8) : F32.FromInt(15, 8);
                int n5 = HandCalculator.GetMaxNbOfSameSuitCards(this.mBRCommCards, this.mBRCommCardsCount);
                if (n5 < 3) break;
                f32 = f32.Sub(F32.FromInt(5, 8));
                break;
            }
            case 8: {
                f32 = this.mRound == 0 ? F32.FromInt(65, 8) : F32.FromInt(42, 8);
                if (!HandCalculator.IsBoardPaired(this.mBRCommCards, this.mBRCommCardsCount)) break;
                f32 = f32.Sub(F32.FromInt(5, 8));
                break;
            }
            case 9: {
                if (this.mRound == 0) {
                    f32 = F32.FromInt(58, 8);
                    break;
                }
                f32 = F32.FromInt(36, 8);
                break;
            }
            case 10: {
                if (this.mRound == 0) {
                    f32 = F32.FromInt(56, 8);
                    break;
                }
                f32 = F32.FromInt(36, 8);
                break;
            }
            case 11: {
                f32 = this.mRound == 0 ? F32.FromInt(50, 8) : F32.FromInt(31, 8);
            }
        }
        if (by3 >= 2 && !bl) {
            f32 = f32.Sub(F32.FromInt(5, 8));
        }
        if (by3 != -1) {
            f32 = f32.Div(100);
        }
        pokerPlayerAI.SetHPForComputingRound(f32, this.mRound);
    }

    public static AIAlgo[] InstArrayAIAlgo(int n2) {
        AIAlgo[] aIAlgoArray = new AIAlgo[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            aIAlgoArray[i2] = new AIAlgo();
        }
        return aIAlgoArray;
    }

    public static AIAlgo[][] InstArrayAIAlgo(int n2, int n3) {
        AIAlgo[][] aIAlgoArray = new AIAlgo[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            aIAlgoArray[i2] = new AIAlgo[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                aIAlgoArray[i2][i3] = new AIAlgo();
            }
        }
        return aIAlgoArray;
    }

    public static AIAlgo[][][] InstArrayAIAlgo(int n2, int n3, int n4) {
        AIAlgo[][][] aIAlgoArray = new AIAlgo[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            aIAlgoArray[i2] = new AIAlgo[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                aIAlgoArray[i2][i3] = new AIAlgo[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    aIAlgoArray[i2][i3][i4] = new AIAlgo();
                }
            }
        }
        return aIAlgoArray;
    }
}

