/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.TimeData;

public class TimeUtils {
    public static TimeData GetTime() {
        TimeData timeData = new TimeData();
        return timeData;
    }

    public static int GetHour(TimeData timeData) {
        return timeData.GetHour();
    }

    public static int GetMin(TimeData timeData) {
        return timeData.GetMin();
    }

    public static int GetSec(TimeData timeData) {
        return timeData.GetSec();
    }

    public static int GetYear(TimeData timeData) {
        return timeData.GetYear();
    }

    public static int GetMonth(TimeData timeData) {
        return timeData.GetMonth();
    }

    public static int GetDay(TimeData timeData) {
        return timeData.GetDay();
    }

    public static FlString Get12HourFormat(TimeData timeData, boolean bl, byte by) {
        int n2 = timeData.GetHour();
        boolean bl2 = true;
        if (n2 > 12) {
            bl2 = false;
            n2 -= 12;
        }
        FlString flString = new FlString(n2);
        flString.AddAssign(FlString.FromChar(by));
        int n3 = timeData.GetMin();
        if (n3 < 10) {
            flString.AddAssign(new FlString(0));
        }
        flString.AddAssign(new FlString(n3));
        if (bl) {
            flString.AddAssign(FlString.FromChar(by));
            int n4 = timeData.GetSec();
            if (n4 < 10) {
                flString.AddAssign(new FlString(0));
            }
            flString.AddAssign(new FlString(n4));
        }
        if (bl2) {
            flString.AddAssign(StringUtils.CreateString("am"));
        } else {
            flString.AddAssign(StringUtils.CreateString("pm"));
        }
        return flString;
    }

    public static FlString Get24HourFormat(TimeData timeData, boolean bl, byte by) {
        FlString flString = new FlString(timeData.GetHour());
        flString.AddAssign(FlString.FromChar(by));
        int n2 = timeData.GetMin();
        if (n2 < 10) {
            flString.AddAssign(new FlString(0));
        }
        flString.AddAssign(new FlString(n2));
        if (bl) {
            flString.AddAssign(FlString.FromChar(by));
            int n3 = timeData.GetSec();
            if (n3 < 10) {
                flString.AddAssign(new FlString(0));
            }
            flString.AddAssign(new FlString(n3));
        }
        return flString;
    }

    public static boolean IsDateValid(int n2, int n3, int n4) {
        TimeData timeData = new TimeData(n3, n4, n2);
        return timeData.IsDateValid();
    }

    public static int GetElapsedDays(TimeData timeData) {
        TimeData timeData2 = new TimeData();
        int n2 = TimeUtils.GetJulianDayNumber(timeData2);
        int n3 = TimeUtils.GetJulianDayNumber(timeData);
        return n2 - n3;
    }

    public static int GetElapsedYears(TimeData timeData) {
        int n2 = 0;
        TimeData timeData2 = new TimeData();
        n2 = timeData2.GetYear() - timeData.GetYear() - 1;
        if (timeData.GetMonth() < timeData2.GetMonth()) {
            ++n2;
        } else if (timeData.GetMonth() == timeData2.GetMonth() && timeData.GetDay() <= timeData2.GetDay()) {
            ++n2;
        }
        return n2;
    }

    public static int GetJulianDayNumber(TimeData timeData) {
        int n2 = timeData.GetMonth();
        int n3 = timeData.GetYear();
        if (n2 < 3) {
            n2 += 12;
            --n3;
        }
        return timeData.GetDay() + (153 * n2 - 457) / 5 + 365 * n3 + n3 / 4 + 1721116;
    }

    public static FlString Get12HourFormat(TimeData timeData) {
        return TimeUtils.Get12HourFormat(timeData, false);
    }

    public static FlString Get12HourFormat(TimeData timeData, boolean bl) {
        return TimeUtils.Get12HourFormat(timeData, bl, (byte)58);
    }

    public static FlString Get24HourFormat(TimeData timeData) {
        return TimeUtils.Get24HourFormat(timeData, false);
    }

    public static FlString Get24HourFormat(TimeData timeData, boolean bl) {
        return TimeUtils.Get24HourFormat(timeData, bl, (byte)58);
    }

    public static TimeUtils[] InstArrayTimeUtils(int n2) {
        TimeUtils[] timeUtilsArray = new TimeUtils[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            timeUtilsArray[i2] = new TimeUtils();
        }
        return timeUtilsArray;
    }

    public static TimeUtils[][] InstArrayTimeUtils(int n2, int n3) {
        TimeUtils[][] timeUtilsArray = new TimeUtils[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            timeUtilsArray[i2] = new TimeUtils[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                timeUtilsArray[i2][i3] = new TimeUtils();
            }
        }
        return timeUtilsArray;
    }

    public static TimeUtils[][][] InstArrayTimeUtils(int n2, int n3, int n4) {
        TimeUtils[][][] timeUtilsArray = new TimeUtils[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            timeUtilsArray[i2] = new TimeUtils[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                timeUtilsArray[i2][i3] = new TimeUtils[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    timeUtilsArray[i2][i3][i4] = new TimeUtils();
                }
            }
        }
        return timeUtilsArray;
    }
}

