/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BlString;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Memory;

public class StringUtils {
    public static FlString CreateString(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        FlString flString = new FlString();
        flString.Assign(byArray, 0, byArray.length);
        return flString;
    }

    public static FlString CreateStringPtr(String string) {
        return StringUtils.CreateString(string);
    }

    public static FlString CreateString(byte[] byArray) {
        FlString flString = new FlString(byArray);
        return flString;
    }

    public static FlString CreateString(FlString flString) {
        return flString;
    }

    public static FlString CreateString(BlString blString) {
        String string = new String(blString.ToAscii());
        FlString flString = new FlString(string);
        return flString;
    }

    public static FlString CreateStringPtr(byte[] byArray) {
        return new FlString(byArray);
    }

    public static FlString CreateFromANSIString(byte[] byArray, int n2, int n3) {
        FlString flString = new FlString();
        flString.mData = null;
        flString.mData = new byte[n2 + 1];
        Memory.Copy(flString.mData, 0, byArray, n3, n2);
        flString.mData[n2] = 0;
        return flString;
    }

    public static byte[] ToRawString(FlString flString) {
        return flString.ToRawString();
    }

    public static FlString StringAdd(FlString flString, byte[] byArray) {
        return flString.Add(byArray);
    }

    public static int StringLen(byte[] byArray) {
        int n2 = 0;
        while (byArray[n2] != 0) {
            ++n2;
        }
        return n2;
    }

    public static void StringNCopy(byte[] byArray, byte[] byArray2, int n2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray[n2 + i2] = byArray2[n3 + i2];
            if (byArray2[n3 + i2] == 0) break;
        }
    }

    public static void StringNCopy(byte[] byArray, byte[] byArray2, int n2) {
        StringUtils.StringNCopy(byArray, byArray2, 0, 0, n2);
    }

    public static void StringCopy(byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        while ((byArray[n2] = byArray2[n2]) != 0) {
            ++n2;
        }
    }

    public static void StringCat(byte[] byArray, byte[] byArray2) {
        StringUtils.StringNCopy(byArray, byArray2, StringUtils.StringLen(byArray), 0, StringUtils.StringLen(byArray2) + 1);
    }

    public static void StringCat(FlString flString, byte[] byArray) {
        flString.AddAssign(byArray);
    }

    public static int StringLong(byte[] byArray, int n2) {
        boolean bl = false;
        if (n2 < 0) {
            bl = true;
            n2 = -n2;
        }
        int n3 = 16;
        byArray[--n3] = 0;
        do {
            byArray[--n3] = (byte)(48 + n2 % 10);
        } while ((n2 /= 10) != 0);
        if (bl) {
            byArray[--n3] = 45;
        }
        return n3;
    }

    public static int StringLongLong(byte[] byArray, long l2) {
        boolean bl = false;
        if (l2 < 0L) {
            bl = true;
            l2 = -l2;
        }
        int n2 = 32;
        byArray[--n2] = 0;
        do {
            byArray[--n2] = (byte)(48L + l2 % 10L);
        } while ((l2 /= 10L) != 0L);
        if (bl) {
            byArray[--n2] = 45;
        }
        return n2;
    }

    public static int StringCmp(byte[] byArray, byte[] byArray2) {
        return StringUtils.StringNCmp(byArray, byArray2, -1);
    }

    public static int StringNCmp(byte[] byArray, byte[] byArray2, int n2) {
        byte by = 0;
        byte by2 = 0;
        for (int i2 = 0; n2 < 0 || i2 < n2; ++i2) {
            by = byArray[i2];
            by2 = byArray2[i2];
            if (by == by2 && by != 0) continue;
            return by - by2;
        }
        return by - by2;
    }

    public static int StringChr(byte[] byArray, int n2, byte by) {
        do {
            if (byArray[n2] != by) continue;
            return n2;
        } while (byArray[n2++] != 0);
        return -1;
    }

    public static int StringRChr(byte[] byArray, byte by) {
        int n2 = StringUtils.StringLen(byArray);
        if (n2 == 0) {
            return 0;
        }
        int n3 = n2 - 1;
        do {
            if (byArray[n3] != by) continue;
            return n3;
        } while (--n3 >= 0);
        return -1;
    }

    public static byte[] StringDuplicate(byte[] byArray) {
        byte[] byArray2 = new byte[StringUtils.StringLen(byArray) + 1];
        StringUtils.StringCopy(byArray2, byArray);
        return byArray2;
    }

    public static int StringFindSubstring(byte[] byArray, byte[] byArray2) {
        return StringUtils.StringFindSubstring(byArray, byArray2, 0);
    }

    public static int StringFindSubstring(byte[] byArray, byte[] byArray2, int n2) {
        int n3 = -1;
        int n4 = 0;
        if (byArray2[n4] == 0) {
            return 0;
        }
        if (n2 != 0 && n2 >= StringUtils.StringLen(byArray)) {
            return -1;
        }
        int n5 = n2;
        while (byArray[n5] != 0) {
            if (byArray[n5] == byArray2[n4]) {
                n3 = n5;
                do {
                    if (byArray2[n4] != 0) continue;
                    return n5;
                } while (byArray[n3++] == byArray2[n4++]);
                n4 = 0;
            }
            ++n5;
        }
        return -1;
    }

    public static void ChangePathSeparator(byte[] byArray) {
        int n2 = 92;
        int n3 = StringUtils.StringLen(byArray);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2] != 47 && byArray[i2] != 92) continue;
            byArray[i2] = n2;
        }
    }

    public static boolean IsReservedURLCharacter(byte by) {
        boolean bl = false;
        switch (by) {
            case 36: 
            case 38: 
            case 43: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean IsUnsafeURLCharacter(byte by) {
        boolean bl;
        boolean bl2 = bl = by <= 31 || by >= 127;
        if (!bl) {
            switch (by) {
                case 32: 
                case 34: 
                case 35: 
                case 37: 
                case 60: 
                case 62: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 96: 
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean IsValidURL(FlString flString) {
        boolean bl = true;
        for (int i2 = 0; i2 < flString.GetLength(); ++i2) {
            byte by = flString.GetCharAt(i2);
            if (by == 37 || !StringUtils.IsUnsafeURLCharacter(by)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static byte ToHexDigit(short s2) {
        FlString flString = new FlString(StringUtils.CreateString("0123456789abcdef"));
        return flString.GetCharAt(s2 & 0xF);
    }

    public static short FromHexDigit(byte by) {
        FlString flString = new FlString(StringUtils.CreateString("0123456789abcdef"));
        if (by >= 65 && by <= 90) {
            by = (byte)(by - 65 + 97);
        }
        return (short)flString.FindChar(by);
    }

    public static FlString EncodeURL(FlString flString, boolean bl) {
        FlString flString2 = new FlString();
        byte[] byArray = StringUtils.ToRawString(flString);
        int n2 = FlString.GetUtf8EncodedDataSize(byArray);
        byte[] byArray2 = new byte[n2];
        FlString.ConvertCharToUtf8(byArray, byArray2);
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            byte by = byArray2[i2];
            if (StringUtils.IsUnsafeURLCharacter(by) || bl && StringUtils.IsReservedURLCharacter(by)) {
                flString2.InsertCharAt(flString2.GetLength(), (byte)37);
                flString2.InsertCharAt(flString2.GetLength(), StringUtils.ToHexDigit((short)((by & 0xF0) / 16)));
                flString2.InsertCharAt(flString2.GetLength(), StringUtils.ToHexDigit((short)(by & 0xF)));
                continue;
            }
            flString2.InsertCharAt(flString2.GetLength(), by);
        }
        byArray2 = null;
        return flString2;
    }

    public static FlString DecodeURL(FlString flString) {
        int n2 = flString.GetLength();
        byte[] byArray = new byte[flString.GetLength() + 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = flString.GetCharAt(i2);
            if (by == 37 && i2 <= n2 - 3) {
                short s2 = (short)(StringUtils.FromHexDigit(flString.GetCharAt(i2 + 1)) * 16 + StringUtils.FromHexDigit(flString.GetCharAt(i2 + 2)));
                byArray[n3] = (byte)s2;
                i2 += 2;
            } else {
                byArray[n3] = by;
            }
            ++n3;
        }
        byArray[n3] = 0;
        FlString flString2 = new FlString(FlString.DecodeUTF8(byArray));
        byArray = null;
        return flString2;
    }

    public static FlString ToLowerCase(FlString flString) {
        FlString flString2 = new FlString(flString);
        int n2 = flString2.GetLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = flString2.GetCharAt(i2);
            if (by < 65 || by > 90) continue;
            flString2.ReplaceCharAt(i2, (byte)(by - 65 + 97));
        }
        return flString2;
    }

    public static int StringAtoI(byte[] byArray) {
        return Integer.parseInt(StringUtils.CreateJavaString(StringUtils.CreateString(byArray)));
    }

    public static long StringAtoLL(byte[] byArray) {
        return Long.parseLong(StringUtils.CreateJavaString(StringUtils.CreateString(byArray)));
    }

    public static String CreateJavaString(FlString flString) {
        return StringUtils.CreateJavaString(flString, 0, flString.GetLength());
    }

    public static String CreateJavaString(FlString flString, int n2, int n3) {
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2] = (char)(flString.GetCharAt(n2++) & 0xFF);
        }
        return new String(cArray);
    }

    public static int StringToBytes(String string, byte[] byArray, int n2) {
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            byArray[n2++] = (byte)(c2 >>> 8);
            byArray[n2++] = (byte)(c2 & 0xFF);
        }
        return n2;
    }

    public static FlString CreateFromANSIString(byte[] byArray, int n2) {
        return StringUtils.CreateFromANSIString(byArray, n2, 0);
    }

    public static FlString EncodeURL(FlString flString) {
        return StringUtils.EncodeURL(flString, true);
    }

    public static StringUtils[] InstArrayStringUtils(int n2) {
        StringUtils[] stringUtilsArray = new StringUtils[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringUtilsArray[i2] = new StringUtils();
        }
        return stringUtilsArray;
    }

    public static StringUtils[][] InstArrayStringUtils(int n2, int n3) {
        StringUtils[][] stringUtilsArray = new StringUtils[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringUtilsArray[i2] = new StringUtils[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                stringUtilsArray[i2][i3] = new StringUtils();
            }
        }
        return stringUtilsArray;
    }

    public static StringUtils[][][] InstArrayStringUtils(int n2, int n3, int n4) {
        StringUtils[][][] stringUtilsArray = new StringUtils[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringUtilsArray[i2] = new StringUtils[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                stringUtilsArray[i2][i3] = new StringUtils[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    stringUtilsArray[i2][i3][i4] = new StringUtils();
                }
            }
        }
        return stringUtilsArray;
    }
}

