/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlDisplayContext;
import ca.jamdat.flight.FlDrawPropertyUtil;
import ca.jamdat.flight.Package;

public class Sprite
extends Component {
    public static final byte typeNumber = 53;
    public static final byte typeID = 53;
    public static final boolean supportsDynamicSerialization = true;
    public static final byte SPRITE_TILE_X = 0;
    public static final byte SPRITE_TILE_Y = 1;
    public static final byte SPRITE_FLIP_X = 2;
    public static final byte SPRITE_FLIP_Y = 3;
    public FlBitmap mBitmap;
    public boolean mTileInX;
    public boolean mTileInY;
    public boolean mFlipX;
    public boolean mFlipY;

    public static Sprite Cast(Object object, Sprite sprite) {
        return (Sprite)object;
    }

    public byte GetTypeID() {
        return 53;
    }

    public static Class AsClass() {
        return null;
    }

    public void destruct() {
        this.mBitmap = null;
    }

    public void SetBitmap(FlBitmap flBitmap) {
        this.mBitmap = flBitmap;
        if (this.mBitmap != null && !this.mTileInX && !this.mTileInY) {
            this.SetSize(this.mBitmap.GetWidth(), this.mBitmap.GetHeight());
        }
    }

    public FlBitmap GetBitmap() {
        return this.mBitmap;
    }

    public void SizeToBitmap() {
        this.SetSize(this.mBitmap.GetWidth(), this.mBitmap.GetHeight());
    }

    public void MoveBy(short s2, short s3) {
        if (s2 != 0 || s3 != 0) {
            this.SetTopLeft((short)(this.GetRectLeft() + s2), (short)(this.GetRectTop() + s3));
        }
    }

    public void SetTileableXY(boolean bl) {
        this.SetTileableX(bl);
        this.SetTileableY(bl);
    }

    public void SetTileableX(boolean bl) {
        this.mTileInX = bl;
    }

    public void SetTileableY(boolean bl) {
        this.mTileInY = bl;
    }

    public boolean GetTileInX() {
        return this.mTileInX;
    }

    public boolean GetTileInY() {
        return this.mTileInY;
    }

    public void SetFlipX(boolean bl) {
        if (this.mFlipX != bl) {
            this.mFlipX = bl;
            this.Invalidate();
        }
    }

    public void SetFlipY(boolean bl) {
        if (this.mFlipY != bl) {
            this.mFlipY = bl;
            this.Invalidate();
        }
    }

    public boolean GetFlipX() {
        return this.mFlipX;
    }

    public boolean GetFlipY() {
        return this.mFlipY;
    }

    public void OnDraw(FlDisplayContext flDisplayContext) {
        FlBitmap flBitmap = this.mBitmap;
        if (flBitmap == null) {
            return;
        }
        int n2 = 255;
        n2 = FlDrawPropertyUtil.ApplyTransform(n2, FlDrawPropertyUtil.FlipXYToTransform(this.mFlipX, this.mFlipY));
        n2 = FlDrawPropertyUtil.ApplyTile(n2, this.mTileInX, this.mTileInY);
        if (this.mTileInX || this.mTileInY) {
            short s2 = 0;
            short s3 = 0;
            short s4 = flBitmap.GetWidth();
            short s5 = flBitmap.GetHeight();
            flDisplayContext.DrawTiledBitmapSection(flBitmap, flBitmap.GetWidth(), flBitmap.GetHeight(), (short)0, (short)0, s2, s3, s4, s5, this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height, n2);
            return;
        }
        flDisplayContext.DrawBitmapSection(flBitmap, this.GetRectLeft(), this.GetRectTop(), (short)0, (short)0, this.GetRectWidth(), this.GetRectHeight(), n2);
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mBitmap = FlBitmap.Cast(package_.SerializePointer((byte)21, true, false), null);
        byte by = 0;
        by = package_.SerializeIntrinsic(by);
        this.mTileInX = (by & 1) != 0;
        this.mTileInY = (by & 2) != 0;
        this.mFlipX = (by & 4) != 0;
        this.mFlipY = (by & 8) != 0;
    }

    public static Sprite[] InstArraySprite(int n2) {
        Sprite[] spriteArray = new Sprite[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            spriteArray[i2] = new Sprite();
        }
        return spriteArray;
    }

    public static Sprite[][] InstArraySprite(int n2, int n3) {
        Sprite[][] spriteArray = new Sprite[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            spriteArray[i2] = new Sprite[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                spriteArray[i2][i3] = new Sprite();
            }
        }
        return spriteArray;
    }

    public static Sprite[][][] InstArraySprite(int n2, int n3, int n4) {
        Sprite[][][] spriteArray = new Sprite[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            spriteArray[i2] = new Sprite[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                spriteArray[i2][i3] = new Sprite[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    spriteArray[i2][i3][i4] = new Sprite();
                }
            }
        }
        return spriteArray;
    }
}

