/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public class Scroller
extends Viewport {
    public static final byte typeNumber = 98;
    public static final byte typeID = 98;
    public static final boolean supportsDynamicSerialization = true;
    public static final byte intermediateState = 0;
    public static final byte finalState = 1;
    public Component[] mElements;
    public int mNumElements;
    public int mMaxNumElements;
    public Viewport mScrollerViewport;
    public Selection mNextArrow;
    public Selection mPreviousArrow;
    public boolean mIsVertical;
    public boolean mIsViewportCentered;

    public static Scroller Cast(Object object, Scroller scroller) {
        return (Scroller)object;
    }

    public byte GetTypeID() {
        return 98;
    }

    public static Class AsClass() {
        return null;
    }

    public Scroller() {
        this.mIsVertical = true;
    }

    public Scroller(int n2) {
        this.mMaxNumElements = n2;
        this.mIsVertical = true;
        this.mElements = this.AllocComponentTable();
    }

    public void destruct() {
        for (int i2 = 0; i2 < this.mNumElements; ++i2) {
            this.mElements[i2] = null;
        }
        this.mElements = null;
    }

    public void SetMaxNumElements(int n2) {
        this.mMaxNumElements = n2;
        Component[] componentArray = this.AllocComponentTable();
        int n3 = this.mMaxNumElements < this.mNumElements ? this.mMaxNumElements : this.mNumElements;
        for (int i2 = 0; i2 < n3; ++i2) {
            componentArray[i2] = this.mElements[i2];
        }
        this.mElements = componentArray;
    }

    public void SetElementAt(int n2, Component component) {
        this.mElements[n2] = component;
    }

    public Component GetElementAt(int n2) {
        return this.mElements[n2];
    }

    public void SetNumElements(int n2) {
        this.mNumElements = n2;
    }

    public int GetNumElements() {
        return this.mNumElements;
    }

    public void SetNextArrow(Selection selection) {
        this.mNextArrow = selection;
    }

    public Selection GetNextArrow() {
        return this.mNextArrow;
    }

    public void SetPreviousArrow(Selection selection) {
        this.mPreviousArrow = selection;
    }

    public Selection GetPreviousArrow() {
        return this.mPreviousArrow;
    }

    public void SetIsViewportCentered(boolean bl) {
        this.mIsViewportCentered = bl;
    }

    public void SetScrollerViewport(Viewport viewport) {
        this.mScrollerViewport = viewport;
    }

    public Viewport GetScrollerViewport() {
        return this.mScrollerViewport;
    }

    public F32 GetScrollbarRatio() {
        Component component = this.GetFirstElement();
        Vector2_short vector2_short = new Vector2_short();
        this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, component, false);
        if (this.mIsVertical) {
            short s2 = this.GetVerticalTotalScrollingSize();
            if (this.mScrollerViewport.GetRectHeight() >= s2) {
                return F32.Zero(16);
            }
            return new F32(-vector2_short.GetY(), 16).Div(new F32(s2 - this.mScrollerViewport.GetRectHeight(), 16), 16);
        }
        short s3 = this.GetHorizontalTotalScrollingSize();
        if (this.mScrollerViewport.GetRectWidth() >= s3) {
            return F32.Zero(16);
        }
        return new F32(-vector2_short.GetX(), 16).Div(new F32(s3 - this.mScrollerViewport.GetRectWidth(), 16), 16);
    }

    public short GetVisibleWindowSize() {
        if (this.mIsVertical) {
            return this.mScrollerViewport.GetRectHeight();
        }
        return this.mScrollerViewport.GetRectWidth();
    }

    public short GetTotalScrollingSize() {
        return this.mIsVertical ? this.GetVerticalTotalScrollingSize() : this.GetHorizontalTotalScrollingSize();
    }

    public short GetFirstElemOffset() {
        if (this.mIsVertical) {
            return this.mScrollerViewport.GetOffsetY();
        }
        return this.mScrollerViewport.GetOffsetX();
    }

    public void SetVertical(boolean bl) {
        this.mIsVertical = bl;
    }

    public boolean IsVertical() {
        return this.mIsVertical;
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mNextArrow = Selection.Cast(package_.SerializePointer((byte)97, true, false), null);
        this.mPreviousArrow = Selection.Cast(package_.SerializePointer((byte)97, true, false), null);
        this.mScrollerViewport = Viewport.Cast(package_.SerializePointer((byte)68, true, false), null);
        this.mIsVertical = package_.SerializeIntrinsic(this.mIsVertical);
        this.mIsViewportCentered = package_.SerializeIntrinsic(this.mIsViewportCentered);
        this.mNumElements = package_.SerializeIntrinsic(this.mNumElements);
        this.mMaxNumElements = package_.SerializeIntrinsic(this.mMaxNumElements);
        this.mElements = this.AllocComponentTable();
        for (int i2 = 0; i2 < this.mNumElements; ++i2) {
            Component component = null;
            this.mElements[i2] = component = Component.Cast(package_.SerializePointer((byte)67, true, false), null);
        }
        if (package_.IsReading()) {
            this.ResetScroller();
        }
    }

    public boolean OnDefaultMsg(Component component, int n2, int n3) {
        if (n2 == -114) {
            this.ResetScroller();
            return true;
        }
        if (n2 == -128) {
            this.FocusGained(n3);
            return false;
        }
        if (n2 == -125) {
            boolean bl;
            boolean bl2 = null != this.mNextArrow && this.mNextArrow.IsSelfOrAncestorOf(component);
            boolean bl3 = bl = null != this.mPreviousArrow && this.mPreviousArrow.IsSelfOrAncestorOf(component);
            if ((0 == n3 || 3 == n3) && (bl2 || bl)) {
                this.SendMsg(this, -111, 1);
            }
        } else if (n2 == -121 || n2 == -120 || n2 == -119) {
            int n4 = 0;
            int n5 = n3;
            if (this.mIsVertical) {
                if (n5 == 1) {
                    n4 = -1;
                } else if (n5 == 2) {
                    n4 = 1;
                }
            } else if (n5 == 3) {
                n4 = -1;
            } else if (n5 == 4) {
                n4 = 1;
            }
            if (n4 != 0) {
                if (this.mNumElements <= 0) {
                    return true;
                }
                if (this.mNextArrow != null) {
                    Selection selection = n4 == 1 ? this.mNextArrow : this.mPreviousArrow;
                    boolean bl = -121 != n2;
                    selection.SetPushedState(bl);
                } else if (-121 == n2) {
                    this.SendMsg(this, -111, 1);
                }
                if (n2 == -119) {
                    this.OnScrollEvent(n4);
                }
                return true;
            }
            if (this.IsAppropriateHotkey(n2, n5)) {
                return true;
            }
        }
        return super.OnDefaultMsg(component, n2, n3);
    }

    public void FocusGained(int n2) {
        if (this.mNextArrow != null) {
            boolean bl = n2 != 0;
            this.mNextArrow.SetSelectedState(bl);
            this.mPreviousArrow.SetSelectedState(bl);
        }
    }

    public void ResetScroller() {
        if (this.mNumElements > 0) {
            Component component = this.GetFirstElement();
            Component component2 = this.GetLastElement();
            Viewport viewport = this.mScrollerViewport;
            boolean bl = this.mIsVertical ? this.GetVerticalTotalScrollingSize() > viewport.GetRectHeight() : this.GetHorizontalTotalScrollingSize() > viewport.GetRectWidth();
            short s2 = viewport.GetOffsetX();
            short s3 = viewport.GetOffsetY();
            if (this.mIsViewportCentered && !bl) {
                if (this.mIsVertical) {
                    s3 = (short)(-(viewport.GetRectHeight() + component.GetRectTop() - component2.GetBottom()) / 2);
                } else {
                    s2 = (short)(-(viewport.GetRectWidth() + component.GetRectLeft() - component2.GetRight()) / 2);
                }
            } else if (this.mIsVertical) {
                s3 = component.GetRectTop();
            } else {
                s2 = component.GetRectLeft();
            }
            viewport.OffsetTo(s2, s3);
        }
        this.UpdateScroller();
    }

    public void UpdateScroller() {
        this.CheckIfArrowsAreNeeded();
        this.UpdateArrowsEnabledState();
    }

    public short GetScrollingPosition() {
        return this.mIsVertical ? this.mScrollerViewport.GetOffsetY() : this.mScrollerViewport.GetOffsetX();
    }

    public void SetScrollingPosition(short s2) {
        short s3 = 0;
        short s4 = 0;
        if (this.mIsVertical) {
            s4 = s2;
        } else {
            s3 = s2;
        }
        this.mScrollerViewport.OffsetTo(s3, s4);
    }

    public Component[] AllocComponentTable() {
        Component[] componentArray = new Component[this.mMaxNumElements];
        return componentArray;
    }

    public void UpdateArrowsEnabledState() {
        if (this.mNextArrow != null && this.mNumElements > 0) {
            Vector2_short vector2_short = new Vector2_short();
            this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, this.GetFirstElement(), false);
            this.mPreviousArrow.SetEnabledState(vector2_short.GetY() < 0);
            this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, this.GetLastElement(), true);
            this.mNextArrow.SetEnabledState(vector2_short.GetY() > 0);
        }
    }

    public void CheckIfArrowsAreNeeded() {
        if (this.mNextArrow != null) {
            boolean bl = false;
            if (this.mNumElements > 0) {
                Vector2_short vector2_short = new Vector2_short();
                this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, this.GetFirstElement(), false);
                boolean bl2 = vector2_short.GetX() == 0;
                boolean bl3 = vector2_short.GetY() == 0;
                this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, this.GetLastElement(), true);
                boolean bl4 = vector2_short.GetX() == 0;
                boolean bl5 = vector2_short.GetY() == 0;
                bl = !bl2 || !bl3 || !bl4 || !bl5;
            }
            this.mNextArrow.SetVisible(bl);
            this.mPreviousArrow.SetVisible(bl);
        }
    }

    public void OnScrollEvent(int n2, boolean bl) {
        int n3;
        int n4 = -1;
        Vector2_short vector2_short = new Vector2_short();
        Component[] componentArray = this.mElements;
        if (n2 == 1) {
            for (n3 = 0; n3 < this.mNumElements; ++n3) {
                this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, componentArray[n3], true);
                if ((!this.mIsVertical || vector2_short.GetY() <= 0) && (this.mIsVertical || vector2_short.GetX() <= 0) || !componentArray[n3].IsVisible()) continue;
                n4 = n3;
                break;
            }
        } else {
            for (n3 = this.mNumElements - 1; n3 >= 0; --n3) {
                this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, componentArray[n3], false);
                if ((!this.mIsVertical || vector2_short.GetY() >= 0) && (this.mIsVertical || vector2_short.GetX() >= 0) || !componentArray[n3].IsVisible()) continue;
                n4 = n3;
                break;
            }
        }
        if (n4 >= 0) {
            if (componentArray[n4] instanceof Text) {
                n3 = ((Text)componentArray[n4]).GetLineHeight();
                this.mScrollerViewport.OffsetBy((short)0, (short)(n2 * n3));
            } else {
                this.mScrollerViewport.ChangeOffsetToShow(componentArray[n4], n2 == 1);
            }
            this.UpdateArrowsEnabledState();
            this.SendMsg(this, -111, 0);
        }
    }

    public boolean IsAppropriateHotkey(int n2, int n3) {
        return false;
    }

    public Component GetFirstElement() {
        Component[] componentArray = this.mElements;
        for (int i2 = 0; i2 < this.mNumElements; ++i2) {
            if (!componentArray[i2].IsVisible() || !this.mScrollerViewport.IsSelfOrAncestorOf(componentArray[i2].GetViewport())) continue;
            return componentArray[i2];
        }
        return componentArray[0];
    }

    public Component GetLastElement() {
        Component[] componentArray = this.mElements;
        for (int i2 = this.mNumElements - 1; i2 >= 0; --i2) {
            if (!componentArray[i2].IsVisible() || !this.mScrollerViewport.IsSelfOrAncestorOf(componentArray[i2].GetViewport())) continue;
            return componentArray[i2];
        }
        return this.mElements[this.mNumElements > 0 ? this.mNumElements - 1 : 0];
    }

    public short GetVerticalTotalScrollingSize() {
        Component component = this.GetLastElement();
        return (short)(component.GetAbsoluteTop() + component.GetRectHeight() - this.GetFirstElement().GetAbsoluteTop());
    }

    public short GetHorizontalTotalScrollingSize() {
        Component component = this.GetLastElement();
        return (short)(component.GetAbsoluteLeft() + component.GetRectWidth() - this.GetFirstElement().GetAbsoluteLeft());
    }

    public void OnScrollEvent(int n2) {
        this.OnScrollEvent(n2, true);
    }

    public static Scroller[] InstArrayScroller(int n2) {
        Scroller[] scrollerArray = new Scroller[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            scrollerArray[i2] = new Scroller();
        }
        return scrollerArray;
    }

    public static Scroller[][] InstArrayScroller(int n2, int n3) {
        Scroller[][] scrollerArray = new Scroller[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            scrollerArray[i2] = new Scroller[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                scrollerArray[i2][i3] = new Scroller();
            }
        }
        return scrollerArray;
    }

    public static Scroller[][][] InstArrayScroller(int n2, int n3, int n4) {
        Scroller[][][] scrollerArray = new Scroller[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            scrollerArray[i2] = new Scroller[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                scrollerArray[i2][i3] = new Scroller[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    scrollerArray[i2][i3][i4] = new Scroller();
                }
            }
        }
        return scrollerArray;
    }
}

