/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Array_byte;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Stream;
import ca.jamdat.flight.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class LibraryStream
extends Stream {
    public static final byte kSizeOfReadByte = 1;
    public static final byte kSizeOfReadInt = 4;
    public static final byte kSizeOfReadChar = 2;
    public static final byte kSizeOfReadShort = 2;
    public static final byte kEofValue = -1;
    public InputStream mInputStream;
    private static Vector mLibraryCacheKeys = new Vector(3);
    private static Vector mLibraryCacheValues = new Vector(3);
    public FlString mFileName;
    public int mError;
    public int mSegmentSize;
    public int mLibrarySize;
    public int mCurrentSegment;
    public int mPositionInSegment;
    public int mSizeOfCurrentSegment;
    public int mCurrentDecompressionSegIndex;
    public byte[] mBuffer = new byte[4];

    public LibraryStream(FlString flString) {
        this.mFileName = new FlString();
        this.Create(flString);
    }

    public void destruct() {
        this.Close();
    }

    public static boolean FileExists(FlString flString) {
        boolean bl = false;
        InputStream inputStream = System.out.getClass().getResourceAsStream(StringUtils.CreateJavaString(flString));
        if (inputStream == null) {
            bl = false;
        } else {
            bl = true;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static InputStream GetResourceAsStream(String string) {
        InputStream inputStream = System.out.getClass().getResourceAsStream(string);
        return inputStream;
    }

    public static byte[] GetResourceAsByteArray(String string) {
        int n2;
        InputStream inputStream = LibraryStream.GetResourceAsStream("/" + string);
        Array_byte array_byte = new Array_byte();
        try {
            n2 = inputStream.read();
        }
        catch (IOException iOException) {
            n2 = -1;
        }
        while (n2 != -1) {
            array_byte.Insert((byte)n2);
            try {
                n2 = inputStream.read();
            }
            catch (IOException iOException) {
                n2 = -1;
            }
        }
        byte[] byArray = new byte[array_byte.End()];
        array_byte.CopyInto(byArray, array_byte.End());
        return byArray;
    }

    public void Skip(int n2) {
        this.SetPosition(this.GetPosition() + n2);
    }

    public int Read(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n3;
        int n6 = n2 + n3;
        do {
            int n7;
            if ((n7 = this.mSizeOfCurrentSegment - this.mPositionInSegment) <= 0) {
                this.CloseSegment();
                ++this.mCurrentSegment;
                this.OpenSegment(this.mCurrentSegment);
                n7 = this.mSizeOfCurrentSegment;
            }
            n4 = FlMath.Minimum(n5, n7);
            try {
                int n8 = 0;
                while ((n8 += this.mInputStream.read(byArray, n6 - n5 + n8, n4 - n8)) != n4) {
                    if (n8 >= 0) continue;
                    throw new IOException();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPositionInSegment += n4;
        } while ((n5 -= n4) > 0);
        return n3;
    }

    public int Read(byte[] byArray, int n2) {
        return this.Read(byArray, this.GetPosition(), n2);
    }

    public int Write(byte[] byArray, int n2) {
        return 0;
    }

    public int ReadLong() {
        byte[] byArray = this.mBuffer;
        this.Read(byArray, 0, 4);
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static int ReadLong(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public short ReadShort() {
        byte[] byArray = this.mBuffer;
        this.Read(byArray, 0, 2);
        return (short)(byArray[0] << 8 | byArray[1] & 0xFF);
    }

    public byte ReadChar() {
        return this.ReadByte();
    }

    public byte ReadByte() {
        if (this.mPositionInSegment >= this.mSizeOfCurrentSegment) {
            this.CloseSegment();
            ++this.mCurrentSegment;
            this.OpenSegment(this.mCurrentSegment);
        }
        byte[] byArray = this.mBuffer;
        try {
            int n2;
            while ((n2 = this.mInputStream.read(byArray, 0, 1)) < 1) {
                if (n2 >= 0) continue;
                throw new IOException();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.mPositionInSegment;
        return byArray[0];
    }

    public int GetSize() {
        return this.mLibrarySize;
    }

    public void SetPosition(int n2) {
        int n3;
        int n4 = this.GetSize();
        int n5 = 0;
        int n6 = this.mSegmentSize;
        if (n2 >= n4) {
            n5 = (n4 - 1) / n6;
            n2 = n4 - n5 * n6;
        } else {
            n5 = n2 / n6;
            n2 %= n6;
        }
        if (n5 == this.mCurrentSegment && n2 >= this.mPositionInSegment) {
            n2 -= this.mPositionInSegment;
        } else {
            this.mCurrentSegment = n5;
            this.CloseSegment();
            this.OpenSegment(this.mCurrentSegment);
        }
        int n7 = -1;
        try {
            for (n3 = 0; n3 < n2 && n7 != 0; n3 += n7) {
                n7 = (int)this.mInputStream.skip(n2 - n3);
            }
        }
        catch (Exception exception) {
            this.mError = 1;
            exception.printStackTrace();
        }
        this.mPositionInSegment += n3;
    }

    public int GetPosition() {
        return this.mPositionInSegment + this.mCurrentSegment * this.mSegmentSize;
    }

    public boolean IsEndOfFile() {
        return this.GetPosition() == this.GetSize();
    }

    public boolean IsOpen() {
        return this.mInputStream != null;
    }

    public boolean IsValid() {
        return this.mInputStream != null;
    }

    public int GetLastError() {
        return this.mError;
    }

    public void Close() {
        this.CloseSegment();
    }

    public void Create(FlString flString) {
        this.mFileName.Assign(FlString.FromChar((byte)47).Add(flString).Add(FlString.FromChar((byte)46)));
        this.mInputStream = this.GetInputStreamOnSegment(0);
        if (this.IsOpen()) {
            int n2 = 0;
            int n3 = 0;
            this.mSizeOfCurrentSegment = this.mLibrarySize = 4096;
            n2 = this.ReadLong();
            n3 = this.ReadLong();
            this.mPositionInSegment += 8;
            if (n2 == 0 || n3 < n2) {
                n2 = n3;
            }
            this.mSizeOfCurrentSegment = n2;
            if (!mLibraryCacheKeys.contains(this.mFileName)) {
                mLibraryCacheKeys.addElement(this.mFileName);
                mLibraryCacheValues.addElement(new byte[n3 / n2 + 1][]);
            }
            this.mLibrarySize = n3;
            this.mSegmentSize = n2;
            this.SetPosition(0);
        }
    }

    public void CloseSegment() {
        try {
            this.mInputStream.close();
        }
        catch (Exception exception) {
            this.mError = 1;
            exception.printStackTrace();
        }
        this.mInputStream = null;
    }

    public void OpenSegment(int n2) {
        ByteArrayInputStream byteArrayInputStream;
        InputStream inputStream;
        int n3 = this.mSegmentSize;
        if (n3 > 0) {
            int n4 = this.mLibrarySize / n3;
            this.mSizeOfCurrentSegment = n2 < n4 ? n3 : this.mLibrarySize - n4 * n3;
        }
        this.mPositionInSegment = 0;
        int n5 = mLibraryCacheKeys.indexOf(this.mFileName);
        byte[][] byArray = (byte[][])mLibraryCacheValues.elementAt(n5);
        if (byArray[n2] == null && (inputStream = this.GetInputStreamOnSegment(n2)) != null) {
            byArray[n2] = new byte[this.mSizeOfCurrentSegment];
            try {
                int n6 = 0;
                while ((n6 += inputStream.read(byArray[n2], n6, byArray[n2].length - n6)) < this.mSizeOfCurrentSegment) {
                }
                inputStream.close();
            }
            catch (Exception exception) {
                this.mError = 1;
                exception.printStackTrace();
            }
        }
        if ((byteArrayInputStream = new ByteArrayInputStream(byArray[n2])) == null) {
            this.mInputStream = null;
            this.mError = 1;
        } else {
            this.mInputStream = byteArrayInputStream;
            this.mError = 0;
        }
    }

    public InputStream GetInputStreamOnSegment(int n2) {
        String string = StringUtils.CreateJavaString(this.mFileName.Add(new FlString(n2)));
        InputStream inputStream = LibraryStream.GetResourceAsStream(string);
        return inputStream;
    }
}

