/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.F32;

public class Interpolator {
    public static final byte STEP = 0;
    public static final byte LINEAR = 1;
    public static final byte SPLINE = 2;
    public static final byte SLERP = 3;
    public static final byte SQUAD = 4;
    public static final byte EASEIN = 5;
    public static final byte EASEOUT = 6;

    public static F32 InterpolateLinear(F32 f32, F32 f322, F32 f323) {
        long l2 = (long)f32.value * (65536L - (long)f323.value);
        long l3 = (long)f322.value * (long)f323.value;
        return new F32((int)(l2 + l3 >> 16), 16);
    }

    public static F32 InterpolateEaseIn(F32 f32, F32 f322, F32 f323) {
        long l2 = (long)f323.value * (long)f323.value;
        long l3 = (long)f32.value * (65536L - l2);
        long l4 = (long)f322.value * l2;
        return new F32((int)(l3 + l4 >> 16), 16);
    }

    public static F32 InterPolateEaseOut(F32 f32, F32 f322, F32 f323) {
        long l2 = 65536L - (long)f323.value * (long)f323.value;
        long l3 = (long)f32.value * l2;
        long l4 = (long)f322.value * (65536L - l2);
        return new F32((int)(l3 + l4 >> 16), 16);
    }

    public static Interpolator[] InstArrayInterpolator(int n2) {
        Interpolator[] interpolatorArray = new Interpolator[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            interpolatorArray[i2] = new Interpolator();
        }
        return interpolatorArray;
    }

    public static Interpolator[][] InstArrayInterpolator(int n2, int n3) {
        Interpolator[][] interpolatorArray = new Interpolator[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            interpolatorArray[i2] = new Interpolator[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                interpolatorArray[i2][i3] = new Interpolator();
            }
        }
        return interpolatorArray;
    }

    public static Interpolator[][][] InstArrayInterpolator(int n2, int n3, int n4) {
        Interpolator[][][] interpolatorArray = new Interpolator[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            interpolatorArray[i2] = new Interpolator[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                interpolatorArray[i2][i3] = new Interpolator[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    interpolatorArray[i2][i3][i4] = new Interpolator();
                }
            }
        }
        return interpolatorArray;
    }
}

