/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Controller;
import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlDisplayContext;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Sprite;

public class IndexedSprite
extends Sprite {
    public static final byte typeNumber = 90;
    public static final byte typeID = 90;
    public static final boolean supportsDynamicSerialization = true;
    public FlBitmapMap mBmpMap;
    public int mCurrentFrame;
    public int[] mValue = new int[1];

    public static IndexedSprite Cast(Object object, IndexedSprite indexedSprite) {
        return (IndexedSprite)object;
    }

    public byte GetTypeID() {
        return 90;
    }

    public static Class AsClass() {
        return null;
    }

    public void destruct() {
        if (this.mBmpMap != null) {
            this.mBmpMap = null;
        }
    }

    public void OnDraw(FlDisplayContext flDisplayContext) {
        if (this.mBmpMap == null) {
            return;
        }
        this.mBmpMap.DrawElementAt(this.mCurrentFrame, flDisplayContext, this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height, this.mFlipX, this.mFlipY, this.mTileInX, this.mTileInY);
    }

    public void SetBitmapMap(FlBitmapMap flBitmapMap) {
        this.mBmpMap = flBitmapMap;
        this.SetCurrentFrame(this.mCurrentFrame);
    }

    public void SizeToBitmap() {
        int n2 = this.mCurrentFrame;
        short s2 = this.mBmpMap.GetPublicSizeXAt(n2);
        short s3 = this.mBmpMap.GetPublicSizeYAt(n2);
        this.SetSize(s2, s3);
    }

    public void SetCurrentFrame(int n2) {
        FlBitmapMap flBitmapMap = this.mBmpMap;
        if (flBitmapMap != null) {
            this.mCurrentFrame = n2 %= flBitmapMap.GetBitmapCount();
            short s2 = flBitmapMap.GetPublicSizeXAt(n2);
            short s3 = flBitmapMap.GetPublicSizeYAt(n2);
            if (this.mTileInX) {
                s2 = this.GetRectWidth();
            }
            if (this.mTileInY) {
                s3 = this.GetRectHeight();
            }
            this.SetSize(s2, s3);
        }
    }

    public int GetCurrentFrame() {
        return this.mCurrentFrame;
    }

    public FlBitmapMap GetBitmapMap() {
        return this.mBmpMap;
    }

    public void ControlValue(int n2, boolean bl, Controller controller) {
        if (n2 == 7) {
            if (bl) {
                int[] nArray = this.mValue;
                controller.GetControlledValue(nArray, 1);
                this.SetCurrentFrame(nArray[0]);
            } else {
                int[] nArray = new int[]{this.GetCurrentFrame()};
                controller.SetRequestedValue(nArray, 1);
            }
        } else {
            super.ControlValue(n2, bl, controller);
        }
    }

    public void OnSerialize(Package package_) {
        this.mBitmap = null;
        super.OnSerialize(package_);
        this.mBmpMap = FlBitmapMap.Cast(package_.SerializePointer((byte)37, true, false), null);
        this.mCurrentFrame = package_.SerializeIntrinsic(this.mCurrentFrame);
        this.SetCurrentFrame(this.mCurrentFrame);
    }

    public static IndexedSprite[] InstArrayIndexedSprite(int n2) {
        IndexedSprite[] indexedSpriteArray = new IndexedSprite[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            indexedSpriteArray[i2] = new IndexedSprite();
        }
        return indexedSpriteArray;
    }

    public static IndexedSprite[][] InstArrayIndexedSprite(int n2, int n3) {
        IndexedSprite[][] indexedSpriteArray = new IndexedSprite[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            indexedSpriteArray[i2] = new IndexedSprite[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                indexedSpriteArray[i2][i3] = new IndexedSprite();
            }
        }
        return indexedSpriteArray;
    }

    public static IndexedSprite[][][] InstArrayIndexedSprite(int n2, int n3, int n4) {
        IndexedSprite[][][] indexedSpriteArray = new IndexedSprite[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            indexedSpriteArray[i2] = new IndexedSprite[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                indexedSpriteArray[i2][i3] = new IndexedSprite[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    indexedSpriteArray[i2][i3][i4] = new IndexedSprite();
                }
            }
        }
        return indexedSpriteArray;
    }
}

