/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FlDisplayManager;
import ca.jamdat.flight.ForceInline;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Vector2_short;

public class FlRect {
    public static final byte typeNumber = 40;
    public static final byte typeID = 40;
    public static final boolean supportsDynamicSerialization = false;
    public short[] mData = new short[4];

    public static FlRect Cast(Object object, FlRect flRect) {
        return (FlRect)object;
    }

    public FlRect() {
    }

    public FlRect(FlRect flRect) {
        this.mData[0] = flRect.GetLeft();
        this.mData[1] = flRect.GetTop();
        this.mData[2] = flRect.GetWidth();
        this.mData[3] = flRect.GetHeight();
    }

    public FlRect(short s2, short s3, short s4, short s5) {
        this.mData[0] = s2;
        this.mData[1] = s3;
        this.mData[2] = s4;
        this.mData[3] = s5;
    }

    public FlRect(Vector2_short vector2_short, Vector2_short vector2_short2) {
        this.mData[0] = vector2_short.GetX();
        this.mData[1] = vector2_short.GetY();
        this.mData[2] = vector2_short2.GetX();
        this.mData[3] = vector2_short2.GetY();
    }

    public Vector2_short GetCenter() {
        return new Vector2_short((short)(this.GetLeft() + this.GetWidth() / 2), (short)(this.GetTop() + this.GetHeight() / 2));
    }

    public short GetWidth() {
        return this.mData[2];
    }

    public short GetHeight() {
        return this.mData[3];
    }

    public short GetTop() {
        return this.mData[1];
    }

    public short GetLeft() {
        return this.mData[0];
    }

    public short GetRight() {
        return (short)(this.GetLeft() + this.GetWidth() - 1);
    }

    public void SetCenter(Vector2_short vector2_short) {
        this.SetLeft((short)(vector2_short.GetX() - this.GetWidth() / 2));
        this.SetTop((short)(vector2_short.GetY() - this.GetHeight() / 2));
    }

    public void SetWidth(int n2) {
        this.mData[2] = (short)n2;
    }

    public void SetHeight(int n2) {
        this.mData[3] = (short)n2;
    }

    public void SetTop(int n2) {
        this.mData[1] = (short)n2;
    }

    public void SetLeft(int n2) {
        this.mData[0] = (short)n2;
    }

    public void SetRight(int n2) {
        this.SetWidth((short)(n2 - this.GetLeft() + 1));
    }

    public short GetBottom() {
        return (short)(this.GetTop() + this.GetHeight() - 1);
    }

    public void SetBottom(int n2) {
        this.SetHeight((short)(n2 + 1 - this.GetTop()));
    }

    public Vector2_short GetTopLeft() {
        return new Vector2_short(this.GetLeft(), this.GetTop());
    }

    public void SetTopLeft(Vector2_short vector2_short) {
        this.SetLeft(vector2_short.GetX());
        this.SetTop(vector2_short.GetY());
    }

    public Vector2_short GetTopRight() {
        return new Vector2_short(this.GetRight(), this.GetTop());
    }

    public Vector2_short GetBottomRight() {
        return new Vector2_short(this.GetRight(), this.GetBottom());
    }

    public void SetBottomRight(Vector2_short vector2_short) {
        this.SetWidth((short)(vector2_short.GetX() + 1 - this.GetLeft()));
        this.SetHeight((short)(vector2_short.GetY() + 1 - this.GetTop()));
    }

    public Vector2_short GetBottomLeft() {
        return new Vector2_short(this.GetLeft(), this.GetBottom());
    }

    public Vector2_short GetSize() {
        return new Vector2_short(this.mData[2], this.mData[3]);
    }

    public void MoveBy(Vector2_short vector2_short) {
        this.SetLeft((short)(this.GetLeft() + vector2_short.GetX()));
        this.SetTop((short)(this.GetTop() + vector2_short.GetY()));
    }

    public void MoveBy(int n2, int n3) {
        this.SetLeft((short)(this.GetLeft() + n2));
        this.SetTop((short)(this.GetTop() + n3));
    }

    public static boolean Contains(short s2, short s3, short s4, short s5, short s6, short s7) {
        return s2 <= s6 && s6 <= s2 + s4 - 1 && s3 <= s7 && s7 <= s3 + s5 - 1;
    }

    public boolean ClipLine(Vector2_short vector2_short, Vector2_short vector2_short2) {
        if (this.IsEmpty()) {
            return false;
        }
        F32 f32 = new F32(vector2_short.GetX() << 16, 16);
        F32 f322 = new F32(vector2_short.GetY() << 16, 16);
        F32 f323 = new F32(vector2_short2.GetX() << 16, 16);
        F32 f324 = new F32(vector2_short2.GetY() << 16, 16);
        F32 f325 = new F32(this.GetLeft() << 16, 16);
        F32 f326 = new F32(this.GetTop() << 16, 16);
        F32 f327 = new F32(this.GetLeft() + this.GetWidth() - 1 << 16, 16);
        F32 f328 = new F32(this.GetTop() + this.GetHeight() - 1 << 16, 16);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = FlRect.calcode(f32, f322, f325, f326, f327, f328);
        int n3 = FlRect.calcode(f323, f324, f325, f326, f327, f328);
        do {
            F32 f329;
            F32 f3210;
            int n4;
            if ((n2 | n3) == 0) {
                bl = true;
                bl2 = true;
                continue;
            }
            if ((n2 & n3) != 0) {
                bl2 = true;
                continue;
            }
            int n5 = n4 = n2 != 0 ? n2 : n3;
            if ((n4 & 1) != 0) {
                f3210 = f32.Add(f323.Sub(f32).Mul(f328.Sub(f322).Div(f324.Sub(f322), 16), 16));
                f329 = f328;
            } else if ((n4 & 2) != 0) {
                f3210 = f32.Add(f323.Sub(f32).Mul(f326.Sub(f322).Div(f324.Sub(f322), 16), 16));
                f329 = f326;
            } else if ((n4 & 4) != 0) {
                f329 = f322.Add(f324.Sub(f322).Mul(f327.Sub(f32).Div(f323.Sub(f32), 16), 16));
                f3210 = f327;
            } else {
                f329 = f322.Add(f324.Sub(f322).Mul(f325.Sub(f32).Div(f323.Sub(f32), 16), 16));
                f3210 = f325;
            }
            if (n4 == n2) {
                f32 = f3210;
                f322 = f329;
                n2 = FlRect.calcode(f32, f322, f325, f326, f327, f328);
                continue;
            }
            f323 = f3210;
            f324 = f329;
            n3 = FlRect.calcode(f323, f324, f325, f326, f327, f328);
        } while (!bl2);
        boolean bl3 = bl;
        vector2_short.SetX((short)f32.ToInt(16));
        vector2_short.SetY((short)f322.ToInt(16));
        vector2_short2.SetX((short)f323.ToInt(16));
        vector2_short2.SetY((short)f324.ToInt(16));
        return bl3;
    }

    public static boolean Intersects(short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9) {
        return s6 + s8 > s2 && s7 + s9 > s3 && s2 + s4 > s6 && s3 + s5 > s7;
    }

    public static boolean Contains(short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9) {
        return s6 >= s2 && s7 >= s3 && (short)(s6 + s8 - 1) <= (short)(s2 + s4 - 1) && (short)(s7 + s9 - 1) <= (short)(s3 + s5 - 1);
    }

    public void OffsetTop(short s2) {
        ForceInline.v();
        this.SetTop((short)(this.GetTop() + s2));
    }

    public void OffsetLeft(short s2) {
        ForceInline.v();
        this.SetLeft((short)(this.GetLeft() + s2));
    }

    public boolean Equals(FlRect flRect) {
        return this.mData[0] == flRect.mData[0] && this.mData[1] == flRect.mData[1] && this.mData[2] == flRect.mData[2] && this.mData[3] == flRect.mData[3];
    }

    public FlRect Add(Vector2_short vector2_short) {
        return new FlRect((short)(this.GetLeft() + vector2_short.GetX()), (short)(this.GetTop() + vector2_short.GetY()), this.GetWidth(), this.GetHeight());
    }

    public boolean IsEmpty() {
        return this.GetWidth() <= 0 || this.GetHeight() <= 0;
    }

    public FlRect GetVideoModeRect() {
        return FlDisplayManager.GetVideoModeRect();
    }

    public void OnSerialize(Package package_) {
        short s2 = this.GetLeft();
        s2 = package_.SerializeIntrinsic(s2);
        this.SetLeft(s2);
        s2 = this.GetTop();
        s2 = package_.SerializeIntrinsic(s2);
        this.SetTop(s2);
        s2 = this.GetWidth();
        s2 = package_.SerializeIntrinsic(s2);
        this.SetWidth(s2);
        s2 = this.GetHeight();
        s2 = package_.SerializeIntrinsic(s2);
        this.SetHeight(s2);
    }

    public FlRect Assign(FlRect flRect) {
        this.mData[0] = flRect.GetLeft();
        this.mData[1] = flRect.GetTop();
        this.mData[2] = flRect.GetWidth();
        this.mData[3] = flRect.GetHeight();
        return this;
    }

    public static int calcode(F32 f32, F32 f322, F32 f323, F32 f324, F32 f325, F32 f326) {
        int n2 = 0;
        if (f322.GreaterThan(f326)) {
            n2 |= 1;
        }
        if (f322.LessThan(f324)) {
            n2 |= 2;
        }
        if (f32.GreaterThan(f325)) {
            n2 |= 4;
        }
        if (f32.LessThan(f323)) {
            n2 |= 8;
        }
        return n2;
    }

    public static FlRect[] InstArrayFlRect(int n2) {
        FlRect[] flRectArray = new FlRect[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            flRectArray[i2] = new FlRect();
        }
        return flRectArray;
    }

    public static FlRect[][] InstArrayFlRect(int n2, int n3) {
        FlRect[][] flRectArray = new FlRect[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flRectArray[i2] = new FlRect[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                flRectArray[i2][i3] = new FlRect();
            }
        }
        return flRectArray;
    }

    public static FlRect[][][] InstArrayFlRect(int n2, int n3, int n4) {
        FlRect[][][] flRectArray = new FlRect[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flRectArray[i2] = new FlRect[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                flRectArray[i2][i3] = new FlRect[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    flRectArray[i2][i3][i4] = new FlRect();
                }
            }
        }
        return flRectArray;
    }
}

