/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlColor;
import ca.jamdat.flight.FlDrawPropertyUtil;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.FlVideoMode;
import ca.jamdat.flight.ForceInline;
import ca.jamdat.flight.MIDPDisplayContextImp;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Vector2_short;
import javax.microedition.lcdui.Image;

public abstract class FlDisplayContext {
    public static final byte resolutionPortrait = 0;
    public static final byte resolutionLandscape = 1;
    public static final byte resolutionCount = 2;
    public static final byte resolutionInvalid = 3;
    public static final byte bmpTransformIdentity = 0;
    public static final byte bmpTransformFlipY = 1;
    public static final byte bmpTransformFlipX = 2;
    public static final byte bmpTransformFlipDiag = 3;
    public static final byte alignmentLeft = 0;
    public static final byte alignmentCenter = 1;
    public static final byte alignmentRight = 2;
    public static final byte alignmentVTop = 0;
    public static final byte alignmentVBottom = 1;
    public static final byte alignmentVBaseline = 2;
    public static final byte alignmentVCenter = 3;
    public boolean mMSAAActive;
    public FlVideoMode mVideoMode;
    public boolean mInvertedLandscape;
    public short mClipRect_left;
    public short mClipRect_top;
    public short mClipRect_width;
    public short mClipRect_height;
    public boolean mBypassClipping;
    public short mCumulativeOffsetX;
    public short mCumulativeOffsetY;
    public FlRect mScreenRect;
    public int mClearNextFramesCount;

    public FlDisplayContext(FlVideoMode flVideoMode) {
        this.mVideoMode = new FlVideoMode(flVideoMode);
        this.mScreenRect = new FlRect(0, 0, (short)flVideoMode.GetWidth(), (short)flVideoMode.GetHeight());
    }

    public void destruct() {
    }

    public static short GetAlignmentOffsetX(byte by, short s2, short s3) {
        short s4 = 0;
        if (by != 0) {
            s4 = (short)(s2 - s3);
            if (by == 1) {
                s4 = (short)(s4 >> 1);
            }
        }
        return s4;
    }

    public abstract void NativeDrawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeDrawLine(int var1, int var2, int var3, int var4);

    public abstract void NativeDrawPixel(int var1, int var2);

    public abstract void NativeDrawRect(int var1, int var2, int var3, int var4);

    public abstract void NativeDrawRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public abstract void NativeDrawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeFillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeFillRect(int var1, int var2, int var3, int var4);

    public abstract void NativeFillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeFillTriangle(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeDrawRegion(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract int NativeGetClipHeight();

    public abstract int NativeGetClipWidth();

    public abstract int NativeGetClipX();

    public abstract int NativeGetClipY();

    public abstract void NativeSetClip(int var1, int var2, int var3, int var4);

    public abstract int NativeGetAlpha();

    public abstract int NativeGetARGB();

    public abstract int NativeGetRGB();

    public abstract void NativeSetAlpha(int var1);

    public abstract void NativeSetARGB(int var1);

    public abstract void NativeSetRGB(int var1);

    public abstract void NativeSetARGB(int var1, int var2, int var3, int var4);

    public abstract void NativeSetRGB(int var1, int var2, int var3);

    public abstract void NativeSetFont(Object var1);

    public void NativeDrawString(String string, int n2, int n3, byte by, byte by2) {
    }

    public abstract void NativeDrawString(String var1, int var2, int var3, int var4);

    public abstract int NativeGetTranslatedX();

    public abstract int NativeGetTranslatedY();

    public abstract void NativeTranslate(int var1, int var2);

    public abstract void Bind3D();

    public abstract void Bind3D(Object var1);

    public abstract void Release3D();

    public void DrawString(FlString flString, short s2, short s3, short s4, short s5, FlFont flFont, byte by, int n2, int n3, short s6, int n4) {
        if (flString.GetCharAt(n2) == 0) {
            return;
        }
        short s7 = this.mClipRect_left;
        short s8 = this.mClipRect_top;
        short s9 = this.mClipRect_width;
        short s10 = this.mClipRect_height;
        short s11 = (short)(s2 + this.mCumulativeOffsetX);
        short s12 = (short)(s3 + this.mCumulativeOffsetY);
        short s13 = s4;
        short s14 = s5;
        if (FlRect.Contains(s7, s8, s9, s10, s11, s12, s13, s14)) {
            this.mBypassClipping = true;
        } else if (!FlRect.Intersects(s7, s8, s9, s10, s11, s12, s13, s14)) {
            return;
        }
        short s15 = FlDisplayContext.GetAlignmentOffsetX(by, s4, s6);
        flFont.DrawString(this, flString, (short)(s2 + s15), s3, s6, n2, n3);
        this.mBypassClipping = false;
    }

    public void DrawMultilineString(FlString flString, int[] nArray, int n2, short s2, short n3, short s3, short s4, int n4, FlFont flFont, byte by, short[] sArray, int n5) {
        if (flFont == null) {
            return;
        }
        int n6 = flFont.GetLineHeight();
        int n7 = n6 - flFont.GetLeading();
        short s5 = s2;
        int n8 = n3;
        short s6 = s3;
        short s7 = s4;
        s5 = (short)(s5 + this.mCumulativeOffsetX);
        short s8 = this.mCumulativeOffsetY;
        n8 = (short)(n8 + s8);
        boolean bl = s5 >= this.mClipRect_left && (short)(s5 + s6 - 1) <= (short)(this.mClipRect_left + this.mClipRect_width - 1);
        short s9 = this.mClipRect_top;
        int n9 = this.mClipRect_top + this.mClipRect_height - 1;
        int n10 = n8;
        int n11 = n8 + s7 - 1;
        int n12 = s9 - n10;
        int n13 = n4;
        int n14 = n10;
        if (n12 > 0) {
            n14 += n12;
            if (n12 > n7) {
                ++n13;
                n13 += (n12 -= n7) / n6;
                n7 = n6;
            }
        }
        if (n13 > n2 - 1) {
            return;
        }
        int n15 = n11;
        if (n15 > n9) {
            n15 = n9;
        }
        int n16 = (n13 - n4) * n6;
        short s10 = 0;
        short s11 = (short)(n8 - this.mCumulativeOffsetY + n16);
        n14 -= s8;
        n15 -= s8;
        int n17 = n13;
        int n18 = n3 + n16;
        int n19 = n18 + n7;
        int n20 = 0;
        int n21 = 0;
        short s12 = s2;
        n7 = n6;
        do {
            this.mBypassClipping = bl && n18 >= n14 && n19 - 1 <= n15;
            n21 = Text.GetStartOfLine(nArray, n17);
            n20 = Text.GetEndOfLine(nArray, n17) - n21 + 1;
            s10 = (short)(s12 + FlDisplayContext.GetAlignmentOffsetX(by, s3, sArray[n17]));
            flFont.DrawString(this, flString, s10, s11, sArray[n17], n21, n20);
            s11 = (short)(s11 + n7);
            n18 = n19;
            n19 = n18 + n7;
        } while (++n17 < n2 && n18 <= n15);
        this.mBypassClipping = false;
    }

    public boolean MSAAIsActive() {
        return this.mMSAAActive;
    }

    public void ActivateMSAA(boolean bl) {
    }

    public abstract void DrawRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public abstract void DrawRectangle(short var1, short var2, short var3, short var4, boolean var5, int var6, int var7, int var8, int var9);

    public abstract void DrawRoundRectangle(short var1, short var2, short var3, short var4, short var5, short var6, boolean var7, FlColor var8, int var9);

    public void DrawFrame(short s2, short s3, short s4, short s5, FlColor flColor, int n2) {
        this.DrawRectangle((short)(s2 - this.mCumulativeOffsetX), (short)(s3 - this.mCumulativeOffsetY), s4, s5, false, flColor.GetRed(), flColor.GetGreen(), flColor.GetBlue(), n2);
    }

    public void DrawAbsoluteSolidRectangle(short s2, short s3, short s4, short s5, int n2, int n3, int n4, int n5) {
        this.DrawRectangle((short)(s2 - this.mCumulativeOffsetX), (short)(s3 - this.mCumulativeOffsetY), s4, s5, true, n2, n3, n4, n5);
    }

    public abstract void DrawTriangle(short var1, short var2, short var3, short var4, short var5, short var6, boolean var7, FlColor var8, int var9);

    public void DrawAbsoluteLine(short s2, short s3, short s4, short s5, FlColor flColor, int n2) {
        this.DrawLine((short)(s2 - this.mCumulativeOffsetX), (short)(s3 - this.mCumulativeOffsetY), (short)(s4 - this.mCumulativeOffsetX), (short)(s5 - this.mCumulativeOffsetY), flColor, n2);
    }

    public abstract void DrawLine(short var1, short var2, short var3, short var4, FlColor var5, int var6);

    public abstract void DrawPixel(short var1, short var2, FlColor var3, int var4);

    public void DrawCircle(Vector2_short vector2_short, short s2, boolean bl, FlColor flColor, FlColor flColor2) {
        short s3 = (short)(vector2_short.GetX() - s2);
        short s4 = (short)(vector2_short.GetY() - s2);
        short s5 = (short)(s2 << 1);
        if (bl) {
            this.DrawArc(s3, s4, s5, s5, (short)0, (short)360, true, flColor, 255);
        }
        this.DrawArc(s3, s4, s5, s5, (short)0, (short)360, false, flColor2, 255);
    }

    public abstract void DrawArc(short var1, short var2, short var3, short var4, short var5, short var6, boolean var7, FlColor var8, int var9);

    public abstract void Clear(FlColor var1);

    public abstract void ClearFullscreen(FlColor var1);

    public void ClearNextFrames(int n2) {
        this.mClearNextFramesCount = n2;
    }

    public void DrawBitmapSection(FlBitmap flBitmap, short s2, short s3, short n2, short n3, short s4, short s5, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        short s6;
        short s7;
        short s8;
        short s9;
        short s10;
        short s11;
        short s12;
        short s13;
        boolean bl;
        short s14 = (short)(s2 + this.mCumulativeOffsetX);
        short s15 = (short)(s3 + this.mCumulativeOffsetY);
        int n9 = FlDrawPropertyUtil.GetTransform(n4);
        boolean bl2 = bl = n9 == 327680 || n9 == 393216 || n9 == 458752 || n9 == 262144;
        if (bl) {
            s13 = s14;
            s12 = s15;
            s11 = s5;
            s10 = s4;
        } else {
            s13 = s14;
            s12 = s15;
            s11 = s4;
            s10 = s5;
        }
        if (!this.mBypassClipping) {
            s9 = this.mClipRect_left;
            s8 = this.mClipRect_top;
            s7 = this.mClipRect_width;
            s6 = this.mClipRect_height;
            n8 = s9 + s7;
            n7 = s13 + s11;
            n6 = s8 + s6;
            n5 = s12 + s10;
            if (s9 > s13) {
                s13 = s9;
            }
            if (s8 > s12) {
                s12 = s8;
            }
            if (n8 < n7) {
                n7 = n8;
            }
            if (n6 < n5) {
                n5 = n6;
            }
            s11 = (short)(n7 - s13);
            s10 = (short)(n5 - s12);
        }
        if (s11 <= 0 || s10 <= 0) {
            return;
        }
        s9 = s13;
        s8 = s12;
        s7 = s11;
        s6 = s10;
        n8 = n2;
        n7 = n3;
        n6 = FlDrawPropertyUtil.IsFlippedX(n4);
        n5 = FlDrawPropertyUtil.IsFlippedY(n4);
        if (bl) {
            n8 = n6 != 0 ? (n8 += s15 + s4 - (s8 + s6)) : (n8 += s8 - s15);
            n7 = n5 != 0 ? (n7 += s14 + s5 - (s9 + s7)) : (n7 += s9 - s14);
        } else {
            n8 = n6 != 0 ? (n8 += s14 + s4 - (s9 + s7)) : (n8 += s9 - s14);
            n7 = n5 != 0 ? (n7 += s15 + s5 - (s8 + s6)) : (n7 += s8 - s15);
        }
        FlBitmap flBitmap2 = flBitmap;
        this.DrawAbsoluteBitmapSection(flBitmap2, (int)s9, (int)s8, n8, n7, (int)s7, (int)s6, n4);
    }

    public void DrawBitmapSection(FlBitmap flBitmap, short s2, short s3, short s4, short s5, short s6, short s7, boolean bl, boolean bl2) {
        int n2 = 255;
        n2 = FlDrawPropertyUtil.ApplyTransform(n2, FlDrawPropertyUtil.FlipXYToTransform(bl, bl2));
        this.DrawBitmapSection(flBitmap, s2, s3, s4, s5, s6, s7, n2);
    }

    public void DrawTiledBitmapSection(FlBitmap flBitmap, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, short s10, short s11, short s12, short s13, int n2) {
        int n3;
        boolean bl = FlDrawPropertyUtil.IsFlippedX(n2);
        boolean bl2 = FlDrawPropertyUtil.IsFlippedY(n2);
        short s14 = this.mCumulativeOffsetX;
        short s15 = this.mCumulativeOffsetY;
        short s16 = (short)(s10 + s14);
        short s17 = (short)(s11 + s15);
        short s18 = s12;
        short s19 = s13;
        int n4 = this.mClipRect_left + this.mClipRect_width;
        int n5 = s16 + s18;
        int n6 = this.mClipRect_top + this.mClipRect_height;
        int n7 = s17 + s19;
        if (this.mClipRect_left > s16) {
            s16 = this.mClipRect_left;
        }
        if (this.mClipRect_top > s17) {
            s17 = this.mClipRect_top;
        }
        if (n4 < n5) {
            n5 = n4;
        }
        if (n6 < n7) {
            n7 = n6;
        }
        s18 = (short)(n5 - s16);
        s19 = (short)(n7 - s17);
        if (s18 <= 0 || s19 <= 0) {
            return;
        }
        n4 = s16 - s14;
        n5 = n4 + s18;
        n7 = n6 + s19;
        for (n6 = s17 - s15; n6 < n7; n6 += n3) {
            int n8;
            int n9 = (n6 - s11) % s3;
            int n10 = FlMath.Minimum((int)s3, n7 - n6 + n9);
            n3 = n10 - n9;
            int n11 = FlMath.Maximum(0, s5 - n9);
            int n12 = FlMath.Maximum(0, n9 - s5);
            int n13 = FlMath.Minimum((int)s9, n10 - s5);
            int n14 = FlMath.Maximum(0, n13 - n12);
            if (bl2) {
                n12 = s9 - n13;
                n13 = n12 + n14;
            }
            for (int i2 = n4; i2 < n5; i2 += n8) {
                int n15 = (i2 - s10) % s2;
                int n16 = FlMath.Minimum((int)s2, n5 - i2 + n15);
                n8 = n16 - n15;
                int n17 = FlMath.Maximum(0, s4 - n15);
                int n18 = FlMath.Maximum(0, n15 - s4);
                int n19 = FlMath.Minimum((int)s8, n16 - s4);
                int n20 = FlMath.Maximum(0, n19 - n18);
                if (bl) {
                    n18 = s8 - n19;
                    n19 = n18 + n20;
                }
                this.mBypassClipping = true;
                this.DrawBitmapSection(flBitmap, (short)(i2 + n17), (short)(n6 + n11), (short)(s6 + n18), (short)(s7 + n12), (short)n20, (short)n14, n2);
            }
        }
        this.mBypassClipping = false;
    }

    public void DrawTiledBitmapSection(FlBitmap flBitmap, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, int n2) {
        this.DrawTiledBitmapSection(flBitmap, s4, s5, (short)0, (short)0, s2, s3, s4, s5, s6, s7, s8, s9, n2);
    }

    public abstract void DrawAbsoluteBitmapSection(FlBitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void DrawAbsoluteBitmapSection(FlBitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, byte var8);

    public void DrawAbsoluteBitmapBypassClipping(FlBitmap flBitmap, int n2, int n3) {
        this.DrawBitmapSection(flBitmap, (short)(n2 - this.mCumulativeOffsetX), (short)(n3 - this.mCumulativeOffsetY), (short)0, (short)0, flBitmap.GetWidth(), flBitmap.GetHeight(), false, false);
    }

    public void DrawAbsoluteBitmap(FlBitmap flBitmap, int n2, int n3) {
        this.ResetClip();
        this.DrawAbsoluteBitmapBypassClipping(flBitmap, n2, n3);
    }

    public void ResetClip() {
    }

    public void Set2DMode() {
    }

    public void OffsetBy(short s2, short s3) {
        ForceInline.v();
        this.mCumulativeOffsetX = (short)(this.mCumulativeOffsetX + s2);
        this.mCumulativeOffsetY = (short)(this.mCumulativeOffsetY + s3);
    }

    public boolean ApplicationIsPortrait() {
        return this.IsResolution(false, (byte)0);
    }

    public boolean ApplicationIsLandscape() {
        return this.IsResolution(false, (byte)1);
    }

    public boolean DeviceIsPortrait() {
        return this.IsResolution(true, (byte)0);
    }

    public boolean DeviceIsLandscape() {
        return this.IsResolution(true, (byte)1);
    }

    public boolean IsResolution(boolean bl, byte by) {
        return this.GetResolution(bl) == by;
    }

    public byte GetResolution(boolean bl) {
        FlVideoMode flVideoMode = null;
        flVideoMode = this.GetVideoMode();
        if (flVideoMode.GetWidth() <= flVideoMode.GetHeight()) {
            return 0;
        }
        return 1;
    }

    public short GetClippingRectLeft() {
        return (short)(this.GetAbsoluteClippingRectLeft() - this.GetCumulativeOffsetX());
    }

    public short GetClippingRectTop() {
        return (short)(this.GetAbsoluteClippingRectTop() - this.GetCumulativeOffsetY());
    }

    public short GetClippingRectWidth() {
        return this.GetAbsoluteClippingRectWidth();
    }

    public short GetClippingRectHeight() {
        return this.GetAbsoluteClippingRectHeight();
    }

    public void SetClippingRect(short s2, short s3, short s4, short s5) {
        s2 = (short)(s2 + this.GetCumulativeOffsetX());
        s3 = (short)(s3 + this.GetCumulativeOffsetY());
        this.SetAbsoluteClippingRect(s2, s3, s4, s5);
    }

    public short GetAbsoluteClippingRectTop() {
        return this.mClipRect_top;
    }

    public short GetAbsoluteClippingRectLeft() {
        return this.mClipRect_left;
    }

    public short GetAbsoluteClippingRectWidth() {
        return this.mClipRect_width;
    }

    public short GetAbsoluteClippingRectHeight() {
        return this.mClipRect_height;
    }

    public void SetAbsoluteClippingRect(short s2, short s3, short s4, short s5) {
        this.mClipRect_left = s2;
        this.mClipRect_top = s3;
        this.mClipRect_width = s4;
        this.mClipRect_height = s5;
    }

    public void DrawClipRectInZBuffer() {
    }

    public void ClearClipRectInZBuffer() {
    }

    public void BeginScene() {
        if (this.mClearNextFramesCount > 0) {
            --this.mClearNextFramesCount;
            this.ClearFullscreen(FlColor.Black());
        }
    }

    public void EndScene() {
    }

    public void Reload() {
    }

    public void RenderApplication() {
        this.BeginScene();
        FlApplication.GetInstance().OnDraw(this);
        this.EndScene();
        FlApplication.GetInstance().SetDirty(false);
    }

    public short GetCumulativeOffsetX() {
        return this.mCumulativeOffsetX;
    }

    public short GetCumulativeOffsetY() {
        return this.mCumulativeOffsetY;
    }

    public FlVideoMode GetVideoMode() {
        return this.mVideoMode;
    }

    public void SetVideoMode(FlVideoMode flVideoMode) {
        this.mVideoMode = flVideoMode;
    }

    public FlRect GetScreenRect() {
        return this.mScreenRect;
    }

    public void UpdateOrientation(FlVideoMode flVideoMode) {
        this.mScreenRect.Assign(new FlRect(0, 0, (short)flVideoMode.GetWidth(), (short)flVideoMode.GetHeight()));
        this.mVideoMode = flVideoMode;
    }

    public abstract byte GetDisplayAPI();

    public boolean InvertedLandscape() {
        return this.mInvertedLandscape;
    }

    public void SetInvertedLandscape(boolean bl) {
        this.mInvertedLandscape = bl;
    }

    public void EnableCoverageCheck(boolean bl) {
    }

    public void EnableVSync(boolean bl) {
    }

    public static FlDisplayContext CreateContext(FlVideoMode flVideoMode) {
        return new MIDPDisplayContextImp(flVideoMode);
    }

    public static FlDisplayContext CreateContext(FlBitmap flBitmap) {
        MIDPDisplayContextImp mIDPDisplayContextImp = new MIDPDisplayContextImp(flBitmap);
        return mIDPDisplayContextImp;
    }

    public void GenericDrawArc(short s2, short s3, short s4, short s5, short n2, short s6, boolean bl, FlColor flColor, int n3) {
        if (s4 == s5 && s6 >= 360) {
            short s7 = (short)(s4 >> 1);
            this.GenericDrawCircle((short)(s2 + s7), (short)(s3 + s7), s7, bl, flColor, n3);
            return;
        }
        if (s4 <= 0 || s5 <= 0) {
            return;
        }
        while (n2 < 0) {
            n2 = (short)(n2 + 360);
        }
        n2 = (short)(n2 % 360);
        if (s6 > 360 || s6 < -360) {
            s6 = (short)360;
        }
        if (s6 < 0) {
            n2 = (short)(n2 + s6);
            s6 = -s6;
        }
        int n4 = n2 + s6;
        if (bl) {
            short s8 = (short)(s4 >> 1);
            short s9 = (short)(s5 >> 1);
            short s10 = (short)(s2 + s8);
            short s11 = (short)(s3 + s9);
            int n5 = n2;
            short s12 = s6;
            while (s12 > 0) {
                int n6;
                if (n5 >= 270) {
                    n6 = s12 > 360 - n5 ? 360 : n5 + s12;
                    this.FillArcImpl(s10, s11, s8, s9, (short)n5, (short)n6, flColor, n3);
                    s12 = (short)(s12 - (360 - n5));
                    n5 = 0;
                    continue;
                }
                if (n5 >= 180) {
                    n6 = s12 > 270 - n5 ? 270 : n5 + s12;
                    this.FillArcImpl(s10, s11, s8, s9, (short)n5, (short)n6, flColor, n3);
                    s12 = (short)(s12 - (270 - n5));
                    n5 = 270;
                    continue;
                }
                if (n5 >= 90) {
                    n6 = s12 > 180 - n5 ? 180 : n5 + s12;
                    this.FillArcImpl(s10, s11, s8, s9, (short)n5, (short)n6, flColor, n3);
                    s12 = (short)(s12 - (180 - n5));
                    n5 = 180;
                    continue;
                }
                n6 = s12 > 90 - n5 ? 90 : n5 + s12;
                this.FillArcImpl(s10, s11, s8, s9, (short)n5, (short)n6, flColor, n3);
                s12 = (short)(s12 - (90 - n5));
                n5 = 90;
            }
        } else {
            for (int n7 = n2; n7 != n4; n7 = (short)(n7 + 1)) {
                short s13 = (short)(s2 + (s4 >> 1) + ((s4 >> 1) * FlMath.Cos1024(n7) >> 10));
                short s14 = (short)(s3 + (s5 >> 1) - ((s5 >> 1) * FlMath.Sin1024(n7) >> 10));
                this.DrawPixel(s13, s14, flColor);
            }
        }
    }

    public void GenericDrawCircle(short s2, short s3, short n2, boolean bl, FlColor flColor, int n3) {
        int n4 = 1 - n2;
        int n5 = 1;
        int n6 = -2 * n2;
        int n7 = 0;
        int n8 = n2;
        if (bl) {
            this.DrawLine((short)(s2 - n2), s3, (short)(s2 + n2), s3, flColor, n3);
        } else {
            this.DrawPixel((short)(s2 + n2), s3, flColor);
            this.DrawPixel((short)(s2 - n2), s3, flColor);
        }
        this.DrawPixel(s2, (short)(s3 + n2), flColor);
        this.DrawPixel(s2, (short)(s3 - n2), flColor);
        while (n7 < n8) {
            if (n4 >= 0) {
                --n8;
                n4 += (n6 += 2);
            }
            ++n7;
            n4 += (n5 += 2);
            if (bl) {
                this.DrawLine((short)(s2 - n7), (short)(s3 + n8), (short)(s2 + n7), (short)(s3 + n8), flColor, n3);
                this.DrawLine((short)(s2 - n7), (short)(s3 - n8), (short)(s2 + n7), (short)(s3 - n8), flColor, n3);
                this.DrawLine((short)(s2 - n8), (short)(s3 + n7), (short)(s2 + n8), (short)(s3 + n7), flColor, n3);
                this.DrawLine((short)(s2 - n8), (short)(s3 - n7), (short)(s2 + n8), (short)(s3 - n7), flColor, n3);
                continue;
            }
            this.DrawPixel((short)(s2 + n7), (short)(s3 + n8), flColor);
            this.DrawPixel((short)(s2 - n7), (short)(s3 + n8), flColor);
            this.DrawPixel((short)(s2 + n7), (short)(s3 - n8), flColor);
            this.DrawPixel((short)(s2 - n7), (short)(s3 - n8), flColor);
            this.DrawPixel((short)(s2 + n8), (short)(s3 + n7), flColor);
            this.DrawPixel((short)(s2 - n8), (short)(s3 + n7), flColor);
            this.DrawPixel((short)(s2 + n8), (short)(s3 - n7), flColor);
            this.DrawPixel((short)(s2 - n8), (short)(s3 - n7), flColor);
        }
    }

    public void GenericDrawTriangle(short s2, short s3, short s4, short s5, short s6, short s7, boolean bl, FlColor flColor, int n2) {
        this.DrawLine(s2, s3, s4, s5, flColor, n2);
        this.DrawLine(s6, s7, s4, s5, flColor, n2);
        this.DrawLine(s2, s3, s6, s7, flColor, n2);
        if (bl) {
            s2 = (short)(s2 + this.mCumulativeOffsetX);
            s3 = (short)(s3 + this.mCumulativeOffsetY);
            s4 = (short)(s4 + this.mCumulativeOffsetX);
            s5 = (short)(s5 + this.mCumulativeOffsetY);
            s6 = (short)(s6 + this.mCumulativeOffsetX);
            s7 = (short)(s7 + this.mCumulativeOffsetY);
            this.GenericFillAbsoluteTriangle(s2, s3, s4, s5, s6, s7, flColor, n2);
        }
    }

    public void GenericFillAbsoluteTriangle(short s2, short s3, short s4, short s5, short s6, short s7, FlColor flColor, int n2) {
        short s8 = 0;
        if (s5 < s3) {
            s8 = s4;
            s4 = s2;
            s2 = s8;
            s8 = s5;
            s5 = s3;
            s3 = s8;
        }
        if (s7 < s3) {
            s8 = s6;
            s6 = s2;
            s2 = s8;
            s8 = s7;
            s7 = s3;
            s3 = s8;
        }
        if (s7 < s5) {
            s8 = s6;
            s6 = s4;
            s4 = s8;
            s8 = s7;
            s7 = s5;
            s5 = s8;
        }
        int n3 = 8;
        int n4 = s2 << n3;
        int n5 = s3 << n3;
        int n6 = s4 << n3;
        int n7 = s5 << n3;
        int n8 = s6 << n3;
        int n9 = s7 << n3;
        int n10 = 0x40000000;
        int n11 = n7 > n5 ? (n6 - n4 << n3) / (n7 - n5) : n10;
        int n12 = n9 > n5 ? (n8 - n4 << n3) / (n9 - n5) : n10;
        int n13 = n9 > n7 ? (n8 - n6 << n3) / (n9 - n7) : n10;
        int n14 = n4;
        int n15 = n5;
        int n16 = n4;
        if (n11 == n10) {
            n16 = n6;
        }
        int n17 = n5;
        if (n11 > n12) {
            while (n15 < n7) {
                this.DrawAbsoluteLine((short)(n14 >> n3), (short)(n15 >> n3), (short)(n16 >> n3), (short)(n15 >> n3), flColor, n2);
                n15 += 1 << n3;
                n17 += 1 << n3;
                n14 += n12;
                n16 += n11;
            }
            n16 = n6;
            n17 = n7;
            while (n15 < n9) {
                this.DrawAbsoluteLine((short)(n14 >> n3), (short)(n15 >> n3), (short)(n16 >> n3), (short)(n15 >> n3), flColor, n2);
                n15 += 1 << n3;
                n17 += 1 << n3;
                n14 += n12;
                n16 += n13;
            }
        } else {
            while (n15 < n7) {
                this.DrawAbsoluteLine((short)(n14 >> n3), (short)(n15 >> n3), (short)(n16 >> n3), (short)(n15 >> n3), flColor, n2);
                n15 += 1 << n3;
                n17 += 1 << n3;
                n14 += n11;
                n16 += n12;
            }
            while (n15 < n9) {
                this.DrawAbsoluteLine((short)(n14 >> n3), (short)(n15 >> n3), (short)(n16 >> n3), (short)(n15 >> n3), flColor, n2);
                n15 += 1 << n3;
                n17 += 1 << n3;
                n14 += n13;
                n16 += n12;
            }
        }
    }

    public void GenericDrawRoundRectangle(short s2, short s3, short s4, short s5, short s6, short s7, boolean bl, FlColor flColor, int n2) {
        short s8 = (short)(s2 + s4 - 1);
        short s9 = (short)(s3 + s5 - 1);
        if (s6 > s4) {
            s6 = s4;
        }
        if (s7 > s5) {
            s7 = s5;
        }
        short s10 = (short)(s6 >> 1);
        short s11 = (short)(s7 >> 1);
        short s12 = (short)(s2 + s10);
        short s13 = (short)(s8 - s10);
        short s14 = (short)(s3 + s11);
        short s15 = (short)(s9 - s11);
        this.DrawArc(s2, s3, s6, s7, (short)90, (short)90, bl, flColor, n2);
        this.DrawArc((short)(s8 - s6), s3, s6, s7, (short)0, (short)90, bl, flColor, n2);
        this.DrawArc(s2, (short)(s9 - s7), s6, s7, (short)180, (short)90, bl, flColor, n2);
        this.DrawArc((short)(s8 - s6), (short)(s9 - s7), s6, s7, (short)270, (short)90, bl, flColor, n2);
        if (bl) {
            int n3 = flColor.GetRed();
            int n4 = flColor.GetGreen();
            int n5 = flColor.GetBlue();
            short s16 = (short)(s13 - s12 + 1);
            short s17 = (short)(s15 - s14 + 1);
            if (s16 > 0) {
                this.DrawRectangle(s12, s3, s16, s11, true, n3, n4, n5, n2);
                this.DrawRectangle(s12, (short)(s15 + 1), s16, s11, true, n3, n4, n5, n2);
            }
            if (s17 > 0) {
                this.DrawRectangle(s2, s14, s4, s17, true, n3, n4, n5, n2);
            }
        } else {
            if (s12 < s13) {
                this.DrawLine(s12, s3, s13, s3, flColor, n2);
                this.DrawLine(s12, s9, s13, s9, flColor, n2);
            }
            if (s14 < s15) {
                this.DrawLine(s2, s14, s2, s15, flColor, n2);
                this.DrawLine(s8, s14, s8, s15, flColor, n2);
            }
        }
    }

    public void FillArcImpl(short s2, short s3, short s4, short s5, short s6, short s7, FlColor flColor, int n2) {
        block41: {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            short s8;
            short s9;
            block43: {
                block42: {
                    int n11;
                    block40: {
                        s9 = (short)(s4 * s4);
                        s8 = (short)(s5 * s5);
                        n10 = s2 + (s4 * FlMath.Cos1024(s6) >> 10);
                        n9 = s3 - (s5 * FlMath.Sin1024(s6) >> 10);
                        n8 = s2 + (s4 * FlMath.Cos1024(s7) >> 10);
                        n7 = s3 - (s5 * FlMath.Sin1024(s7) >> 10);
                        this.GenericDrawTriangle(s2, s3, (short)n10, (short)n9, (short)n8, (short)n7, true, flColor, n2);
                        n6 = 0;
                        if (s6 >= 270) {
                            n6 = 3;
                        } else if (s6 >= 180) {
                            n6 = 2;
                        } else if (s6 >= 90) {
                            n6 = 1;
                        }
                        switch (n6) {
                            case 0: {
                                n5 = n8;
                                n11 = n7;
                                n4 = n10;
                                n3 = n9;
                                break;
                            }
                            case 1: {
                                n5 = n8;
                                n3 = n7;
                                n4 = n10;
                                n11 = n9;
                                break;
                            }
                            case 2: {
                                n5 = n10;
                                n3 = n7;
                                n4 = n8;
                                n11 = n9;
                                break;
                            }
                            default: {
                                n5 = n10;
                                n3 = n9;
                                n4 = n8;
                                n11 = n7;
                            }
                        }
                        if (n5 < 0) {
                            n5 = 0;
                        }
                        if (n5 < this.mClipRect_left) {
                            n5 = this.mClipRect_left;
                        }
                        if (n3 > this.mClipRect_top + this.mClipRect_height - 1) {
                            n3 = this.mClipRect_top + this.mClipRect_height - 1;
                        }
                        if (n4 > this.mClipRect_left + this.mClipRect_width - 1) {
                            n4 = this.mClipRect_left + this.mClipRect_width - 1;
                        }
                        if (n11 < 0) {
                            n11 = 0;
                        }
                        if (n11 < this.mClipRect_top) {
                            n11 = this.mClipRect_top;
                        }
                        if (n6 != 1) break block40;
                        block5: for (int i2 = n3; i2 >= n11; --i2) {
                            int n12 = n5;
                            boolean bl = false;
                            while (true) {
                                if (!bl) {
                                    if ((n12 - s2) * (n12 - s2) * s8 + (i2 - s3) * (i2 - s3) * s9 <= s8 * s9) {
                                        bl = true;
                                    } else {
                                        ++n5;
                                    }
                                }
                                if (bl) {
                                    this.DrawPixel((short)n12, (short)i2, flColor);
                                }
                                if (n12 == n4 || (n10 - n8) * (i2 - n7) > (n12 - n8) * (n9 - n7)) continue block5;
                                ++n12;
                            }
                        }
                        break block41;
                    }
                    if (n6 != 0) break block42;
                    block7: for (int i3 = n3; i3 >= n11; --i3) {
                        int n13 = n4;
                        boolean bl = false;
                        while (true) {
                            if (!bl) {
                                if ((n13 - s2) * (n13 - s2) * s8 + (i3 - s3) * (i3 - s3) * s9 <= s8 * s9) {
                                    bl = true;
                                } else {
                                    --n4;
                                }
                            }
                            if (bl) {
                                this.DrawPixel((short)n13, (short)i3, flColor);
                            }
                            if (n13 == n5 || (n10 - n8) * (i3 - n7) > (n13 - n8) * (n9 - n7)) continue block7;
                            --n13;
                        }
                    }
                    break block41;
                }
                if (n6 != 2) break block43;
                block9: for (int i4 = n11; i4 <= n3; ++i4) {
                    int n14 = n5;
                    boolean bl = false;
                    while (true) {
                        if (!bl) {
                            if ((n14 - s2) * (n14 - s2) * s8 + (i4 - s3) * (i4 - s3) * s9 <= s8 * s9) {
                                bl = true;
                            } else {
                                ++n5;
                            }
                        }
                        if (bl) {
                            this.DrawPixel((short)n14, (short)i4, flColor);
                        }
                        if (n14 == n4 || (n10 - n8) * (i4 - n7) > (n14 - n8) * (n9 - n7)) continue block9;
                        ++n14;
                    }
                }
                break block41;
            }
            if (n6 != 3) break block41;
            block11: for (int i5 = n11; i5 <= n3; ++i5) {
                int n15 = n4;
                boolean bl = false;
                while (true) {
                    if (!bl) {
                        if ((n15 - s2) * (n15 - s2) * s8 + (i5 - s3) * (i5 - s3) * s9 <= s8 * s9) {
                            bl = true;
                        } else {
                            --n4;
                        }
                    }
                    if (bl) {
                        this.DrawPixel((short)n15, (short)i5, flColor);
                    }
                    if (n15 == n5 || (n10 - n8) * (i5 - n7) > (n15 - n8) * (n9 - n7)) continue block11;
                    --n15;
                }
            }
        }
    }

    public void DrawString(FlString flString, short s2, short s3, short s4, short s5, FlFont flFont, byte by, int n2, int n3, short s6) {
        this.DrawString(flString, s2, s3, s4, s5, flFont, by, n2, n3, s6, 255);
    }

    public void DrawMultilineString(FlString flString, int[] nArray, int n2, short s2, short s3, short s4, short s5, int n3, FlFont flFont, byte by, short[] sArray) {
        this.DrawMultilineString(flString, nArray, n2, s2, s3, s4, s5, n3, flFont, by, sArray, 255);
    }

    public void DrawRectangle(short s2, short s3, short s4, short s5, boolean bl, int n2, int n3, int n4) {
        this.DrawRectangle(s2, s3, s4, s5, bl, n2, n3, n4, 255);
    }

    public void DrawRoundRectangle(short s2, short s3, short s4, short s5, short s6, short s7, boolean bl, FlColor flColor) {
        this.DrawRoundRectangle(s2, s3, s4, s5, s6, s7, bl, flColor, 255);
    }

    public void DrawFrame(short s2, short s3, short s4, short s5, FlColor flColor) {
        this.DrawFrame(s2, s3, s4, s5, flColor, 255);
    }

    public void DrawAbsoluteSolidRectangle(short s2, short s3, short s4, short s5, int n2, int n3, int n4) {
        this.DrawAbsoluteSolidRectangle(s2, s3, s4, s5, n2, n3, n4, 255);
    }

    public void DrawAbsoluteLine(short s2, short s3, short s4, short s5, FlColor flColor) {
        this.DrawAbsoluteLine(s2, s3, s4, s5, flColor, 255);
    }

    public void DrawLine(short s2, short s3, short s4, short s5, FlColor flColor) {
        this.DrawLine(s2, s3, s4, s5, flColor, 255);
    }

    public void DrawPixel(short s2, short s3, FlColor flColor) {
        this.DrawPixel(s2, s3, flColor, 255);
    }

    public void DrawTiledBitmapSection(FlBitmap flBitmap, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, short s10, short s11, short s12, short s13) {
        this.DrawTiledBitmapSection(flBitmap, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, 255);
    }

    public void DrawTiledBitmapSection(FlBitmap flBitmap, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9) {
        this.DrawTiledBitmapSection(flBitmap, s2, s3, s4, s5, s6, s7, s8, s9, 255);
    }

    public void GenericFillAbsoluteTriangle(short s2, short s3, short s4, short s5, short s6, short s7, FlColor flColor) {
        this.GenericFillAbsoluteTriangle(s2, s3, s4, s5, s6, s7, flColor, 255);
    }
}

