/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BlArray;
import ca.jamdat.flight.BlString;
import ca.jamdat.flight.BlStringBuffer;

public class BlStringBufferUtf16
extends BlStringBuffer {
    public char[] mCharacters = null;

    public BlStringBufferUtf16(int n2) {
        super(BlString.ENC_UTF16BE);
        this.mCharacters = new char[n2];
        this.mCapacity = n2;
    }

    public BlStringBufferUtf16(byte[] byArray, int n2, int n3) {
        super(BlString.ENC_UTF16BE);
        int n4 = n3 >> 1;
        this.mCharacters = new char[n4];
        this.mCapacity = n4;
        this.mLength = n4;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = n2 + i2;
            int n6 = byArray[n5] & 0xFF;
            int n7 = byArray[n5 + 1] & 0xFF;
            this.mCharacters[i2] = (char)(n6 << 8 | n7);
        }
    }

    public BlStringBufferUtf16(char[] cArray, int n2, int n3, int n4) {
        super(BlString.ENC_UTF16BE);
        if (n4 == 0) {
            this.mCharacters = new char[n3];
            this.mCapacity = n3;
            this.mLength = n3;
            BlArray.Copy(cArray, n2, this.mCharacters, 0, n3);
        } else {
            this.mCharacters = cArray;
            this.mOffset = n2;
            this.mLength = n3;
            this.mCapacity = BlStringBuffer.IMMUTABLE_CAPACITY;
        }
    }

    public void destruct() {
        if (this.IsMutable()) {
            this.mCharacters = null;
        }
    }

    public char GetCharAt(int n2) {
        return this.mCharacters[this.mOffset + n2];
    }

    public void SetCharAt(int n2, char c2) {
        this.mCharacters[n2] = c2;
    }

    public void AppendChar(char c2) {
        this.mCharacters[this.mLength++] = c2;
    }

    public void SetLength(int n2) {
        if (n2 <= 0) {
            this.mLength = 0;
        } else if (n2 <= this.mLength) {
            this.mLength = n2;
        } else {
            this.EnsureCapacity(n2);
            for (int i2 = this.mLength; i2 < n2; ++i2) {
                this.mCharacters[i2] = 32;
            }
            this.mLength = n2;
        }
    }

    public void EnsureCapacity(int n2) {
        if (n2 > this.mCapacity) {
            char[] cArray = this.mCharacters;
            this.mCharacters = new char[n2];
            BlArray.Copy(cArray, this.mOffset, this.mCharacters, 0, this.mLength);
            cArray = null;
            this.mCapacity = n2;
            this.mOffset = 0;
        }
    }

    public BlStringBufferUtf16(BlStringBufferUtf16 blStringBufferUtf16) {
    }
}

