/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BlJsonArray;
import ca.jamdat.flight.BlJsonBoolean;
import ca.jamdat.flight.BlJsonElement;
import ca.jamdat.flight.BlJsonNumber;
import ca.jamdat.flight.BlJsonObject;
import ca.jamdat.flight.BlJsonString;
import ca.jamdat.flight.BlOutputStream;
import ca.jamdat.flight.BlString;

public class BlJsonWriter {
    public BlString mString;
    public int mDepth;

    public BlJsonWriter() {
    }

    public void destruct() {
    }

    public void Write(BlJsonElement blJsonElement, BlString blString, boolean bl) {
        blString.SetLength(0);
        this.mString = blString;
        this.mDepth = 0;
        this.WriteJsonElement(blJsonElement, bl);
    }

    public void Write(BlJsonElement blJsonElement, BlOutputStream blOutputStream, int n2, boolean bl) {
        this.mString = new BlString("");
        this.mString.EnsureCapacity(n2);
        this.mDepth = 0;
        this.WriteJsonElement(blJsonElement, bl);
        blOutputStream.WriteString(this.mString);
        this.mString = null;
    }

    public BlJsonWriter(BlJsonWriter blJsonWriter) {
    }

    public void WriteJsonElement(BlJsonElement blJsonElement, boolean bl) {
        switch (blJsonElement.GetType()) {
            case 5: {
                this.WriteJsonObject((BlJsonObject)blJsonElement, bl);
                break;
            }
            case 4: {
                this.WriteJsonArray((BlJsonArray)blJsonElement, bl);
                break;
            }
            case 2: {
                this.WriteJsonNumber((BlJsonNumber)blJsonElement, bl);
                break;
            }
            case 3: {
                this.WriteJsonString((BlJsonString)blJsonElement, bl);
                break;
            }
            case 1: {
                this.WriteJsonBool((BlJsonBoolean)blJsonElement, bl);
                break;
            }
            case 0: {
                this.WriteJsonNull(blJsonElement, bl);
                break;
            }
        }
    }

    public void WriteJsonObject(BlJsonObject blJsonObject, boolean bl) {
        int n2 = blJsonObject.GetMemberCount();
        if (0 == n2) {
            this.mString.Append("{}");
        } else {
            this.mString.Append("{");
            if (bl) {
                this.mString.Append("\n");
            }
            ++this.mDepth;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl) {
                    this.WriteJsonTabs();
                }
                this.mString.Append("\"");
                this.mString.Append(blJsonObject.GetMemberNameAt(i2));
                if (bl) {
                    this.mString.Append("\" : ");
                } else {
                    this.mString.Append("\":");
                }
                this.WriteJsonElement(blJsonObject.GetMemberElementAt(i2), bl);
                if (i2 + 1 < n2) {
                    this.mString.Append(",");
                }
                if (!bl) continue;
                this.mString.Append("\n");
            }
            --this.mDepth;
            if (bl) {
                this.WriteJsonTabs();
            }
            this.mString.Append("}");
        }
    }

    public void WriteJsonArray(BlJsonArray blJsonArray, boolean bl) {
        if (blJsonArray.IsEmpty()) {
            this.mString.Append("[]");
        } else {
            this.mString.Append("[");
            if (bl) {
                this.mString.Append("\n");
            }
            ++this.mDepth;
            int n2 = blJsonArray.GetSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl) {
                    this.WriteJsonTabs();
                }
                this.WriteJsonElement(blJsonArray.GetElementAt(i2), bl);
                if (i2 + 1 < n2) {
                    this.mString.Append(",");
                }
                if (!bl) continue;
                this.mString.Append("\n");
            }
            --this.mDepth;
            if (bl) {
                this.WriteJsonTabs();
            }
            this.mString.Append("]");
        }
    }

    public void WriteJsonNumber(BlJsonNumber blJsonNumber, boolean bl) {
        BlString blString = new BlString(blJsonNumber.GetValue());
        switch (blString.GetCharAt(0)) {
            case '.': {
                this.mString.Append('0');
                break;
            }
            case '-': {
                if (blString.GetCharAt(1) != '.') break;
                this.mString.Append('0');
            }
        }
        this.mString.Append(blString);
    }

    public void WriteJsonString(BlJsonString blJsonString, boolean bl) {
        this.mString.Append("\"");
        block9: for (int i2 = 0; i2 < blJsonString.GetLength(); ++i2) {
            char c2 = blJsonString.GetCharAt(i2);
            switch (c2) {
                case '\"': {
                    this.mString.Append("\\\"");
                    continue block9;
                }
                case '\\': {
                    this.mString.Append("\\\\");
                    continue block9;
                }
                case '\b': {
                    this.mString.Append("\\b");
                    continue block9;
                }
                case '\f': {
                    this.mString.Append("\\f");
                    continue block9;
                }
                case '\n': {
                    this.mString.Append("\\n");
                    continue block9;
                }
                case '\r': {
                    this.mString.Append("\\r");
                    continue block9;
                }
                case '\t': {
                    this.mString.Append("\\t");
                    continue block9;
                }
                default: {
                    this.mString.Append(c2);
                }
            }
        }
        this.mString.Append("\"");
    }

    public void WriteJsonBool(BlJsonBoolean blJsonBoolean, boolean bl) {
        this.mString.Append(blJsonBoolean.GetValue() ? "true" : "false");
    }

    public void WriteJsonNull(BlJsonElement blJsonElement, boolean bl) {
        this.mString.Append("null");
    }

    public void WriteJsonTabs() {
        for (int i2 = 0; i2 < this.mDepth; ++i2) {
            this.mString.Append("\t");
        }
    }

    public void Write(BlJsonElement blJsonElement, BlString blString) {
        this.Write(blJsonElement, blString, true);
    }

    public void Write(BlJsonElement blJsonElement, BlOutputStream blOutputStream) {
        this.Write(blJsonElement, blOutputStream, 1024);
    }

    public void Write(BlJsonElement blJsonElement, BlOutputStream blOutputStream, int n2) {
        this.Write(blJsonElement, blOutputStream, n2, true);
    }

    public static BlJsonWriter[] InstArrayBlJsonWriter(int n2) {
        BlJsonWriter[] blJsonWriterArray = new BlJsonWriter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            blJsonWriterArray[i2] = new BlJsonWriter();
        }
        return blJsonWriterArray;
    }

    public static BlJsonWriter[][] InstArrayBlJsonWriter(int n2, int n3) {
        BlJsonWriter[][] blJsonWriterArray = new BlJsonWriter[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            blJsonWriterArray[i2] = new BlJsonWriter[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                blJsonWriterArray[i2][i3] = new BlJsonWriter();
            }
        }
        return blJsonWriterArray;
    }

    public static BlJsonWriter[][][] InstArrayBlJsonWriter(int n2, int n3, int n4) {
        BlJsonWriter[][][] blJsonWriterArray = new BlJsonWriter[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            blJsonWriterArray[i2] = new BlJsonWriter[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                blJsonWriterArray[i2][i3] = new BlJsonWriter[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    blJsonWriterArray[i2][i3][i4] = new BlJsonWriter();
                }
            }
        }
        return blJsonWriterArray;
    }
}

