/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.BaseScene;

public class SceneList {
    public BaseScene mFirst;
    public BaseScene mLast;
    public int mCount;

    public void destruct() {
    }

    public boolean IsEmpty() {
        return this.mFirst == null && this.mLast == null;
    }

    public void AddLast(BaseScene baseScene) {
        baseScene.AddRef();
        if (this.mFirst == null) {
            this.mFirst = baseScene;
            this.mLast = baseScene;
        } else {
            this.mLast.mNextScene = baseScene;
            baseScene.mPrevScene = this.mLast;
            this.mLast = baseScene;
        }
        ++this.mCount;
    }

    public BaseScene GetLast() {
        return this.mLast;
    }

    public void RemoveLast() {
        BaseScene baseScene = this.mLast;
        if (baseScene != null) {
            if (baseScene == this.mFirst) {
                this.mLast = null;
                this.mFirst = null;
            } else {
                this.mLast = baseScene.mPrevScene;
                baseScene.mPrevScene = null;
                this.mLast.mNextScene = null;
            }
            baseScene.RemoveRef();
            --this.mCount;
        }
    }

    public BaseScene Find(int n2) {
        BaseScene baseScene = this.mFirst;
        while (baseScene != null && baseScene.GetId() != n2) {
            baseScene = baseScene.mNextScene;
        }
        return baseScene;
    }

    public void InsertAfter(BaseScene baseScene, BaseScene baseScene2) {
        baseScene2.mPrevScene = baseScene;
        baseScene2.mNextScene = baseScene.mNextScene;
        baseScene.mNextScene = baseScene2;
        if (baseScene2.mNextScene != null) {
            baseScene2.mNextScene.mPrevScene = baseScene2;
        }
        if (baseScene == this.mLast) {
            this.mLast = baseScene2;
        }
        baseScene2.AddRef();
        ++this.mCount;
    }

    public int GetCount() {
        return this.mCount;
    }

    public static SceneList[] InstArraySceneList(int n2) {
        SceneList[] sceneListArray = new SceneList[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sceneListArray[i2] = new SceneList();
        }
        return sceneListArray;
    }

    public static SceneList[][] InstArraySceneList(int n2, int n3) {
        SceneList[][] sceneListArray = new SceneList[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sceneListArray[i2] = new SceneList[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                sceneListArray[i2][i3] = new SceneList();
            }
        }
        return sceneListArray;
    }

    public static SceneList[][][] InstArraySceneList(int n2, int n3, int n4) {
        SceneList[][][] sceneListArray = new SceneList[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sceneListArray[i2] = new SceneList[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                sceneListArray[i2][i3] = new SceneList[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    sceneListArray[i2][i3][i4] = new SceneList();
                }
            }
        }
        return sceneListArray;
    }
}

