/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.Package;
import ca.jamdat.texasholdem09.AIAlgo;
import ca.jamdat.texasholdem09.CardValue;
import ca.jamdat.texasholdem09.Character;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.HandCalculator;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.TexasGameManager;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class PokerPlayerAI
extends PokerPlayer {
    public static final byte typeNumber = -1;
    public static final byte typeID = 127;
    public static final boolean supportsDynamicSerialization = false;
    public static final byte tight1ID = 0;
    public static final byte tight2ID = 1;
    public static final byte pfAggID = 2;
    public static final byte fAggID = 3;
    public static final byte callID = 4;
    public static final byte betID = 5;
    public static final byte raiseID = 6;
    public static final byte checkRaiseID = 7;
    public static final byte minCallID = 8;
    public static final byte minCheckRaiseID = 9;
    public static final byte bluffID = 10;
    public static final byte maxBluffID = 11;
    public static final byte minBetID = 12;
    public static final byte minRaiseID = 13;
    public static final byte preflopAllInID = 14;
    public static final byte flopAllInID = 15;
    public static final byte preflopBluffID = 16;
    public static final byte preflopSlowplayID = 17;
    public static final byte maxNbOfOpponentsBluffID = 18;
    public PlayerDecision mAiPlayerDecision;
    public Character mCharacter;
    public F32[] mHS = F32.InstArrayF32(3);
    public F32[] mHP = F32.InstArrayF32(3);
    public F32[] mEHS = F32.InstArrayF32(3);
    public boolean[] mAreMetricsReady = new boolean[3];
    public F32 mTightnessThresh1;
    public F32 mTightnessThresh2;
    public F32 mPreflopAggressivity;
    public F32 mFlopAggressivity;
    public F32 mCallSensitivity;
    public F32 mBetSensitivity;
    public F32 mRaiseSensitivity;
    public F32 mCheckRaiseSensitivity;
    public F32 mMinForBet;
    public F32 mMinForRaise;
    public F32 mMinForCall;
    public F32 mMinForCheckRaise;
    public F32 mMaxForBluff;
    public F32 mBluffTendency;
    public F32 mPreflopAllInTendency;
    public F32 mFlopAllInTendency;
    public F32 mPreflopBluffTendency;
    public F32 mPreflopSlowplayTendency;
    public int mMaxNbOfOpponentsToBluffAgainst;
    public boolean mHasBluffedInBettingRound;
    public boolean mCheckRaising;
    public boolean mHasCheckRaised;
    public boolean mSlowPlaying;
    public boolean mComputeMetrics;
    public boolean mHSWasModifiedDuringCurrentBettingRound;

    public static PokerPlayerAI Cast(Object object, PokerPlayerAI pokerPlayerAI) {
        return (PokerPlayerAI)object;
    }

    public PokerPlayerAI(Character character, boolean bl) {
        this.mCharacter = character;
        this.mComputeMetrics = true;
        this.mTightnessThresh1 = new F32();
        this.mTightnessThresh2 = new F32();
        this.mPreflopAggressivity = new F32();
        this.mFlopAggressivity = new F32();
        this.mCallSensitivity = new F32();
        this.mBetSensitivity = new F32();
        this.mRaiseSensitivity = new F32();
        this.mCheckRaiseSensitivity = new F32();
        this.mMinForBet = new F32();
        this.mMinForRaise = new F32();
        this.mMinForCall = new F32();
        this.mMinForCheckRaise = new F32();
        this.mMaxForBluff = new F32();
        this.mBluffTendency = new F32();
        this.mPreflopAllInTendency = new F32();
        this.mFlopAllInTendency = new F32();
        this.mPreflopBluffTendency = new F32();
        this.mPreflopSlowplayTendency = new F32();
        for (int i2 = 0; i2 < 3; ++i2) {
            this.mHS[i2] = F32.FromInt(-1, 8);
            this.mHP[i2] = F32.FromInt(-1, 8);
            this.mEHS[i2] = F32.FromInt(-1, 8);
            this.mAreMetricsReady[i2] = false;
        }
        this.mAiPlayerDecision = this.mPlayerDecision = new PlayerDecision();
        if (!bl) {
            this.LoadAIAttributes();
        }
    }

    public void destruct() {
    }

    public void UnloadResources() {
        this.mAiPlayerDecision = null;
        super.UnloadResources();
    }

    public void LoadAIAttributes() {
        if (this.GetPersonality() == -1) {
            return;
        }
        int n2 = 9 + this.GetPersonality();
        MetaPackage metaPackage = GameLibrary.GetPackage(n2);
        Package package_ = metaPackage.GetPackage();
        int n3 = package_.GetEntryPoint(0, (int[])null);
        this.mTightnessThresh1 = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(1, (int[])null);
        this.mTightnessThresh2 = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(2, (int[])null);
        this.mPreflopAggressivity = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(3, (int[])null);
        this.mFlopAggressivity = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(4, (int[])null);
        this.mCallSensitivity = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(5, (int[])null);
        this.mBetSensitivity = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(6, (int[])null);
        this.mRaiseSensitivity = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(7, (int[])null);
        this.mCheckRaiseSensitivity = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(8, (int[])null);
        this.mMinForCall = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(9, (int[])null);
        this.mMinForCheckRaise = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(10, (int[])null);
        this.mBluffTendency = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(11, (int[])null);
        this.mMaxForBluff = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(12, (int[])null);
        this.mMinForBet = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(13, (int[])null);
        this.mMinForRaise = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(14, (int[])null);
        this.mPreflopAllInTendency = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(15, (int[])null);
        this.mFlopAllInTendency = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(16, (int[])null);
        this.mPreflopBluffTendency = F32.FromInt(n3, 0);
        n3 = package_.GetEntryPoint(17, (int[])null);
        this.mPreflopSlowplayTendency = F32.FromInt(n3, 0);
        this.mMaxNbOfOpponentsToBluffAgainst = package_.GetEntryPoint(18, (int[])null);
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void LoadAIAttributes(Character character) {
        this.mCharacter = null;
        this.mCharacter = character;
        this.LoadAIAttributes();
    }

    public boolean IsPlayerHero() {
        return this.mCharacter.GetPortrait() >= 18;
    }

    public int GetPersonality() {
        return this.mCharacter == null ? -1 : this.mCharacter.GetPersonality();
    }

    public int GetPortrait() {
        return this.mCharacter == null ? -1 : this.mCharacter.GetPortrait();
    }

    public void Save(FileSegmentStream fileSegmentStream) {
        super.Save(fileSegmentStream);
    }

    public void Load(FileSegmentStream fileSegmentStream) {
        super.Load(fileSegmentStream);
        this.LoadAIAttributes();
    }

    public void SetHSForComputingRound(F32 f32, byte by) {
        this.mHS[by] = f32;
    }

    public void SetHPForComputingRound(F32 f32, byte by) {
        this.mHP[by] = f32;
    }

    public F32 GetHSForComputingRound(byte by) {
        return this.mHS[by];
    }

    public F32 GetHPForComputingRound(byte by) {
        return this.mHP[by];
    }

    public F32 GetEHSForComputingRound(byte by) {
        return this.mEHS[by];
    }

    public F32 GetEHS() {
        F32 f32 = new F32(F32.Zero(8));
        TexasGameManager texasGameManager = TexasGameManager.Get();
        byte by = TexasGameManager.GetHandStepAsComputingRound(texasGameManager.GetTexasHandStep());
        if (by == -1) {
            f32 = AIAlgo.GetValueForHoleCategory(AIAlgo.GetHoleCategory(this.mHoleCards));
        } else if (this.mHS[by].GreaterOrEqual(F32.Zero(8))) {
            f32 = this.mHP[by].GreaterOrEqual(F32.Zero(8)) ? this.mHS[by].Add(F32.FromInt(1, 8).Sub(this.mHS[by]).Mul(this.mHP[by], 8)) : this.mHS[by];
        }
        return f32;
    }

    public void SetMetricsReadyForComputingRound(byte by, boolean bl) {
        this.mAreMetricsReady[by] = bl;
    }

    public boolean AreMetricsReadyForComputingRound(byte by) {
        return this.mAreMetricsReady[by];
    }

    public void TakeDecision(TexasGameManager texasGameManager) {
        byte by = texasGameManager.GetTexasHandStep();
        switch (by) {
            case 3: {
                this.TakePreflopDecision(texasGameManager);
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                this.TakeFlopDecision(texasGameManager);
            }
        }
    }

    public boolean DoIRaise(int n2, int n3, byte by) {
        if (this.mCheckRaising) {
            return true;
        }
        if (this.mEHS[by].LessThan(this.mMinForRaise)) {
            return false;
        }
        F32 f32 = new F32();
        f32 = F32.FromInt(n2, 8).Div(n3);
        if (f32.GreaterThan(this.mEHS[by])) {
            return false;
        }
        int n4 = f32.Div(this.mEHS[by], 8).Mul(1000).ToInt(8);
        short s2 = FlMath.Random((short)0, (short)1000);
        F32 f322 = new F32();
        f322 = F32.FromInt(s2, 8).Mul(this.mRaiseSensitivity, 8);
        int n5 = f322.ToInt(8);
        return n5 > n4;
    }

    public boolean DoIBet(byte by) {
        if (this.mEHS[by].LessThan(this.mMinForBet)) {
            return false;
        }
        int n2 = this.mEHS[by].Mul(this.mBetSensitivity, 8).Mul(1000).ToInt(8);
        short s2 = FlMath.Random((short)0, (short)1000);
        return s2 <= n2;
    }

    public boolean DoICall(int n2, int n3, byte by) {
        if (this.mEHS[by].LessThan(this.mMinForCall)) {
            return false;
        }
        F32 f32 = new F32();
        f32 = F32.FromInt(n2, 8).Div(n3);
        if (f32.LessThan(this.mEHS[by])) {
            return true;
        }
        int n4 = this.mEHS[by].Div(f32, 8).Mul(1000).ToInt(8);
        short s2 = FlMath.Random((short)0, (short)1000);
        F32 f322 = new F32();
        f322 = F32.FromInt(s2, 8).Mul(this.mCallSensitivity, 8);
        int n5 = f322.ToInt(8);
        return n5 > n4;
    }

    public boolean DoISlowPlayOrCheckRaise(byte by) {
        if (this.mEHS[by].LessThan(this.mMinForCheckRaise) || by == 2) {
            return false;
        }
        int n2 = this.mEHS[by].Mul(this.mCheckRaiseSensitivity, 8).Mul(1000).ToInt(8);
        short s2 = FlMath.Random((short)0, (short)1000);
        return s2 <= n2;
    }

    public boolean DoIBluff(F32 f32, byte by, int n2) {
        if (n2 > this.mMaxNbOfOpponentsToBluffAgainst) {
            return false;
        }
        if (this.mEHS[by].GreaterThan(this.mMaxForBluff)) {
            return false;
        }
        int n3 = f32.Mul(this.mBluffTendency, 8).Mul(1000).ToInt(8);
        short s2 = FlMath.Random((short)0, (short)1000);
        return s2 <= n3;
    }

    public boolean DoIGoAllIn(F32 f32, F32 f322) {
        int n2 = f32.Mul(f322, 8).Mul(1000).ToInt(8);
        short s2 = FlMath.Random((short)0, (short)1000);
        return s2 <= n2;
    }

    public void SetComputeMetrics(boolean bl) {
        this.mComputeMetrics = bl;
    }

    public boolean GetComputeMetrics() {
        return this.mComputeMetrics;
    }

    public void ApplyHeadsupModif() {
        F32 f32 = new F32(F32.FromInt(102, 0));
        F32 f322 = new F32(F32.FromInt(154, 0));
        this.mTightnessThresh1 = this.mTightnessThresh1.Mul(f32, 8);
        this.mTightnessThresh2 = this.mTightnessThresh2.Mul(f32, 8);
        this.mMinForBet = this.mMinForBet.Mul(f322, 8);
        this.mMinForCall = this.mMinForCall.Mul(f322, 8);
        this.mMinForRaise = this.mMinForRaise.Mul(f322, 8);
        this.mMinForCheckRaise = this.mMinForCheckRaise.Mul(f322, 8);
    }

    public void SetState(byte by) {
        if (by == -1) {
            this.mCharacter.SetCurrentSeat(-1);
        }
        super.SetState(by);
    }

    public static int ValidateBetRaiseAmount(int n2, int n3, int n4, int n5) {
        int n6 = n2 / n5 * n5;
        if (n6 > n4) {
            n6 = n4;
        }
        if (n6 < n3) {
            n6 = n3;
        }
        return n6;
    }

    public void ResetForNextHand() {
        super.ResetForNextHand();
        this.mHasBluffedInBettingRound = false;
        this.mHSWasModifiedDuringCurrentBettingRound = false;
        this.mCheckRaising = false;
        this.mHasCheckRaised = false;
        this.mSlowPlaying = false;
    }

    public void ResetForNextBettingRound() {
        super.ResetForNextBettingRound();
        this.mHasBluffedInBettingRound = false;
        this.mHSWasModifiedDuringCurrentBettingRound = false;
    }

    public void TakePreflopDecision(TexasGameManager texasGameManager) {
        int n2;
        int n3;
        F32 f32 = new F32();
        f32 = AIAlgo.GetValueForHoleCategory(AIAlgo.GetHoleCategory(this.mHoleCards));
        PlayerDecision playerDecision = this.mAiPlayerDecision;
        int n4 = texasGameManager.GetBigBlindValue();
        int n5 = FlMath.Random((short)0, (short)2000);
        f32 = n5 < 1000 ? f32.Sub(F32.FromInt(n5, 8).Div(10000)) : f32.Add(F32.FromInt(n5 -= 1000, 8).Div(10000));
        if (f32.LessThan(F32.Zero(8))) {
            f32 = F32.Zero(8);
        }
        F32 f322 = new F32();
        f322 = F32.FromInt(texasGameManager.GetHumanPlayer().GetBluffFactor(), 8);
        f322 = f322.Div(10);
        if ((f32 = f32.Mul(f322 = f322.Add(F32.One(8)), 8)).GreaterThan(F32.One(8))) {
            f32 = F32.One(8);
        }
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        int n8 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        PlayerDecision playerDecision2 = null;
        for (n3 = 1; n3 < 4; n3 = (int)((short)(n3 + 1))) {
            playerDecision2 = this.mPossibleDecision[n3];
            byte by = playerDecision2.GetPlayerAction();
            if (by == 2) {
                bl2 = true;
                n8 = playerDecision2.GetChip();
                continue;
            }
            if (by == 4) {
                n2 = playerDecision2.GetChip();
                if (bl) {
                    n7 = n2;
                } else {
                    n6 = n2;
                }
                bl = true;
                continue;
            }
            if (by == 1) {
                bl3 = true;
                continue;
            }
            if (by != 3) continue;
        }
        n3 = CardValue.GetValue(this.mHoleCards[0]) == CardValue.GetValue(this.mHoleCards[1]) ? 1 : 0;
        int n9 = n2 = CardValue.GetValue(this.mHoleCards[0]) == 12 || CardValue.GetValue(this.mHoleCards[1]) == 12 ? 1 : 0;
        if (this.GetChip() <= n4 * 5) {
            if (AIAlgo.GetHoleCategory(this.mHoleCards) <= 2 || n3 != 0 || n2 != 0) {
                if (bl) {
                    playerDecision.SetPlayerAction((byte)4);
                    playerDecision.SetChip(n7);
                } else {
                    playerDecision.SetPlayerAction((byte)2);
                    playerDecision.SetChip(n8);
                }
            } else if (texasGameManager.GetSmallBlindPlayer() == this || texasGameManager.GetBigBlindPlayer() == this) {
                if (texasGameManager.WasABetOrRaise() || f32.GreaterThan(this.mTightnessThresh2)) {
                    if (bl) {
                        playerDecision.SetPlayerAction((byte)4);
                        playerDecision.SetChip(n7);
                    } else {
                        playerDecision.SetPlayerAction((byte)2);
                        playerDecision.SetChip(n8);
                    }
                } else if (texasGameManager.GetSmallBlindPlayer() == this) {
                    playerDecision.SetPlayerAction((byte)2);
                    playerDecision.SetChip(n8);
                } else {
                    playerDecision.SetPlayerAction((byte)1);
                }
            } else {
                playerDecision.SetPlayerAction((byte)0);
            }
            bl4 = true;
        }
        if (!bl4) {
            boolean bl5;
            int n10 = this.mPreflopSlowplayTendency.Mul(1000).ToInt(8);
            n5 = FlMath.Random((short)0, (short)1000);
            boolean bl6 = n5 <= n10;
            n10 = this.mPreflopBluffTendency.Mul(1000).ToInt(8);
            n5 = FlMath.Random((short)0, (short)1000);
            boolean bl7 = bl5 = n5 <= n10;
            if ((!bl6 && AIAlgo.GetHoleCategory(this.mHoleCards) <= 2 || n3 != 0 || n2 != 0) && this.DoIGoAllIn(f32, this.mPreflopAllInTendency)) {
                if (bl) {
                    playerDecision.SetPlayerAction((byte)4);
                    playerDecision.SetChip(n7);
                } else {
                    playerDecision.SetPlayerAction((byte)2);
                    playerDecision.SetChip(n8);
                }
                bl4 = true;
            }
            if (!bl4) {
                if (f32.LessThan(this.mTightnessThresh1)) {
                    if (texasGameManager.GetBigBlindPlayer() == this && !texasGameManager.WasABetOrRaise()) {
                        playerDecision.SetPlayerAction((byte)1);
                    } else if (bl5) {
                        if (n8 <= 5 * n4) {
                            playerDecision.SetPlayerAction((byte)2);
                            playerDecision.SetChip(n8);
                        } else {
                            playerDecision.SetPlayerAction((byte)0);
                        }
                    } else {
                        playerDecision.SetPlayerAction((byte)0);
                    }
                } else if (f32.LessThan(this.mTightnessThresh2)) {
                    if (bl3) {
                        playerDecision.SetPlayerAction((byte)1);
                    } else if (!bl5) {
                        if (texasGameManager.WasABetOrRaise()) {
                            playerDecision.SetPlayerAction((byte)0);
                        } else {
                            playerDecision.SetPlayerAction((byte)2);
                            playerDecision.SetChip(n8);
                        }
                    } else if (n8 <= 5 * n4) {
                        playerDecision.SetPlayerAction((byte)2);
                        playerDecision.SetChip(n8);
                    } else {
                        playerDecision.SetPlayerAction((byte)0);
                    }
                } else {
                    int n11;
                    int n12 = n4 * 30;
                    F32 f323 = new F32();
                    F32 f324 = new F32();
                    F32 f325 = new F32();
                    F32 f326 = new F32();
                    f323 = f32.Sub(this.mTightnessThresh2);
                    f324 = f323 = f323.Div(F32.FromInt(1, 8).Sub(this.mTightnessThresh2), 8);
                    int n13 = 4;
                    for (n11 = 0; n11 < n13; n11 = (int)((short)(n11 + 1))) {
                        f324 = f324.Mul(f323, 8);
                    }
                    n11 = 2;
                    f324 = f324.Mul(n12 / n11);
                    f325 = f323.Mul(this.mPreflopAggressivity, 8).Mul(n12);
                    f326 = f324.Add(f325);
                    if ((f326 = f326.Add(F32.FromInt(n4, 8))).GreaterThan(F32.FromInt(n12, 8))) {
                        f326 = F32.FromInt(n12, 8);
                    }
                    F32 f327 = new F32();
                    f327 = bl3 ? F32.FromInt(n4, 8) : F32.FromInt(n8, 8);
                    F32 f328 = new F32();
                    if (bl) {
                        int n14 = n6 - this.GetChipInvolvedInCurrentBetRound();
                        f328 = F32.FromInt(n14, 8);
                    } else {
                        f328 = F32.FromInt(-1, 8);
                    }
                    if (f326.LessThan(f327)) {
                        if (f326.LessThan(f327.Div(2))) {
                            playerDecision.SetPlayerAction((byte)0);
                        } else {
                            playerDecision.SetPlayerAction((byte)2);
                            playerDecision.SetChip(n8);
                        }
                    } else if (f326.LessThan(f328)) {
                        F32 f329 = new F32();
                        f329 = f328.Sub(f327).Div(2).Add(f327);
                        if (f326.LessThan(f329)) {
                            if (bl3) {
                                playerDecision.SetPlayerAction((byte)1);
                            } else {
                                playerDecision.SetPlayerAction((byte)2);
                                playerDecision.SetChip(n8);
                            }
                        } else if (bl6) {
                            playerDecision.SetPlayerAction((byte)2);
                            playerDecision.SetChip(n8);
                        } else {
                            playerDecision.SetPlayerAction((byte)4);
                            playerDecision.SetChip(n6);
                        }
                    } else if (f328.Equals(F32.FromInt(-1, 8))) {
                        playerDecision.SetPlayerAction((byte)2);
                        playerDecision.SetChip(n8);
                    } else if (bl6) {
                        if (bl3) {
                            playerDecision.SetPlayerAction((byte)1);
                        } else {
                            playerDecision.SetPlayerAction((byte)2);
                            playerDecision.SetChip(n8);
                        }
                    } else {
                        playerDecision.SetPlayerAction((byte)4);
                        f326 = f326.Add(F32.FromInt(this.GetChipInvolvedInCurrentBetRound(), 8));
                        if (f326.GreaterThan(F32.FromInt(n7, 8))) {
                            playerDecision.SetChip(n7);
                        } else if (f326.LessThan(F32.FromInt(n6, 8))) {
                            playerDecision.SetChip(n6);
                        } else if ((f326 = f326.Div(10).Round(8).Mul(10)).GreaterThan(F32.FromInt(n7, 8))) {
                            playerDecision.SetChip(n7);
                        } else if (f326.LessThan(F32.FromInt(n6, 8))) {
                            playerDecision.SetChip(n6);
                        } else {
                            playerDecision.SetChip(f326.ToInt(8));
                        }
                    }
                }
                if (playerDecision.GetPlayerAction() == 0 && AIAlgo.GetHoleCategory(this.mHoleCards) <= 2) {
                    if (bl2) {
                        playerDecision.SetPlayerAction((byte)2);
                        playerDecision.SetChip(n8);
                    } else if (bl3) {
                        playerDecision.SetPlayerAction((byte)1);
                    }
                }
            }
        }
        this.SetDecisionAllInIfNeeded();
    }

    public void TakeFlopDecision(TexasGameManager texasGameManager) {
        int n2;
        byte by = TexasGameManager.GetHandStepAsComputingRound(texasGameManager.GetTexasHandStep());
        PlayerDecision playerDecision = this.mAiPlayerDecision;
        int n3 = texasGameManager.GetBigBlindValue();
        int n4 = 0;
        if (!this.mHSWasModifiedDuringCurrentBettingRound) {
            F32 f32 = new F32();
            f32 = this.mHS[by];
            for (n4 = 0; n4 < texasGameManager.GetNbOfPlayersInTheHand() - 2; ++n4) {
                this.mHS[by] = this.mHS[by].Mul(f32, 8);
            }
            this.mHSWasModifiedDuringCurrentBettingRound = true;
        }
        this.mEHS[by] = this.mHP[by].GreaterOrEqual(F32.Zero(8)) ? this.mHS[by].Add(F32.FromInt(1, 8).Sub(this.mHS[by]).Mul(this.mHP[by], 8)) : this.mHS[by];
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        PlayerDecision playerDecision2 = null;
        for (n4 = 1; n4 < 4; ++n4) {
            playerDecision2 = this.mPossibleDecision[n4];
            byte by2 = playerDecision2.GetPlayerAction();
            if (by2 == 2) {
                bl2 = true;
                n7 = playerDecision2.GetChip();
                continue;
            }
            if (by2 == 3 || by2 == 4) {
                n2 = playerDecision2.GetChip();
                if (bl) {
                    n6 = n2;
                } else {
                    n5 = n2;
                }
                bl = true;
                continue;
            }
            if (by2 != 1) continue;
            bl3 = true;
        }
        n2 = 0;
        if (this.GetChip() <= n3 * 5) {
            n2 = 1;
        }
        TexasPokerTable texasPokerTable = (TexasPokerTable)texasGameManager.GetPokerTable();
        boolean bl4 = false;
        boolean bl5 = false;
        F32 f32 = new F32();
        f32 = this.mEHS[by];
        F32 f322 = new F32();
        f322 = HandCalculator.GetIncompleteHandValue(texasPokerTable.GetCommunityCards(), texasPokerTable.GetCommunityCardsCount());
        int n8 = 0;
        short s2 = 0;
        if (this.DoIBluff(f322, by, texasGameManager.GetNbOfPlayersInTheHand() - 1) && !this.mHasBluffedInBettingRound && n2 == 0) {
            bl4 = true;
            this.mHasBluffedInBettingRound = true;
            this.mEHS[by] = F32.FromInt(800, 8);
            this.mEHS[by] = this.mEHS[by].Div(1000);
            n8 = f322.Mul(this.mFlopAllInTendency, 8).Mul(1000).ToInt(8);
            s2 = FlMath.Random((short)0, (short)1000);
            bl5 = s2 <= n8;
        } else if (!this.mHasCheckRaised && !this.mCheckRaising && !this.mSlowPlaying && this.DoISlowPlayOrCheckRaise(by)) {
            if (texasGameManager.WasABetOrRaise()) {
                this.mSlowPlaying = true;
            } else {
                s2 = FlMath.Random((short)0, (short)1000);
                if (s2 < 500) {
                    this.mCheckRaising = true;
                } else {
                    this.mSlowPlaying = true;
                }
            }
        }
        if (this.mCheckRaising) {
            boolean bl6 = this.mCheckRaising = this.mEHS[by].GreaterOrEqual(this.mMinForCheckRaise) && by < 2;
        }
        if (this.mSlowPlaying) {
            this.mSlowPlaying = this.mEHS[by].GreaterOrEqual(this.mMinForCheckRaise) && by < 2;
        }
        int n9 = texasPokerTable.GetEffectivePotOfPlayer(this);
        if (texasGameManager.WasABetOrRaise()) {
            if (bl && !this.mSlowPlaying) {
                if ((this.DoIRaise(n7, n9, by) || bl4) && this.GetChipInvolvedInCurrentBetRound() == 0) {
                    if (this.mCheckRaising) {
                        this.mCheckRaising = false;
                        this.mHasCheckRaised = true;
                    }
                    playerDecision.SetPlayerAction((byte)4);
                    if (bl5 || n2 != 0 || this.DoIGoAllIn(this.mEHS[by], this.mFlopAllInTendency)) {
                        playerDecision.SetChip(n6);
                    } else {
                        F32 f323 = new F32();
                        int n10 = 2;
                        f323 = this.mFlopAggressivity.Mul(n10);
                        int n11 = F32.FromInt(n9, 8).Mul(this.mEHS[by], 8).Mul(f323, 8).ToInt(8);
                        int n12 = n11 + this.GetChipInvolvedInCurrentBetRound();
                        n12 = n12 < n5 ? n5 : (n12 > n6 ? n6 : PokerPlayerAI.ValidateBetRaiseAmount(n12, n5, n6, texasGameManager.GetSmallBlindValue()));
                        playerDecision.SetChip(n12);
                    }
                } else if (this.DoICall(n7, n9, by) && n2 == 0) {
                    playerDecision.SetPlayerAction((byte)2);
                    playerDecision.SetChip(n7);
                } else {
                    playerDecision.SetPlayerAction((byte)0);
                }
                this.mCheckRaising = false;
            } else if (n2 == 0 && this.DoICall(n7, n9, by) || n2 != 0 && this.DoICall(n7, n9, by) && n7 == this.GetChip() || this.mSlowPlaying) {
                playerDecision.SetPlayerAction((byte)2);
                playerDecision.SetChip(n7);
            } else {
                playerDecision.SetPlayerAction((byte)0);
            }
        } else if (this.mCheckRaising) {
            playerDecision.SetPlayerAction((byte)1);
        } else if (this.mSlowPlaying) {
            playerDecision.SetPlayerAction((byte)3);
            F32 f324 = new F32();
            f324 = F32.FromInt(15, 8);
            f324 = f324.Div(100);
            int n13 = F32.FromInt(n9, 8).Mul(f324, 8).ToInt(8);
            n13 = n13 < n5 ? n5 : (n13 > n6 ? n6 : PokerPlayerAI.ValidateBetRaiseAmount(n13, n5, n6, texasGameManager.GetSmallBlindValue()));
            playerDecision.SetChip(n13);
        } else if (this.DoIBet(by) || bl4) {
            playerDecision.SetPlayerAction((byte)3);
            if (bl5 || this.DoIGoAllIn(this.mEHS[by], this.mFlopAllInTendency) || n2 != 0) {
                playerDecision.SetChip(n6);
            } else {
                int n14 = F32.FromInt(n9, 8).Mul(this.mEHS[by], 8).Mul(this.mFlopAggressivity, 8).ToInt(8);
                n14 = n14 < n5 ? n5 : (n14 > n6 ? n6 : PokerPlayerAI.ValidateBetRaiseAmount(n14, n5, n6, texasGameManager.GetSmallBlindValue()));
                playerDecision.SetChip(n14);
            }
        } else {
            short s3 = FlMath.Random((short)0, (short)1000);
            if (texasGameManager.GetCloseHandPlayer() == this && s3 < 400) {
                int n15 = n9 * 200 / 1000;
                n15 = PokerPlayerAI.ValidateBetRaiseAmount(n15, n5, n6, texasGameManager.GetSmallBlindValue());
                playerDecision.SetChip(n15);
                playerDecision.SetPlayerAction((byte)3);
            } else {
                playerDecision.SetPlayerAction((byte)1);
            }
        }
        this.mEHS[by] = f32;
        this.SetDecisionAllInIfNeeded();
    }

    public void SetDecisionAllInIfNeeded() {
        byte by = this.mAiPlayerDecision.GetPlayerAction();
        if (by == 2 || by == 3 || by == 4) {
            int n2 = by == 4 ? this.mChipInvolvedInCurrentBetRound : 0;
            int n3 = this.mChips - (this.mAiPlayerDecision.GetChip() - n2);
            if (n3 + this.mChipInvolvedInCurrentBetRound == 0 || n3 == 0) {
                this.mAiPlayerDecision.SetPlayerAction((byte)5);
            }
        }
    }

    public PokerPlayerAI(Character character) {
        this(character, false);
    }

    public void SetMetricsReadyForComputingRound(byte by) {
        this.SetMetricsReadyForComputingRound(by, true);
    }
}

