/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FlString;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.HandCalculator;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.StaticCard;
import ca.jamdat.texasholdem09.TexasGameManager;

public abstract class PokerPlayer {
    public static final byte typeNumber = -1;
    public static final byte typeID = 127;
    public static final boolean supportsDynamicSerialization = false;
    public static final byte undefined = -1;
    public static final byte isOut = 0;
    public static final byte inPlay = 1;
    public static final byte fold = 2;
    public static final byte mucked = 3;
    public static final byte allIn = 4;
    public static final byte showCards = 5;
    public byte[] mHoleCards = null;
    public byte[] mNextHoleCards = null;
    public PlayerDecision[] mPossibleDecision = null;
    public PlayerDecision mPlayerDecision;
    public boolean mActionReady;
    public int mChipInvolvedInCurrentBetRound;
    public int mChips;
    public int mLastBluffFactorIncrease;
    public int mBluffFactor;
    public byte mPlayerState = (byte)-1;
    public boolean mAreCardsShown;
    public int mHandValue;
    public int mTotalChipWonInCurrentHand;
    public FlString mName;

    public static PokerPlayer Cast(Object object, PokerPlayer pokerPlayer) {
        return (PokerPlayer)object;
    }

    public PokerPlayer() {
        int n2;
        this.mHoleCards = new byte[2];
        this.mNextHoleCards = new byte[2];
        StaticCard.Clear(this.mNextHoleCards, 2);
        StaticCard.Clear(this.mHoleCards, 2);
        this.mPossibleDecision = new PlayerDecision[4];
        for (n2 = 0; n2 < this.mPossibleDecision.length; ++n2) {
            this.mPossibleDecision[n2] = null;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            this.mPossibleDecision[n2] = new PlayerDecision();
        }
    }

    public void destruct() {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.mPossibleDecision[i2] = null;
        }
        this.mPossibleDecision = null;
        this.mHoleCards = null;
        this.mNextHoleCards = null;
    }

    public void UnloadResources() {
        this.mPlayerDecision = null;
    }

    public void ExecuteDecision() {
        this.mActionReady = false;
    }

    public boolean IsDecisionAvailable() {
        return this.mActionReady;
    }

    public void SetDecision(PlayerDecision playerDecision) {
        this.mPlayerDecision.SetChip(playerDecision.GetChip());
        this.mPlayerDecision.SetPlayerAction(playerDecision.GetPlayerAction());
        this.CheckBluff(this.mPlayerDecision);
        this.mActionReady = true;
    }

    public PlayerDecision GetDecision() {
        return this.mPlayerDecision;
    }

    public boolean IsGoingAllIn() {
        return this.mPlayerDecision.GetPlayerAction() == 5;
    }

    public void AddChip(int n2) {
        this.SetChip(this.mChips + n2);
        if (this.mPlayerState == 4 && this.mChips > 0) {
            this.mPlayerState = 1;
        }
    }

    public void AddChipWon(int n2) {
        this.mTotalChipWonInCurrentHand += n2;
    }

    public void RemoveChip(int n2) {
        this.mChipInvolvedInCurrentBetRound += n2;
        this.SetChip(this.mChips - n2);
        if (this.mChips == 0) {
            this.mPlayerState = (byte)4;
        }
    }

    public void SetChip(int n2) {
        this.mChips = n2;
    }

    public int GetChip() {
        return this.mChips;
    }

    public int GetChipWon() {
        return this.mTotalChipWonInCurrentHand;
    }

    public int GetChipInvolvedInCurrentBetRound() {
        return this.mChipInvolvedInCurrentBetRound;
    }

    public void SetChipInvolvedInCurrentBetRound(int n2) {
        this.mChipInvolvedInCurrentBetRound = n2;
    }

    public byte GetState() {
        return this.mPlayerState;
    }

    public void SetState(byte by) {
        this.mPlayerState = by;
    }

    public void ResetForNextHand() {
        this.mTotalChipWonInCurrentHand = 0;
        this.mChipInvolvedInCurrentBetRound = 0;
        this.ResetForNextBettingRound();
        this.mActionReady = false;
        this.mAreCardsShown = false;
        if (this.mChips > 0) {
            this.SetState((byte)1);
        } else {
            this.SetState((byte)0);
        }
    }

    public void ResetForNextBettingRound() {
        this.mChipInvolvedInCurrentBetRound = 0;
        this.mPlayerDecision.Reset();
    }

    public boolean IsPlayerHuman() {
        return false;
    }

    public boolean IsPlayerHero() {
        return false;
    }

    public abstract F32 GetEHS();

    public void Save(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteLong(this.mChips);
        fileSegmentStream.WriteByte(this.mPlayerState);
        fileSegmentStream.WriteLong(this.mHandValue);
        fileSegmentStream.WriteLong(this.mTotalChipWonInCurrentHand);
        fileSegmentStream.WriteLong(this.mChipInvolvedInCurrentBetRound);
        fileSegmentStream.WriteLong(this.mHoleCards[0]);
        fileSegmentStream.WriteLong(this.mHoleCards[1]);
        fileSegmentStream.WriteLong(this.mNextHoleCards[0]);
        fileSegmentStream.WriteLong(this.mNextHoleCards[1]);
        for (int i2 = 0; i2 < 4; ++i2) {
            fileSegmentStream.WriteByte(this.mPossibleDecision[i2].GetPlayerAction());
            fileSegmentStream.WriteLong(this.mPossibleDecision[i2].GetChip());
        }
        fileSegmentStream.WriteByte(this.mPlayerDecision.GetPlayerAction());
        fileSegmentStream.WriteLong(this.mPlayerDecision.GetChip());
        fileSegmentStream.WriteByte((byte)(this.mActionReady ? 1 : 0));
        fileSegmentStream.WriteBoolean(this.mAreCardsShown);
    }

    public void Load(FileSegmentStream fileSegmentStream) {
        this.mChips = fileSegmentStream.ReadLong();
        this.mPlayerState = fileSegmentStream.ReadByte();
        this.mHandValue = fileSegmentStream.ReadLong();
        this.mTotalChipWonInCurrentHand = fileSegmentStream.ReadLong();
        this.mChipInvolvedInCurrentBetRound = fileSegmentStream.ReadLong();
        this.mHoleCards[0] = (byte)fileSegmentStream.ReadLong();
        this.mHoleCards[1] = (byte)fileSegmentStream.ReadLong();
        this.mNextHoleCards[0] = (byte)fileSegmentStream.ReadLong();
        this.mNextHoleCards[1] = (byte)fileSegmentStream.ReadLong();
        for (int i2 = 0; i2 < 4; ++i2) {
            this.mPossibleDecision[i2].SetPlayerAction(fileSegmentStream.ReadByte());
            this.mPossibleDecision[i2].SetChip(fileSegmentStream.ReadLong());
        }
        this.mPlayerDecision.SetPlayerAction(fileSegmentStream.ReadByte());
        this.mPlayerDecision.SetChip(fileSegmentStream.ReadLong());
        this.mActionReady = fileSegmentStream.ReadByte() != 0;
        this.mAreCardsShown = fileSegmentStream.ReadBoolean();
    }

    public void ClearPossibleDecisionArray() {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.mPossibleDecision[i2].SetPlayerAction((byte)-1);
            this.mPossibleDecision[i2].SetChip(-1);
        }
    }

    public boolean IsPlayerOutOfTheGame() {
        return this.GetState() == 0;
    }

    public boolean IsPlayerInTheHand() {
        byte by = this.GetState();
        return by == 4 || by == 1 || by == 5 || by == 3;
    }

    public byte[] GetHoleCards() {
        return this.mHoleCards;
    }

    public void SetHoleCards(byte[] byArray) {
        StaticCard.Assign(byArray, this.mHoleCards, 2);
    }

    public void AddNextCard(byte by, int n2) {
        this.mNextHoleCards[n2] = by;
    }

    public int GetHandValue() {
        return this.mHandValue;
    }

    public void SetHandValue(byte[] byArray) {
        byte[] byArray2 = new byte[7];
        StaticCard.Assign(byArray, byArray2, 5);
        byArray2[5] = this.mHoleCards[0];
        byArray2[6] = this.mHoleCards[1];
        HandCalculator handCalculator = new HandCalculator();
        this.mHandValue = handCalculator.GetBestHandValue(byArray2, 7);
        byArray2 = null;
    }

    public PlayerDecision[] GetPossibleDecision() {
        return this.mPossibleDecision;
    }

    public int GetBluffFactor() {
        return this.mBluffFactor;
    }

    public byte[] GetNextHoleCards() {
        return this.mNextHoleCards;
    }

    public void SwitchNextHoleCardToCurrent() {
        StaticCard.Clear(this.mHoleCards, 2);
        this.SetHoleCards(this.mNextHoleCards);
    }

    public void SetCardsShown() {
        this.mAreCardsShown = true;
    }

    public boolean AreCardsShown() {
        return this.mAreCardsShown;
    }

    public void SetName(FlString flString) {
        this.mName = flString;
    }

    public FlString GetName() {
        return this.mName;
    }

    public void CheckBluff(PlayerDecision playerDecision) {
        this.mBluffFactor += this.mLastBluffFactorIncrease;
        if (this.mBluffFactor < 0) {
            this.mBluffFactor = 0;
        }
        if (playerDecision.GetPlayerAction() == 3 || playerDecision.GetPlayerAction() == 4) {
            if (playerDecision.GetChip() == this.mChips) {
                this.mLastBluffFactorIncrease = 6;
            } else if (playerDecision.GetChip() > 30 * TexasGameManager.Get().GetBigBlindValue()) {
                this.mLastBluffFactorIncrease = 4;
            }
        } else {
            this.mLastBluffFactorIncrease = -2;
        }
    }
}

