/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileManager;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.TexasGameManager;

public class GameFactory {
    public PokerGame mGame;
    public GameSettings mSettings;
    public TexasGameManager mTexasManager;
    public boolean mIsPokerGameValid;

    public GameFactory(GameSettings gameSettings) {
        this.mSettings = gameSettings;
    }

    public void destruct() {
        this.ReleaseGame();
    }

    public void CreateNewGame() {
        GameApp.Get().GetCareerState().ResetInGameStack();
        this.CreateGame();
        this.ChooseAIInGame();
        this.mTexasManager.InitializeGame();
        GameApp.Get().GetFileManager().GetInputSegmentStream(this.mSettings.GetSerializedGameObjectId()).SetValidDataFlag(true);
    }

    public void ResumeSavedGame() {
        GameApp gameApp = GameApp.Get();
        FileSegmentStream fileSegmentStream = gameApp.GetFileManager().GetInputSegmentStream(this.mSettings.GetSerializedGameObjectId());
        this.mSettings.SetCurrentGameMode(fileSegmentStream.ReadByte());
        this.mSettings.SetTournamentRound(fileSegmentStream.ReadByte());
        this.CreateGame();
        this.mTexasManager.InitializeGame();
        this.mTexasManager.Load(fileSegmentStream);
        this.mGame.Read(fileSegmentStream);
    }

    public void SaveCurrentGame() {
        GameApp.Get().GetFileManager().WriteObject(4);
        FileSegmentStream fileSegmentStream = GameApp.Get().GetFileManager().GetOutputSegmentStream(this.mSettings.GetSerializedGameObjectId());
        int n2 = this.mSettings.GetCurrentGameMode();
        fileSegmentStream.WriteByte((byte)n2);
        fileSegmentStream.WriteByte((byte)this.mSettings.GetTournamentRound());
        this.mTexasManager.Save(fileSegmentStream);
        this.mGame.Write(fileSegmentStream);
        fileSegmentStream.SetValidDataFlag(true);
        this.SetIsPokerGameValid(false);
    }

    public void DeleteSavedGame() {
        FileManager fileManager = GameApp.Get().GetFileManager();
        int n2 = this.mSettings.GetSerializedGameObjectId();
        fileManager.GetInputSegmentStream(n2).SetValidDataFlag(false);
        fileManager.GetOutputSegmentStream(n2).SetValidDataFlag(false);
        fileManager.GetOutputSegmentStream(n2).ForceModifiedFlag();
    }

    public void ReleaseGame() {
        this.SetIsPokerGameValid(false);
        if (this.mGame != null) {
            this.mGame.ReleaseGame();
            this.mGame = null;
        }
        if (this.mTexasManager != null) {
            this.mTexasManager.ReleaseResources();
            this.mTexasManager = null;
        }
    }

    public void SetIsPokerGameValid(boolean bl) {
        this.mIsPokerGameValid = bl;
    }

    public boolean IsPokerGameValid() {
        return this.mIsPokerGameValid;
    }

    public PokerGame GetGame() {
        return this.mGame;
    }

    public TexasGameManager GetTexasManager() {
        return this.mTexasManager;
    }

    public void CreateGame() {
        this.ReleaseGame();
        this.mGame = new PokerGame();
        this.mTexasManager = new TexasGameManager();
        this.mTexasManager.ResetRules();
        this.mTexasManager.CreateHumanPlayer(PokerTable.GetSeatOfHumanPlayer());
        this.mGame.CreateStatesAndProcesses();
    }

    public void ChooseAIInGame() {
        this.mTexasManager.FillTable();
    }
}

