/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.Softkey;
import ca.jamdat.texasholdem09.TimedPopup;

public class AIDialoguePopup
extends TimedPopup {
    public Text mPlayerActionText;
    public Viewport mBigAIDialogueTextContentViewport;

    public AIDialoguePopup(BaseScene baseScene, Softkey softkey, Softkey softkey2, byte by) {
        super(baseScene, softkey, softkey2, by);
    }

    public void destruct() {
    }

    public void Unload() {
        this.UnloadAIDialoguePopup();
        super.Unload();
    }

    public void Hide() {
        if (this.mId == 8 || this.mId == 7 || this.mId == 9) {
            this.SetAIDialogueTail(false);
            this.UnloadAIDialoguePopup();
        }
        super.Hide();
    }

    public void Shown() {
        if (this.mId == 8 || this.mId == 7 || this.mId == 9) {
            this.SetAIDialogueTail(true);
        }
        super.Shown();
    }

    public int GetAttributes() {
        int n2 = 0;
        switch (this.mId) {
            case 7: 
            case 8: 
            case 9: {
                n2 = 16;
                break;
            }
            default: {
                return super.GetAttributes();
            }
        }
        return n2;
    }

    public void LoadMetaPackage() {
        this.mContentMetaPackage = GameLibrary.GetPackage(1441836);
    }

    public void InitializeSpecificPopup() {
        switch (this.mId) {
            case 8: {
                this.InitSmallDecision();
                break;
            }
            case 7: {
                this.InitBigDecision();
                break;
            }
            case 9: {
                this.InitAIOut();
                break;
            }
        }
    }

    public void UnloadAIDialoguePopup() {
        if (this.mPlayerActionText != null) {
            this.mPlayerActionText.SetCaption(new FlString());
            this.mPlayerActionText = null;
        }
        if (this.mBigAIDialogueTextContentViewport != null) {
            this.mBigAIDialogueTextContentViewport.SetViewport(null);
            this.mBigAIDialogueTextContentViewport = null;
        }
    }

    public void InitSmallDecision() {
        GameApp gameApp = GameApp.Get();
        this.SetAutoHideTime(1500);
        this.InitAIDialogue(0, 5, 6);
        byte by = this.mTexasGameManager.GetPokerTable().GetSeatOfPlayer(this.mTexasGameManager.GetActivePlayer());
        int n2 = 0;
        if (gameApp.GetGameSettings().IsCurrentModeHeadsUp()) {
            by = (byte)(by + 2);
        }
        n2 = by == 1 || by == 2 ? 95 : 51;
        this.mContentViewport.SetTopLeft(this.mContentViewport.GetRectLeft(), (short)n2);
        this.PositionAIDialogueTail(by);
    }

    public void InitBigDecision() {
        Package package_ = this.mContentMetaPackage.GetPackage();
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Viewport viewport = null;
        viewport = Viewport.Cast(package_.GetEntryPoint(8), null);
        this.mBigAIDialogueTextContentViewport = Viewport.Cast(package_.GetEntryPoint(9), null);
        this.mBigAIDialogueTextContentViewport.SetViewport(viewport);
        this.SetAutoHideTime(1958);
        GameLibrary.ReleasePackage(metaPackage);
        this.InitAIDialogue(7, 10, 12);
        byte by = this.mTexasGameManager.GetPokerTable().GetSeatOfPlayer(this.mTexasGameManager.GetActivePlayer());
        this.PositionBigAIDialogue(by);
        GameApp.Get().GetMediaPlayer().StartVibration(175);
    }

    public void InitAIOut() {
        PokerGame pokerGame = GameApp.Get().GetGameFactory().GetGame();
        this.SetAutoHideTime(1500);
        Package package_ = this.mContentMetaPackage.GetPackage();
        Viewport viewport = null;
        this.mContentViewport = Viewport.Cast(package_.GetEntryPoint(7), null);
        viewport = Viewport.Cast(package_.GetEntryPoint(8), null);
        this.mPlayerActionText = Text.Cast(package_.GetEntryPoint(13), null);
        this.mPlayerActionText.SetViewport(viewport);
        byte by = this.mTexasGameManager.GetPokerTable().GetSeatOfPlayer(this.mTexasGameManager.GetEliminatedPlayer());
        FlString flString = null;
        flString = FlString.Cast(package_.GetEntryPoint(14), null);
        this.mPlayerActionText.SetCaption(flString);
        this.PositionBigAIDialogue(by);
        this.CenterAIDialogueText(viewport);
    }

    public void InitAIDialogue(int n2, int n3, int n4) {
        Package package_ = this.mContentMetaPackage.GetPackage();
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_2 = metaPackage.GetPackage();
        PokerPlayer pokerPlayer = this.mTexasGameManager.GetActivePlayer();
        PlayerDecision playerDecision = pokerPlayer.GetDecision();
        int n5 = -1;
        FlString flString = null;
        this.mContentViewport = Viewport.Cast(package_.GetEntryPoint(n2), null);
        this.mPlayerActionText = Text.Cast(package_.GetEntryPoint(n3), null);
        n5 = playerDecision.GetPlayerAction();
        flString = FlString.Cast(package_2.GetEntryPoint(33 + n5), null);
        this.mPlayerActionText.SetCaption(flString);
        if (n5 != 0 && n5 != 1) {
            Text text = null;
            text = Text.Cast(package_.GetEntryPoint(n4), null);
            FlString flString2 = new FlString(playerDecision.GetChip());
            text.SetCaption(flString2);
        }
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void PositionBigAIDialogue(byte by) {
        int n2 = 0;
        if (GameApp.Get().GetGameSettings().IsCurrentModeHeadsUp()) {
            by = (byte)(by + 2);
        }
        n2 = by == 1 || by == 2 ? 95 : 39;
        this.mContentViewport.SetTopLeft(this.mContentViewport.GetRectLeft(), (short)n2);
        this.PositionAIDialogueTail(by);
    }

    public void PositionAIDialogueTail(byte by) {
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        Sprite sprite = null;
        sprite = Sprite.Cast(package_.GetEntryPoint(168), null);
        short s2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (by == 2 || by == 3) {
            bl = true;
        }
        if (by == 2 || by == 1) {
            bl2 = true;
            s2 = 89;
        }
        if (by == 0 || by == 3) {
            s2 = 95;
        }
        sprite.SetFlipX(bl);
        sprite.SetFlipY(bl2);
        sprite.SetTopLeft(sprite.GetRectLeft(), s2);
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void SetAIDialogueTail(boolean bl) {
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        Sprite sprite = null;
        sprite = Sprite.Cast(package_.GetEntryPoint(168), null);
        if (bl) {
            this.SetViewport(sprite.GetViewport());
            sprite.BringToFront();
        }
        sprite.SetVisible(bl);
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void CenterAIDialogueText(Viewport viewport) {
        short s2 = (short)((viewport.GetRectWidth() - this.mPlayerActionText.GetRectWidth()) / 2);
        short s3 = (short)((viewport.GetRectHeight() - this.mPlayerActionText.GetRectHeight()) / 2);
        this.mPlayerActionText.SetTopLeft(s2, s3);
    }
}

