/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlString;
import java.util.Calendar;

public class TimeData {
    public static final byte TD_YEAR = 0;
    public static final byte TD_MONTH = 1;
    public static final byte TD_DAY = 2;
    public static final byte TD_HOUR = 3;
    public static final byte TD_MINUTE = 4;
    public static final byte TD_SECOND = 5;
    public static final byte TD_SIZE = 6;
    public static final byte MonthJanuary = 1;
    public static final byte MonthFebruary = 2;
    public static final byte MonthMarch = 3;
    public static final byte MonthApril = 4;
    public static final byte MonthMay = 5;
    public static final byte MonthJune = 6;
    public static final byte MonthJuly = 7;
    public static final byte MonthAugust = 8;
    public static final byte MonthSeptember = 9;
    public static final byte MonthOctober = 10;
    public static final byte MonthNovember = 11;
    public static final byte MonthDecember = 12;
    public int[] mData = new int[6];

    public TimeData() {
        Calendar calendar = Calendar.getInstance();
        this.mData[1] = calendar.get(2) + 1;
        this.mData[2] = calendar.get(5);
        this.mData[0] = calendar.get(1);
        this.mData[3] = calendar.get(11);
        this.mData[4] = calendar.get(12);
        this.mData[5] = calendar.get(13);
    }

    public TimeData(FlString flString) {
        int n2 = flString.ToLong();
        int n3 = n2 / 1000000;
        int n4 = n2 / 10000 % 100;
        int n5 = n2 % 10000;
        this.mData[1] = n3;
        this.mData[2] = n4;
        this.mData[0] = n5;
        this.mData[3] = 0;
        this.mData[4] = 0;
        this.mData[5] = 0;
    }

    public TimeData(int n2, int n3, int n4) {
        this.mData[1] = n2;
        this.mData[2] = n3;
        this.mData[0] = n4;
        this.mData[3] = 0;
        this.mData[4] = 0;
        this.mData[5] = 0;
    }

    public TimeData(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mData[1] = n2;
        this.mData[2] = n3;
        this.mData[0] = n4;
        this.mData[3] = n5;
        this.mData[4] = n6;
        this.mData[5] = n7;
    }

    public int GetHour() {
        return this.mData[3];
    }

    public int GetMin() {
        return this.mData[4];
    }

    public int GetSec() {
        return this.mData[5];
    }

    public int GetYear() {
        return this.mData[0];
    }

    public int GetMonth() {
        return this.mData[1];
    }

    public int GetDay() {
        return this.mData[2];
    }

    public boolean IsDateValid() {
        int n2 = this.mData[0];
        int n3 = this.mData[1];
        int n4 = this.mData[2];
        if (n3 < 1 || n3 > 12) {
            return false;
        }
        if (n4 < 1) {
            return false;
        }
        if (n3 == 2) {
            if (n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0) {
                return n4 < 30;
            }
            return n4 < 29;
        }
        if (n3 == 1 || n3 == 3 || n3 == 5 || n3 == 7 || n3 == 8 || n3 == 10 || n3 == 12) {
            return n4 < 32;
        }
        return n4 < 31;
    }

    public boolean Equals(TimeData timeData) {
        boolean bl = true;
        for (int i2 = 0; i2 < 6; ++i2) {
            if (this.mData[i2] == timeData.mData[i2]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static TimeData[] InstArrayTimeData(int n2) {
        TimeData[] timeDataArray = new TimeData[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            timeDataArray[i2] = new TimeData();
        }
        return timeDataArray;
    }

    public static TimeData[][] InstArrayTimeData(int n2, int n3) {
        TimeData[][] timeDataArray = new TimeData[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            timeDataArray[i2] = new TimeData[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                timeDataArray[i2][i3] = new TimeData();
            }
        }
        return timeDataArray;
    }

    public static TimeData[][][] InstArrayTimeData(int n2, int n3, int n4) {
        TimeData[][][] timeDataArray = new TimeData[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            timeDataArray[i2] = new TimeData[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                timeDataArray[i2][i3] = new TimeData[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    timeDataArray[i2][i3][i4] = new TimeData();
                }
            }
        }
        return timeDataArray;
    }
}

