/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Box3;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.FVec3T_F32;
import ca.jamdat.flight.Package;

public class Sphere {
    public static final byte typeNumber = 32;
    public static final byte typeID = 32;
    public static final boolean supportsDynamicSerialization = false;
    public FVec3T_F32 center;
    public F32 radius;
    public F32 radiusSquared;

    public static Sphere Cast(Object object, Sphere sphere) {
        return (Sphere)object;
    }

    public Sphere() {
        this.center = new FVec3T_F32();
        this.radius = new F32();
        this.radiusSquared = new F32();
    }

    public Sphere(FVec3T_F32 fVec3T_F32, F32 f32) {
        this.center = new FVec3T_F32(fVec3T_F32);
        this.radius = new F32(f32);
        this.radiusSquared = new F32(f32.DecreasePrecision(8).Square(8));
    }

    public Sphere(Sphere sphere) {
        this.center = new FVec3T_F32(sphere.GetCenter());
        this.radius = new F32(sphere.GetRadius());
        this.radiusSquared = new F32(sphere.GetRadius().DecreasePrecision(8).Square(8));
    }

    public void SetCenter(FVec3T_F32 fVec3T_F32) {
        this.center.Assign(fVec3T_F32);
    }

    public FVec3T_F32 GetCenter() {
        return this.center;
    }

    public void SetRadius(F32 f32) {
        this.radius = f32;
        this.radiusSquared = this.radius.DecreasePrecision(8).Square(8);
    }

    public F32 GetRadius() {
        return this.radius;
    }

    public F32 GetRadiusSquared() {
        return this.radiusSquared;
    }

    public boolean Contains(FVec3T_F32 fVec3T_F32) {
        return fVec3T_F32.Sub(this.center).DecreasePrecision(8).LengthSquared(8).LessOrEqual(this.radiusSquared);
    }

    public boolean Intersects(Box3 box3) {
        F32 f32;
        F32 f322 = new F32(F32.Zero(8));
        if (this.center.x.GreaterThan(box3.maxCorner.x)) {
            f32 = new F32(this.center.x.Sub(box3.maxCorner.x));
            f322 = f322.Add(f32.DecreasePrecision(8).Square(8));
        } else if (this.center.x.LessThan(box3.minCorner.x)) {
            f32 = new F32(this.center.x.Sub(box3.minCorner.x));
            f322 = f322.Add(f32.DecreasePrecision(8).Square(8));
        }
        if (this.center.y.GreaterThan(box3.maxCorner.y)) {
            f32 = new F32(this.center.y.Sub(box3.maxCorner.y));
            f322 = f322.Add(f32.DecreasePrecision(8).Square(8));
        } else if (this.center.y.LessThan(box3.minCorner.y)) {
            f32 = new F32(this.center.y.Sub(box3.minCorner.y));
            f322 = f322.Add(f32.DecreasePrecision(8).Square(8));
        }
        if (this.center.z.GreaterThan(box3.maxCorner.z)) {
            f32 = new F32(this.center.z.Sub(box3.maxCorner.z));
            f322 = f322.Add(f32.DecreasePrecision(8).Square(8));
        } else if (this.center.z.LessThan(box3.minCorner.z)) {
            f32 = new F32(this.center.z.Sub(box3.minCorner.z));
            f322 = f322.Add(f32.DecreasePrecision(8).Square(8));
        }
        return f322.LessOrEqual(this.radiusSquared);
    }

    public boolean IntersectsExtension(Box3 box3, FVec3T_F32 fVec3T_F32, FVec3T_F32 fVec3T_F322, F32 f32, FVec3T_F32 fVec3T_F323, F32 f322) {
        FVec3T_F32 fVec3T_F324 = new FVec3T_F32(FVec3T_F32.Zero(16));
        f32 = F32.Zero(16);
        if (this.center.x.GreaterThan(box3.maxCorner.x)) {
            fVec3T_F324.x = this.center.x.Sub(box3.maxCorner.x);
            f32 = f32.Add(fVec3T_F324.x.Square(16));
        } else if (this.center.x.LessThan(box3.minCorner.x)) {
            fVec3T_F324.x = this.center.x.Sub(box3.minCorner.x);
            f32 = f32.Add(fVec3T_F324.x.Square(16));
        }
        if (this.center.y.GreaterThan(box3.maxCorner.y)) {
            fVec3T_F324.y = this.center.y.Sub(box3.maxCorner.y);
            f32 = f32.Add(fVec3T_F324.y.Square(16));
        } else if (this.center.y.LessThan(box3.minCorner.y)) {
            fVec3T_F324.y = this.center.y.Sub(box3.minCorner.y);
            f32 = f32.Add(fVec3T_F324.y.Square(16));
        }
        if (this.center.z.GreaterThan(box3.maxCorner.z)) {
            fVec3T_F324.z = this.center.z.Sub(box3.maxCorner.z);
            f32 = f32.Add(fVec3T_F324.z.Square(16));
        } else if (this.center.z.LessThan(box3.minCorner.z)) {
            fVec3T_F324.z = this.center.z.Sub(box3.minCorner.z);
            f32 = f32.Add(fVec3T_F324.z.Square(16));
        }
        if (f32.LessOrEqual(this.radius.Add(f322).Square(16))) {
            if (f32.GreaterThan(this.radiusSquared)) {
                fVec3T_F323.Assign(fVec3T_F324.Normalized(16).Neg());
                fVec3T_F32.Assign(this.center.Add(fVec3T_F323.Mul(this.radius, 16)));
                fVec3T_F322.Assign(this.center.Sub(fVec3T_F324));
            }
            return true;
        }
        return false;
    }

    public boolean Intersects(Box3 box3, F32 f32) {
        F32 f322;
        F32 f323 = new F32(F32.Zero(8));
        if (this.center.x.GreaterThan(box3.maxCorner.x)) {
            f322 = new F32(this.center.x.Sub(box3.maxCorner.x));
            f323 = f323.Add(f322.DecreasePrecision(8).Square(8));
        } else if (this.center.x.LessThan(box3.minCorner.x)) {
            f322 = new F32(this.center.x.Sub(box3.minCorner.x));
            f323 = f323.Add(f322.DecreasePrecision(8).Square(8));
        }
        if (this.center.y.GreaterThan(box3.maxCorner.y)) {
            f322 = new F32(this.center.y.Sub(box3.maxCorner.y));
            f323 = f323.Add(f322.DecreasePrecision(8).Square(8));
        } else if (this.center.y.LessThan(box3.minCorner.y)) {
            f322 = new F32(this.center.y.Sub(box3.minCorner.y));
            f323 = f323.Add(f322.DecreasePrecision(8).Square(8));
        }
        if (this.center.z.GreaterThan(box3.maxCorner.z)) {
            f322 = new F32(this.center.z.Sub(box3.maxCorner.z));
            f323 = f323.Add(f322.DecreasePrecision(8).Square(8));
        } else if (this.center.z.LessThan(box3.minCorner.z)) {
            f322 = new F32(this.center.z.Sub(box3.minCorner.z));
            f323 = f323.Add(f322.DecreasePrecision(8).Square(8));
        }
        f322 = new F32(this.radius.Add(f32));
        F32 f324 = new F32(f322.DecreasePrecision(8).Square(8));
        return f323.LessOrEqual(f324);
    }

    public boolean Contains(Box3 box3) {
        boolean bl = box3.minCorner.x.Add(box3.maxCorner.x).Mul(F32.Half(16), 16).GreaterThan(this.center.x);
        boolean bl2 = box3.minCorner.y.Add(box3.maxCorner.y).Mul(F32.Half(16), 16).GreaterThan(this.center.y);
        boolean bl3 = box3.minCorner.z.Add(box3.maxCorner.z).Mul(F32.Half(16), 16).GreaterThan(this.center.z);
        FVec3T_F32 fVec3T_F32 = new FVec3T_F32(bl ? box3.maxCorner.x : box3.minCorner.x, bl2 ? box3.maxCorner.y : box3.minCorner.y, bl3 ? box3.maxCorner.z : box3.minCorner.z);
        return fVec3T_F32.Sub(this.center).DecreasePrecision(8).LengthSquared(8).LessOrEqual(this.radiusSquared);
    }

    public boolean Intersects(Sphere sphere) {
        return this.center.Sub(sphere.center).DecreasePrecision(8).LengthSquared(8).LessOrEqual(this.radiusSquared.Add(sphere.radiusSquared).Add(F32.FromInt(2, 8).Mul(this.radius.DecreasePrecision(8), 8).Mul(sphere.radius.DecreasePrecision(8), 8)));
    }

    public boolean Contains(Sphere sphere) {
        return this.center.Sub(sphere.center).DecreasePrecision(8).LengthSquared(8).LessOrEqual(this.radiusSquared.Add(sphere.radiusSquared).Sub(F32.FromInt(2, 8).Mul(this.radius.DecreasePrecision(8), 8).Mul(sphere.radius.DecreasePrecision(8), 8))) && this.radius.GreaterOrEqual(sphere.radius);
    }

    public Sphere BoundingSphereOfUnion(Sphere sphere) {
        F32 f32 = new F32(this.center.Sub(sphere.center).DecreasePrecision(8).LengthSquared(8));
        boolean bl = f32.LessOrEqual(this.radiusSquared.Add(sphere.radiusSquared).Sub(F32.FromInt(2, 8).Mul(this.radius.DecreasePrecision(8), 8).Mul(sphere.radius.DecreasePrecision(8), 8)));
        if (bl || f32.LessThan(F32.Epsilon(8))) {
            if (this.radius.GreaterOrEqual(sphere.radius)) {
                return this;
            }
            return sphere;
        }
        F32 f322 = new F32(f32.Sqrt(8));
        F32 f323 = new F32(this.radius.Add(sphere.radius).Add(f322).Mul(F32.Half(16), 16));
        F32 f324 = new F32(f322.LessThan(F32.Epsilon(16)) ? F32.Half(16) : f323.Sub(this.radius).Div(f322, 16));
        FVec3T_F32 fVec3T_F32 = new FVec3T_F32(this.center.Add(sphere.center.Sub(this.center).Mul(f324, 16)));
        return new Sphere(fVec3T_F32, f323);
    }

    public void OnSerialize(Package package_) {
        this.center.OnSerialize(package_);
        this.radius = package_.SerializeIntrinsic(this.radius);
        if (package_.IsReading()) {
            this.radiusSquared = this.radius.DecreasePrecision(8).Square(8);
        }
    }

    public Sphere Assign(Sphere sphere) {
        this.center.Assign(sphere.center);
        this.radius = sphere.radius;
        this.radiusSquared = sphere.radiusSquared;
        return this;
    }

    public static Sphere[] InstArraySphere(int n2) {
        Sphere[] sphereArray = new Sphere[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sphereArray[i2] = new Sphere();
        }
        return sphereArray;
    }

    public static Sphere[][] InstArraySphere(int n2, int n3) {
        Sphere[][] sphereArray = new Sphere[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sphereArray[i2] = new Sphere[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                sphereArray[i2][i3] = new Sphere();
            }
        }
        return sphereArray;
    }

    public static Sphere[][][] InstArraySphere(int n2, int n3, int n4) {
        Sphere[][][] sphereArray = new Sphere[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sphereArray[i2] = new Sphere[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                sphereArray[i2][i3] = new Sphere[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    sphereArray[i2][i3][i4] = new Sphere();
                }
            }
        }
        return sphereArray;
    }
}

