/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.MMAPISoundImp;
import ca.jamdat.flight.Sound;
import ca.jamdat.flight.SoundManager;
import javax.microedition.media.control.VolumeControl;

public class MMAPISoundPlayerImp {
    public Sound mSound;
    public MMAPISoundImp mSoundImp;
    public short mVolume = (short)255;
    public boolean mIsLooping;
    public boolean mIsMuted;
    public boolean mIsPaused;
    public int mPlayAgain;

    public void destruct() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Play() {
        block8: {
            MMAPISoundImp mMAPISoundImp = this.mSoundImp;
            if (mMAPISoundImp.GetPlayerState() == 200) {
                mMAPISoundImp.Prefetch();
            }
            try {
                SoundManager soundManager = SoundManager.Get();
                synchronized (soundManager) {
                    if (mMAPISoundImp.GetPlayerState() == 300 && !this.mIsMuted && !SoundManager.Get().IsMuted()) {
                        this.SetNativeVolume();
                        if (this.mIsPaused) {
                            this.mIsPaused = false;
                        }
                        mMAPISoundImp.GetPlayer().start();
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.mPlayAgain >= 20) break block8;
                ++this.mPlayAgain;
                this.Play();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Pause() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                if (!this.IsPlaying()) {
                    return;
                }
                this.mSoundImp.GetPlayer().stop();
                this.mIsPaused = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Stop() {
        MMAPISoundImp mMAPISoundImp = this.mSoundImp;
        if (mMAPISoundImp == null || mMAPISoundImp.GetPlayer() == null) {
            return;
        }
        if (mMAPISoundImp.EvaluateSoundFormatSpec((byte)0)) {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                if (!this.IsPlaying() && !this.IsPaused()) {
                    return;
                }
                if (mMAPISoundImp.EvaluateSoundFormatSpec((byte)1)) {
                    this.Reset(true);
                } else {
                    mMAPISoundImp.Deallocate();
                    this.mIsPaused = false;
                }
            }
        }
        this.Pause();
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                this.mIsPaused = false;
                mMAPISoundImp.GetPlayer().setMediaTime(0L);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsPaused() {
        boolean bl = false;
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            bl = this.mIsPaused;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsPlaying() {
        boolean bl = false;
        MMAPISoundImp mMAPISoundImp = this.mSoundImp;
        if (mMAPISoundImp == null || mMAPISoundImp.GetPlayer() == null) {
            return false;
        }
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            bl = mMAPISoundImp != null && mMAPISoundImp.GetPlayerState() == 400;
        }
        return bl;
    }

    public void SetVolume(short s2) {
        this.mVolume = s2;
        this.SetNativeVolume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short GetVolume() {
        short s2 = 255;
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            s2 = this.mVolume;
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetNativeVolume() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                VolumeControl volumeControl;
                if (this.mSoundImp != null && (volumeControl = (VolumeControl)this.mSoundImp.GetPlayer().getControl("VolumeControl")) != null) {
                    SoundManager.Get();
                    volumeControl.setLevel(SoundManager.CalculateNativePlayerVolume(this.mVolume));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetLooping(boolean bl) {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            this.mIsLooping = bl;
            if (this.mSoundImp != null && this.mSoundImp.GetPlayer() != null) {
                try {
                    this.mSoundImp.GetPlayer().setLoopCount(bl ? -1 : 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsLooping() {
        boolean bl = false;
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            bl = this.mIsLooping;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetMuted(boolean bl) {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            this.mIsMuted = bl;
            if (bl) {
                this.Stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean IsMuted() {
        boolean bl = false;
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            bl = this.mIsMuted;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Reset(boolean bl) {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            if (bl) {
                this.mIsPaused = false;
            }
            this.mSoundImp.ResetSoundPlayer();
            this.SetNativeVolume();
            this.SetLooping(this.mIsLooping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SetSound(Sound sound) {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            if (this.mSoundImp != null) {
                if (this.IsPlaying() || this.IsPaused() && !FrameworkGlobals.GetInstance().application.GetIsSuspended()) {
                    this.Stop();
                }
                if (this.mSound == sound && this.mSoundImp.GetPlayer() != null) {
                    return;
                }
                if (this.mSoundImp.GetPlayerState() != 300 && this.mSoundImp.GetPlayer() != null) {
                    this.mSoundImp.Close();
                }
            }
            this.mSound = sound;
            this.mPlayAgain = 0;
            if (this.mSound != null) {
                MMAPISoundImp mMAPISoundImp;
                this.mSoundImp = mMAPISoundImp = sound.mImplementor;
                if (mMAPISoundImp.GetPlayer() == null) {
                    mMAPISoundImp.CreatePlayer();
                }
                this.SetLooping(this.mIsLooping);
            } else {
                this.mSoundImp = null;
            }
        }
    }

    public Sound GetSound() {
        return this.mSound;
    }

    public static MMAPISoundPlayerImp[] InstArrayMMAPISoundPlayerImp(int n2) {
        MMAPISoundPlayerImp[] mMAPISoundPlayerImpArray = new MMAPISoundPlayerImp[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            mMAPISoundPlayerImpArray[i2] = new MMAPISoundPlayerImp();
        }
        return mMAPISoundPlayerImpArray;
    }

    public static MMAPISoundPlayerImp[][] InstArrayMMAPISoundPlayerImp(int n2, int n3) {
        MMAPISoundPlayerImp[][] mMAPISoundPlayerImpArray = new MMAPISoundPlayerImp[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            mMAPISoundPlayerImpArray[i2] = new MMAPISoundPlayerImp[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                mMAPISoundPlayerImpArray[i2][i3] = new MMAPISoundPlayerImp();
            }
        }
        return mMAPISoundPlayerImpArray;
    }

    public static MMAPISoundPlayerImp[][][] InstArrayMMAPISoundPlayerImp(int n2, int n3, int n4) {
        MMAPISoundPlayerImp[][][] mMAPISoundPlayerImpArray = new MMAPISoundPlayerImp[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            mMAPISoundPlayerImpArray[i2] = new MMAPISoundPlayerImp[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                mMAPISoundPlayerImpArray[i2][i3] = new MMAPISoundPlayerImp[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    mMAPISoundPlayerImpArray[i2][i3][i4] = new MMAPISoundPlayerImp();
                }
            }
        }
        return mMAPISoundPlayerImpArray;
    }
}

