/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FrameworkGlobals;

public class FlMath {
    public static final int maxInt8Value = 127;
    public static final int minInt8Value = -128;
    public static final int maxInt16Value = Short.MAX_VALUE;
    public static final int minInt16Value = Short.MIN_VALUE;
    public static final int maxInt32Value = Integer.MAX_VALUE;
    public static final int minInt32Value = -2147483647;
    public static float epsilon;
    public static float twoPi;
    public static float Pi;
    public static int[] SIN_TABLE;

    public static int IntegerSqrt(int n2) {
        return 0;
    }

    public static short Random(short s2, short s3) {
        if (s3 == s2) {
            return s2;
        }
        return (short)(s2 + FlMath.Rand(true) % (s3 - s2 + 1));
    }

    public static int Random(int n2, int n3) {
        if (n3 == n2) {
            return n2;
        }
        return n2 + FlMath.Rand() % (n3 - n2 + 1);
    }

    public static int Rand(boolean bl) {
        int n2;
        int n3 = n2 = FrameworkGlobals.GetInstance().randomState;
        if (!bl) {
            long l2 = n2;
            l2 = (long)n2 * 214013L + 2531011L;
            n3 = (int)(l2 >> 32) & Integer.MAX_VALUE;
            FrameworkGlobals.GetInstance().randomState = (int)l2;
        } else {
            n2 = n2 * 214013 + 2531011;
            n3 = n2 >> 16 & Short.MAX_VALUE;
            FrameworkGlobals.GetInstance().randomState = n2;
        }
        return n3;
    }

    public static void Seed(int n2) {
        FrameworkGlobals.GetInstance().randomState = n2;
    }

    public static int Modulo(int n2, int n3) {
        if ((n2 %= n3) < 0) {
            n2 += n3;
        }
        return n2;
    }

    public static int Sin1024(int n2) {
        while (n2 > 360) {
            n2 -= 360;
        }
        while (n2 < 0) {
            n2 += 360;
        }
        if (n2 >= 0 && n2 <= 90) {
            return SIN_TABLE[n2];
        }
        if (n2 > 90 && n2 <= 180) {
            return SIN_TABLE[180 - n2];
        }
        if (n2 > 180 && n2 <= 270) {
            return -SIN_TABLE[n2 - 180];
        }
        return -SIN_TABLE[360 - n2];
    }

    public static int Cos1024(int n2) {
        while (n2 > 360) {
            n2 -= 360;
        }
        while (n2 < 0) {
            n2 += 360;
        }
        if (n2 >= 0 && n2 <= 90) {
            return SIN_TABLE[90 - n2];
        }
        if (n2 > 90 && n2 <= 180) {
            return -SIN_TABLE[n2 - 90];
        }
        if (n2 > 180 && n2 <= 270) {
            return -SIN_TABLE[270 - n2];
        }
        return SIN_TABLE[n2 - 270];
    }

    public static byte Absolute(byte by) {
        if (by < 0) {
            by = -by;
        }
        return by;
    }

    public static short Absolute(short s2) {
        if (s2 < 0) {
            s2 = -s2;
        }
        return s2;
    }

    public static int Absolute(int n2) {
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2;
    }

    public static long Absolute(long l2) {
        if (l2 < 0L) {
            l2 = -l2;
        }
        return l2;
    }

    public static F32 Absolute(F32 f32) {
        return f32.Abs();
    }

    public static byte Minimum(byte by, byte by2) {
        if (by < by2) {
            by2 = by;
        }
        return by2;
    }

    public static short Minimum(short s2, short s3) {
        if (s2 < s3) {
            s3 = s2;
        }
        return s3;
    }

    public static int Minimum(int n2, int n3) {
        if (n2 < n3) {
            n3 = n2;
        }
        return n3;
    }

    public static long Minimum(long l2, long l3) {
        if (l2 < l3) {
            l3 = l2;
        }
        return l3;
    }

    public static F32 Minimum(F32 f32, F32 f322) {
        return f32.LessThan(f322) ? f32 : f322;
    }

    public static byte Maximum(byte by, byte by2) {
        if (by > by2) {
            by2 = by;
        }
        return by2;
    }

    public static short Maximum(short s2, short s3) {
        if (s2 > s3) {
            s3 = s2;
        }
        return s3;
    }

    public static int Maximum(int n2, int n3) {
        if (n2 > n3) {
            n3 = n2;
        }
        return n3;
    }

    public static long Maximum(long l2, long l3) {
        if (l2 > l3) {
            l3 = l2;
        }
        return l3;
    }

    public static F32 Maximum(F32 f32, F32 f322) {
        return f32.GreaterThan(f322) ? f32 : f322;
    }

    public static boolean IsOdd(int n2) {
        return (n2 & 1) == 1;
    }

    public static boolean IsEven(int n2) {
        return (n2 & 1) == 0;
    }

    public static boolean IsPowerOf2(int n2) {
        return (n2 & n2 - 1) == 0;
    }

    public static int GetPowerOf2(int n2) {
        if (!FlMath.IsPowerOf2(n2)) {
            return -1;
        }
        int n3 = 0;
        while (n2 >> n3 != 0) {
            ++n3;
        }
        return n3 - 1;
    }

    public static int GetNextPowerOf2(int n2) {
        if (FlMath.IsPowerOf2(n2)) {
            return n2;
        }
        int n3 = 0;
        while (n2 >> n3 != 0) {
            ++n3;
        }
        return 1 << n3;
    }

    public static int Pow(int n2, int n3) {
        if (n2 == 0 || n3 < 0) {
            return 0;
        }
        if (n3 == 0) {
            return 1;
        }
        int n4 = 1;
        while (n3 != 0) {
            if ((n3 & 1) == 1) {
                n4 *= n2;
            }
            n2 *= n2;
            n3 >>= 1;
        }
        return n4;
    }

    public static float Sqrt(float f2) {
        return 0.0f;
    }

    public static float ArcTan(float f2, float f3) {
        return 0.0f;
    }

    public static float Absolute(float f2) {
        return f2 < 0.0f ? -f2 : f2;
    }

    public static float Minimum(float f2, float f3) {
        return f2 < f3 ? f2 : f3;
    }

    public static float Maximum(float f2, float f3) {
        return f2 > f3 ? f2 : f3;
    }

    public static int Round(float f2) {
        return 0;
    }

    public static int Floor(float f2) {
        return 0;
    }

    public static int Ceiling(float f2) {
        return 0;
    }

    public static float SubtractFloor(float f2) {
        return f2 - (float)FlMath.Floor(f2);
    }

    public static boolean AbnormalValue(double d2) {
        return false;
    }

    public static void CheckForAbnormalValue(double d2) {
    }

    public static float NearExponentialDecay(float f2) {
        return 0.0f;
    }

    public static float GetUniformRandom(float f2, float f3) {
        return 0.0f;
    }

    public static float GetGaussianRandom(float f2, float f3) {
        return 0.0f;
    }

    public static int Rand() {
        return FlMath.Rand(false);
    }

    public static float GetUniformRandom() {
        return FlMath.GetUniformRandom(0.0f);
    }

    public static float GetUniformRandom(float f2) {
        return FlMath.GetUniformRandom(f2, 1.0f);
    }

    public static float GetGaussianRandom() {
        return FlMath.GetGaussianRandom(0.0f);
    }

    public static float GetGaussianRandom(float f2) {
        return FlMath.GetGaussianRandom(f2, 1.0f);
    }

    public static FlMath[] InstArrayFlMath(int n2) {
        FlMath[] flMathArray = new FlMath[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            flMathArray[i2] = new FlMath();
        }
        return flMathArray;
    }

    public static FlMath[][] InstArrayFlMath(int n2, int n3) {
        FlMath[][] flMathArray = new FlMath[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flMathArray[i2] = new FlMath[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                flMathArray[i2][i3] = new FlMath();
            }
        }
        return flMathArray;
    }

    public static FlMath[][][] InstArrayFlMath(int n2, int n3, int n4) {
        FlMath[][][] flMathArray = new FlMath[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flMathArray[i2] = new FlMath[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                flMathArray[i2][i3] = new FlMath[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    flMathArray[i2][i3][i4] = new FlMath();
                }
            }
        }
        return flMathArray;
    }

    static {
        SIN_TABLE = new int[]{0, 18, 36, 54, 71, 89, 107, 125, 143, 160, 178, 195, 213, 230, 248, 265, 282, 299, 316, 333, 350, 367, 384, 400, 416, 433, 449, 465, 481, 496, 512, 527, 543, 558, 573, 587, 602, 616, 630, 644, 658, 672, 685, 698, 711, 724, 737, 749, 761, 773, 784, 796, 807, 818, 828, 839, 849, 859, 868, 878, 887, 896, 904, 912, 920, 928, 935, 943, 949, 956, 962, 968, 974, 979, 984, 989, 994, 998, 1002, 1005, 1008, 1011, 1014, 1016, 1018, 1020, 1022, 1023, 1023, 1024, 1024};
    }
}

