/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.CareerState;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.HV;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.TexasGameManager;
import ca.jamdat.texasholdem09.TexasPokerTable;
import ca.jamdat.texasholdem09.Utilities;

public class Statistics {
    public static final byte careerStatPlayStyleFirst = 0;
    public static final byte careerStatHandsDealt = 0;
    public static final byte careerStatHandsFolded = 1;
    public static final byte careerStatFlopSeen = 2;
    public static final byte careerStatRiverSeen = 3;
    public static final byte careerStatShowdowns = 4;
    public static final byte careerStatAmbitionLevel = 5;
    public static final byte careerStatHandsFirst = 6;
    public static final byte careerStatThreeOfAKind = 6;
    public static final byte careerStatStraight = 7;
    public static final byte careerStatFlush = 8;
    public static final byte careerStatFullHouse = 9;
    public static final byte careerStatFourOfAKind = 10;
    public static final byte careerStatStraightFlush = 11;
    public static final byte careerStatRoyalFlush = 12;
    public static final byte careerStatMoneyFirst = 13;
    public static final byte careerStatPotsWon = 13;
    public static final byte careerStatAveragePot = 14;
    public static final byte careerStatBiggestPot = 15;
    public static final byte careerStatTotalEarnings = 16;
    public static final byte careerStatROI = 17;
    public static final byte careerStatTournamentsFirst = 18;
    public static final byte careerStatTournamentsWon = 18;
    public static final byte careerStatTournamentsInTheMoney = 19;
    public static final byte careerStatExtraFirst = 20;
    public static final byte careerStatNbrGames = 20;
    public static final byte careerStatNbrTournaments = 21;
    public static final byte careerStatTotalBuyInInvestments = 22;
    public static final byte careerStatTotalPotsWon = 23;
    public static final byte careerStatsCount = 24;
    public static final byte careerStatsPlayStyleCount = 6;
    public static final byte careerStatsHandsCount = 7;
    public static final byte careerStatsMoneyCount = 5;
    public static final byte careerStatsTournamentsCount = 2;
    public static final byte inGameStatHandsDealt = 0;
    public static final byte inGameStatTotalFlopSeen = 1;
    public static final byte inGameStatFlopSeenInBigBlind = 2;
    public static final byte inGameStatFlopSeenInSmallBlind = 3;
    public static final byte inGameStatFlopSeenOther = 4;
    public static final byte inGameStatHandsFolded = 5;
    public static final byte inGameStatRiverSeen = 6;
    public static final byte inGameStatPotsWon = 7;
    public static final byte inGameStatPotsWonAtShowdown = 8;
    public static final byte inGameStatsCount = 9;
    public boolean[] mCareerMilestones = null;
    public boolean[] mInGameMilestones = null;
    public int[] mCareerStats = null;
    public int[] mInGameStats = null;
    public int[] mInGamePracticeStats = null;
    public int mNbConsecutiveRegularGameWon;

    public Statistics() {
        this.ResetAll();
    }

    public void destruct() {
        this.mCareerStats = null;
        this.mInGameStats = null;
        this.mInGamePracticeStats = null;
    }

    public void Reset() {
        if (this.IsPractice()) {
            this.ResetInGamePracticeStats();
        } else {
            this.ResetInGameStats();
        }
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        if (fileSegmentStream.HasValidData()) {
            int n2;
            int n3 = 0;
            for (n3 = 0; n3 < 24; ++n3) {
                n2 = fileSegmentStream.ReadLong();
                this.mCareerStats[n3] = n2 > 0 ? n2 : 0;
            }
            for (n3 = 0; n3 < 9; ++n3) {
                n2 = fileSegmentStream.ReadLong();
                this.mInGameStats[n3] = n2 > 0 ? n2 : 0;
            }
            n2 = fileSegmentStream.ReadLong();
            this.mNbConsecutiveRegularGameWon = n2 > 0 ? n2 : 0;
        }
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        int n2 = 0;
        for (n2 = 0; n2 < 24; ++n2) {
            fileSegmentStream.WriteLong(this.mCareerStats[n2]);
        }
        for (n2 = 0; n2 < 9; ++n2) {
            fileSegmentStream.WriteLong(this.mInGameStats[n2]);
        }
        fileSegmentStream.WriteLong(this.mNbConsecutiveRegularGameWon);
        fileSegmentStream.SetValidDataFlag(true);
    }

    public int GetCareerStat(byte by) {
        if (Statistics.RequiresPct(by, true)) {
            return this.GetCareerPctStat(by);
        }
        return this.mCareerStats[by];
    }

    public int GetInGameStat(byte by) {
        if (Statistics.RequiresPct(by, false)) {
            return this.GetInGamePctStat(by);
        }
        if (this.IsPractice()) {
            return this.mInGamePracticeStats[by];
        }
        return this.mInGameStats[by];
    }

    public void OnGameStart() {
        GameApp gameApp = GameApp.Get();
        GameSettings gameSettings = gameApp.GetGameSettings();
        CareerState careerState = gameApp.GetCareerState();
        boolean bl = gameSettings.IsCurrentModeTournament();
        int n2 = gameSettings.GetBuyInCost();
        int n3 = careerState.GetBankRoll();
        this.IncrementCareerStat((byte)20);
        this.IncrementCareerStat((byte)22, n2);
        int n4 = n2 / n3;
        this.IncrementCareerStat((byte)5, n4);
        if (bl) {
            this.IncrementCareerStat((byte)21);
        }
    }

    public void OnHandDealt() {
        this.IncrementInGameStat((byte)0);
        this.IncrementCareerStat((byte)0);
    }

    public void OnFlop() {
        if (this.IsHumanPlayerInTheHand()) {
            GameApp gameApp = GameApp.Get();
            TexasGameManager texasGameManager = TexasGameManager.Get();
            PokerPlayer pokerPlayer = gameApp.GetGameFactory().GetGame().GetTexasPokerTable().GetHumanPlayer();
            this.IncrementCareerStat((byte)2);
            this.IncrementInGameStat((byte)1);
            if (texasGameManager.GetBigBlindPlayer() == pokerPlayer) {
                this.IncrementInGameStat((byte)2);
            } else if (texasGameManager.GetSmallBlindPlayer() == pokerPlayer) {
                this.IncrementInGameStat((byte)3);
            } else {
                this.IncrementInGameStat((byte)4);
            }
        }
    }

    public void OnRiver() {
        if (this.IsHumanPlayerInTheHand()) {
            this.IncrementInGameStat((byte)6);
            this.IncrementCareerStat((byte)3);
        }
    }

    public void OnFold() {
        this.IncrementInGameStat((byte)5);
        this.IncrementCareerStat((byte)1);
    }

    public void OnShowdown() {
        if (this.IsHumanPlayerInTheHand()) {
            this.IncrementCareerStat((byte)4);
            byte by = HV.GetType(GameApp.Get().GetGameFactory().GetGame().GetTexasPokerTable().GetHumanPlayer().GetHandValue());
            switch (by) {
                case 3: {
                    this.IncrementCareerStat((byte)6);
                    break;
                }
                case 4: {
                    this.IncrementCareerStat((byte)7);
                    break;
                }
                case 5: {
                    this.IncrementCareerStat((byte)8);
                    break;
                }
                case 6: {
                    this.IncrementCareerStat((byte)9);
                    break;
                }
                case 7: {
                    this.IncrementCareerStat((byte)10);
                    break;
                }
                case 8: {
                    this.IncrementCareerStat((byte)11);
                    break;
                }
                case 9: {
                    this.IncrementCareerStat((byte)12);
                    break;
                }
            }
        }
    }

    public void OnHandCompleted() {
        PokerPlayer pokerPlayer = GameApp.Get().GetGameFactory().GetGame().GetTexasPokerTable().GetHumanPlayer();
        if (pokerPlayer.GetChipWon() > 0) {
            int n2 = pokerPlayer.GetChipWon();
            TexasGameManager texasGameManager = TexasGameManager.Get();
            if (texasGameManager.GetTexasHandStep() == 10) {
                this.IncrementInGameStat((byte)8);
            }
            this.IncrementInGameStat((byte)7);
            this.IncrementCareerStat((byte)13);
            this.IncrementCareerStat((byte)23, n2);
            if (this.GetCareerStat((byte)15) < n2) {
                this.SetCareerStat((byte)15, n2);
            }
            if (!this.IsPractice()) {
                int n3 = this.GetCareerStat((byte)23) / this.GetCareerStat((byte)13);
                this.SetCareerStat((byte)14, n3);
            }
        }
    }

    public void OnGameCompleted() {
        this.OnGameFinished();
    }

    public void OnGameAbandoned() {
        this.OnGameFinished();
    }

    public static boolean RequiresPct(int n2, boolean bl) {
        return bl ? (byte)n2 == 1 || (byte)n2 == 2 || (byte)n2 == 3 || (byte)n2 == 4 || (byte)n2 == 5 || (byte)n2 == 17 || (byte)n2 == 19 : (byte)n2 == 1 || (byte)n2 == 2 || (byte)n2 == 3 || (byte)n2 == 4 || (byte)n2 == 5 || (byte)n2 == 6 || (byte)n2 == 7 || (byte)n2 == 8;
    }

    public void OnGameFinished() {
        if (this.IsPractice()) {
            return;
        }
        GameApp gameApp = GameApp.Get();
        GameSettings gameSettings = gameApp.GetGameSettings();
        CareerState careerState = gameApp.GetCareerState();
        int n2 = 0;
        int n3 = careerState.GetInGameStack();
        switch (gameSettings.GetCurrentGameMode()) {
            case 0: {
                n2 = this.HandleHeadsUpFinished(n3);
                break;
            }
            case 1: {
                n2 = this.HandleStandardGameFinished(n3);
                break;
            }
            case 2: {
                n2 = this.HandleTournamentFinished();
                break;
            }
            case 3: {
                n2 = this.HandleProGameFinished(n3);
                break;
            }
        }
        if (n2 > 0) {
            this.IncrementCareerStat((byte)16, n2 - gameSettings.GetBuyInCost());
        }
        careerState.ResetInGameStack();
        int n4 = this.GetCareerStat((byte)16);
        this.SetCareerStat((byte)17, n4);
    }

    public void ResetAll() {
        this.ResetCareerStats();
        this.ResetInGameStats();
        this.ResetInGamePracticeStats();
    }

    public void ResetInGameStats() {
        this.mInGameStats = null;
        this.mInGameStats = new int[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            this.mInGameStats[i2] = 0;
        }
    }

    public void ResetInGamePracticeStats() {
        this.mInGamePracticeStats = null;
        this.mInGamePracticeStats = new int[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            this.mInGamePracticeStats[i2] = 0;
        }
    }

    public void ResetCareerStats() {
        this.mCareerStats = null;
        this.mCareerStats = new int[24];
        for (int i2 = 0; i2 < 24; ++i2) {
            this.mCareerStats[i2] = 0;
        }
    }

    public int GetCareerPctStat(byte by) {
        switch (by) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.mCareerStats[0] != 0 ? 100 * this.mCareerStats[by] / this.mCareerStats[0] : 0;
            }
            case 5: {
                return this.mCareerStats[20] != 0 ? 100 * this.mCareerStats[by] / this.mCareerStats[20] : 0;
            }
            case 17: {
                return this.mCareerStats[22] != 0 ? 100 * this.mCareerStats[by] / this.mCareerStats[22] : 0;
            }
            case 19: {
                return this.mCareerStats[21] != 0 ? 100 * this.mCareerStats[by] / this.mCareerStats[21] : 0;
            }
        }
        return 0;
    }

    public int GetInGamePctStat(byte by) {
        if (this.IsPractice()) {
            return this.mInGamePracticeStats[0] != 0 ? 100 * this.mInGamePracticeStats[by] / this.mInGamePracticeStats[0] : 0;
        }
        return this.mInGameStats[0] != 0 ? 100 * this.mInGameStats[by] / this.mInGameStats[0] : 0;
    }

    public boolean IsPractice() {
        return GameApp.Get().GetGameSettings().IsPractice();
    }

    public boolean IsHumanPlayerInTheHand() {
        return TexasPokerTable.Get().GetHumanPlayer().IsPlayerInTheHand();
    }

    public void SetCareerStat(byte by, int n2) {
        if (!this.IsPractice()) {
            this.mCareerStats[by] = Utilities.ValidateLongValue(n2);
        }
    }

    public void IncrementCareerStat(byte by, int n2) {
        if (!this.IsPractice()) {
            this.mCareerStats[by] = Utilities.ValidateLongValue(this.mCareerStats[by] + n2);
        }
    }

    public void IncrementInGameStat(byte by, int n2) {
        if (this.IsPractice()) {
            this.mInGamePracticeStats[by] = Utilities.ValidateLongValue(this.mInGamePracticeStats[by] + n2);
        } else {
            this.mInGameStats[by] = Utilities.ValidateLongValue(this.mInGameStats[by] + n2);
        }
    }

    public int HandleTournamentFinished() {
        GameSettings gameSettings = GameApp.Get().GetGameSettings();
        CareerState careerState = GameApp.Get().GetCareerState();
        int n2 = 0;
        if (careerState.GetInGameRank() <= 4) {
            this.IncrementCareerStat((byte)19);
            n2 = GameSettings.GetTournamentPrize(gameSettings.GetLocation(), careerState.GetInGameRank()) - gameSettings.GetBuyInCost();
        }
        if (careerState.GetInGameRank() == 0) {
            this.IncrementCareerStat((byte)18);
        }
        return n2;
    }

    public int HandleHeadsUpFinished(int n2) {
        int n3 = 0;
        if (n2 > 0) {
            n3 = n2;
        }
        return n3;
    }

    public int HandleStandardGameFinished(int n2) {
        int n3 = 0;
        if (n2 > 0) {
            n3 = n2;
            ++this.mNbConsecutiveRegularGameWon;
            if (this.mNbConsecutiveRegularGameWon >= 3) {
                this.mNbConsecutiveRegularGameWon = 0;
            }
        } else {
            this.mNbConsecutiveRegularGameWon = 0;
        }
        return n3;
    }

    public int HandleProGameFinished(int n2) {
        int n3 = 0;
        if (n2 > 0) {
            n3 = 1000000;
        }
        return n3;
    }

    public void IncrementCareerStat(byte by) {
        this.IncrementCareerStat(by, 1);
    }

    public void IncrementInGameStat(byte by) {
        this.IncrementInGameStat(by, 1);
    }

    public static Statistics[] InstArrayStatistics(int n2) {
        Statistics[] statisticsArray = new Statistics[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            statisticsArray[i2] = new Statistics();
        }
        return statisticsArray;
    }

    public static Statistics[][] InstArrayStatistics(int n2, int n3) {
        Statistics[][] statisticsArray = new Statistics[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            statisticsArray[i2] = new Statistics[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                statisticsArray[i2][i3] = new Statistics();
            }
        }
        return statisticsArray;
    }

    public static Statistics[][][] InstArrayStatistics(int n2, int n3, int n4) {
        Statistics[][][] statisticsArray = new Statistics[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            statisticsArray[i2] = new Statistics[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                statisticsArray[i2][i3] = new Statistics[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    statisticsArray[i2][i3][i4] = new Statistics();
                }
            }
        }
        return statisticsArray;
    }
}

