/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerState;

public class StateGameOver
extends PokerState {
    public static final byte kUndefined = -1;
    public static final byte kCompletingGame = 0;
    public static final byte kShowGameOverPopup = 1;
    public static final byte kLeavingGameScene = 2;
    public static final byte kReadyForGameSceneUnload = 3;
    public byte mStateStage = (byte)-1;
    public boolean mUserWon;

    public StateGameOver(PokerGame pokerGame) {
        super(pokerGame);
    }

    public void destruct() {
    }

    public byte GetID() {
        return 10;
    }

    public void OnEntry() {
        this.mGameScene.UpdateAcceptSoftKey();
        this.mGameScene.DisableDeclineSoftKey();
        if (this.mStateStage == -1) {
            this.SetStage((byte)0);
        }
    }

    public void OnSkip() {
        this.HidePopup();
        super.OnSkip();
    }

    public void OnTime(int n2, int n3) {
        this.ManageState();
        super.OnTime(n2, n3);
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        this.mStateStage = fileSegmentStream.ReadByte();
        this.mUserWon = fileSegmentStream.ReadBoolean();
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte(this.mStateStage);
        fileSegmentStream.WriteBoolean(this.mUserWon);
    }

    public void ManageState() {
        GameApp gameApp = GameApp.Get();
        GameSettings gameSettings = gameApp.GetGameSettings();
        switch (this.mStateStage) {
            case 0: {
                boolean bl = this.mUserWon = this.mPokerGame.GetTexasPokerTable().GetHumanPlayer().GetChip() > 0;
                if (!gameSettings.IsPractice()) {
                    if (this.mUserWon) {
                        int n2 = this.mPokerGame.GetTexasPokerTable().GetHeroCharacterAtTable();
                        gameApp.GetCareerState().OnVictory(n2);
                    } else {
                        gameApp.GetCareerState().OnElimination();
                    }
                    gameApp.GetStatistics().OnGameCompleted();
                }
                this.SetStage((byte)1);
                break;
            }
            case 1: {
                int n3 = 2000;
                if (this.mUserWon) {
                    this.HandlePopup((byte)16);
                    n3 = -1;
                }
                this.SetStage((byte)2, n3);
                break;
            }
            case 2: {
                gameApp.GetCareerState().ResetGameMenuGameMode();
                gameApp.GetGameFactory().DeleteSavedGame();
                gameApp.GetStatistics().Reset();
                if (gameSettings.IsPractice()) {
                    this.mGameScene.OnCommand(-86);
                } else {
                    this.mGameScene.OnCommand(-88);
                }
                this.SetStage((byte)3);
                break;
            }
        }
    }

    public void SetStage(byte by, int n2) {
        this.mStateStage = by;
        this.SetWaitingTime(n2);
    }

    public void SetStage(byte by) {
        this.SetStage(by, -1);
    }
}

