/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.SoundPlayer;
import ca.jamdat.flight.VibrationManager;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.SoundResourcesHandler;

public class MediaPlayer {
    public SoundResourcesHandler mSoundResourcesHandler;
    public SoundPlayer mSoundPlayer;
    public boolean mSoundEnabled;
    public int mLatestSoundId = 25;

    public MediaPlayer() {
        this.ReadDeviceSoundProfile();
        this.mSoundResourcesHandler = new SoundResourcesHandler();
        this.mSoundPlayer = SoundManager.Get().GetChannelSoundPlayer(0);
        this.mSoundEnabled = true;
        boolean bl = true;
        VibrationManager.Get().SetEnabled(bl);
    }

    public void destruct() {
        this.mSoundResourcesHandler = null;
        this.StopSound();
        this.mSoundPlayer = null;
    }

    public void PlayMusic(int n2, boolean bl, boolean bl2) {
        this.PlaySound(n2, bl, bl2);
    }

    public void StopMusic(boolean bl) {
        this.StopSound();
    }

    public void PlayGameSceneSoundFX(int n2, boolean bl, boolean bl2) {
        PokerGame pokerGame = GameApp.Get().GetGameFactory().GetGame();
        if (!pokerGame.IsInSkipMode()) {
            this.PlaySoundFx(n2, bl, bl2);
        }
    }

    public void PlaySoundFx(int n2, boolean bl, boolean bl2) {
        this.StopSound();
        this.PlaySound(n2, bl, bl2);
    }

    public void StopSoundFx(boolean bl) {
        this.mSoundPlayer.Stop();
        this.mSoundPlayer.SetSound(null);
    }

    public void StartVibration(int n2) {
        if (this.IsVibrationEnabled_()) {
            VibrationManager.Get().Start(n2);
        }
    }

    public void StopVibration() {
        VibrationManager.Get().Stop();
    }

    public void SetMenuSoundsPackage(MetaPackage metaPackage) {
        this.mSoundResourcesHandler.SetMenuSoundsPackage(metaPackage);
    }

    public void SetCommonSoundsPackage(MetaPackage metaPackage) {
        this.mSoundResourcesHandler.SetCommonSoundsPackage(metaPackage);
    }

    public void SetGameSoundsPackage(MetaPackage metaPackage) {
        this.mSoundResourcesHandler.SetGameSoundsPackage(metaPackage);
    }

    public void Terminate() {
        this.StopVibration();
        this.StopSound();
    }

    public void ReadDeviceSoundProfile() {
    }

    public boolean IsDeviceSoundProfileMuted() {
        return false;
    }

    public int GetLatestSoundId() {
        return this.mLatestSoundId;
    }

    public void PlaySound(int n2, boolean bl, boolean bl2) {
        if (this.mSoundEnabled) {
            this.mSoundPlayer.SetSound(this.mSoundResourcesHandler.GetSound(n2));
            this.mSoundPlayer.SetLooping(bl);
            this.mSoundPlayer.Play();
            this.mLatestSoundId = n2;
        }
    }

    public void StopSound() {
        this.mSoundPlayer.Stop();
        this.mSoundPlayer.SetSound(null);
    }

    public void SetSoundEnabled_(boolean bl) {
        this.mSoundEnabled = bl;
        if (!bl) {
            this.mSoundPlayer.Stop();
        }
    }

    public boolean IsSoundEnabled_() {
        return this.mSoundEnabled;
    }

    public void SetSoundVolume_(short s2) {
        this.mSoundPlayer.SetVolume(s2);
    }

    public short GetSoundVolume_() {
        return this.mSoundPlayer.GetVolume();
    }

    public void SetVibrationEnabled_(boolean bl) {
        VibrationManager.Get().SetEnabled(bl);
    }

    public boolean IsVibrationEnabled_() {
        return VibrationManager.Get().IsEnabled();
    }

    public void PlayMusic(int n2) {
        this.PlayMusic(n2, false);
    }

    public void PlayMusic(int n2, boolean bl) {
        this.PlayMusic(n2, bl, false);
    }

    public void StopMusic() {
        this.StopMusic(false);
    }

    public void PlayGameSceneSoundFX(int n2) {
        this.PlayGameSceneSoundFX(n2, false);
    }

    public void PlayGameSceneSoundFX(int n2, boolean bl) {
        this.PlayGameSceneSoundFX(n2, bl, false);
    }

    public void PlaySoundFx(int n2) {
        this.PlaySoundFx(n2, false);
    }

    public void PlaySoundFx(int n2, boolean bl) {
        this.PlaySoundFx(n2, bl, false);
    }

    public void StopSoundFx() {
        this.StopSoundFx(false);
    }

    public static MediaPlayer[] InstArrayMediaPlayer(int n2) {
        MediaPlayer[] mediaPlayerArray = new MediaPlayer[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            mediaPlayerArray[i2] = new MediaPlayer();
        }
        return mediaPlayerArray;
    }

    public static MediaPlayer[][] InstArrayMediaPlayer(int n2, int n3) {
        MediaPlayer[][] mediaPlayerArray = new MediaPlayer[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            mediaPlayerArray[i2] = new MediaPlayer[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                mediaPlayerArray[i2][i3] = new MediaPlayer();
            }
        }
        return mediaPlayerArray;
    }

    public static MediaPlayer[][][] InstArrayMediaPlayer(int n2, int n3, int n4) {
        MediaPlayer[][][] mediaPlayerArray = new MediaPlayer[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            mediaPlayerArray[i2] = new MediaPlayer[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                mediaPlayerArray[i2][i3] = new MediaPlayer[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    mediaPlayerArray[i2][i3][i4] = new MediaPlayer();
                }
            }
        }
        return mediaPlayerArray;
    }
}

