/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BlCharacter;
import ca.jamdat.flight.BlJsonArray;
import ca.jamdat.flight.BlJsonBoolean;
import ca.jamdat.flight.BlJsonElement;
import ca.jamdat.flight.BlJsonNull;
import ca.jamdat.flight.BlJsonNumber;
import ca.jamdat.flight.BlJsonObject;
import ca.jamdat.flight.BlJsonString;
import ca.jamdat.flight.BlMath;
import ca.jamdat.flight.BlString;

public class BlJsonParser {
    public static final int MARKER_NONE = 0;
    public static final int MARKER_NULL = 1;
    public static final int MARKER_BOOLEAN = 2;
    public static final int MARKER_NUMBER = 3;
    public static final int MARKER_STRING = 4;
    public static final int MARKER_ARRAY_START = 5;
    public static final int MARKER_ARRAY_END = 6;
    public static final int MARKER_OBJECT_START = 7;
    public static final int MARKER_OBJECT_ASSIGN = 8;
    public static final int MARKER_OBJECT_END = 9;
    public static final int MARKER_NEXT = 10;
    public static final int MARKER_COMMENT_START = 11;
    public static final int MARKER_COMMENT_END = 12;
    public static final int MARKER_PAIR = 13;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_ENDED_BEFORE_END = 1;
    public static final int ERROR_STRING_CORRUPTED = 2;
    public static final int ERROR_NUMBER_INVALID = 3;
    public BlString mInput;
    public int mInputPosition;
    public BlJsonElement mCurrentElement;
    public int mErrorId;

    public static BlJsonElement Parse(BlString blString) {
        BlJsonParser blJsonParser = new BlJsonParser(blString);
        return blJsonParser.ReadElement();
    }

    public BlJsonParser(BlString blString) {
        this.mInput = new BlString(blString);
        this.mErrorId = 0;
    }

    public BlJsonParser(BlJsonParser blJsonParser) {
        this.mInput = new BlString();
    }

    public BlJsonElement ReadElement() {
        BlJsonElement blJsonElement = null;
        if (!this.IsEnded()) {
            switch (this.ReadToMarker()) {
                case 1: {
                    blJsonElement = this.ReadNull();
                    break;
                }
                case 2: {
                    blJsonElement = this.ReadBoolean();
                    break;
                }
                case 3: {
                    blJsonElement = this.ReadNumber();
                    break;
                }
                case 4: {
                    blJsonElement = this.ReadString();
                    break;
                }
                case 5: {
                    blJsonElement = this.ReadArray();
                    break;
                }
                case 7: {
                    blJsonElement = this.ReadObject();
                    break;
                }
                case 11: {
                    blJsonElement = this.ReadComment();
                    break;
                }
                default: {
                    blJsonElement = null;
                }
            }
        }
        if (this.mErrorId != 0) {
            blJsonElement = null;
        }
        return blJsonElement;
    }

    public int ReadToMarker() {
        while (!this.IsEnded() && this.IsWhiteSpace()) {
            this.Skip(1);
        }
        if (!this.IsEnded()) {
            return this.IdentifyMarker();
        }
        return 0;
    }

    public int IdentifyMarker() {
        if (!this.IsEnded()) {
            switch (this.mInput.GetCharAt(this.mInputPosition)) {
                case '\"': {
                    return 4;
                }
                case ':': {
                    return 8;
                }
                case '{': {
                    return 7;
                }
                case '}': {
                    return 9;
                }
                case '[': {
                    return 5;
                }
                case ']': {
                    return 6;
                }
                case ',': {
                    return 10;
                }
                case 'f': 
                case 't': {
                    return 2;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return 3;
                }
                case '/': {
                    return 11;
                }
                case 'n': {
                    return 1;
                }
            }
        }
        return 0;
    }

    public boolean IsEnded() {
        return this.mErrorId == 0 && this.mInput.GetLength() <= this.mInputPosition;
    }

    public boolean IsWhiteSpace() {
        return BlCharacter.IsWhiteSpace(this.mInput.GetCharAt(this.mInputPosition));
    }

    public boolean IsPostElementMarker() {
        switch (this.IdentifyMarker()) {
            case 6: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean Skip(int n2) {
        this.mInputPosition += n2;
        return !this.IsEnded();
    }

    public boolean FindStringAtCurrentPosition(BlString blString) {
        if (this.mInput.GetLength() < this.mInputPosition + blString.GetLength()) {
            return false;
        }
        for (int i2 = 0; i2 < blString.GetLength(); ++i2) {
            if (blString.GetCharAt(i2) == this.mInput.GetCharAt(this.mInputPosition + i2)) continue;
            return false;
        }
        return true;
    }

    public BlString ParseString() {
        BlString blString = new BlString();
        if (this.ReadToMarker() == 4) {
            this.Skip(1);
            block11: while (!this.IsEnded() && '\"' != this.mInput.GetCharAt(this.mInputPosition)) {
                char c2 = this.mInput.GetCharAt(this.mInputPosition);
                this.Skip(1);
                if (!this.IsEnded() && c2 == '\\') {
                    c2 = this.mInput.GetCharAt(this.mInputPosition++);
                    switch (c2) {
                        case '/': {
                            blString.Append('/');
                            continue block11;
                        }
                        case '\"': {
                            blString.Append('\"');
                            continue block11;
                        }
                        case '\\': {
                            blString.Append('\\');
                            continue block11;
                        }
                        case 'b': {
                            blString.Append('\b');
                            continue block11;
                        }
                        case 'f': {
                            blString.Append('\f');
                            continue block11;
                        }
                        case 'n': {
                            blString.Append('\n');
                            continue block11;
                        }
                        case 'r': {
                            blString.Append('\r');
                            continue block11;
                        }
                        case 't': {
                            blString.Append('\t');
                            continue block11;
                        }
                        case 'u': {
                            blString.Append("\\u");
                            continue block11;
                        }
                    }
                    blString.Append('\\');
                    blString.Append(c2);
                    continue;
                }
                blString.Append(c2);
            }
            if (this.ReadToMarker() == 4) {
                this.Skip(1);
            }
        }
        return blString;
    }

    public double ParseNumber() {
        if (this.IdentifyMarker() == 3) {
            BlString blString = new BlString("0123456789.eE");
            double d2 = 0.0;
            int n2 = -1;
            boolean bl = false;
            int n3 = 1;
            if ('-' == this.mInput.GetCharAt(this.mInputPosition)) {
                bl = true;
                this.Skip(1);
                if (this.IdentifyMarker() != 3) {
                    this.FailBuildingStructure();
                    return 0.0;
                }
            }
            int n4 = 0;
            do {
                char c2;
                if ((c2 = this.mInput.GetCharAt(this.mInputPosition++)) == '.') {
                    if (n2 == -1) {
                        n2 = n4;
                        continue;
                    }
                    this.FailBuildingStructure();
                    return 0.0;
                }
                ++n4;
                d2 = (long)((double)n3 * d2) + (long)(c2 - 48);
                n3 = 10;
            } while (!this.IsEnded() && -1 != blString.Find(this.mInput.GetCharAt(this.mInputPosition)));
            if (n2 != -1) {
                d2 /= (double)BlMath.Pow(10, n4 - n2);
            }
            if (bl) {
                d2 = -d2;
            }
            return d2;
        }
        return 0.0;
    }

    public BlJsonElement ReadNull() {
        BlJsonNull blJsonNull = null;
        BlString blString = new BlString("null");
        if (this.FindStringAtCurrentPosition(blString)) {
            this.Skip(4);
            if (this.IsEnded() || this.IsWhiteSpace() || this.IsPostElementMarker()) {
                blJsonNull = new BlJsonNull();
            }
        }
        if (null == blJsonNull) {
            this.FailBuildingStructure();
        }
        return blJsonNull;
    }

    public BlJsonElement ReadBoolean() {
        BlJsonBoolean blJsonBoolean = null;
        BlString blString = new BlString("false");
        BlString blString2 = new BlString("true");
        if (this.FindStringAtCurrentPosition(blString)) {
            blJsonBoolean = new BlJsonBoolean(false);
            this.Skip(5);
        } else if (this.FindStringAtCurrentPosition(blString2)) {
            blJsonBoolean = new BlJsonBoolean(true);
            this.Skip(4);
        }
        if (null == blJsonBoolean || !this.IsEnded() && !this.IsWhiteSpace() && !this.IsPostElementMarker()) {
            this.FailBuildingStructure();
        }
        return blJsonBoolean;
    }

    public BlJsonElement ReadNumber() {
        BlJsonNumber blJsonNumber = null;
        blJsonNumber = new BlJsonNumber(this.ParseNumber());
        return blJsonNumber;
    }

    public BlJsonElement ReadString() {
        BlJsonString blJsonString = null;
        blJsonString = new BlJsonString();
        BlString blString = new BlString(this.ParseString());
        blJsonString.SetValue(blString);
        return blJsonString;
    }

    public BlJsonElement ReadArray() {
        BlJsonArray blJsonArray = null;
        if (this.IdentifyMarker() == 5) {
            this.Skip(1);
            BlJsonElement blJsonElement = null;
            boolean bl = this.ReadToMarker() != 6;
            blJsonArray = new BlJsonArray();
            while (bl) {
                bl = false;
                blJsonElement = this.ReadElement();
                if (null != blJsonElement) {
                    blJsonArray.Append(blJsonElement);
                    if (this.ReadToMarker() != 10) continue;
                    this.Skip(1);
                    bl = true;
                    continue;
                }
                this.FailBuildingStructure();
            }
            if (this.ReadToMarker() == 6) {
                this.Skip(1);
            } else {
                this.FailBuildingStructure();
            }
        } else {
            this.FailBuildingStructure();
        }
        return blJsonArray;
    }

    public BlJsonElement ReadObject() {
        BlJsonObject blJsonObject = null;
        if (this.ReadToMarker() == 7) {
            this.Skip(1);
            blJsonObject = new BlJsonObject();
            BlJsonElement blJsonElement = null;
            boolean bl = true;
            while (bl) {
                bl = false;
                if (this.ReadToMarker() == 9) continue;
                if (this.ReadToMarker() == 4) {
                    BlString blString = new BlString(this.ParseString());
                    if (this.ReadToMarker() != 8) {
                        this.FailBuildingStructure();
                        continue;
                    }
                    this.Skip(1);
                    blJsonElement = this.ReadElement();
                    if (null == blJsonElement) {
                        this.FailBuildingStructure();
                        continue;
                    }
                    blJsonObject.SetMember(blString, blJsonElement);
                    if (this.ReadToMarker() != 10) continue;
                    this.Skip(1);
                    bl = true;
                    continue;
                }
                this.FailBuildingStructure();
                bl = false;
            }
            if (this.ReadToMarker() == 9) {
                this.Skip(1);
            } else {
                this.FailBuildingStructure();
                blJsonObject = null;
            }
        } else {
            this.FailBuildingStructure();
        }
        return blJsonObject;
    }

    public BlJsonElement ReadComment() {
        return null;
    }

    public void FailBuildingStructure() {
        this.mErrorId = 1;
    }
}

