/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.texasholdem09.Character;
import ca.jamdat.texasholdem09.CharacterManager;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGameManager;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.TexasPokerTable;
import ca.jamdat.texasholdem09.TexasRules;

public class TexasGameManager
extends PokerGameManager {
    public static final byte startHand = 0;
    public static final byte betBlind = 1;
    public static final byte dealPreflop = 2;
    public static final byte betPreflop = 3;
    public static final byte dealFlop = 4;
    public static final byte betFlop = 5;
    public static final byte dealTurn = 6;
    public static final byte betTurn = 7;
    public static final byte dealRiver = 8;
    public static final byte betRiver = 9;
    public static final byte showdown = 10;
    public static final byte winWithoutShowdown = 11;
    public static final byte handConcluded = 12;
    public static final byte texasHandStepCount = 13;
    public CharacterManager mCharacterManager;
    public boolean mInHeadsupMode;
    public TexasRules mTexasRules = new TexasRules();
    public byte mHandStep = 0;
    public PokerPlayer mSmallBlindPlayer;
    public PokerPlayer mBigBlindPlayer;
    public FlString[] mPossiblePlayerActionsStrings = null;

    public TexasGameManager() {
        this.mPokerTable = new TexasPokerTable();
        this.mCharacterManager = new CharacterManager();
    }

    public void destruct() {
    }

    public static TexasGameManager Get() {
        return GameApp.Get().GetGameFactory().GetTexasManager();
    }

    public void ReleaseResources() {
        super.ReleaseResources();
        this.Unload();
        this.mSmallBlindPlayer = null;
        this.mBigBlindPlayer = null;
        if (this.mPokerTable != null) {
            this.mPokerTable.UnloadResources();
            this.mPokerTable = null;
            this.mPokerTable = null;
        }
        if (this.mCharacterManager != null) {
            this.mCharacterManager = null;
        }
    }

    public void GetEntryPoints() {
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        this.mPossiblePlayerActionsStrings = new FlString[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            FlString cfr_ignored_0 = this.mPossiblePlayerActionsStrings[i2];
            this.mPossiblePlayerActionsStrings[i2] = FlString.Cast(package_.GetEntryPoint(33 + i2), null);
        }
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void Unload() {
        this.mPossiblePlayerActionsStrings = null;
    }

    public void ResetRules() {
        this.mTexasRules.Initialize();
    }

    public static byte GetHandStepAsComputingRound(byte by) {
        switch (by) {
            case 0: {
                return -1;
            }
            case 1: {
                return -1;
            }
            case 2: {
                return -1;
            }
            case 3: {
                return -1;
            }
            case 4: {
                return -1;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return -1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return -1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return -1;
            }
            case 11: {
                return -1;
            }
            case 12: {
                return -1;
            }
        }
        return -1;
    }

    public byte GetTexasHandStep() {
        return this.mHandStep;
    }

    public void MakePlayersPostBlinds() {
        this.mHandStep = 1;
        PlayerDecision playerDecision = new PlayerDecision();
        playerDecision.SetPlayerAction((byte)6);
        if (this.mSmallBlindPlayer.GetChip() < this.mTexasRules.GetSmallBlindValue()) {
            playerDecision.SetChip(this.mSmallBlindPlayer.GetChip());
        } else {
            playerDecision.SetChip(this.mTexasRules.GetSmallBlindValue());
        }
        this.mSmallBlindPlayer.SetDecision(playerDecision);
        this.SetActivePlayer(this.mSmallBlindPlayer);
        this.ExecuteActivePlayerDecision();
        playerDecision.SetPlayerAction((byte)7);
        if (this.mBigBlindPlayer.GetChip() < this.mTexasRules.GetBigBlindValue()) {
            playerDecision.SetChip(this.mBigBlindPlayer.GetChip());
        } else {
            playerDecision.SetChip(this.mTexasRules.GetBigBlindValue());
        }
        this.mBigBlindPlayer.SetDecision(playerDecision);
        this.SetActivePlayer(this.mBigBlindPlayer);
        this.ExecuteActivePlayerDecision();
        if (this.IsBetRoundNeeded()) {
            this.mHandStep = (byte)3;
            this.InitializeBetRound();
            if (!this.IsBetRoundNeeded()) {
                this.ResolveNewEvent();
            }
        }
    }

    public void ExecuteActivePlayerDecision() {
        byte by = this.mActivePlayer.GetDecision().GetPlayerAction();
        boolean bl = false;
        int n2 = 25;
        switch (by) {
            case 1: {
                n2 = 15;
                break;
            }
            case 0: {
                n2 = 16;
                this.mActivePlayer.SetState((byte)2);
                if (!this.mActivePlayer.IsPlayerHuman()) break;
                GameApp.Get().GetStatistics().OnFold();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                int n3;
                n2 = 17;
                if (this.mChipToCall >= this.mActivePlayer.GetDecision().GetChip()) {
                    bl = true;
                } else {
                    this.mCloseHandPlayer = this.GetRightActivePlayer();
                    n3 = 2 * this.mActivePlayer.GetDecision().GetChip() - this.mChipToCall;
                    int n4 = (this.mMinChipToRaiseTo + 1 - this.mChipToCallLastTrueRaise) / 2;
                    int n5 = this.mActivePlayer.GetDecision().GetChip() - this.mChipToCallLastTrueRaise;
                    this.mChipToCall = this.mActivePlayer.GetDecision().GetChip();
                    if (this.mPotentialSidePotPlayer != null) {
                        this.SetLastPlayerToBetOrRaiseForCurrentPot(this.mPotentialSidePotPlayer);
                        this.mPotentialSidePotPlayer = null;
                        this.mPokerTable.IncrementCurrentPotIdx();
                    }
                    if (n5 >= n4) {
                        this.mCannotReRaisePlayer = null;
                        if (n3 >= this.mMinChipToRaiseTo) {
                            this.mMinChipToRaiseTo = n3;
                        }
                        this.mChipToCallLastTrueRaise = this.mChipToCall;
                    } else if (this.mCannotReRaisePlayer == null) {
                        this.mCannotReRaisePlayer = this.GetLastPlayerToBetOrRaiseForCurrentPot();
                    }
                    this.SetLastPlayerToBetOrRaiseForCurrentPot(this.mActivePlayer);
                }
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 17;
                int n3 = this.mActivePlayer.GetDecision().GetChip();
                if (this.mActivePlayer.GetDecision().GetPlayerAction() != 2 && !bl) {
                    n3 -= this.mActivePlayer.GetChipInvolvedInCurrentBetRound();
                }
                this.mPokerTable.AddToPot(this.mPokerTable.GetSeatOfPlayer(this.mActivePlayer), n3);
                this.mActivePlayer.RemoveChip(n3);
                if (this.mActivePlayer.GetState() == 4) {
                    this.mPotentialSidePotPlayer = this.GetLastPlayerToBetOrRaiseForCurrentPot();
                    if (by == 2 || bl || by == 7 || by == 6) {
                        this.mPokerTable.IncrementCurrentPotIdx();
                        this.SetLastPlayerToBetOrRaiseForCurrentPot(this.mPotentialSidePotPlayer);
                        this.mPotentialSidePotPlayer = null;
                    }
                }
                if (by != 7) break;
                this.mChipToCallLastTrueRaise = this.mChipToCall = this.mTexasRules.GetBigBlindValue();
                this.mMinChipToRaiseTo = this.mChipToCall * 2;
                break;
            }
        }
        if (25 != n2) {
            GameApp.Get().GetMediaPlayer().PlayGameSceneSoundFX(n2);
        }
        if (!(this.mActivePlayer.IsPlayerHuman() || this.mActivePlayer.GetState() != 2 && this.mActivePlayer.GetState() != 4)) {
            PokerPlayerAI pokerPlayerAI = (PokerPlayerAI)this.mActivePlayer;
            pokerPlayerAI.SetComputeMetrics(false);
        }
        if (this.mActivePlayer == this.mCloseHandPlayer && (by == 2 || bl || by == 1 || by == 0)) {
            this.ResolveNewEvent();
        }
        if (!this.mBetRoundIsFinish && !this.UpdateNextActivePlayer()) {
            this.ResolveNewEvent();
        }
        if (by != 6 && !this.mBetRoundIsFinish && !this.IsBetRoundNeeded()) {
            this.ResolveNewEvent();
        }
    }

    public void DealCardsToAllPlayers() {
        byte by = this.mPokerTable.GetNbOfStartingPlayers();
        for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            PokerPlayer pokerPlayer = this.mPokerTable.GetPlayerSeatedAt(by2);
            if (!pokerPlayer.IsPlayerInTheHand()) continue;
            pokerPlayer.SwitchNextHoleCardToCurrent();
        }
        GameApp.Get().GetStatistics().OnHandDealt();
    }

    public void DetermineSpecialPlayers() {
        PokerPlayer pokerPlayer = this.mBigBlindPlayer;
        this.SetActivePlayer(this.mDealerButtonPlayer);
        this.mDealerButtonPlayer = this.GetLeftActivePlayer();
        this.SetActivePlayer(this.mDealerButtonPlayer);
        this.mSmallBlindPlayer = this.GetLeftActivePlayer();
        this.SetActivePlayer(this.mSmallBlindPlayer);
        this.mBigBlindPlayer = this.GetLeftActivePlayer();
        if (this.mDealerButtonPlayer == this.mBigBlindPlayer) {
            this.mActivePlayer = this.mDealerButtonPlayer;
            this.mBigBlindPlayer = this.GetLeftActivePlayer();
            this.mSmallBlindPlayer = this.mDealerButtonPlayer;
        }
        if (pokerPlayer == this.mBigBlindPlayer) {
            this.mBigBlindPlayer = this.mDealerButtonPlayer;
            this.mActivePlayer = this.mBigBlindPlayer = this.mSmallBlindPlayer;
            this.mBigBlindPlayer = this.GetLeftActivePlayer();
        }
    }

    public void InitializeGame() {
        super.InitializeGame();
        this.mPokerTable.CloseTable();
        this.mInHeadsupMode = false;
        this.mHandStep = 0;
        this.mPokerTable.ResetNextData();
        short s2 = (short)(this.mPokerTable.GetNbOfStartingPlayers() - 1);
        byte by = (byte)FlMath.Random((short)0, s2);
        this.mDealerButtonPlayer = this.mPokerTable.GetPlayerSeatedAt(by);
        this.mPokerTable.ResetForNextHand();
    }

    public void InitializeHand() {
        super.InitializeHand();
        this.mHandStep = 0;
        this.mEliminatedPlayerArray.Clear();
        this.mMinChipToRaiseTo = 0;
        this.mChipToCall = 0;
        this.mChipToCallLastTrueRaise = 0;
        this.mBetRoundIsFinish = false;
        this.DetermineSpecialPlayers();
        if (!this.mInHeadsupMode) {
            this.mInHeadsupMode = this.mPokerTable.ApplyHeadsupModifIfNeeded();
        }
    }

    public void FlagEliminatedPlayers() {
        this.mEliminatedPlayerArray.Clear();
        int n2 = this.mPokerTable.GetNbOfStartingPlayers();
        for (int n3 = 0; n3 < n2; n3 = (int)((short)(n3 + 1))) {
            byte by = (byte)n3;
            PokerPlayer pokerPlayer = this.mPokerTable.GetPlayerSeatedAt(by);
            if (pokerPlayer.GetChip() != 0 || pokerPlayer.GetState() == 0) continue;
            this.mEliminatedPlayerArray.Insert(pokerPlayer);
        }
    }

    public void FinalizeHand() {
        this.mTexasRules.OnHandCompleted();
        GameApp.Get().GetStatistics().OnHandCompleted();
        this.mPokerTable.ResetForNextHand();
        this.mHandStep = (byte)12;
    }

    public void InitializeBetRound() {
        this.mMinChipToRaiseTo = 0;
        this.mChipToCall = 0;
        this.mChipToCallLastTrueRaise = 0;
        this.mBetRoundIsFinish = false;
        this.SetLastPlayerToBetOrRaiseForCurrentPot(null);
        this.mCannotReRaisePlayer = null;
        if (this.mHandStep == 3) {
            this.mMinChipToRaiseTo = this.mTexasRules.GetBigBlindValue() * 2;
            this.mChipToCall = this.mTexasRules.GetBigBlindValue();
            this.SetActivePlayer(this.mBigBlindPlayer);
            this.SetActivePlayer(this.GetLeftActivePlayer());
            this.mCloseHandPlayer = this.GetRightActivePlayer();
        } else {
            this.mPokerTable.ResetForNextBettingRound();
            this.SetActivePlayer(this.mPokerTable.GetLeftPlayer(this.mDealerButtonPlayer));
            this.mCloseHandPlayer = this.GetRightActivePlayer();
            this.SetActivePlayer(this.mDealerButtonPlayer);
            if (!this.UpdateNextActivePlayer()) {
                this.ResolveNewEvent();
            }
        }
    }

    public void DealTurn() {
        this.mPokerTable.AddCard();
        this.mHandStep = (byte)7;
        this.InitializeBetRound();
        if (!this.IsBetRoundNeeded()) {
            this.ResolveNewEvent();
        }
    }

    public void DealFlop() {
        for (int i2 = 0; i2 < 3; ++i2) {
            this.mPokerTable.AddCard();
        }
        GameApp.Get().GetStatistics().OnFlop();
        this.mHandStep = (byte)5;
        this.InitializeBetRound();
        if (!this.IsBetRoundNeeded()) {
            this.ResolveNewEvent();
        }
    }

    public void DealRiver() {
        this.mPokerTable.AddCard();
        GameApp.Get().GetStatistics().OnRiver();
        this.mHandStep = (byte)9;
        this.InitializeBetRound();
        if (!this.IsBetRoundNeeded()) {
            this.ResolveNewEvent();
        }
    }

    public void ResolveNewEvent() {
        this.mBetRoundIsFinish = true;
        this.mPokerTable.CheckForExcedentMoneyInPot();
        this.UpdateHandStepAfterEvent();
    }

    public boolean UpdateNextActivePlayer() {
        PokerPlayer pokerPlayer = this.GetLeftActivePlayer();
        if (this.mActivePlayer == pokerPlayer) {
            return false;
        }
        this.SetActivePlayer(pokerPlayer);
        this.DetermineActivePlayerPossibleActions();
        return true;
    }

    public void UpdateHandStepAfterEvent() {
        if (this.mHandStep != 3 && this.mHandStep != 1 && this.mHandStep != 5 && this.mHandStep != 7 && this.mHandStep != 9 && this.mHandStep != 10) {
            return;
        }
        if (!this.IsThereOnlyOnePlayerNotFolded()) {
            switch (this.mHandStep) {
                case 1: {
                    if (this.mBetRoundIsFinish) {
                        this.mHandStep = (byte)4;
                        break;
                    }
                    this.mHandStep = (byte)3;
                    break;
                }
                case 3: {
                    this.mHandStep = (byte)4;
                    break;
                }
                case 5: {
                    this.mHandStep = (byte)6;
                    break;
                }
                case 7: {
                    this.mHandStep = (byte)8;
                    break;
                }
                case 9: {
                    this.mPokerTable.ResetNextData();
                    this.mHandStep = (byte)10;
                    this.mPokerTable.ResolvePotsDistribution();
                    this.SetPlayerHandValues();
                    this.mCurrentWinningHV = this.GetNextPlayerToShow().GetHandValue();
                    break;
                }
                case 10: {
                    this.SetPlayerHandValues();
                    break;
                }
            }
        } else {
            this.mPokerTable.ResetNextData();
            this.mHandStep = (byte)11;
            this.mPokerTable.ResolvePotsDistribution();
        }
    }

    public int GetBigBlindValue() {
        return this.mTexasRules.GetBigBlindValue();
    }

    public int GetSmallBlindValue() {
        return this.mTexasRules.GetSmallBlindValue();
    }

    public boolean MustRefillTable() {
        return GameApp.Get().GetGameSettings().IsCurrentModeTournament() && GameApp.Get().GetGameSettings().GetTournamentRound() < 3 && this.mPokerTable.GetNumberPlayersInState((byte)0) > 2;
    }

    public void RefillTable(PlayerViewportManager playerViewportManager) {
        this.mCharacterManager.RefillTable(this.mPokerTable, playerViewportManager);
    }

    public void FillTable() {
        this.mCharacterManager.FillTable(this.mPokerTable);
    }

    public void CreateHumanPlayer(byte by) {
        int n2 = GameApp.Get().GetCareerState().GetInGameStack();
        this.mPokerTable.AddHumanPlayer(by, n2 > -1 ? n2 : this.mTexasRules.GetInitialStack());
    }

    public PokerPlayer GetBigBlindPlayer() {
        return this.mBigBlindPlayer;
    }

    public PokerPlayer GetSmallBlindPlayer() {
        return this.mSmallBlindPlayer;
    }

    public void PopEliminatedPlayer() {
        if (this.mEliminatedPlayerArray.End() != 0) {
            this.mEliminatedPlayerArray.RemoveAt(this.mEliminatedPlayerArray.End() - 1);
        }
    }

    public PokerPlayer GetEliminatedPlayer() {
        if (this.mEliminatedPlayerArray.End() == 0) {
            return null;
        }
        return this.mEliminatedPlayerArray.GetAt(this.mEliminatedPlayerArray.End() - 1);
    }

    public PokerPlayer GetHumanPlayer() {
        return this.mPokerTable.GetHumanPlayer();
    }

    public void Load(FileSegmentStream fileSegmentStream) {
        this.mPokerTable.Load(fileSegmentStream);
        this.mCharacterManager.Load(fileSegmentStream, this.mPokerTable);
        super.Load(fileSegmentStream);
        this.mTexasRules.Initialize(fileSegmentStream.ReadLong());
        this.mInHeadsupMode = fileSegmentStream.ReadByte() != 0;
        this.mHandStep = fileSegmentStream.ReadByte();
        this.mSmallBlindPlayer = this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
        this.mBigBlindPlayer = this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
    }

    public void Save(FileSegmentStream fileSegmentStream) {
        this.mPokerTable.Save(fileSegmentStream);
        this.mCharacterManager.Save(fileSegmentStream);
        super.Save(fileSegmentStream);
        fileSegmentStream.WriteLong(this.mTexasRules.GetHandCounter());
        fileSegmentStream.WriteByte((byte)(this.mInHeadsupMode ? 1 : 0));
        fileSegmentStream.WriteByte(this.mHandStep);
        fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mSmallBlindPlayer));
        fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mBigBlindPlayer));
    }

    public boolean BlindsJustGotIncremented() {
        return this.mTexasRules.BlindsJustGotIncremented();
    }

    public int GetInitialStack() {
        return this.mTexasRules.GetInitialStack();
    }

    public Character GetHumanAdvisorCharacter() {
        return this.mCharacterManager.GetHumanAdvisor();
    }

    public FlString GetActionString(byte by) {
        return this.mPossiblePlayerActionsStrings[by];
    }

    public void DetermineActivePlayerPossibleActions() {
        if (this.mHandStep != 1 && this.mHandStep != 3 && this.mHandStep != 5 && this.mHandStep != 7 && this.mHandStep != 9) {
            return;
        }
        PlayerDecision[] playerDecisionArray = this.mActivePlayer.GetPossibleDecision();
        this.mActivePlayer.ClearPossibleDecisionArray();
        int n2 = this.mActivePlayer.GetChip();
        int n3 = 0;
        playerDecisionArray[n3].SetPlayerAction((byte)0);
        ++n3;
        if (this.mChipToCall == 0) {
            playerDecisionArray[n3].SetPlayerAction((byte)1);
            playerDecisionArray[n3].SetChip(0);
            playerDecisionArray[++n3].SetPlayerAction((byte)3);
            playerDecisionArray[n3].SetChip(this.mTexasRules.GetMinimumBet(n2));
            playerDecisionArray[++n3].SetPlayerAction((byte)3);
            playerDecisionArray[n3].SetChip(n2);
            ++n3;
        } else {
            int n4;
            if (this.mHandStep == 3 && this.mActivePlayer == this.mBigBlindPlayer && this.mChipToCall == this.mBigBlindPlayer.GetChipInvolvedInCurrentBetRound()) {
                playerDecisionArray[n3].SetPlayerAction((byte)1);
                ++n3;
            } else {
                playerDecisionArray[n3].SetPlayerAction((byte)2);
                n4 = this.mChipToCall - this.mActivePlayer.GetChipInvolvedInCurrentBetRound();
                if (n4 > n2) {
                    n4 = n2;
                }
                playerDecisionArray[n3].SetChip(n4);
                ++n3;
            }
            if (this.mActivePlayer.GetChip() + this.mActivePlayer.GetChipInvolvedInCurrentBetRound() > this.mChipToCall && this.mPokerTable.GetNumberPlayersInState((byte)1) > 1) {
                int n5;
                int n6;
                n4 = 1;
                if (this.mCannotReRaisePlayer != null) {
                    int n7;
                    n6 = this.mPokerTable.GetSeatOfPlayer(this.mCannotReRaisePlayer);
                    n5 = this.mPokerTable.GetSeatOfPlayer(this.GetLastPlayerToBetOrRaiseForCurrentPot());
                    int n8 = n7 = this.mPokerTable.GetSeatOfPlayer(this.mActivePlayer);
                    int n9 = this.mPokerTable.GetNbOfStartingPlayers();
                    for (int i2 = 0; i2 < n9; ++i2) {
                        if (n7 == n6) {
                            n4 = 0;
                            break;
                        }
                        if ((n8 = (n8 + 1) % n9) == n5) {
                            n4 = 0;
                            break;
                        }
                        if (n8 == n6) break;
                    }
                }
                if (n4 != 0) {
                    playerDecisionArray[n3].SetPlayerAction((byte)4);
                    n6 = this.mMinChipToRaiseTo;
                    if (n6 > n2 + this.mActivePlayer.GetChipInvolvedInCurrentBetRound()) {
                        n6 = n2 + this.mActivePlayer.GetChipInvolvedInCurrentBetRound();
                    }
                    playerDecisionArray[n3].SetChip(n6);
                    n5 = n2 + this.mActivePlayer.GetChipInvolvedInCurrentBetRound();
                    playerDecisionArray[++n3].SetPlayerAction((byte)4);
                    playerDecisionArray[n3].SetChip(n5);
                }
            }
        }
    }

    public void SetPlayerHandValues() {
        int n2 = this.mPokerTable.GetNbOfStartingPlayers();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.mPokerTable.GetPlayerSeatedAt((byte)i2).GetState() == 2 || this.mPokerTable.GetPlayerSeatedAt((byte)i2).GetState() == 0) continue;
            this.mPokerTable.GetPlayerSeatedAt((byte)i2).SetHandValue(this.mPokerTable.GetCommunityCards());
        }
    }

    public static TexasGameManager[] InstArrayTexasGameManager(int n2) {
        TexasGameManager[] texasGameManagerArray = new TexasGameManager[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            texasGameManagerArray[i2] = new TexasGameManager();
        }
        return texasGameManagerArray;
    }

    public static TexasGameManager[][] InstArrayTexasGameManager(int n2, int n3) {
        TexasGameManager[][] texasGameManagerArray = new TexasGameManager[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            texasGameManagerArray[i2] = new TexasGameManager[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                texasGameManagerArray[i2][i3] = new TexasGameManager();
            }
        }
        return texasGameManagerArray;
    }

    public static TexasGameManager[][][] InstArrayTexasGameManager(int n2, int n3, int n4) {
        TexasGameManager[][][] texasGameManagerArray = new TexasGameManager[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            texasGameManagerArray[i2] = new TexasGameManager[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                texasGameManagerArray[i2][i3] = new TexasGameManager[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    texasGameManagerArray[i2][i3][i4] = new TexasGameManager();
                }
            }
        }
        return texasGameManagerArray;
    }
}

