/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.PlayerViewport;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerState;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class StateDealingCards
extends PokerState {
    public static final byte kUndefined = -1;
    public static final byte kLeavingStateDealingCards = 0;
    public byte mStateStage = (byte)-1;
    public PokerPlayer mCurrentPlayer;
    public int mIterationAroundTable;

    public StateDealingCards(PokerGame pokerGame) {
        super(pokerGame);
    }

    public void destruct() {
    }

    public byte GetID() {
        return 3;
    }

    public void OnEntry() {
        this.mGameScene.UpdateSoftKey();
        if (this.mStateStage == -1) {
            this.mTexasManager.DealCardsToAllPlayers();
            this.mCurrentPlayer = this.mTexasManager.GetDealerPlayer();
            this.mIterationAroundTable = 0;
        }
    }

    public void OnExit() {
        this.SetStage((byte)-1);
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        int n2 = this.mPokerGame.GetNbOfStartingPlayers();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray = this.mPokerGame.GetTexasPokerTable().GetPlayerSeatedAt((byte)i2).GetHoleCards();
            playerViewportManager.GetPlayerViewportSeatedAt((byte)i2).SetCards(byArray[0], byArray[1]);
        }
        if (GameApp.Get().GetCheatContainer().GetCheat(15).IsActivated()) {
            TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!texasPokerTable.GetPlayerSeatedAt((byte)i3).IsPlayerInTheHand()) continue;
                playerViewportManager.GetPlayerViewportSeatedAt((byte)i3).UpdatePlayerState((byte)0, false);
            }
        } else {
            playerViewportManager.GetPlayerViewportSeatedAt(PokerTable.GetSeatOfHumanPlayer()).UpdatePlayerState((byte)0, false);
        }
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        this.mStateStage = fileSegmentStream.ReadByte();
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte(this.mStateStage);
    }

    public void OnSkip() {
        while (this.mStateStage != 0) {
            this.DealACard();
        }
        super.OnSkip();
    }

    public void OnTime(int n2, int n3) {
        this.DealACard();
        this.ManageState();
        super.OnTime(n2, n3);
    }

    public void ManageState() {
        switch (this.mStateStage) {
            case 0: {
                this.SetNextState((byte)4);
            }
        }
    }

    public void SetStage(byte by, int n2) {
        this.mStateStage = by;
        this.SetWaitingTime(n2);
    }

    public void DealACard() {
        byte by = -1;
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        byte by2 = texasPokerTable.GetSeatOfPlayer(this.mTexasManager.GetDealerPlayer());
        if (this.mStateStage == -1) {
            if (this.mIterationAroundTable < 2) {
                this.mCurrentPlayer = texasPokerTable.GetLeftPlayer(this.mCurrentPlayer);
                if (!this.mCurrentPlayer.IsPlayerOutOfTheGame()) {
                    by = texasPokerTable.GetSeatOfPlayer(this.mCurrentPlayer);
                    PlayerViewport playerViewport = playerViewportManager.GetPlayerViewportSeatedAt(by);
                    if (this.mIterationAroundTable == 0) {
                        playerViewport.SetHoleCardsState((byte)3);
                    } else {
                        playerViewport.SetHoleCardsState((byte)4);
                    }
                    this.SetWaitingTime(203);
                }
                if (by == by2) {
                    ++this.mIterationAroundTable;
                }
            } else {
                this.SetStage((byte)0);
            }
        }
    }

    public void SetStage(byte by) {
        this.SetStage(by, -1);
    }
}

