/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class PotManager {
    public Text mPotAmountText;
    public IndexedSprite mPotChip;
    public Viewport mPotViewport;

    public void destruct() {
    }

    public void LoadResources() {
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        Text text = null;
        this.mPotAmountText = text = Text.Cast(package_.GetEntryPoint(166), null);
        this.mPotChip = IndexedSprite.Cast(package_.GetEntryPoint(167), null);
        this.SetPotChipSprite();
        this.mPotViewport = Viewport.Cast(package_.GetEntryPoint(165), null);
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void UnloadResources() {
        if (this.mPotChip != null) {
            this.mPotChip = null;
        }
        if (this.mPotViewport != null) {
            this.mPotViewport = null;
        }
        if (this.mPotAmountText != null) {
            this.mPotAmountText = null;
        }
    }

    public void SetPot(int n2) {
        this.mPotAmountText.SetCaption(new FlString(n2));
    }

    public void Refresh() {
        this.SetPot(TexasPokerTable.Get().GetPot());
    }

    public void SetPotChipSprite() {
        GameSettings gameSettings = GameApp.Get().GetGameSettings();
        int n2 = -1;
        if (gameSettings.IsPractice()) {
            n2 = 2;
        } else if (gameSettings.IsCurrentModeStandard() || gameSettings.IsCurrentModeHeadsUp()) {
            n2 = 0;
        } else if (gameSettings.IsCurrentModeTournament() || gameSettings.IsCurrentModeProGame()) {
            n2 = 1;
        }
        this.mPotChip.SetCurrentFrame(n2);
    }

    public static PotManager[] InstArrayPotManager(int n2) {
        PotManager[] potManagerArray = new PotManager[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            potManagerArray[i2] = new PotManager();
        }
        return potManagerArray;
    }

    public static PotManager[][] InstArrayPotManager(int n2, int n3) {
        PotManager[][] potManagerArray = new PotManager[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            potManagerArray[i2] = new PotManager[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                potManagerArray[i2][i3] = new PotManager();
            }
        }
        return potManagerArray;
    }

    public static PotManager[][][] InstArrayPotManager(int n2, int n3, int n4) {
        PotManager[][][] potManagerArray = new PotManager[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            potManagerArray[i2] = new PotManager[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                potManagerArray[i2][i3] = new PotManager[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    potManagerArray[i2][i3][i4] = new PotManager();
                }
            }
        }
        return potManagerArray;
    }
}

