/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlString;
import ca.jamdat.texasholdem09.AIAlgo;
import ca.jamdat.texasholdem09.CardsFlipProcess;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameScene;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerState;
import ca.jamdat.texasholdem09.Popup;
import ca.jamdat.texasholdem09.PtrArray_PokerPlayerAI;
import ca.jamdat.texasholdem09.StateBetting;
import ca.jamdat.texasholdem09.StateDealingCards;
import ca.jamdat.texasholdem09.StateDealingSharedCards;
import ca.jamdat.texasholdem09.StateEliminatingPlayer;
import ca.jamdat.texasholdem09.StateEndingTurn;
import ca.jamdat.texasholdem09.StateGameOver;
import ca.jamdat.texasholdem09.StateIntroduction;
import ca.jamdat.texasholdem09.StateNoShowdown;
import ca.jamdat.texasholdem09.StateShowdown;
import ca.jamdat.texasholdem09.StateWaitingForDeal;
import ca.jamdat.texasholdem09.StateWaitingForInitialize;
import ca.jamdat.texasholdem09.TexasGameManager;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class PokerGame {
    public PokerState mCurrentGameState;
    public StateIntroduction mStateIntroduction;
    public StateWaitingForInitialize mStateWaitingForInitialize;
    public StateWaitingForDeal mStateWaitingForDeal;
    public StateDealingCards mStateDealingCards;
    public StateBetting mStateBetting;
    public StateDealingSharedCards mStateDealingSharedCards;
    public StateNoShowdown mStateNoShowdown;
    public StateShowdown mStateShowdown;
    public StateEliminatingPlayer mStateEliminatingPlayer;
    public StateEndingTurn mStateEndingTurn;
    public StateGameOver mStateGameOver;
    public CardsFlipProcess mCardsFlipProcess;
    public int mWaitingTimerMs;
    public GameScene mGameScene;
    public TexasGameManager mTexasManager;
    public TexasPokerTable mPokerTable;
    public AIAlgo mAiAlgo;
    public boolean mGameIsPaused;
    public boolean mInSkipMode;
    public boolean mSkipToEnd;
    public int mBuyInAmount = -1;
    public int mFactoredAllInAmount = -1;
    public int mFactoredCallAmount = -1;
    public int mFactoredRaiseAmount = -1;
    public int mFactoredBetAmount = -1;
    public int mFactoredFoldAmount = -1;
    public byte mLoadedGameStateID = 0;
    public byte mLoadedNextGameStateID = (byte)-1;

    public void destruct() {
    }

    public void Initialize(GameScene gameScene) {
        this.mAiAlgo = new AIAlgo();
        this.mGameScene = gameScene;
        this.mStateIntroduction.SetGameScene(this.mGameScene);
        this.mStateWaitingForInitialize.SetGameScene(this.mGameScene);
        this.mStateWaitingForDeal.SetGameScene(this.mGameScene);
        this.mStateDealingCards.SetGameScene(this.mGameScene);
        this.mStateBetting.SetGameScene(this.mGameScene);
        this.mStateDealingSharedCards.SetGameScene(this.mGameScene);
        this.mStateNoShowdown.SetGameScene(this.mGameScene);
        this.mStateShowdown.SetGameScene(this.mGameScene);
        this.mStateEliminatingPlayer.SetGameScene(this.mGameScene);
        this.mStateEndingTurn.SetGameScene(this.mGameScene);
        this.mStateGameOver.SetGameScene(this.mGameScene);
        this.mCardsFlipProcess.SetGameScene(this.mGameScene);
        this.mTexasManager = TexasGameManager.Get();
        this.mPokerTable = (TexasPokerTable)this.mTexasManager.GetPokerTable();
        this.InitAIAlgo();
        this.mBuyInAmount = this.mTexasManager.GetInitialStack();
        this.mFactoredAllInAmount = this.mBuyInAmount * 25;
        this.mFactoredCallAmount = this.mBuyInAmount * 25;
        this.mFactoredRaiseAmount = this.mBuyInAmount * 25;
        this.mFactoredBetAmount = this.mBuyInAmount * 10;
        this.mFactoredFoldAmount = this.mBuyInAmount * 2;
        if (this.mLoadedGameStateID == 0) {
            this.mCurrentGameState = this.mStateIntroduction;
            this.mCurrentGameState.OnEntry();
        } else {
            this.ChangeState(this.mLoadedGameStateID);
            this.mGameScene.RefreshManagers();
        }
        this.mCurrentGameState.SetNextState(this.mLoadedNextGameStateID);
        GameApp.Get().GetGameFactory().SetIsPokerGameValid(true);
    }

    public void LoadStates() {
        this.mStateIntroduction.Load();
        this.mStateWaitingForInitialize.Load();
        this.mStateWaitingForDeal.Load();
        this.mStateDealingCards.Load();
        this.mStateBetting.Load();
        this.mStateDealingSharedCards.Load();
        this.mStateNoShowdown.Load();
        this.mStateShowdown.Load();
        this.mStateEliminatingPlayer.Load();
        this.mStateEndingTurn.Load();
        this.mStateGameOver.Load();
    }

    public void UnloadStates() {
        this.mStateIntroduction.Unload();
        this.mStateWaitingForInitialize.Unload();
        this.mStateWaitingForDeal.Unload();
        this.mStateDealingCards.Unload();
        this.mStateBetting.Unload();
        this.mStateDealingSharedCards.Unload();
        this.mStateNoShowdown.Unload();
        this.mStateShowdown.Unload();
        this.mStateEliminatingPlayer.Unload();
        this.mStateEndingTurn.Unload();
        this.mStateGameOver.Unload();
    }

    public void InitAIAlgo() {
        PtrArray_PokerPlayerAI ptrArray_PokerPlayerAI = new PtrArray_PokerPlayerAI();
        this.mPokerTable.GetNotOutAiPlayers(ptrArray_PokerPlayerAI);
        if (ptrArray_PokerPlayerAI.End() >= 2) {
            this.mAiAlgo.Init(ptrArray_PokerPlayerAI);
            int n2 = this.mTexasManager.GetLeftPlayerToDealerIndex(ptrArray_PokerPlayerAI);
            this.mAiAlgo.InitHand(this.mPokerTable.GetNextCommunityCards(), n2);
        }
        ptrArray_PokerPlayerAI.Clear();
        this.mAiAlgo.RegisterInGlobalTime();
    }

    public void ReleaseGame() {
        if (this.mAiAlgo != null) {
            this.mAiAlgo.UnloadResources();
            this.mAiAlgo = null;
        }
        this.ReleaseStatesAndProcesses();
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        this.mSkipToEnd = fileSegmentStream.ReadBoolean();
        this.mLoadedGameStateID = fileSegmentStream.ReadByte();
        this.mLoadedNextGameStateID = fileSegmentStream.ReadByte();
        this.mStateIntroduction.Read(fileSegmentStream);
        this.mStateWaitingForInitialize.Read(fileSegmentStream);
        this.mStateWaitingForDeal.Read(fileSegmentStream);
        this.mStateDealingCards.Read(fileSegmentStream);
        this.mStateBetting.Read(fileSegmentStream);
        this.mStateDealingSharedCards.Read(fileSegmentStream);
        this.mStateNoShowdown.Read(fileSegmentStream);
        this.mStateShowdown.Read(fileSegmentStream);
        this.mStateEliminatingPlayer.Read(fileSegmentStream);
        this.mStateEndingTurn.Read(fileSegmentStream);
        this.mStateGameOver.Read(fileSegmentStream);
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteBoolean(this.mSkipToEnd);
        fileSegmentStream.WriteByte(this.mCurrentGameState.GetID());
        fileSegmentStream.WriteByte(this.mCurrentGameState.GetNextState());
        this.mStateIntroduction.Write(fileSegmentStream);
        this.mStateWaitingForInitialize.Write(fileSegmentStream);
        this.mStateWaitingForDeal.Write(fileSegmentStream);
        this.mStateDealingCards.Write(fileSegmentStream);
        this.mStateBetting.Write(fileSegmentStream);
        this.mStateDealingSharedCards.Write(fileSegmentStream);
        this.mStateNoShowdown.Write(fileSegmentStream);
        this.mStateShowdown.Write(fileSegmentStream);
        this.mStateEliminatingPlayer.Write(fileSegmentStream);
        this.mStateEndingTurn.Write(fileSegmentStream);
        this.mStateGameOver.Write(fileSegmentStream);
    }

    public boolean OnKeyUp(int n2) {
        if (this.IsInSkipMode()) {
            return false;
        }
        boolean bl = true;
        if (n2 == 5) {
            if (this.IsStageShowPlayerActionPopup()) {
                if (this.mGameScene.GetPlayerViewportManager().IsThereInfoScreenShown()) {
                    this.ToggleOutInfoScreens();
                } else {
                    bl = this.mCurrentGameState.OnKeyUp(n2);
                }
            } else {
                bl = this.mCurrentGameState.OnKeyUp(n2);
            }
        } else if (n2 == 6 && this.IsStageShowPlayerActionPopup()) {
            if (this.mGameScene.GetPlayerViewportManager().IsThereInfoScreenShown()) {
                this.mGameScene.OnCommand(-20);
            } else {
                bl = false;
            }
        } else {
            Popup popup = this.mGameScene.GetCurrentPopup();
            if (this.mGameScene.CanShowPlayerActionInfo() || this.ArePlayerActionInfoShown()) {
                if (n2 == 16) {
                    if (popup != null) {
                        this.mGameScene.HidePopup();
                        ((StateBetting)this.mCurrentGameState).SetWaitingForInfoScreenStage();
                    } else {
                        this.ToggleOutInfoScreens();
                    }
                } else if (n2 == 15 || n2 == 17) {
                    int n3 = n2 == 17 ? 6 : 15;
                    int n4 = -1;
                    if (popup != null) {
                        n4 = popup.GetId();
                        this.mGameScene.HidePopup();
                    } else if (this.mGameScene.GetPlayerViewportManager().IsThereInfoScreenShown()) {
                        this.ToggleOutInfoScreens();
                    }
                    if (n4 != n3) {
                        if (n3 == 15) {
                            ((StateBetting)this.mCurrentGameState).SetWaitingForStatsPopupStage();
                        } else {
                            ((StateBetting)this.mCurrentGameState).SetWaitingForAdvisorPopupStage();
                        }
                    }
                } else {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public void OnPause() {
        boolean bl = this.mInSkipMode;
        this.mInSkipMode = true;
        this.mCurrentGameState.OnSkip();
        this.mInSkipMode = bl;
    }

    public void OnSkip() {
        this.mCurrentGameState.OnSkip();
    }

    public void OnTime(int n2, int n3) {
        if (this.mWaitingTimerMs > 0) {
            this.mWaitingTimerMs -= n3;
        } else {
            this.mCurrentGameState.OnTime(n2, n3);
        }
    }

    public void OnHidePlayerActionPopUp() {
        ((StateBetting)this.mCurrentGameState).OnHidePlayerActionPopUp();
    }

    public void OnHideAIDialoguePopUp() {
        ((StateBetting)this.mCurrentGameState).OnHideAIDialoguePopUp();
    }

    public void ToggleOutInfoScreens() {
        this.mGameScene.SetDefaultSoftkeys();
        this.mGameScene.GetPlayerViewportManager().ToggleInfoScreens(false);
    }

    public void ChangeState(byte by) {
        this.mCurrentGameState.OnExit();
        switch (by) {
            case 0: {
                this.mCurrentGameState = this.mStateIntroduction;
                break;
            }
            case 1: {
                this.mCurrentGameState = this.mStateWaitingForInitialize;
                break;
            }
            case 2: {
                this.mCurrentGameState = this.mStateWaitingForDeal;
                break;
            }
            case 3: {
                this.mCurrentGameState = this.mStateDealingCards;
                break;
            }
            case 4: {
                this.mCurrentGameState = this.mStateBetting;
                break;
            }
            case 5: {
                this.mCurrentGameState = this.mStateDealingSharedCards;
                break;
            }
            case 6: {
                this.mCurrentGameState = this.mStateNoShowdown;
                break;
            }
            case 7: {
                this.mCurrentGameState = this.mStateShowdown;
                break;
            }
            case 8: {
                this.mCurrentGameState = this.mStateEliminatingPlayer;
                break;
            }
            case 9: {
                this.mCurrentGameState = this.mStateEndingTurn;
                break;
            }
            case 10: {
                this.mCurrentGameState = this.mStateGameOver;
                break;
            }
        }
        this.mCurrentGameState.OnEntry();
    }

    public boolean IsGamePaused() {
        return this.mGameIsPaused;
    }

    public void SetGamePaused(boolean bl) {
        this.mGameIsPaused = bl;
    }

    public boolean IsInSkipMode() {
        return this.mInSkipMode;
    }

    public void SetIsInSkipMode(boolean bl) {
        byte by;
        this.mInSkipMode = bl;
        if (!(!bl || this.GetTexasPokerTable().GetHumanPlayer().IsPlayerInTheHand() || GameApp.Get().GetCheatContainer().GetCheat(13).IsActivated() || (by = this.mCurrentGameState.GetID()) != 4 && by != 5)) {
            this.SetSkipToEnd(true);
        }
    }

    public boolean IsSkippingToEnd() {
        return this.mSkipToEnd;
    }

    public void SetSkipToEnd(boolean bl) {
        this.mSkipToEnd = bl;
    }

    public void SetAIPlayerName(byte by, FlString flString) {
        this.mPokerTable.GetPlayerSeatedAt(by).SetName(flString);
    }

    public FlString GetAIPlayerName(byte by) {
        return this.mPokerTable.GetPlayerSeatedAt(by).GetName();
    }

    public void SetPlayerName(FlString flString) {
        this.mPokerTable.GetHumanPlayer().SetName(flString);
    }

    public FlString GetPlayerName() {
        return this.mPokerTable.GetHumanPlayer().GetName();
    }

    public AIAlgo GetAIAlgorithm() {
        return this.mAiAlgo;
    }

    public void ResetDataForAIAlgorithm() {
        AIAlgo aIAlgo = this.GetAIAlgorithm();
        PtrArray_PokerPlayerAI ptrArray_PokerPlayerAI = new PtrArray_PokerPlayerAI();
        this.mPokerTable.GetNotOutAiPlayers(ptrArray_PokerPlayerAI);
        aIAlgo.Init(ptrArray_PokerPlayerAI);
        int n2 = this.mTexasManager.GetLeftPlayerToDealerIndex(ptrArray_PokerPlayerAI);
        aIAlgo.InitHand(this.mPokerTable.GetNextCommunityCards(), n2);
        ptrArray_PokerPlayerAI.Clear();
    }

    public TexasPokerTable GetTexasPokerTable() {
        return this.mPokerTable;
    }

    public int GetNbOfStartingPlayers() {
        return this.mPokerTable.GetNbOfStartingPlayers();
    }

    public int GetNbOfStartingAIPlayers() {
        return this.mPokerTable.GetNbOfStartingAIPlayers();
    }

    public int GetBuyInAmount() {
        return this.mBuyInAmount;
    }

    public boolean IsBigDecision(PokerPlayer pokerPlayer) {
        if (pokerPlayer.IsGoingAllIn()) {
            int n2 = pokerPlayer.GetDecision().GetChip();
            if ((n2 *= 100) >= this.mFactoredAllInAmount) {
                return true;
            }
        }
        return false;
    }

    public boolean IsMediumDecision(PokerPlayer pokerPlayer) {
        byte by = pokerPlayer.GetDecision().GetPlayerAction();
        int n2 = pokerPlayer.GetDecision().GetChip();
        int n3 = n2 * 100;
        return pokerPlayer.IsGoingAllIn() || by == 2 && n3 >= this.mFactoredCallAmount || by == 4 && n3 > this.mFactoredRaiseAmount || by == 3 && n3 >= this.mFactoredBetAmount || by == 0 && pokerPlayer.GetChipInvolvedInCurrentBetRound() > this.mFactoredFoldAmount;
    }

    public int GetAcceptSoftkeyCaption() {
        return this.mCurrentGameState.GetAcceptSoftkeyCaption();
    }

    public int GetDeclineSoftkeyCaption() {
        return this.mCurrentGameState.GetDeclineSoftkeyCaption();
    }

    public boolean IsWaitingForUserInput() {
        return this.mCurrentGameState.IsWaitingForUserInput();
    }

    public boolean IsStageShowPlayerActionPopup() {
        if (this.mCurrentGameState.GetID() == 4) {
            return ((StateBetting)this.mCurrentGameState).IsStageShowPlayerActionPopup();
        }
        return false;
    }

    public boolean ArePlayerActionInfoShown() {
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        Popup popup = this.mGameScene.GetCurrentPopup();
        return playerViewportManager.IsThereInfoScreenShown() && this.IsStageShowPlayerActionPopup() || popup != null && (popup.GetId() == 15 || popup.GetId() == 6);
    }

    public void SetWaitingTime(int n2) {
        this.mWaitingTimerMs = n2;
    }

    public void CreateStatesAndProcesses() {
        this.mStateIntroduction = new StateIntroduction(this);
        this.mStateWaitingForInitialize = new StateWaitingForInitialize(this);
        this.mStateWaitingForDeal = new StateWaitingForDeal(this);
        this.mStateDealingCards = new StateDealingCards(this);
        this.mStateBetting = new StateBetting(this);
        this.mStateDealingSharedCards = new StateDealingSharedCards(this);
        this.mStateNoShowdown = new StateNoShowdown(this);
        this.mStateShowdown = new StateShowdown(this);
        this.mStateEliminatingPlayer = new StateEliminatingPlayer(this);
        this.mStateEndingTurn = new StateEndingTurn(this);
        this.mStateGameOver = new StateGameOver(this);
        this.mCurrentGameState = this.mStateIntroduction;
        this.mCardsFlipProcess = new CardsFlipProcess(this);
    }

    public byte GetCurrentStateID() {
        return this.mCurrentGameState.GetID();
    }

    public boolean ProcessCardsFlip() {
        return this.mCardsFlipProcess.RunProcess();
    }

    public void ResumeCardsFlip() {
        this.mCardsFlipProcess.ResumeProcess();
    }

    public void ReleaseStatesAndProcesses() {
        this.mCurrentGameState = null;
        if (this.mStateIntroduction != null) {
            this.mStateIntroduction = null;
        }
        if (this.mStateWaitingForInitialize != null) {
            this.mStateWaitingForInitialize = null;
        }
        if (this.mStateWaitingForDeal != null) {
            this.mStateWaitingForDeal = null;
        }
        if (this.mStateDealingCards != null) {
            this.mStateDealingCards = null;
        }
        if (this.mStateBetting != null) {
            this.mStateBetting = null;
        }
        if (this.mStateDealingSharedCards != null) {
            this.mStateDealingSharedCards = null;
        }
        if (this.mStateNoShowdown != null) {
            this.mStateNoShowdown = null;
        }
        if (this.mStateShowdown != null) {
            this.mStateShowdown = null;
        }
        if (this.mStateEliminatingPlayer != null) {
            this.mStateEliminatingPlayer = null;
        }
        if (this.mStateEndingTurn != null) {
            this.mStateEndingTurn = null;
        }
        if (this.mStateGameOver != null) {
            this.mStateGameOver = null;
        }
        if (this.mCardsFlipProcess != null) {
            this.mCardsFlipProcess = null;
        }
    }

    public static PokerGame[] InstArrayPokerGame(int n2) {
        PokerGame[] pokerGameArray = new PokerGame[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            pokerGameArray[i2] = new PokerGame();
        }
        return pokerGameArray;
    }

    public static PokerGame[][] InstArrayPokerGame(int n2, int n3) {
        PokerGame[][] pokerGameArray = new PokerGame[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            pokerGameArray[i2] = new PokerGame[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                pokerGameArray[i2][i3] = new PokerGame();
            }
        }
        return pokerGameArray;
    }

    public static PokerGame[][][] InstArrayPokerGame(int n2, int n3, int n4) {
        PokerGame[][][] pokerGameArray = new PokerGame[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            pokerGameArray[i2] = new PokerGame[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                pokerGameArray[i2][i3] = new PokerGame[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    pokerGameArray[i2][i3][i4] = new PokerGame();
                }
            }
        }
        return pokerGameArray;
    }
}

