/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.texasholdem09.AIPlayerViewport;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.HumanPlayerViewport;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.PlayerViewport;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.TexasGameManager;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class PlayerViewportManager {
    public PlayerViewport[] mPlayerViewport = null;
    public int mNbOfStartingPlayers = -1;
    public FlString mThinkingString;
    public FlFont mRedFont;
    public FlFont mBottomFont;

    public void destruct() {
    }

    public void LoadResources() {
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        byte by = PokerTable.GetSeatOfHumanPlayer();
        this.mNbOfStartingPlayers = TexasGameManager.Get().GetPokerTable().GetNbOfStartingPlayers();
        this.mPlayerViewport = new PlayerViewport[this.mNbOfStartingPlayers];
        boolean bl = GameApp.Get().GetGameSettings().IsCurrentModeHeadsUp();
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            this.mPlayerViewport[i2] = i2 == by ? new HumanPlayerViewport(by) : (bl ? new AIPlayerViewport(2) : new AIPlayerViewport((byte)i2));
            this.mPlayerViewport[i2].Initialize();
        }
        this.mThinkingString = FlString.Cast(package_.GetEntryPoint(32), null);
        this.mRedFont = FlFont.Cast(package_.GetEntryPoint(170), null);
        this.mBottomFont = FlFont.Cast(package_.GetEntryPoint(169), null);
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void UnloadResources() {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            if (this.mPlayerViewport[i2] == null) continue;
            this.mPlayerViewport[i2].UnloadResources();
            this.mPlayerViewport[i2] = null;
        }
        this.mPlayerViewport = null;
    }

    public HumanPlayerViewport GetHumanPlayerViewport() {
        return (HumanPlayerViewport)this.mPlayerViewport[PokerTable.GetSeatOfHumanPlayer()];
    }

    public void InitializeAllInfoScreens(PokerGame pokerGame) {
        int n2 = this.GetNbOfStartingAIPlayers();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((AIPlayerViewport)this.mPlayerViewport[i2]).InitializeInfoScreen(pokerGame);
        }
    }

    public void ToggleInfoScreens(boolean bl, byte by, int n2) {
        TexasPokerTable texasPokerTable = GameApp.Get().GetGameFactory().GetGame().GetTexasPokerTable();
        byte by2 = -1;
        PokerPlayer pokerPlayer = null;
        int n3 = this.GetNbOfStartingAIPlayers();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 == by || (pokerPlayer = texasPokerTable.GetPlayerSeatedAt(by2 = (byte)((byte)i2))).IsPlayerOutOfTheGame()) continue;
            this.SetupInfoScreen(by2, bl, n2 >= 0 ? n2 : pokerPlayer.GetChip(), false);
        }
    }

    public void ToggleInfoScreen(byte by, boolean bl, int n2, boolean bl2) {
        this.SetupInfoScreen(by, bl, n2, bl2);
    }

    public void SetupInfoScreen(byte by, boolean bl, int n2, boolean bl2) {
        FlString flString = null;
        FlFont flFont = this.mBottomFont;
        if (bl) {
            if (n2 < 0) {
                flString = this.mThinkingString;
            }
            if (bl2) {
                flFont = this.mRedFont;
            }
        }
        ((AIPlayerViewport)this.mPlayerViewport[by]).ToggleInfoScreen(bl, n2, flString, flFont);
    }

    public void ToggleInfoScreensOutIfNeeded() {
        int n2 = this.GetNbOfStartingAIPlayers();
        for (int i2 = 0; i2 < n2; ++i2) {
            AIPlayerViewport aIPlayerViewport = (AIPlayerViewport)this.mPlayerViewport[(byte)i2];
            if (!aIPlayerViewport.IsInfoScreenShown()) continue;
            this.SetupInfoScreen((byte)i2, false);
        }
    }

    public boolean IsThereInfoScreenShown() {
        int n2 = this.GetNbOfStartingAIPlayers();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.IsInfoScreenShownAt((byte)i2)) continue;
            return true;
        }
        return false;
    }

    public boolean IsInfoScreenShownAt(byte by) {
        return ((AIPlayerViewport)this.mPlayerViewport[by]).IsInfoScreenShown();
    }

    public boolean IsInfoScreenAnimationCompleted() {
        boolean bl = true;
        return bl;
    }

    public void HideThinkingString(byte by) {
        ((AIPlayerViewport)this.mPlayerViewport[by]).HideThinkingString();
    }

    public void SetCardsBitmap(FlBitmapMap flBitmapMap, FlBitmapMap flBitmapMap2, FlBitmapMap flBitmapMap3) {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            this.mPlayerViewport[i2].SetCardsBitmap(flBitmapMap, flBitmapMap2, flBitmapMap3);
        }
    }

    public void WonPot(byte by, PokerPlayer pokerPlayer) {
        this.GetPlayerViewportSeatedAt(by).OnMoneyWon(pokerPlayer);
    }

    public PlayerViewport GetPlayerViewportSeatedAt(byte by) {
        return this.mPlayerViewport[by];
    }

    public void SetDealerButtonOnTable(byte by) {
        this.GetPlayerViewportSeatedAt(by).SetAsDealer();
    }

    public void HideButton(byte by) {
        this.GetPlayerViewportSeatedAt(by).SetButtonVisible(false);
    }

    public void SetPlayerCardVisible(boolean bl, byte by, boolean bl2, boolean bl3) {
        if (bl2 && bl) {
            if (bl3) {
                this.GetPlayerViewportSeatedAt(by).UpdatePlayerState((byte)0, false);
            }
        } else {
            this.GetPlayerViewportSeatedAt(by).UpdatePlayerState((byte)4, false);
        }
    }

    public void SetAllPlayersState(byte by) {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            this.GetPlayerViewportSeatedAt((byte)i2).UpdatePlayerState(by, false);
        }
    }

    public void SetPlayerAction(byte by, byte by2, PlayerDecision playerDecision) {
        this.GetPlayerViewportSeatedAt(by).SetPlayerAction(by2, playerDecision);
    }

    public void HideAIPlayersDecision() {
        int n2 = TexasGameManager.Get().GetPokerTable().GetNbOfStartingAIPlayers();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.HidePlayerDecision((byte)i2);
        }
    }

    public void MuckCards(byte by) {
        this.GetPlayerViewportSeatedAt(by).UpdatePlayerState((byte)2, false);
    }

    public void RevealHoleCards(byte by) {
        this.GetPlayerViewportSeatedAt(by).UpdatePlayerState((byte)0, false);
    }

    public void Refresh() {
        byte by = GameApp.Get().GetGameFactory().GetGame().GetCurrentStateID();
        TexasGameManager texasGameManager = TexasGameManager.Get();
        PokerTable pokerTable = texasGameManager.GetPokerTable();
        PokerPlayer pokerPlayer = null;
        PlayerViewport playerViewport = null;
        if (by == 2 || by == 1 || by == 0 || by == 10) {
            for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
                byte by2 = (byte)i2;
                pokerPlayer = pokerTable.GetPlayerSeatedAt(by2);
                playerViewport = this.GetPlayerViewportSeatedAt(by2);
                playerViewport.UpdatePlayerState((byte)4, true);
            }
            if (by == 1 || by == 2) {
                this.SetDealerButtonOnTable(pokerTable.GetSeatOfPlayer(texasGameManager.GetDealerPlayer()));
            }
        } else {
            Object object;
            this.GetHumanPlayerViewport().SetStackText(pokerTable.GetHumanPlayer().GetChip());
            byte by3 = texasGameManager.GetTexasHandStep();
            if (by3 < 10) {
                PokerPlayer pokerPlayer2;
                PokerPlayer pokerPlayer3;
                if (!texasGameManager.IsEveryoneInTheHandAllInExceptMaxOne()) {
                    this.SetDealerButtonOnTable(pokerTable.GetSeatOfPlayer(texasGameManager.GetDealerPlayer()));
                }
                if (by3 >= 0 && by3 < 4) {
                    pokerPlayer3 = texasGameManager.GetSmallBlindPlayer();
                    pokerPlayer2 = texasGameManager.GetBigBlindPlayer();
                    boolean bl = true;
                    this.GetPlayerViewportSeatedAt(pokerTable.GetSeatOfPlayer(pokerPlayer3)).SetBlindButton(!bl);
                    this.GetPlayerViewportSeatedAt(pokerTable.GetSeatOfPlayer(pokerPlayer2)).SetBlindButton(bl);
                }
                pokerPlayer3 = texasGameManager.GetLastPlayerToBetOrRaiseForCurrentPot();
                pokerPlayer2 = pokerTable.GetRightPlayer(pokerPlayer3);
                object = texasGameManager.GetActivePlayer();
                byte by4 = -1;
                PlayerDecision playerDecision = null;
                do {
                    by4 = pokerTable.GetSeatOfPlayer((PokerPlayer)object);
                    playerDecision = ((PokerPlayer)object).GetDecision();
                    if (playerDecision.GetPlayerAction() == -1) continue;
                    this.SetPlayerAction(by4, ((PokerPlayer)object).GetState(), playerDecision);
                } while ((object = pokerTable.GetRightPlayer((PokerPlayer)object)) != pokerPlayer2);
            }
            for (int i3 = 0; i3 < this.mNbOfStartingPlayers; ++i3) {
                byte by5 = (byte)i3;
                pokerPlayer = pokerTable.GetPlayerSeatedAt(by5);
                playerViewport = this.GetPlayerViewportSeatedAt(by5);
                if (pokerPlayer.IsPlayerInTheHand()) {
                    object = pokerPlayer.GetHoleCards();
                    playerViewport.SetCards((byte)object[0], (byte)object[1]);
                    if (pokerPlayer.AreCardsShown()) {
                        playerViewport.UpdatePlayerState((byte)0, true);
                        continue;
                    }
                    if (!pokerPlayer.IsPlayerHuman() && pokerPlayer.GetState() == 3) {
                        this.MuckCards(by5);
                        continue;
                    }
                    playerViewport.UpdatePlayerState((byte)1, true);
                    continue;
                }
                playerViewport.UpdatePlayerState((byte)4, true);
            }
        }
    }

    public void SetStateShowdownCards(byte by) {
        for (int i2 = 0; i2 < this.mNbOfStartingPlayers; ++i2) {
            this.GetPlayerViewportSeatedAt((byte)i2).SetHoleCardsState(by);
        }
    }

    public void SetCardsOutAt(byte by) {
        this.mPlayerViewport[by].SetCardsViewportVisible(false);
    }

    public void ResetCardsViewport(byte by) {
        this.mPlayerViewport[by].ResetCardsViewport();
    }

    public int GetNbOfStartingAIPlayers() {
        return this.mNbOfStartingPlayers - 1;
    }

    public void HidePlayerDecision(byte by) {
        ((AIPlayerViewport)this.GetPlayerViewportSeatedAt(by)).HideActionText();
        ((AIPlayerViewport)this.GetPlayerViewportSeatedAt(by)).HideStack();
    }

    public void ToggleInfoScreens(boolean bl) {
        this.ToggleInfoScreens(bl, (byte)-1);
    }

    public void ToggleInfoScreens(boolean bl, byte by) {
        this.ToggleInfoScreens(bl, by, -1);
    }

    public void ToggleInfoScreen(byte by, boolean bl) {
        this.ToggleInfoScreen(by, bl, -1);
    }

    public void ToggleInfoScreen(byte by, boolean bl, int n2) {
        this.ToggleInfoScreen(by, bl, n2, false);
    }

    public void SetupInfoScreen(byte by, boolean bl) {
        this.SetupInfoScreen(by, bl, -1);
    }

    public void SetupInfoScreen(byte by, boolean bl, int n2) {
        this.SetupInfoScreen(by, bl, n2, false);
    }

    public void SetPlayerCardVisible(boolean bl, byte by, boolean bl2) {
        this.SetPlayerCardVisible(bl, by, bl2, false);
    }

    public static PlayerViewportManager[] InstArrayPlayerViewportManager(int n2) {
        PlayerViewportManager[] playerViewportManagerArray = new PlayerViewportManager[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            playerViewportManagerArray[i2] = new PlayerViewportManager();
        }
        return playerViewportManagerArray;
    }

    public static PlayerViewportManager[][] InstArrayPlayerViewportManager(int n2, int n3) {
        PlayerViewportManager[][] playerViewportManagerArray = new PlayerViewportManager[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            playerViewportManagerArray[i2] = new PlayerViewportManager[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                playerViewportManagerArray[i2][i3] = new PlayerViewportManager();
            }
        }
        return playerViewportManagerArray;
    }

    public static PlayerViewportManager[][][] InstArrayPlayerViewportManager(int n2, int n3, int n4) {
        PlayerViewportManager[][][] playerViewportManagerArray = new PlayerViewportManager[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            playerViewportManagerArray[i2] = new PlayerViewportManager[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                playerViewportManagerArray[i2][i3] = new PlayerViewportManager[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    playerViewportManagerArray[i2][i3][i4] = new PlayerViewportManager();
                }
            }
        }
        return playerViewportManagerArray;
    }
}

