/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlBrowser;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Tokenizer;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.Utilities;

public class MoreGames15 {
    public int mImpl = 0;
    public MetaPackage mPackage;
    public FlString[] mConfiguredProductIds = null;
    public FlString[] mEmbeddedProductIds = null;
    public int mConfiguredProductCount;
    public int mEmbeddedProductCount;
    public FlString mSelectedProductId = new FlString();
    public int mBuyUriConfigCheatStatus;
    public int mCatUriConfigCheatStatus;
    public int mRealConfiguredProductCount;

    public void destruct() {
        this.mConfiguredProductCount = this.mRealConfiguredProductCount;
        this.SafeReleaseStringArray(this.mConfiguredProductIds, this.mConfiguredProductCount);
        this.SafeReleaseStringArray(this.mEmbeddedProductIds, this.mEmbeddedProductCount);
        this.mSelectedProductId = null;
    }

    public void Load() {
        this.mPackage = GameLibrary.GetPackage(65538);
    }

    public boolean IsLoaded() {
        return GameLibrary.IsPackageLoaded(this.mPackage);
    }

    public void Unload() {
        if (this.mPackage != null) {
            GameLibrary.ReleasePackage(this.mPackage);
            this.mPackage = null;
        }
    }

    public void Initialize() {
        this.Initialize(GameApp.Get().GetFlMoreGamesInstance().GetImplementation());
    }

    public boolean IsEnabled() {
        return this.mImpl != 0;
    }

    public boolean IsWapBrowserExitApp() {
        boolean bl = false;
        return FlBrowser.GetInstance().LaunchURIWillExit(bl);
    }

    public int GetConfiguredProductCount() {
        return this.mConfiguredProductCount;
    }

    public FlString[] GetConfiguredProductIds() {
        return this.mConfiguredProductIds;
    }

    public int GetBuyCommand(FlString flString) {
        int n2 = 0;
        if (this.IsEnabled() && this.IsWapEnabled() && this.IsBuyAttributeConfigured(flString)) {
            n2 = this.IsWapBrowserExitApp() ? -34 : -36;
        }
        return n2;
    }

    public int GetCatCommand(FlString flString) {
        int n2 = 0;
        if (this.IsEnabled()) {
            n2 = this.IsWapEnabled() && this.IsCatAttributeConfigured(flString) ? (this.IsWapBrowserExitApp() ? -35 : -37) : (this.mImpl == 2 ? 0 : -30);
        }
        return n2;
    }

    public boolean IsBuyAttributeConfigured(FlString flString) {
        boolean bl = this.IsPropertySet(FlApplication.GetPropertyValue(this.GetBuyUriAttributeName(flString)));
        if (this.mBuyUriConfigCheatStatus == 2) {
            bl = false;
        }
        return bl;
    }

    public FlString GetBuyUriAttributeName(FlString flString) {
        return StringUtils.CreateString("MG_BUYURI_").AddAssign(flString);
    }

    public boolean IsCatAttributeConfigured(FlString flString) {
        boolean bl = this.IsPropertySet(FlApplication.GetPropertyValue(this.GetCatUriAttributeName(flString)));
        if (this.mCatUriConfigCheatStatus == 2) {
            bl = false;
        }
        return bl;
    }

    public FlString GetCatUriAttributeName(FlString flString) {
        return StringUtils.CreateString("MG_CATURI_").AddAssign(flString);
    }

    public void SetSelectedProductId(FlString flString) {
        this.mSelectedProductId.Assign(flString);
    }

    public FlString GetSelectedProductId() {
        return this.mSelectedProductId;
    }

    public void SetImplementation(int n2) {
        if ((n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3) && this.mImpl != n2) {
            this.Initialize(n2);
        }
    }

    public void SetBuyUriConfiguration(int n2) {
        if (n2 == 0 || n2 == 1 || n2 == 2) {
            this.mBuyUriConfigCheatStatus = n2;
        }
    }

    public void SetCatUriConfiguration(int n2) {
        if (n2 == 0 || n2 == 1 || n2 == 2) {
            this.mCatUriConfigCheatStatus = n2;
        }
    }

    public void SetConfiguredProductCount(int n2) {
        this.mConfiguredProductCount = n2 < 0 ? 0 : (n2 > this.mRealConfiguredProductCount ? this.mRealConfiguredProductCount : n2);
        this.Initialize();
    }

    public void SwapConfiguredProductPosition() {
        int n2 = this.mConfiguredProductCount - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            FlString flString = this.mConfiguredProductIds[i2];
            this.mConfiguredProductIds[i2] = this.mConfiguredProductIds[i2 + 1];
            this.mConfiguredProductIds[i2 + 1] = flString;
        }
    }

    public void InitializeConfiguredProducts() {
        FlString flString = new FlString(FlApplication.GetPropertyValue(StringUtils.CreateString("MG_PRODUCTS")));
        int n2 = 0;
        if (this.IsPropertySet(flString)) {
            FlString flString2 = new FlString(StringUtils.CreateString(","));
            Tokenizer tokenizer = new Tokenizer(flString, flString2);
            n2 = tokenizer.CountTokens();
            this.mConfiguredProductIds = this.Tokenize(tokenizer, n2);
        }
        this.mConfiguredProductCount = n2;
        this.mRealConfiguredProductCount = n2;
    }

    public void InitializeEmbeddedProducts() {
        FlString flString = null;
        flString = FlString.Cast(this.mPackage.GetPackage().GetEntryPoint(0), null);
        FlString flString2 = new FlString(StringUtils.CreateString(","));
        Tokenizer tokenizer = new Tokenizer(flString, flString2);
        this.mEmbeddedProductCount = tokenizer.CountTokens();
        this.mEmbeddedProductIds = this.Tokenize(tokenizer, this.mEmbeddedProductCount);
    }

    public boolean HasValidConfiguration() {
        if (this.mConfiguredProductCount > 0) {
            for (int i2 = 0; i2 < this.mEmbeddedProductCount; ++i2) {
                FlString flString = this.mEmbeddedProductIds[i2];
                for (int i3 = 0; i3 < this.mConfiguredProductCount; ++i3) {
                    if (!flString.Equals(this.mConfiguredProductIds[i3])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public FlString[] Tokenize(Tokenizer tokenizer, int n2) {
        FlString[] flStringArray = null;
        if (n2 > 0) {
            flStringArray = new FlString[n2];
            int n3 = 0;
            while (tokenizer.HasMoreToken()) {
                FlString flString = new FlString(Utilities.TrimString(tokenizer.NextToken()));
                flStringArray[n3++] = new FlString(flString);
            }
        }
        return flStringArray;
    }

    public boolean IsWapSupported() {
        return true;
    }

    public boolean IsWapEnabled() {
        return this.IsWapSupported() && (this.mImpl == 2 || this.mImpl == 3);
    }

    public boolean IsStatic() {
        return this.mImpl == 1;
    }

    public void SafeReleaseStringArray(FlString[] flStringArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (flStringArray[i2] == null) continue;
            flStringArray[i2] = null;
        }
        flStringArray = null;
    }

    public void Initialize(int n2) {
        this.mImpl = n2;
        if (this.IsEnabled()) {
            if (this.mConfiguredProductIds == null) {
                this.InitializeConfiguredProducts();
            }
            if (this.mEmbeddedProductIds == null) {
                this.InitializeEmbeddedProducts();
            }
            if (!this.HasValidConfiguration()) {
                this.mImpl = 0;
            }
        }
    }

    public boolean IsPropertySet(FlString flString) {
        return GameApp.Get().IsPropertySet(flString);
    }

    public static MoreGames15[] InstArrayMoreGames15(int n2) {
        MoreGames15[] moreGames15Array = new MoreGames15[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            moreGames15Array[i2] = new MoreGames15();
        }
        return moreGames15Array;
    }

    public static MoreGames15[][] InstArrayMoreGames15(int n2, int n3) {
        MoreGames15[][] moreGames15Array = new MoreGames15[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            moreGames15Array[i2] = new MoreGames15[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                moreGames15Array[i2][i3] = new MoreGames15();
            }
        }
        return moreGames15Array;
    }

    public static MoreGames15[][][] InstArrayMoreGames15(int n2, int n3, int n4) {
        MoreGames15[][][] moreGames15Array = new MoreGames15[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            moreGames15Array[i2] = new MoreGames15[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                moreGames15Array[i2][i3] = new MoreGames15[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    moreGames15Array[i2][i3][i4] = new MoreGames15();
                }
            }
        }
        return moreGames15Array;
    }
}

