/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.texasholdem09.AIDialoguePopup;
import ca.jamdat.texasholdem09.AdvisorPopup;
import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.CommunityCardManager;
import ca.jamdat.texasholdem09.Cursor;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameInfoPopup;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.GameRenderer;
import ca.jamdat.texasholdem09.InGameStatisticsPopup;
import ca.jamdat.texasholdem09.MediaPlayer;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.PlayerActionPopup;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.Popup;
import ca.jamdat.texasholdem09.PotManager;
import ca.jamdat.texasholdem09.TexasGameManager;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class GameScene
extends BaseScene {
    public static final byte kInitializingFirstGame = 0;
    public static final byte kReady = 1;
    public static final byte kIdle = 2;
    public PokerGame mPokerGame;
    public byte mGameSceneState = 0;
    public TexasGameManager mTexasManager;
    public TexasPokerTable mPokerTable;
    public CommunityCardManager mCommunityCardManager;
    public PlayerViewportManager mPlayerViewportManager;
    public PotManager mPotManager;
    public FlBitmapMap mSmallCardSuits;
    public FlBitmapMap mSmallCardRedValues;
    public FlBitmapMap mSmallCardBlackValues;
    public boolean mSkipOpeningPopupAnim;
    public PlayerActionPopup mPlayerActionPopup;
    public GameInfoPopup mGameInfoPopup;
    public AIDialoguePopup mAIDialoguePopup;
    public InGameStatisticsPopup mInGameStatisticsPopup;
    public AdvisorPopup mAdvisorPopup;
    public boolean mNewGame = true;
    public MetaPackage mGameSoundsPackage;

    public GameScene(int n2, int n3) {
        super(n2, n3);
        this.mType = 4;
        this.SetCursor(new Cursor());
    }

    public void destruct() {
    }

    public void Load() {
        super.Load();
        GameApp gameApp = GameApp.Get();
        this.mTexasManager = TexasGameManager.Get();
        this.mPokerTable = (TexasPokerTable)this.mTexasManager.GetPokerTable();
        this.mPokerGame = gameApp.GetGameFactory().GetGame();
        this.mGameSoundsPackage = GameLibrary.GetPackage(196614);
        GameApp.Get().GetMediaPlayer().SetGameSoundsPackage(this.mGameSoundsPackage);
        this.mCommunityCardManager = new CommunityCardManager();
        this.mPlayerViewportManager = new PlayerViewportManager();
        this.mPotManager = new PotManager();
        this.mPlayerViewportManager.LoadResources();
        this.mCommunityCardManager.Load();
        this.mPotManager.LoadResources();
    }

    public boolean IsLoaded() {
        boolean bl = false;
        bl = super.IsLoaded() && GameLibrary.IsPackageLoaded(this.mGameSoundsPackage);
        return bl;
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mTexasManager.GetEntryPoints();
        this.mSmallCardSuits = FlBitmapMap.Cast(this.mPackage.GetEntryPoint(126), null);
        this.mSmallCardBlackValues = FlBitmapMap.Cast(this.mPackage.GetEntryPoint(128), null);
        this.mSmallCardRedValues = FlBitmapMap.Cast(this.mPackage.GetEntryPoint(127), null);
        this.SetCardsDefaultBitmapMap();
        if (!this.mNewGame) {
            this.RefreshManagers();
        }
    }

    public void Initialize() {
        super.Initialize();
        this.mPokerGame.SetGamePaused(false);
        this.mPokerGame.LoadStates();
        if (this.mNewGame) {
            this.mNewGame = false;
            this.mPokerGame.Initialize(this);
        }
        FlString flString = null;
        flString = FlString.Cast(this.mPackage.GetEntryPoint(3), null);
        this.mPokerGame.SetPlayerName(flString);
        this.mPlayerViewportManager.InitializeAllInfoScreens(this.mPokerGame);
    }

    public void Unload() {
        MediaPlayer mediaPlayer = GameApp.Get().GetMediaPlayer();
        mediaPlayer.StopVibration();
        mediaPlayer.StopMusic();
        mediaPlayer.StopSoundFx();
        mediaPlayer.SetGameSoundsPackage(null);
        if (this.mGameSoundsPackage != null) {
            GameLibrary.ReleasePackage(this.mGameSoundsPackage);
            this.mGameSoundsPackage = null;
        }
        if (this.mPokerGame != null) {
            this.mPokerGame.UnloadStates();
            this.mPokerGame = null;
        }
        if (this.mPackage != null && (this.mPackage.IsLoaded() || this.mPackage.IsLoading())) {
            if (this.mViewport != null) {
                this.mViewport.SetViewport(null);
            }
            if (this.mCommunityCardManager != null) {
                this.mCommunityCardManager.Unload();
                this.mCommunityCardManager = null;
            }
            if (this.mPotManager != null) {
                this.mPotManager.UnloadResources();
                this.mPotManager = null;
            }
            this.ReleaseGamePopup();
            if (this.mPlayerViewportManager != null) {
                this.mPlayerViewportManager.UnloadResources();
                this.mPlayerViewportManager = null;
            }
            this.mViewport = null;
            this.mSmallCardSuits = null;
            this.mSmallCardRedValues = null;
            this.mSmallCardBlackValues = null;
            GameApp.Get().GetCheatContainer().GetCheat(16).Deactivate();
        }
        if (this.mTexasManager != null) {
            this.mTexasManager.Unload();
            this.mTexasManager = null;
        }
        super.Unload();
    }

    public void OnSceneAttached() {
        super.OnSceneAttached();
        GameApp.Get().GetHourglass().SetTopLeft((short)79, (short)95);
        this.StartGame();
    }

    public void Suspend() {
        if (this.GetTransitionState() == 7) {
            // empty if block
        }
    }

    public void CreateView() {
        this.mView = new GameRenderer();
    }

    public boolean OnMsg(Component component, int n2, int n3) {
        if (n2 == -125 && this.mPlayerActionPopup != null && this.mCurrentPopupId == 10) {
            this.mPlayerActionPopup.OnMsg(component, n2, n3);
        }
        return super.OnMsg(component, n2, n3);
    }

    public void OnTime(int n2, int n3) {
        if (this.mGameSceneState == 0 || this.mPokerGame.IsGamePaused()) {
            return;
        }
        super.OnTime(n2, n3);
        if (this.WaitingForUserInput()) {
            return;
        }
        if (this.mPokerGame.IsInSkipMode()) {
            this.OnSkip();
            return;
        }
        if (this.mGameSceneState == 1) {
            this.mPokerGame.OnTime(n2, n3);
        }
    }

    public boolean OnKeyUp(int n2) {
        return this.mPokerGame.OnKeyUp(n2);
    }

    public boolean SaveFiles(int n2) {
        return super.SaveFiles(n2);
    }

    public void SerializeObjects() {
    }

    public boolean OnCommand(int n2) {
        if (n2 == -20) {
            this.mPokerGame.SetGamePaused(true);
            this.mPokerGame.OnPause();
        }
        boolean bl = super.OnCommand(n2);
        if (this.mPlayerActionPopup != null && this.mPlayerActionPopup.IsShown()) {
            bl = this.mPlayerActionPopup.OnCommand(n2);
        }
        return bl;
    }

    public void AddPopup(Popup popup, boolean bl) {
        this.SetState((byte)2);
        super.AddPopup(popup, bl);
    }

    public void HandlePopup(byte by) {
        switch (by) {
            case 6: {
                if (this.mAdvisorPopup == null) {
                    this.mAdvisorPopup = new AdvisorPopup(this, this.mSelectSoftKey, this.mClearSoftKey, 6);
                }
                this.AddPopup(this.mAdvisorPopup, true);
                break;
            }
            case 10: {
                if (this.mPlayerActionPopup == null) {
                    this.mPlayerActionPopup = new PlayerActionPopup((BaseScene)this, this.mSelectSoftKey, this.mClearSoftKey, this.mCursor);
                }
                this.AddPopup(this.mPlayerActionPopup, true);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                if (this.mGameInfoPopup == null) {
                    this.mGameInfoPopup = new GameInfoPopup(this, this.mSelectSoftKey, this.mClearSoftKey, by);
                } else {
                    this.mGameInfoPopup.SetId(by);
                }
                this.AddPopup(this.mGameInfoPopup, true);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                if (this.mAIDialoguePopup == null) {
                    this.mAIDialoguePopup = new AIDialoguePopup(this, this.mSelectSoftKey, this.mClearSoftKey, by);
                } else {
                    this.mAIDialoguePopup.SetId(by);
                }
                this.AddPopup(this.mAIDialoguePopup, true);
                break;
            }
            case 15: {
                if (this.mInGameStatisticsPopup == null) {
                    this.mInGameStatisticsPopup = new InGameStatisticsPopup(this, this.mSelectSoftKey, this.mClearSoftKey);
                }
                this.AddPopup(this.mInGameStatisticsPopup, true);
                break;
            }
        }
    }

    public void OnPopupHidden() {
        byte by = this.mCurrentPopupId;
        super.OnPopupHidden();
        switch (by) {
            case 6: {
                this.mPlayerActionPopup.OnHideAdvisor();
                break;
            }
            case 10: {
                this.mPokerGame.OnHidePlayerActionPopUp();
                break;
            }
            case 7: 
            case 8: {
                this.mPokerGame.OnHideAIDialoguePopUp();
                break;
            }
            case 19: {
                PokerTable pokerTable = this.mTexasManager.GetPokerTable();
                PokerPlayer pokerPlayer = this.mTexasManager.GetDealerPlayer();
                PokerPlayer pokerPlayer2 = this.mTexasManager.GetSmallBlindPlayer();
                PokerPlayer pokerPlayer3 = this.mTexasManager.GetBigBlindPlayer();
                this.mPlayerViewportManager.HideButton(pokerTable.GetSeatOfPlayer(pokerPlayer));
                this.mPlayerViewportManager.HideButton(pokerTable.GetSeatOfPlayer(pokerPlayer2));
                this.mPlayerViewportManager.HideButton(pokerTable.GetSeatOfPlayer(pokerPlayer3));
                break;
            }
        }
        if (!this.IsHandlingPopup()) {
            this.SetState((byte)1);
        }
    }

    public void OnPopupShown() {
        if (this.mCurrentPopupId == 7 || this.mCurrentPopupId == 8) {
            PokerPlayerAI pokerPlayerAI = (PokerPlayerAI)this.mTexasManager.GetActivePlayer();
            byte by = this.mPokerGame.GetTexasPokerTable().GetSeatOfPlayer(pokerPlayerAI);
            this.mPlayerViewportManager.HideThinkingString(by);
        }
        super.OnPopupShown();
    }

    public void ReceiveFocus() {
        if (this.mCurrentPopup == null || !this.mCurrentPopup.HasFocus()) {
            super.ReceiveFocus();
            this.mView.RegisterInGlobalTime();
            if (!this.IsHandlingPopup()) {
                this.SetState((byte)1);
            }
        }
    }

    public void ReleaseGamePopup() {
        if (this.mCurrentPopup != this.mAdvisorPopup && !this.IsPopupAdded(this.mAdvisorPopup)) {
            if (this.mAdvisorPopup != null) {
                this.mAdvisorPopup.Unload();
            }
            this.mAdvisorPopup = null;
        }
        if (this.mCurrentPopup != this.mPlayerActionPopup && !this.IsPopupAdded(this.mPlayerActionPopup)) {
            if (this.mPlayerActionPopup != null) {
                this.mPlayerActionPopup.Unload();
            }
            this.mPlayerActionPopup = null;
        }
        if (this.mCurrentPopup != this.mGameInfoPopup && !this.IsPopupAdded(this.mGameInfoPopup)) {
            if (this.mGameInfoPopup != null) {
                this.mGameInfoPopup.Unload();
            }
            this.mGameInfoPopup = null;
        }
        if (this.mCurrentPopup != this.mAIDialoguePopup && !this.IsPopupAdded(this.mAIDialoguePopup)) {
            if (this.mAIDialoguePopup != null) {
                this.mAIDialoguePopup.Unload();
            }
            this.mAIDialoguePopup = null;
        }
        if (this.mCurrentPopup != this.mInGameStatisticsPopup && !this.IsPopupAdded(this.mInGameStatisticsPopup)) {
            if (this.mInGameStatisticsPopup != null) {
                this.mInGameStatisticsPopup.Unload();
            }
            this.mInGameStatisticsPopup = null;
        }
        this.mAdvisorPopup = null;
        this.mGameInfoPopup = null;
        this.mAIDialoguePopup = null;
        this.mPlayerActionPopup = null;
        this.mInGameStatisticsPopup = null;
    }

    public boolean CanShowPlayerActionInfo() {
        return this.mPlayerActionPopup != null && this.mPlayerActionPopup.IsShown() && this.mTexasManager.GetActivePlayer().IsPlayerHuman();
    }

    public void UpdateSoftKey() {
        this.UpdateAcceptSoftKey();
        this.UpdateDeclineSoftKeyCaption();
    }

    public void UpdateAcceptSoftKey() {
        int n2 = this.mPokerGame.GetAcceptSoftkeyCaption();
        if (n2 == 0) {
            this.mSelectSoftKey.SetCommand(0);
        } else {
            this.mSelectSoftKey.SetCommand(25);
        }
        this.SetSoftkeyCaption(n2, 13);
    }

    public void UpdateDeclineSoftKeyCaption() {
        int n2 = this.mPokerGame.GetDeclineSoftkeyCaption();
        this.SetSoftkeyCaption(n2, 14);
    }

    public void DisableDeclineSoftKey() {
        this.mClearSoftKey.SetCommand(0);
        this.SetSoftkeyCaption(0, 14);
    }

    public void OnSkip() {
        this.mPokerGame.OnSkip();
    }

    public boolean WaitingForUserInput() {
        return this.mPokerGame.IsWaitingForUserInput();
    }

    public void SetSoftkeyCaption(int n2, int n3) {
        MetaPackage metaPackage = GameLibrary.GetPackage(1638450);
        Package package_ = metaPackage.GetPackage();
        FlString flString = null;
        flString = FlString.Cast(package_.GetEntryPoint(51 + n2), null);
        GameLibrary.ReleasePackage(metaPackage);
        if (n3 == 13) {
            this.mSelectSoftKey.SetCaption(flString);
        } else {
            this.mClearSoftKey.SetCaption(flString);
        }
    }

    public CommunityCardManager GetCommunityCardManager() {
        return this.mCommunityCardManager;
    }

    public PlayerActionPopup GetPlayerActionPopup() {
        return this.mPlayerActionPopup;
    }

    public PlayerViewportManager GetPlayerViewportManager() {
        return this.mPlayerViewportManager;
    }

    public PotManager GetPotManager() {
        return this.mPotManager;
    }

    public InGameStatisticsPopup GetInGameStatisticsPopup() {
        return this.mInGameStatisticsPopup;
    }

    public void SetState(byte by) {
        this.mGameSceneState = by;
    }

    public void RefreshManagers() {
        this.mCommunityCardManager.Refresh();
        this.mPlayerViewportManager.Refresh();
        this.mPotManager.Refresh();
    }

    public void SetCardsDefaultBitmapMap() {
        this.mCommunityCardManager.SetSharedCardsBitmap(this.mSmallCardSuits, this.mSmallCardBlackValues, this.mSmallCardRedValues);
        this.mPlayerViewportManager.SetCardsBitmap(this.mSmallCardSuits, this.mSmallCardBlackValues, this.mSmallCardRedValues);
    }

    public void StartGame() {
        if (this.mCurrentPopupId != -1) {
            this.mSkipOpeningPopupAnim = true;
            this.HandlePopup(this.mCurrentPopupId);
        } else if (this.WaitingForUserInput()) {
            this.mSkipOpeningPopupAnim = true;
            this.HandlePopup((byte)10);
        }
    }

    public boolean IsReady() {
        return this.mGameSceneState == 1;
    }
}

