/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlMoreGames;
import ca.jamdat.texasholdem09.CareerState;
import ca.jamdat.texasholdem09.CheatActivationController;
import ca.jamdat.texasholdem09.CheatContainer;
import ca.jamdat.texasholdem09.CommandHandler;
import ca.jamdat.texasholdem09.FileManager;
import ca.jamdat.texasholdem09.GameAppImpl;
import ca.jamdat.texasholdem09.GameFactory;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.GameMenuSettings;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.Hourglass;
import ca.jamdat.texasholdem09.InputMapper;
import ca.jamdat.texasholdem09.MediaPlayer;
import ca.jamdat.texasholdem09.MoreGames15;
import ca.jamdat.texasholdem09.PopupManager;
import ca.jamdat.texasholdem09.Settings;
import ca.jamdat.texasholdem09.Statistics;
import ca.jamdat.texasholdem09.TutorialManager;

public class GameApp
extends FlApplication {
    public GameAppImpl mImpl;

    public GameApp() {
        int n2 = this.InitializeRandomSeed();
        this.mImpl = new GameAppImpl();
        this.mImpl.Initialize();
        InputMapper.ChangeMapping(0);
        this.RegisterInGlobalTime();
    }

    public void destruct() {
        this.UnRegisterInGlobalTime();
        this.mImpl = null;
    }

    public boolean OnMsg(Component component, int n2, int n3) {
        boolean bl = false;
        if (n2 == -56) {
            this.Quit();
            bl = true;
        }
        return bl;
    }

    public void OnTime(int n2, int n3) {
        if (this.mImpl.mBootProcess.OnTime()) {
            this.UnRegisterInGlobalTime();
            this.mImpl.mBootProcess = null;
        }
    }

    public void Suspend() {
        this.mImpl.mCommandHandler.Execute(-67);
    }

    public void Resume() {
    }

    public void SaveGame() {
        this.mImpl.mCommandHandler.Execute(-66);
        boolean bl = GameApp.Get().GetFileManager().OnSave();
    }

    public void Reset() {
        this.mImpl.Reset();
        GameApp.Get().GetFileManager().WriteObject(4);
        this.GetFileManager().WriteApplicationObjects();
    }

    public void Quit() {
        this.TakeFocus();
        this.SaveGame();
        FlApplication.Exit();
    }

    public static GameApp Get() {
        return (GameApp)FlApplication.GetInstance();
    }

    public Settings GetSettings() {
        return this.mImpl.mSettings;
    }

    public Hourglass GetHourglass() {
        return this.mImpl.mHourglass;
    }

    public MediaPlayer GetMediaPlayer() {
        return this.mImpl.mMediaPlayer;
    }

    public GameLibrary GetLibrary() {
        return this.mImpl.mGameLibrary;
    }

    public FileManager GetFileManager() {
        return this.mImpl.mFileManager;
    }

    public FlMoreGames GetFlMoreGamesInstance() {
        return this.mImpl.mFlMoreGamesInstance;
    }

    public CareerState GetCareerState() {
        return this.mImpl.mCareerState;
    }

    public Statistics GetStatistics() {
        return this.mImpl.mStatistics;
    }

    public GameFactory GetGameFactory() {
        return this.mImpl.mGameFactory;
    }

    public GameSettings GetGameSettings() {
        return this.mImpl.mGameSettings;
    }

    public PopupManager GetPopupManager() {
        return this.mImpl.mPopupManager;
    }

    public TutorialManager GetTutorialManager() {
        return this.mImpl.mTutorialManager;
    }

    public GameMenuSettings GetGameMenuSettings() {
        return this.mImpl.mGameMenuSettings;
    }

    public CommandHandler GetCommandHandler() {
        return this.mImpl.mCommandHandler;
    }

    public boolean IsBooting() {
        return this.mImpl.mBootProcess != null;
    }

    public CheatActivationController GetCheatActivationController() {
        return this.mImpl.mCheatActivationController;
    }

    public CheatContainer GetCheatContainer() {
        return this.mImpl.mCheatContainer;
    }

    public MoreGames15 GetMoreGames() {
        return this.mImpl.mMoreGames15;
    }

    public int InitializeRandomSeed() {
        int n2 = (int)FlApplication.GetRealTime();
        FlMath.Seed(n2);
        return n2;
    }

    public static GameApp[] InstArrayGameApp(int n2) {
        GameApp[] gameAppArray = new GameApp[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            gameAppArray[i2] = new GameApp();
        }
        return gameAppArray;
    }

    public static GameApp[][] InstArrayGameApp(int n2, int n3) {
        GameApp[][] gameAppArray = new GameApp[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            gameAppArray[i2] = new GameApp[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                gameAppArray[i2][i3] = new GameApp();
            }
        }
        return gameAppArray;
    }

    public static GameApp[][][] InstArrayGameApp(int n2, int n3, int n4) {
        GameApp[][][] gameAppArray = new GameApp[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            gameAppArray[i2] = new GameApp[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                gameAppArray[i2][i3] = new GameApp[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    gameAppArray[i2][i3][i4] = new GameApp();
                }
            }
        }
        return gameAppArray;
    }
}

