/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FileStream;
import ca.jamdat.flight.FlString;
import ca.jamdat.texasholdem09.FileSegmentStream;

public class FileHandler {
    public static final int opRead = 0;
    public static final int opWrite = 1;
    public FlString mPathname;
    public int mSegmentCount;
    public int mWritingCount;
    public FileSegmentStream[] mSegmentStreams = null;

    public FileHandler(FlString flString, FileSegmentStream[] fileSegmentStreamArray, int n2) {
        this.mPathname = new FlString(flString);
        this.mSegmentCount = n2;
        this.mSegmentStreams = fileSegmentStreamArray;
    }

    public void destruct() {
        for (int i2 = 0; i2 < this.mSegmentCount; ++i2) {
            this.mSegmentStreams[i2] = null;
        }
        this.mSegmentStreams = null;
        this.mPathname = null;
    }

    public void Terminate() {
    }

    public void SetPathname(FlString flString) {
        this.mPathname.Assign(flString);
    }

    public FlString GetPathname() {
        return this.mPathname;
    }

    public int GetSize() {
        int n2 = 8;
        for (int i2 = 0; i2 < this.mSegmentCount; ++i2) {
            n2 += this.mSegmentStreams[i2].GetSize();
        }
        return n2;
    }

    public int GetWritingCount() {
        return this.mWritingCount;
    }

    public boolean OnSerialize(int n2) {
        boolean bl = false;
        bl = n2 == 0 ? this.OnReadSync() : this.OnWriteSync();
        return bl;
    }

    public boolean IsValid() {
        int n2 = this.GetSize();
        FileStream fileStream = new FileStream(this.GetPathname(), 0, n2);
        boolean bl = fileStream.IsValid();
        fileStream.Close();
        return bl;
    }

    public FileSegmentStream GetSegmentStream(int n2, int n3) {
        FileSegmentStream fileSegmentStream = this.mSegmentStreams[n2];
        fileSegmentStream.SetMode(n3);
        return fileSegmentStream;
    }

    public void ReadFromFileStream(FileStream fileStream) {
        int n2;
        this.ResetSerializableData();
        if (fileStream.IsValid() && (n2 = fileStream.ReadLong()) == -804627712) {
            this.mWritingCount = fileStream.ReadLong();
            for (int i2 = 0; i2 < this.mSegmentCount; ++i2) {
                this.mSegmentStreams[i2].Read(fileStream);
            }
        }
    }

    public void WriteToFileStream(FileStream fileStream) {
        fileStream.WriteLong(-804627712);
        fileStream.WriteLong(++this.mWritingCount);
        for (int i2 = 0; i2 < this.mSegmentCount; ++i2) {
            this.mSegmentStreams[i2].Write(fileStream);
        }
    }

    public void ResetSerializableData() {
        for (int i2 = 0; i2 < this.mSegmentCount; ++i2) {
            this.mSegmentStreams[i2].SetValidDataFlag(false);
        }
    }

    public boolean AreSegmentsModified() {
        for (int i2 = 0; i2 < this.mSegmentCount; ++i2) {
            if (!this.mSegmentStreams[i2].IsModified()) continue;
            return true;
        }
        return false;
    }

    public boolean OnReadSync() {
        if (FileStream.FileExists(this.GetPathname())) {
            int n2 = this.GetSize();
            FileStream fileStream = new FileStream(this.GetPathname(), 0, n2);
            this.ReadFromFileStream(fileStream);
            fileStream.Close();
        }
        return true;
    }

    public boolean OnWriteSync() {
        if (this.AreSegmentsModified()) {
            int n2 = this.GetSize();
            FileStream fileStream = new FileStream(this.GetPathname(), 1, n2);
            this.WriteToFileStream(fileStream);
            fileStream.Close();
        }
        return true;
    }
}

