/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Box3;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.HalfSpace;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Sphere;

public class ViewingFrustrum {
    public static final byte front = 0;
    public static final byte back = 1;
    public static final byte left = 2;
    public static final byte right = 3;
    public static final byte top = 4;
    public static final byte bottom = 5;
    public static final byte frontMask = 1;
    public static final byte backMask = 2;
    public static final byte leftMask = 4;
    public static final byte rightMask = 8;
    public static final byte topMask = 16;
    public static final byte bottomMask = 32;
    public HalfSpace[] halfSpaces = HalfSpace.InstArrayHalfSpace(6);

    public static ViewingFrustrum Cast(Object object, ViewingFrustrum viewingFrustrum) {
        return (ViewingFrustrum)object;
    }

    public void OnSerialize(Package package_) {
    }

    public ViewingFrustrum() {
    }

    public ViewingFrustrum(ViewingFrustrum viewingFrustrum) {
        this.Init(viewingFrustrum.halfSpaces[0], viewingFrustrum.halfSpaces[1], viewingFrustrum.halfSpaces[2], viewingFrustrum.halfSpaces[3], viewingFrustrum.halfSpaces[4], viewingFrustrum.halfSpaces[5]);
    }

    public ViewingFrustrum(HalfSpace halfSpace, HalfSpace halfSpace2, HalfSpace halfSpace3, HalfSpace halfSpace4, HalfSpace halfSpace5, HalfSpace halfSpace6) {
        this.Init(halfSpace, halfSpace2, halfSpace3, halfSpace4, halfSpace5, halfSpace6);
    }

    public void Init(HalfSpace halfSpace, HalfSpace halfSpace2, HalfSpace halfSpace3, HalfSpace halfSpace4, HalfSpace halfSpace5, HalfSpace halfSpace6) {
        this.halfSpaces[0].Assign(halfSpace);
        this.halfSpaces[1].Assign(halfSpace2);
        this.halfSpaces[2].Assign(halfSpace3);
        this.halfSpaces[3].Assign(halfSpace4);
        this.halfSpaces[4].Assign(halfSpace5);
        this.halfSpaces[5].Assign(halfSpace6);
    }

    public HalfSpace Front() {
        return this.halfSpaces[0];
    }

    public HalfSpace Back() {
        return this.halfSpaces[1];
    }

    public HalfSpace Left() {
        return this.halfSpaces[2];
    }

    public HalfSpace Right() {
        return this.halfSpaces[3];
    }

    public HalfSpace Top() {
        return this.halfSpaces[4];
    }

    public HalfSpace Bottom() {
        return this.halfSpaces[5];
    }

    public byte AttemptToExcludeIntersectingPlanes(byte by, Box3 box3) {
        byte by2 = 0;
        int n2 = 1;
        for (int i2 = 0; i2 < 6; ++i2) {
            if ((by & n2) != 0) {
                byte by3 = this.halfSpaces[i2].WhichSideOfPlane(box3);
                if (by3 == 0) {
                    by2 = (byte)(by2 | n2);
                } else if (by3 == -1) {
                    return 64;
                }
            }
            n2 <<= 1;
        }
        return by2;
    }

    public byte AttemptToExcludeIntersectingPlanes(byte by, Box3 box3, F32 f32) {
        byte by2 = 0;
        int n2 = 1;
        for (int i2 = 0; i2 < 6; ++i2) {
            if ((by & n2) != 0) {
                byte by3 = this.halfSpaces[i2].WhichSideOfPlane(box3, f32);
                if (by3 == 0) {
                    by2 = (byte)(by2 | n2);
                } else if (by3 == -1) {
                    return 64;
                }
            }
            n2 <<= 1;
        }
        return by2;
    }

    public byte AttemptToExcludeIntersectingPlanes(byte by, Sphere sphere) {
        byte by2 = 0;
        int n2 = 1;
        for (int i2 = 0; i2 < 6; ++i2) {
            if ((by & n2) != 0) {
                byte by3 = this.halfSpaces[i2].WhichSideOfPlane(sphere);
                if (by3 == 0) {
                    by2 = (byte)(by2 | n2);
                } else if (by3 == -1) {
                    return 64;
                }
            }
            n2 <<= 1;
        }
        return by2;
    }

    public ViewingFrustrum Assign(ViewingFrustrum viewingFrustrum) {
        for (int i2 = 0; i2 < 6; ++i2) {
            this.halfSpaces[i2].Assign(viewingFrustrum.halfSpaces[i2]);
        }
        return this;
    }

    public static ViewingFrustrum[] InstArrayViewingFrustrum(int n2) {
        ViewingFrustrum[] viewingFrustrumArray = new ViewingFrustrum[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            viewingFrustrumArray[i2] = new ViewingFrustrum();
        }
        return viewingFrustrumArray;
    }

    public static ViewingFrustrum[][] InstArrayViewingFrustrum(int n2, int n3) {
        ViewingFrustrum[][] viewingFrustrumArray = new ViewingFrustrum[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            viewingFrustrumArray[i2] = new ViewingFrustrum[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                viewingFrustrumArray[i2][i3] = new ViewingFrustrum();
            }
        }
        return viewingFrustrumArray;
    }

    public static ViewingFrustrum[][][] InstArrayViewingFrustrum(int n2, int n3, int n4) {
        ViewingFrustrum[][][] viewingFrustrumArray = new ViewingFrustrum[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            viewingFrustrumArray[i2] = new ViewingFrustrum[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                viewingFrustrumArray[i2][i3] = new ViewingFrustrum[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    viewingFrustrumArray[i2][i3][i4] = new ViewingFrustrum();
                }
            }
        }
        return viewingFrustrumArray;
    }
}

